/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.group_template;

import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.NpcStringId;

/**
 * Turek Orcs AI - flee and return with assistance
 * @author GKR
 */

public final class TurekOrcs extends AbstractNpcAI
{
	private static final int NON = 0, FLEE = 1, WARNING = 2, ASSIST = 3;
	// NPC's
	private static final int[] MOBS =
	{
		20494, // Turek War Hound		gDbN EH[nEh
		20495, // Turek Orc Warlord		gDbN I[N EH[[h
		20497, // Turek Orc Skirmisher	gDbN I[N C_[
		20498, // Turek Orc Supplier	gDbN I[N TvC[
		20499, // Turek Orc Footman		gDbN I[N tbg}
		20500, // Turek Orc Sentinel	gDbN I[N ZeBl
	};
	
	private TurekOrcs()
	{
		super(TurekOrcs.class.getSimpleName(), "ai/group_template");
		registerMobs(MOBS, QuestEventType.ON_ATTACK, QuestEventType.ON_EVENT_RECEIVED, QuestEventType.ON_MOVE_FINISHED);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		if (event == "checkState" && !npc.isDead() && npc.isVisible() && npc.getVariables().getInt("state") == WARNING)
		{
			if (npc.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK)
			{
				npc.getVariables().set("state", ASSIST);
			}
			else if (npc.getCurrentHp() > npc.getMaxHp() * 0.7)
			{
				npc.getVariables().set("state", ASSIST);
				((L2Attackable) npc).returnHome();
			}
			else
			{
				npc.getVariables().remove("state");
			}
		}
		return super.onAdvEvent(event, npc, player);
	}
	
	@Override
	public String onAttack(L2Npc npc, L2PcInstance attacker, int damage, boolean isSummon)
	{
		if ((npc.getCurrentHp() < (npc.getMaxHp() * 0.5)) && (npc.getCurrentHp() > (npc.getMaxHp() * 0.3)) && (attacker.getCurrentHp() > (attacker.getMaxHp() * 0.25)) && npc.hasAIValue("fleeX") && npc.hasAIValue("fleeY") && npc.hasAIValue("fleeZ") && (npc.getVariables().getInt("state") == NON) && (getRandom(100) < 10))
		{
			// Say and flee
			// 1000007 oĂI
			// 1000008 ̋JAYʂI
			// 1000009 PށI
			// 1000010 헪IɌނI
			// 1000011 I
			// 1000012 v苭I
			// 1000013 oĂI
			// 1000014 ́AĂI
			// 1000015 I苭I
			// 1000016 N҂I
			// 1000017 EĂɂȂȂDDDNNNB
			// 1000018 ͕KDDD
			// 1000019 Ȃ΂艣񂾁I
			// 1000020 قĂI
			// 1000021 ̐c܂Ⴢ邺I
			// 1000022 ͉I
			// 1000023 ėȂAėȁI
			// 1000024 ~I
			// 1000025 A܂I
			// 1000026 N\Iđ҂ƂI
			// 1000027 AĂȂA1疜Afi邼I
			broadcastNpcSay(npc, 0, NpcStringId.getNpcStringId(getRandom(1000007, 1000027)));
			npc.disableCoreAI(true); // to avoid attacking behaviour, while flee
			npc.setIsRunning(true);
			npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(npc.getAIValue("fleeX"), npc.getAIValue("fleeY"), npc.getAIValue("fleeZ")));
			npc.getVariables().set("state", FLEE);
			npc.getVariables().set("attacker", attacker.getObjectId());
		}
		return super.onAttack(npc, attacker, damage, isSummon);
	}
	
	@Override
	public String onEventReceived(String eventName, L2Npc sender, L2Npc receiver, L2Object reference)
	{
		if (eventName == "WARNING" && !receiver.isDead() && receiver.isVisible() && (receiver.getAI().getIntention() != CtrlIntention.AI_INTENTION_ATTACK) && (reference != null) && (reference.getActingPlayer() != null) && !reference.getActingPlayer().isDead() && reference.getActingPlayer().isVisible())
		{
			receiver.getVariables().set("state", ASSIST);
			receiver.setIsRunning(true);
			((L2Attackable) receiver).addDamageHate(reference.getActingPlayer(), 0, 99999);
			receiver.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, reference.getActingPlayer());
		}
		return null;
	}
	
	@Override
	public boolean onMoveFinished(L2Npc npc)
	{
		// NPC reaches flee point
		if (npc.getVariables().getInt("state") == FLEE)
		{
			if ((npc.getX() == npc.getAIValue("fleeX")) && (npc.getY() == npc.getAIValue("fleeY")))
			{
				npc.disableCoreAI(false);
				startQuestTimer("checkState", 15000, npc, null);
				npc.getVariables().set("state", WARNING);
				broadcastEvent("WARNING", npc, 400, L2World.getInstance().getPlayer(npc.getVariables().getInt("attacker")));	//[JOJO]
			}
			else
			{
				npc.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(npc.getAIValue("fleeX"), npc.getAIValue("fleeY"), npc.getAIValue("fleeZ")));
				return true;
			}
		}
		else if ((npc.getVariables().getInt("state") == ASSIST) && npc.staysInSpawnLoc())
		{
			npc.disableCoreAI(false);
			npc.getVariables().remove("state");
		}
		return false;
	}
	
	public static void main(String[] args)
	{
		new TurekOrcs();
	}
}
