/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.tools.dbinstaller.util.mysql;

import com.l2jserver.tools.dbinstaller.DBOutputInterface;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Formatter;
import java.util.GregorianCalendar;

public class DBDumper {
    DBOutputInterface _frame;
    String _host;
    String _db;

    public DBDumper(DBOutputInterface frame, String host, String db) {
        this._frame = frame;
        this._host = host;
        this._db = db;
        this.createDump();
    }

    public void createDump() {
        try {
            Throwable throwable;
            ResultSet rset;
            Throwable throwable2;
            Statement s;
            Connection con = this._frame.getConnection();
            String serverVersion = "Unknown";
            try {
                s = con.createStatement();
                throwable2 = null;
                try {
                    rset = s.executeQuery("SELECT VERSION()");
                    throwable = null;
                    try {
                        if (rset.next()) {
                            serverVersion = rset.getString(1);
                        }
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (rset != null) {
                            if (throwable != null) {
                                try {
                                    rset.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                rset.close();
                            }
                        }
                    }
                }
                catch (Throwable x2) {
                    throwable2 = x2;
                    throw x2;
                }
                finally {
                    if (s != null) {
                        if (throwable2 != null) {
                            try {
                                s.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                        } else {
                            s.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            s = con.createStatement();
            throwable2 = null;
            try {
                rset = s.executeQuery("SHOW TABLES");
                throwable = null;
                try {
                    Formatter form = new Formatter();
                    File dump = new File("dumps", form.format("dump_%3$s_%1$s_%2$tY%2$tm%2$td-%2$tH%2$tM%2$tS.sql", this._db, new GregorianCalendar().getTime(), this._host).toString());
                    form.close();
                    new File("dumps").mkdir();
                    dump.createNewFile();
                    this._frame.appendToProgressArea("Writing dump " + dump.getName());
                    if (rset.last()) {
                        int rows = rset.getRow();
                        rset.beforeFirst();
                        if (rows > 0) {
                            this._frame.setProgressIndeterminate(false);
                            this._frame.setProgressMaximum(rows);
                        }
                    }
                    try (PrintWriter fws = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(dump), StandardCharsets.UTF_8));){
                        fws.println("-- L2J DBDumper 1.0");
                        fws.println("--");
                        fws.println("-- Host: " + this._host + "    Database: " + this._db);
                        fws.println("-- ------------------------------------------------------");
                        fws.println("-- Server version\t\t" + serverVersion);
                        fws.println();
                        fws.println("SET NAMES utf8;");
                        fws.println();
                        while (rset.next()) {
                            Throwable throwable3;
                            ResultSet dset;
                            String table = rset.getString(1);
                            this._frame.setProgressValue(rset.getRow());
                            this._frame.appendToProgressArea("Dumping Table " + table);
                            try (Statement desc = con.createStatement();){
                                dset = desc.executeQuery("SHOW CREATE TABLE " + table);
                                throwable3 = null;
                                try {
                                    fws.println("DROP TABLE IF EXISTS `" + table + "`;");
                                    while (dset.next()) {
                                        fws.println(dset.getString(2) + ";");
                                    }
                                }
                                catch (Throwable x2) {
                                    throwable3 = x2;
                                    throw x2;
                                }
                                finally {
                                    if (dset != null) {
                                        if (throwable3 != null) {
                                            try {
                                                dset.close();
                                            }
                                            catch (Throwable x2) {
                                                throwable3.addSuppressed(x2);
                                            }
                                        } else {
                                            dset.close();
                                        }
                                    }
                                }
                            }
                            desc = con.createStatement();
                            var13_30 = null;
                            try {
                                dset = desc.executeQuery("SELECT * FROM " + table);
                                throwable3 = null;
                                try {
                                    int cnt = 0;
                                    while (dset.next()) {
                                        if (cnt == 0) {
                                            fws.println("\nLOCK TABLES `" + table + "` WRITE;");
                                        }
                                        if (cnt % 100 == 0) {
                                            fws.println("INSERT INTO `" + table + "` VALUES ");
                                        } else {
                                            fws.println(",");
                                        }
                                        fws.print("(");
                                        for (int i = 1; i <= dset.getMetaData().getColumnCount(); ++i) {
                                            String value = dset.getString(i);
                                            if (i > 1) {
                                                fws.print(", ");
                                            }
                                            if (value == null) {
                                                fws.print("NULL");
                                                continue;
                                            }
                                            fws.print("'" + value.replace("'", "\\'") + "'");
                                        }
                                        fws.print(")");
                                        if (++cnt % 100 != 0) continue;
                                        fws.println(";");
                                    }
                                    if (cnt % 100 != 0) {
                                        fws.println(";");
                                    }
                                    if (cnt > 0) {
                                        fws.println("UNLOCK TABLES;");
                                    }
                                    fws.println();
                                }
                                catch (Throwable throwable4) {
                                    throwable3 = throwable4;
                                    throw throwable4;
                                }
                                finally {
                                    if (dset == null) continue;
                                    if (throwable3 != null) {
                                        try {
                                            dset.close();
                                        }
                                        catch (Throwable x2) {
                                            throwable3.addSuppressed(x2);
                                        }
                                        continue;
                                    }
                                    dset.close();
                                }
                            }
                            catch (Throwable throwable5) {
                                var13_30 = throwable5;
                                throw throwable5;
                            }
                            finally {
                                if (desc == null) continue;
                                if (var13_30 != null) {
                                    try {
                                        desc.close();
                                    }
                                    catch (Throwable x2) {
                                        var13_30.addSuppressed(x2);
                                    }
                                    continue;
                                }
                                desc.close();
                            }
                        }
                        fws.flush();
                    }
                }
                catch (Throwable throwable6) {
                    throwable = throwable6;
                    throw throwable6;
                }
                finally {
                    if (rset != null) {
                        if (throwable != null) {
                            try {
                                rset.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rset.close();
                        }
                    }
                }
            }
            catch (Throwable throwable7) {
                throwable2 = throwable7;
                throw throwable7;
            }
            finally {
                if (s != null) {
                    if (throwable2 != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (IOException | SQLException e) {
            e.printStackTrace();
        }
        this._frame.appendToProgressArea("Dump Complete!");
    }
}

