/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.util.StringUtil;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;

public class ThreadPoolManager {
    protected static final Logger _log = Logger.getLogger(ThreadPoolManager.class.getName());
    protected ScheduledThreadPoolExecutor _effectsScheduledThreadPool = new ScheduledThreadPoolExecutor(Config.THREAD_P_EFFECTS, new PriorityThreadFactory("EffectsSTPool", 5));
    protected ScheduledThreadPoolExecutor _generalScheduledThreadPool = new ScheduledThreadPoolExecutor(Config.THREAD_P_GENERAL, new PriorityThreadFactory("GeneralSTPool", 5));
    protected ScheduledThreadPoolExecutor _aiScheduledThreadPool;
    private final ThreadPoolExecutor _generalPacketsThreadPool;
    private final ThreadPoolExecutor _ioPacketsThreadPool = new ThreadPoolExecutor(Config.IO_PACKET_THREAD_CORE_SIZE, Integer.MAX_VALUE, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("I/O Packet Pool", 6));
    private final ThreadPoolExecutor _generalThreadPool;
    private boolean _shutdown;

    public static ThreadPoolManager getInstance() {
        return SingletonHolder._instance;
    }

    protected ThreadPoolManager() {
        this._generalPacketsThreadPool = new ThreadPoolExecutor(Config.GENERAL_PACKET_THREAD_CORE_SIZE, Config.GENERAL_PACKET_THREAD_CORE_SIZE + 2, 15L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("Normal Packet Pool", 6));
        this._generalThreadPool = new ThreadPoolExecutor(Config.GENERAL_THREAD_CORE_SIZE, Config.GENERAL_THREAD_CORE_SIZE + 2, 5L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new PriorityThreadFactory("General Pool", 5));
        this._aiScheduledThreadPool = new ScheduledThreadPoolExecutor(Config.AI_MAX_THREAD, new PriorityThreadFactory("AISTPool", 5));
        this.scheduleGeneralAtFixedRate(new PurgeTask(), 600000L, 300000L);
    }

    public ScheduledFuture<?> scheduleEffect(Runnable r, long delay) {
        try {
            return this._effectsScheduledThreadPool.schedule(new RunnableWrapper(r), delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleEffectAtFixedRate(Runnable task, long initialDelay, long period) {
        try {
            return this._effectsScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(task), initialDelay, period, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    @Deprecated
    public boolean removeEffect(RunnableScheduledFuture<?> r) {
        return this._effectsScheduledThreadPool.remove(r);
    }

    public ScheduledFuture<?> scheduleGeneral(Runnable r, long delay) {
        try {
            return this._generalScheduledThreadPool.schedule(new RunnableWrapper(r), delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleGeneralAtFixedRate(Runnable r, long initial, long delay) {
        try {
            return this._generalScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(r), initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleGeneralWithFixedDelay(Runnable r, long initial, long delay) {
        try {
            return this._generalScheduledThreadPool.scheduleWithFixedDelay(new RunnableWrapper(r), initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    @Deprecated
    public boolean removeGeneral(RunnableScheduledFuture<?> r) {
        return this._generalScheduledThreadPool.remove(r);
    }

    public ScheduledFuture<?> scheduleAi(Runnable r, long delay) {
        try {
            return this._aiScheduledThreadPool.schedule(new RunnableWrapper(r), delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public ScheduledFuture<?> scheduleAiAtFixedRate(Runnable r, long initial, long delay) {
        try {
            return this._aiScheduledThreadPool.scheduleAtFixedRate(new RunnableWrapper(r), initial, delay, TimeUnit.MILLISECONDS);
        }
        catch (RejectedExecutionException e) {
            return null;
        }
    }

    public void executePacket(Runnable pkt) {
        this._generalPacketsThreadPool.execute(pkt);
    }

    public void executeCommunityPacket(Runnable r) {
        this._generalPacketsThreadPool.execute(r);
    }

    public void executeIOPacket(Runnable pkt) {
        this._ioPacketsThreadPool.execute(pkt);
    }

    public void executeTask(Runnable r) {
        this._generalThreadPool.execute(r);
    }

    public void executeAi(Runnable r) {
        this._aiScheduledThreadPool.execute(new RunnableWrapper(r));
    }

    public String[] getStats() {
        return new String[]{"STP:", " + Effects:", " |- ActiveThreads:   " + this._effectsScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._effectsScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._effectsScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._effectsScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._effectsScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._effectsScheduledThreadPool.getQueue().size(), " | -------", " + General:", " |- ActiveThreads:   " + this._generalScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._generalScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._generalScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._generalScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._generalScheduledThreadPool.getQueue().size(), " | -------", " + AI:", " |- ActiveThreads:   " + this._aiScheduledThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._aiScheduledThreadPool.getCorePoolSize(), " |- PoolSize:        " + this._aiScheduledThreadPool.getPoolSize(), " |- MaximumPoolSize: " + this._aiScheduledThreadPool.getMaximumPoolSize(), " |- CompletedTasks:  " + this._aiScheduledThreadPool.getCompletedTaskCount(), " |- ScheduledTasks:  " + this._aiScheduledThreadPool.getQueue().size(), "TP:", " + Packets:", " |- ActiveThreads:   " + this._generalPacketsThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalPacketsThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._generalPacketsThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._generalPacketsThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._generalPacketsThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._generalPacketsThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._generalPacketsThreadPool.getQueue().size(), " | -------", " + I/O Packets:", " |- ActiveThreads:   " + this._ioPacketsThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._ioPacketsThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._ioPacketsThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._ioPacketsThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._ioPacketsThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._ioPacketsThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._ioPacketsThreadPool.getQueue().size(), " | -------", " + General Tasks:", " |- ActiveThreads:   " + this._generalThreadPool.getActiveCount(), " |- getCorePoolSize: " + this._generalThreadPool.getCorePoolSize(), " |- MaximumPoolSize: " + this._generalThreadPool.getMaximumPoolSize(), " |- LargestPoolSize: " + this._generalThreadPool.getLargestPoolSize(), " |- PoolSize:        " + this._generalThreadPool.getPoolSize(), " |- CompletedTasks:  " + this._generalThreadPool.getCompletedTaskCount(), " |- QueuedTasks:     " + this._generalThreadPool.getQueue().size(), " | -------", " + Javolution stats:", " |- FastList:        " + FastList.report(), " |- FastMap:         " + FastMap.report(), " |- FastSet:         " + FastSet.report(), " | -------"};
    }

    public void shutdown() {
        this._shutdown = true;
        try {
            this._effectsScheduledThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalScheduledThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalPacketsThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._ioPacketsThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._generalThreadPool.awaitTermination(1L, TimeUnit.SECONDS);
            this._effectsScheduledThreadPool.shutdown();
            this._generalScheduledThreadPool.shutdown();
            this._generalPacketsThreadPool.shutdown();
            this._ioPacketsThreadPool.shutdown();
            this._generalThreadPool.shutdown();
            _log.info("All ThreadPools are now stopped");
        }
        catch (InterruptedException e) {
            _log.log(Level.WARNING, "", e);
        }
    }

    public boolean isShutdown() {
        return this._shutdown;
    }

    public void purge() {
        this._effectsScheduledThreadPool.purge();
        this._generalScheduledThreadPool.purge();
        this._aiScheduledThreadPool.purge();
        this._ioPacketsThreadPool.purge();
        this._generalPacketsThreadPool.purge();
        this._generalThreadPool.purge();
    }

    public String getPacketStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._generalPacketsThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "General Packet Thread Pool:" + Config.EOL + "Tasks in the queue: ", String.valueOf(this._generalPacketsThreadPool.getQueue().size()), Config.EOL + "Showing threads stack trace:" + Config.EOL + "There should be ", String.valueOf(count), " Threads" + Config.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Config.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Config.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.");
        sb.append(Config.EOL);
        return sb.toString();
    }

    public String getIOPacketStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._ioPacketsThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "I/O Packet Thread Pool:" + Config.EOL + "Tasks in the queue: ", String.valueOf(this._ioPacketsThreadPool.getQueue().size()), Config.EOL + "Showing threads stack trace:" + Config.EOL + "There should be ", String.valueOf(count), " Threads" + Config.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Config.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Config.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.").append(Config.EOL);
        return sb.toString();
    }

    public String getGeneralStats() {
        StringBuilder sb = new StringBuilder(1000);
        ThreadFactory tf = this._generalThreadPool.getThreadFactory();
        if (tf instanceof PriorityThreadFactory) {
            PriorityThreadFactory ptf = (PriorityThreadFactory)tf;
            int count = ptf.getGroup().activeCount();
            Thread[] threads = new Thread[count + 2];
            ptf.getGroup().enumerate(threads);
            StringUtil.append(sb, "General Thread Pool:" + Config.EOL + "Tasks in the queue: ", String.valueOf(this._generalThreadPool.getQueue().size()), Config.EOL + "Showing threads stack trace:" + Config.EOL + "There should be ", String.valueOf(count), " Threads" + Config.EOL);
            for (Thread t : threads) {
                if (t == null) continue;
                StringUtil.append(sb, t.getName(), Config.EOL);
                for (StackTraceElement ste : t.getStackTrace()) {
                    StringUtil.append(sb, ste.toString(), Config.EOL);
                }
            }
        }
        sb.append("Packet Tp stack traces printed.").append(Config.EOL);
        return sb.toString();
    }

    private static class SingletonHolder {
        protected static final ThreadPoolManager _instance = new ThreadPoolManager();

        private SingletonHolder() {
        }
    }

    protected class PurgeTask
    implements Runnable {
        protected PurgeTask() {
        }

        @Override
        public void run() {
            ThreadPoolManager.this._effectsScheduledThreadPool.purge();
            ThreadPoolManager.this._generalScheduledThreadPool.purge();
            ThreadPoolManager.this._aiScheduledThreadPool.purge();
        }
    }

    private static class PriorityThreadFactory
    implements ThreadFactory {
        private final int _prio;
        private final String _name;
        private final AtomicInteger _threadNumber = new AtomicInteger(1);
        private final ThreadGroup _group;

        public PriorityThreadFactory(String name, int prio) {
            this._prio = prio;
            this._name = name;
            this._group = new ThreadGroup(this._name);
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this._group, r, this._name + "-" + this._threadNumber.getAndIncrement());
            t.setPriority(this._prio);
            return t;
        }

        public ThreadGroup getGroup() {
            return this._group;
        }
    }

    private static final class RunnableWrapper
    implements Runnable {
        private final Runnable _r;

        public RunnableWrapper(Runnable r) {
            this._r = r;
        }

        @Override
        public final void run() {
            block2: {
                try {
                    this._r.run();
                }
                catch (Throwable e) {
                    Thread t = Thread.currentThread();
                    Thread.UncaughtExceptionHandler h = t.getUncaughtExceptionHandler();
                    if (h == null) break block2;
                    h.uncaughtException(t, e);
                }
            }
        }
    }
}

