/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.TradeItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OfflineTradersTable {
    private static Logger _log = Logger.getLogger(OfflineTradersTable.class.getName());
    private static final String SAVE_OFFLINE_STATUS = "INSERT INTO character_offline_trade (`charId`,`time`,`type`,`title`) VALUES (?,?,?,?)";
    private static final String SAVE_ITEMS = "INSERT INTO character_offline_trade_items (`charId`,`item`,`count`,`price`) VALUES (?,?,?,?)";
    private static final String CLEAR_OFFLINE_TABLE = "DELETE FROM character_offline_trade";
    private static final String CLEAR_OFFLINE_TABLE_ITEMS = "DELETE FROM character_offline_trade_items";
    private static final String LOAD_OFFLINE_STATUS = "SELECT * FROM character_offline_trade";
    private static final String LOAD_OFFLINE_ITEMS = "SELECT * FROM character_offline_trade_items WHERE charId = ?";

    public void storeOffliners() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement stm1 = con.prepareStatement(CLEAR_OFFLINE_TABLE);
             PreparedStatement stm2 = con.prepareStatement(CLEAR_OFFLINE_TABLE_ITEMS);
             PreparedStatement stm3 = con.prepareStatement(SAVE_OFFLINE_STATUS);
             PreparedStatement stm_items = con.prepareStatement(SAVE_ITEMS);){
            stm1.execute();
            stm2.execute();
            con.setAutoCommit(false);
            block54: for (L2PcInstance pc : L2World.getInstance().getPlayers()) {
                try {
                    if (pc.getPrivateStoreType() == PrivateStoreType.NONE || pc.getClient() != null && !pc.getClient().isDetached()) continue;
                    stm3.setInt(1, pc.getObjectId());
                    stm3.setLong(2, pc.getOfflineStartTime());
                    stm3.setInt(3, pc.getPrivateStoreType().getId());
                    String title = null;
                    switch (pc.getPrivateStoreType()) {
                        case BUY: {
                            if (!Config.OFFLINE_TRADE_ENABLE) continue block54;
                            title = pc.getBuyList().getTitle();
                            for (TradeItem i : pc.getBuyList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getItem().getId());
                                stm_items.setLong(3, i.getCount());
                                stm_items.setLong(4, i.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case SELL: 
                        case PACKAGE_SELL: {
                            if (!Config.OFFLINE_TRADE_ENABLE) continue block54;
                            title = pc.getSellList().getTitle();
                            for (TradeItem i : pc.getSellList().getItems()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getObjectId());
                                stm_items.setLong(3, i.getCount());
                                stm_items.setLong(4, i.getPrice());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                        case MANUFACTURE: {
                            if (!Config.OFFLINE_CRAFT_ENABLE) continue block54;
                            title = pc.getStoreName();
                            for (L2ManufactureItem i : pc.getManufactureItems().values()) {
                                stm_items.setInt(1, pc.getObjectId());
                                stm_items.setInt(2, i.getRecipeId());
                                stm_items.setLong(3, 0L);
                                stm_items.setLong(4, i.getCost());
                                stm_items.executeUpdate();
                                stm_items.clearParameters();
                            }
                            break;
                        }
                    }
                    stm3.setString(4, title);
                    stm3.executeUpdate();
                    stm3.clearParameters();
                    con.commit();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while saving offline trader: " + pc.getObjectId() + " " + e, e);
                }
            }
            _log.info(this.getClass().getSimpleName() + ": Offline traders stored.");
        }
        catch (Exception e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while saving offline traders: " + e, e);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void restoreOfflineTraders() {
        OfflineTradersTable._log.info(this.getClass().getSimpleName() + ": Loading offline traders...");
        nTraders = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            var3_4 = null;
            try {
                stm = con.createStatement();
                var5_8 = null;
                try {
                    rs = stm.executeQuery("SELECT * FROM character_offline_trade");
                    var7_12 = null;
                    try {
                        while (rs.next()) {
                            time = rs.getLong("time");
                            if (Config.OFFLINE_MAX_DAYS > 0) {
                                cal = Calendar.getInstance();
                                cal.setTimeInMillis(time);
                                cal.add(6, Config.OFFLINE_MAX_DAYS);
                                if (cal.getTimeInMillis() <= System.currentTimeMillis()) continue;
                            }
                            if ((type = PrivateStoreType.findById(rs.getInt("type"))) == null) {
                                OfflineTradersTable._log.warning(this.getClass().getSimpleName() + ": PrivateStoreType with id " + rs.getInt("type") + " could not be found.");
                                continue;
                            }
                            if (type == PrivateStoreType.NONE) continue;
                            player = null;
                            try {
                                client = new L2GameClient(null);
                                client.setDetached(true);
                                player = L2PcInstance.load(rs.getInt("charId"));
                                client.setActiveChar(player);
                                player.setOnlineStatus(true, false);
                                client.setAccountName(player.getAccountNamePlayer());
                                client.setState(L2GameClient.GameClientState.IN_GAME);
                                player.setClient(client);
                                player.setOfflineStartTime(time);
                                player.spawnMe(player.getX(), player.getY(), player.getZ());
                                LoginServerThread.getInstance().addGameServerLogin(player.getAccountName(), client);
                                stm_items = con.prepareStatement("SELECT * FROM character_offline_trade_items WHERE charId = ?");
                                var14_24 = null;
                                try {
                                    stm_items.setInt(1, player.getObjectId());
                                    items = stm_items.executeQuery();
                                    var16_28 = null;
                                    try {
                                        switch (1.$SwitchMap$com$l2jserver$gameserver$enums$PrivateStoreType[type.ordinal()]) {
                                            case 1: {
                                                while (items.next()) {
                                                    if (player.getBuyList().addItemByItemId(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                                    throw new NullPointerException();
                                                }
                                                player.getBuyList().setTitle(rs.getString("title"));
                                                ** break;
lbl51:
                                                // 1 sources

                                                break;
                                            }
                                            case 2: 
                                            case 3: {
                                                while (items.next()) {
                                                    if (player.getSellList().addItem(items.getInt(2), items.getLong(3), items.getLong(4)) != null) continue;
                                                    throw new NullPointerException();
                                                }
                                                player.getSellList().setTitle(rs.getString("title"));
                                                player.getSellList().setPackaged(type == PrivateStoreType.PACKAGE_SELL);
                                                ** break;
lbl59:
                                                // 1 sources

                                                break;
                                            }
                                            case 4: {
                                                while (items.next()) {
                                                    player.getManufactureItems().put(items.getInt(2), new L2ManufactureItem(items.getInt(2), items.getLong(4)));
                                                }
                                                player.setStoreName(rs.getString("title"));
                                                break;
                                            }
                                        }
                                    }
                                    catch (Throwable var17_30) {
                                        var16_28 = var17_30;
                                        throw var17_30;
                                    }
                                    finally {
                                        if (items != null) {
                                            if (var16_28 != null) {
                                                try {
                                                    items.close();
                                                }
                                                catch (Throwable x2) {
                                                    var16_28.addSuppressed(x2);
                                                }
                                            } else {
                                                items.close();
                                            }
                                        }
                                    }
                                }
                                catch (Throwable var15_27) {
                                    var14_24 = var15_27;
                                    throw var15_27;
                                }
                                finally {
                                    if (stm_items != null) {
                                        if (var14_24 != null) {
                                            try {
                                                stm_items.close();
                                            }
                                            catch (Throwable x2) {
                                                var14_24.addSuppressed(x2);
                                            }
                                        } else {
                                            stm_items.close();
                                        }
                                    }
                                }
                                player.sitDown();
                                if (Config.OFFLINE_SET_NAME_COLOR) {
                                    player.getAppearance().setNameColor(Config.OFFLINE_NAME_COLOR);
                                }
                                player.setPrivateStoreType(type);
                                player.setOnlineStatus(true, true);
                                player.restoreEffects();
                                player.broadcastUserInfo();
                                ++nTraders;
                            }
                            catch (Exception e) {
                                OfflineTradersTable._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error loading trader: " + player, e);
                                if (player == null) continue;
                                player.deleteMe();
                            }
                        }
                        OfflineTradersTable._log.info(this.getClass().getSimpleName() + ": Loaded: " + nTraders + " offline trader(s)");
                        stm1 = con.createStatement();
                        var9_35 = null;
                        try {
                            stm1.execute("DELETE FROM character_offline_trade");
                            stm1.execute("DELETE FROM character_offline_trade_items");
                            return;
                        }
                        catch (Throwable var10_19) {
                            var9_35 = var10_19;
                            throw var10_19;
                        }
                        finally {
                            if (stm1 != null) {
                                if (var9_35 != null) {
                                    try {
                                        stm1.close();
                                    }
                                    catch (Throwable x2) {
                                        var9_35.addSuppressed(x2);
                                    }
                                } else {
                                    stm1.close();
                                }
                            }
                        }
                    }
                    catch (Throwable var8_16) {
                        var7_12 = var8_16;
                        throw var8_16;
                    }
                    finally {
                        if (rs != null) {
                            if (var7_12 != null) {
                                try {
                                    rs.close();
                                }
                                catch (Throwable x2) {
                                    var7_12.addSuppressed(x2);
                                }
                            } else {
                                rs.close();
                            }
                        }
                    }
                }
                catch (Throwable var6_11) {
                    var5_8 = var6_11;
                    throw var6_11;
                }
                finally {
                    if (stm != null) {
                        if (var5_8 != null) {
                            try {
                                stm.close();
                            }
                            catch (Throwable x2) {
                                var5_8.addSuppressed(x2);
                            }
                        } else {
                            stm.close();
                        }
                    }
                }
            }
            catch (Throwable var4_7) {
                var3_4 = var4_7;
                throw var4_7;
            }
            finally {
                if (con != null) {
                    if (var3_4 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable x2) {
                            var3_4.addSuppressed(x2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            OfflineTradersTable._log.log(Level.WARNING, this.getClass().getSimpleName() + ": Error while loading offline traders: ", e);
        }
    }

    public static OfflineTradersTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final OfflineTradersTable _instance = new OfflineTradersTable();

        private SingletonHolder() {
        }
    }
}

