/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.StatsSet;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class PetDataTable
extends DocumentParser {
    private static final SortedIntObjectArrayMap<L2PetData> _pets = new SortedIntObjectArrayMap((Object[])new L2PetData[0]);

    protected PetDataTable() {
        this.load();
    }

    @Override
    public void load() {
        _pets.clear();
        this.parseDatapackDirectory("data/stats/pets", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + _pets.size() + " Pets.");
    }

    @Override
    protected void parseDocument() {
        Node n = this.getCurrentDocument().getFirstChild();
        for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
            if (!d.getNodeName().equals("pet")) continue;
            int npcId = this.parseInt(d.getAttributes(), "id");
            int itemId = this.parseInt(d.getAttributes(), "itemId");
            L2PetData data = new L2PetData(npcId, itemId);
            for (Node p = d.getFirstChild(); p != null; p = p.getNextSibling()) {
                Node s;
                NamedNodeMap attrs;
                if (p.getNodeName().equals("set")) {
                    attrs = p.getAttributes();
                    String type = attrs.getNamedItem("name").getNodeValue();
                    if ("food".equals(type)) {
                        for (String foodId : attrs.getNamedItem("val").getNodeValue().split(";")) {
                            data.addFood(Integer.valueOf(foodId));
                        }
                        continue;
                    }
                    if ("load".equals(type)) {
                        data.setLoad(this.parseInt(attrs, "val"));
                        continue;
                    }
                    if ("hungry_limit".equals(type)) {
                        data.setHungryLimit(this.parseInt(attrs, "val"));
                        continue;
                    }
                    if (!"sync_level".equals(type)) continue;
                    data.setSyncLevel(this.parseInt(attrs, "val") == 1);
                    continue;
                }
                if (p.getNodeName().equals("skills")) {
                    for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                        if (!s.getNodeName().equals("skill")) continue;
                        attrs = s.getAttributes();
                        data.addNewSkill(this.parseInt(attrs, "skillId"), this.parseInt(attrs, "skillLvl"), this.parseInt(attrs, "minLvl"));
                    }
                    continue;
                }
                if (!p.getNodeName().equals("stats")) continue;
                for (s = p.getFirstChild(); s != null; s = s.getNextSibling()) {
                    if (!s.getNodeName().equals("stat")) continue;
                    int level = Integer.parseInt(s.getAttributes().getNamedItem("level").getNodeValue());
                    StatsSet set = new StatsSet();
                    for (Node bean = s.getFirstChild(); bean != null; bean = bean.getNextSibling()) {
                        if (!bean.getNodeName().equals("set")) continue;
                        attrs = bean.getAttributes();
                        if (attrs.getNamedItem("name").getNodeValue().equals("speed_on_ride")) {
                            set.set("walkSpeedOnRide", attrs.getNamedItem("walk").getNodeValue());
                            set.set("runSpeedOnRide", attrs.getNamedItem("run").getNodeValue());
                            set.set("slowSwimSpeedOnRide", attrs.getNamedItem("slowSwim").getNodeValue());
                            set.set("fastSwimSpeedOnRide", attrs.getNamedItem("fastSwim").getNodeValue());
                            if (attrs.getNamedItem("slowFly") != null) {
                                set.set("slowFlySpeedOnRide", attrs.getNamedItem("slowFly").getNodeValue());
                            }
                            if (attrs.getNamedItem("fastFly") == null) continue;
                            set.set("fastFlySpeedOnRide", attrs.getNamedItem("fastFly").getNodeValue());
                            continue;
                        }
                        set.set(attrs.getNamedItem("name").getNodeValue(), attrs.getNamedItem("val").getNodeValue());
                    }
                    data.addNewStat(level, new L2PetLevelData(set));
                }
            }
            _pets.append(npcId, (Object)data);
        }
    }

    public L2PetData getPetDataByItemId(int itemId) {
        for (L2PetData data : (L2PetData[])_pets.values()) {
            if (data.getItemId() != itemId) continue;
            return data;
        }
        return null;
    }

    public L2PetLevelData getPetLevelData(int petId, int petLevel) {
        L2PetData pd = this.getPetData(petId);
        if (pd != null) {
            return pd.getPetLevelData(petLevel);
        }
        return null;
    }

    public L2PetData getPetData(int petId) {
        L2PetData data = (L2PetData)_pets.get(petId);
        if (data == null) {
            this._log.info(this.getClass().getSimpleName() + ": Missing pet data for npcid: " + petId);
        }
        return data;
    }

    public int getPetMinLevel(int petId) {
        return ((L2PetData)_pets.get(petId)).getMinLevel();
    }

    public static boolean isStrider(int npcId) {
        return npcId >= 12526 && npcId <= 12528 || npcId >= 16038 && npcId <= 16040 || npcId == 16068;
    }

    public static boolean isGrowUpWolfGroup(int npcId) {
        return npcId == 16025 || npcId == 16030 || npcId == 16037 || npcId == 16041 || npcId == 16042;
    }

    public static boolean isHatchlingGroup(int npcId) {
        return npcId >= 12311 && npcId <= 12313;
    }

    public static boolean isAllWolfGroup(int npcId) {
        return npcId == 12077 || npcId == 16025 || npcId == 16030 || npcId == 16037 || npcId == 16041 || npcId == 16042;
    }

    public static boolean isBabyPetGroup(int npcId) {
        return npcId >= 12780 && npcId <= 12782;
    }

    public static boolean isUpgradeBabyPetGroup(int npcId) {
        return npcId >= 16034 && npcId <= 16036;
    }

    public static boolean isItemEquipPetGroup(int npcId) {
        return npcId == 12077 || npcId >= 12311 && npcId <= 12313 || npcId >= 12526 && npcId <= 12528 || npcId >= 12780 && npcId <= 12782 || npcId == 16025 || npcId == 16030 || npcId >= 16034 && npcId <= 16036 || npcId == 16037 || npcId >= 16038 && npcId <= 16042 || npcId == 16068 || npcId == 16067 || npcId == 16071 || npcId == 16072 || npcId == 1561;
    }

    public static int[] getPetItemsByNpc(int npcId) {
        switch (npcId) {
            case 12077: {
                return new int[]{2375};
            }
            case 16025: {
                return new int[]{9882};
            }
            case 16030: {
                return new int[]{10163};
            }
            case 16037: {
                return new int[]{10307};
            }
            case 16041: {
                return new int[]{10426};
            }
            case 16042: {
                return new int[]{10611};
            }
            case 12564: {
                return new int[]{4425};
            }
            case 12311: 
            case 12312: 
            case 12313: {
                return new int[]{3500, 3501, 3502};
            }
            case 12526: 
            case 12527: 
            case 12528: 
            case 16038: 
            case 16039: 
            case 16040: 
            case 16068: {
                return new int[]{4422, 4423, 4424, 10308, 10309, 10310, 14819};
            }
            case 12621: {
                return new int[]{8663};
            }
            case 12780: 
            case 12781: 
            case 12782: {
                return new int[]{6648, 6649, 6650};
            }
            case 16034: 
            case 16035: 
            case 16036: {
                return new int[]{10311, 10312, 10313};
            }
        }
        return new int[]{0};
    }

    public static boolean isMountable(int npcId) {
        return npcId == 12526 || npcId == 12527 || npcId == 12528 || npcId == 12621 || npcId == 16037 || npcId == 16041 || npcId == 16042 || npcId == 16038 || npcId == 16039 || npcId == 16040 || npcId == 16068;
    }

    public static PetDataTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final PetDataTable _instance = new PetDataTable();

        private SingletonHolder() {
        }
    }
}

