/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.L2Territory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class TerritoryTable {
    private static final Logger _log = Logger.getLogger(TerritoryTable.class.getName());
    private static final FastIntObjectMap<L2Territory> _territory = new FastIntObjectMap();

    protected TerritoryTable() {
        this.load();
    }

    public int[] getRandomPoint(int terr) {
        return ((L2Territory)_territory.get(terr)).getRandomPoint();
    }

    public int getProcMax(int terr) {
        return ((L2Territory)_territory.get(terr)).getProcMax();
    }

    public void load() {
        _territory.clear();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement stmt = con.createStatement();
             ResultSet rset = stmt.executeQuery("SELECT * FROM locations WHERE loc_id>0");){
            while (rset.next()) {
                int terrId = rset.getInt("loc_id");
                L2Territory terr = (L2Territory)_territory.get(terrId);
                if (terr == null) {
                    terr = new L2Territory(terrId);
                    _territory.put(terrId, (Object)terr);
                }
                terr.add(rset.getInt("loc_x"), rset.getInt("loc_y"), rset.getInt("loc_zmin"), rset.getInt("loc_zmax"), rset.getInt("proc"));
            }
            _log.info("TerritoryTable: Loaded " + _territory.size() + " territories from database.");
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "TerritoryTable: Failed to load territories from database!", e);
        }
    }

    public static TerritoryTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final TerritoryTable _instance = new TerritoryTable();

        private SingletonHolder() {
        }
    }
}

