/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.instancemanager;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.zone.AbstractZoneSettings;
import com.l2jserver.gameserver.model.zone.L2ZoneForm;
import com.l2jserver.gameserver.model.zone.L2ZoneRespawn;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.form.ZoneCuboid;
import com.l2jserver.gameserver.model.zone.form.ZoneCylinder;
import com.l2jserver.gameserver.model.zone.form.ZoneNPoly;
import com.l2jserver.gameserver.model.zone.type.L2ArenaZone;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.model.zone.type.L2RespawnZone;
import com.l2jserver.gameserver.model.zone.type.NpcSpawnTerritory;
import com.l2jserver.util.Util;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ZoneManager
extends DocumentParser {
    private static final Map<String, AbstractZoneSettings> _settings = new HashMap<String, AbstractZoneSettings>();
    private final Map<Class<? extends L2ZoneType>, Map<Integer, ? extends L2ZoneType>> _classZones = new HashMap<Class<? extends L2ZoneType>, Map<Integer, ? extends L2ZoneType>>();
    private final Map<String, NpcSpawnTerritory> _spawnTerritories = new HashMap<String, NpcSpawnTerritory>();
    private int _lastDynamicId = 300000;
    private List<L2ItemInstance> _debugItems;

    protected ZoneManager() {
        this._log.info("Initializing ZoneManager");
        this.load();
    }

    public void reload() {
        int count = 0;
        L2WorldRegion[][] worldRegions = L2World.getInstance().getWorldRegions();
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            for (L2ZoneType l2ZoneType : map.values()) {
                if (l2ZoneType.getSettings() == null) continue;
                _settings.put(l2ZoneType.getName(), l2ZoneType.getSettings());
            }
        }
        L2WorldRegion[][] arr$ = worldRegions;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            L2WorldRegion[] l2WorldRegionArray;
            for (L2WorldRegion element : l2WorldRegionArray = arr$[i$]) {
                element.getZones().clear();
                ++count;
            }
        }
        GrandBossManager.getInstance().getZones().clear();
        this._log.info(this.getClass().getSimpleName() + ": Removed zones in " + count + " regions.");
        this.load();
        for (L2Object obj : L2World.getInstance().getVisibleObjects()) {
            if (!(obj instanceof L2Character)) continue;
            ((L2Character)obj).revalidateZone(true);
        }
        _settings.clear();
    }

    @Override
    protected void parseDocument() {
        L2WorldRegion[][] worldRegions = L2World.getInstance().getWorldRegions();
        ArrayList<int[]> rs = new ArrayList<int[]>();
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            NamedNodeMap attrs;
            Node attribute;
            if (!"list".equalsIgnoreCase(n.getNodeName()) || (attribute = (attrs = n.getAttributes()).getNamedItem("enabled")) != null && !Boolean.parseBoolean(attribute.getNodeValue())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                L2ZoneType temp;
                L2ZoneForm zoneForm;
                String zoneName;
                int zoneId;
                String zoneType;
                block31: {
                    if (!"zone".equalsIgnoreCase(d.getNodeName())) continue;
                    attrs = d.getAttributes();
                    attribute = attrs.getNamedItem("type");
                    if (attribute == null) {
                        this._log.warning("ZoneData: Missing type for zone in file: " + this.getCurrentFile().getName());
                        continue;
                    }
                    zoneType = attribute.getNodeValue();
                    attribute = attrs.getNamedItem("id");
                    if (attribute != null) {
                        zoneId = Integer.parseInt(attribute.getNodeValue());
                    } else {
                        int n2;
                        if (zoneType.equalsIgnoreCase("NpcSpawnTerritory")) {
                            n2 = 0;
                        } else {
                            int n3 = this._lastDynamicId;
                            n2 = n3;
                            this._lastDynamicId = n3 + 1;
                        }
                        zoneId = n2;
                    }
                    attribute = attrs.getNamedItem("name");
                    zoneName = attribute != null ? attribute.getNodeValue() : null;
                    if (zoneType.equalsIgnoreCase("NpcSpawnTerritory")) {
                        if (zoneName == null) {
                            this._log.warning("ZoneData: Missing name for NpcSpawnTerritory in file: " + this.getCurrentFile().getName() + ", skipping zone");
                            continue;
                        }
                        if (this._spawnTerritories.containsKey(zoneName)) {
                            this._log.warning("ZoneData: Name " + zoneName + " already used for another zone, check file: " + this.getCurrentFile().getName() + ". Skipping zone");
                            continue;
                        }
                    }
                    int minZ = this.parseInteger(attrs, "minZ");
                    int maxZ = this.parseInteger(attrs, "maxZ");
                    zoneType = attrs.getNamedItem("type").getNodeValue();
                    String zoneShape = attrs.getNamedItem("shape").getNodeValue();
                    zoneForm = null;
                    try {
                        rs.clear();
                        for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if (!"node".equalsIgnoreCase(cd.getNodeName())) continue;
                            attrs = cd.getAttributes();
                            int[] point = new int[]{this.parseInteger(attrs, "X"), this.parseInteger(attrs, "Y")};
                            rs.add(point);
                        }
                        if (rs.size() == 0) {
                            this._log.warning(this.getClass().getSimpleName() + ": ZoneData: missing data for zone: " + zoneId + " XML file: " + this.getCurrentFile().getName());
                            continue;
                        }
                        int[][] coords = (int[][])rs.toArray((T[])new int[rs.size()][2]);
                        if (zoneShape.equalsIgnoreCase("Cuboid")) {
                            if (coords.length == 2) {
                                zoneForm = new ZoneCuboid(coords[0][0], coords[1][0], coords[0][1], coords[1][1], minZ, maxZ);
                                break block31;
                            }
                            this._log.warning(this.getClass().getSimpleName() + ": ZoneData: Missing cuboid vertex in sql data for zone: " + zoneId + " in file: " + this.getCurrentFile().getName());
                            continue;
                        }
                        if (zoneShape.equalsIgnoreCase("NPoly")) {
                            if (coords.length > 2) {
                                int[] aX = new int[coords.length];
                                int[] aY = new int[coords.length];
                                for (int i = 0; i < coords.length; ++i) {
                                    aX[i] = coords[i][0];
                                    aY[i] = coords[i][1];
                                }
                                zoneForm = new ZoneNPoly(aX, aY, minZ, maxZ);
                                break block31;
                            }
                            this._log.warning(this.getClass().getSimpleName() + ": ZoneData: Bad data for zone: " + zoneId + " in file: " + this.getCurrentFile().getName());
                            continue;
                        }
                        if (zoneShape.equalsIgnoreCase("Cylinder")) {
                            attrs = d.getAttributes();
                            int zoneRad = Integer.parseInt(attrs.getNamedItem("rad").getNodeValue());
                            if (coords.length == 1 && zoneRad > 0) {
                                zoneForm = new ZoneCylinder(coords[0][0], coords[0][1], minZ, maxZ, zoneRad);
                                break block31;
                            }
                            this._log.warning(this.getClass().getSimpleName() + ": ZoneData: Bad data for zone: " + zoneId + " in file: " + this.getCurrentFile().getName());
                            continue;
                        }
                        this._log.warning(this.getClass().getSimpleName() + ": ZoneData: Unknown shape: \"" + zoneShape + "\"  for zone: " + zoneId + " in file: " + this.getCurrentFile().getName());
                        continue;
                    }
                    catch (Exception e) {
                        this._log.log(Level.WARNING, this.getClass().getSimpleName() + ": ZoneData: Failed to load zone " + zoneId + " coordinates: " + e.getMessage(), e);
                    }
                }
                if (zoneType.equalsIgnoreCase("NpcSpawnTerritory")) {
                    this._spawnTerritories.put(zoneName, new NpcSpawnTerritory(zoneName, zoneForm));
                    continue;
                }
                Class<?> newZone = null;
                Constructor<?> zoneConstructor = null;
                try {
                    newZone = Class.forName("com.l2jserver.gameserver.model.zone.type.L2" + zoneType);
                    zoneConstructor = newZone.getConstructor(Integer.TYPE);
                    temp = (L2ZoneType)zoneConstructor.newInstance(zoneId);
                    temp.setZone(zoneForm);
                }
                catch (Exception e) {
                    this._log.warning(this.getClass().getSimpleName() + ": ZoneData: No such zone type: " + zoneType + " in file: " + this.getCurrentFile().getName());
                    continue;
                }
                for (Node cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                    if ("stat".equalsIgnoreCase(cd.getNodeName())) {
                        attrs = cd.getAttributes();
                        String name = attrs.getNamedItem("name").getNodeValue();
                        String val = attrs.getNamedItem("val").getNodeValue();
                        temp.setParameter(name, val);
                        continue;
                    }
                    if ("spawn".equalsIgnoreCase(cd.getNodeName()) && temp instanceof L2ZoneRespawn) {
                        attrs = cd.getAttributes();
                        int spawnX = Integer.parseInt(attrs.getNamedItem("X").getNodeValue());
                        int spawnY = Integer.parseInt(attrs.getNamedItem("Y").getNodeValue());
                        int spawnZ = Integer.parseInt(attrs.getNamedItem("Z").getNodeValue());
                        Node val = attrs.getNamedItem("type");
                        ((L2ZoneRespawn)temp).parseLoc(spawnX, spawnY, spawnZ, val == null ? null : val.getNodeValue());
                        continue;
                    }
                    if (!"race".equalsIgnoreCase(cd.getNodeName()) || !(temp instanceof L2RespawnZone)) continue;
                    attrs = cd.getAttributes();
                    String race = attrs.getNamedItem("name").getNodeValue();
                    String point = attrs.getNamedItem("point").getNodeValue();
                    ((L2RespawnZone)temp).addRaceRespawnPoint(race, point);
                }
                if (this.checkId(zoneId)) {
                    this._log.config(this.getClass().getSimpleName() + ": Caution: Zone (" + zoneId + ") from file: " + this.getCurrentFile().getName() + " overrides previos definition.");
                }
                if (zoneName != null && !zoneName.isEmpty()) {
                    temp.setName(zoneName);
                }
                this.addZone(zoneId, temp);
                for (int x = 0; x < worldRegions.length; ++x) {
                    for (int y = 0; y < worldRegions[x].length; ++y) {
                        int ax = x - L2World.OFFSET_X << 12;
                        int bx = x + 1 - L2World.OFFSET_X << 12;
                        int ay = y - L2World.OFFSET_Y << 12;
                        int by = y + 1 - L2World.OFFSET_Y << 12;
                        if (!temp.getZone().intersectsRectangle(ax, bx, ay, by)) continue;
                        worldRegions[x][y].addZone(temp);
                    }
                }
            }
        }
    }

    @Override
    public final void load() {
        this._log.info(this.getClass().getSimpleName() + ": Loading zones...");
        this._classZones.clear();
        this._spawnTerritories.clear();
        long started = System.currentTimeMillis();
        this.parseDatapackDirectory("data/zones", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._classZones.size() + " zone classes and " + this.getSize() + " zones. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
        started = System.currentTimeMillis();
        this.parseDatapackDirectory("data/zones/npcSpawnTerritories", false);
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._spawnTerritories.size() + " NPC spawn territoriers. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    public int getSize() {
        int i = 0;
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            i += map.size();
        }
        return i;
    }

    public boolean checkId(int id) {
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            if (!map.containsKey(id)) continue;
            return true;
        }
        return false;
    }

    public <T extends L2ZoneType> void addZone(Integer id, T zone) {
        Map<Integer, ? extends L2ZoneType> map = this._classZones.get(zone.getClass());
        if (map == null) {
            map = new HashMap<Integer, L2ZoneType>();
            map.put(id, zone);
            this._classZones.put(zone.getClass(), map);
        } else {
            map.put(id, zone);
        }
    }

    @Deprecated
    public Collection<L2ZoneType> getAllZones() {
        ArrayList<L2ZoneType> zones = new ArrayList<L2ZoneType>();
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            zones.addAll(map.values());
        }
        return zones;
    }

    public <T extends L2ZoneType> Collection<T> getAllZones(Class<T> zoneType) {
        return this._classZones.get(zoneType).values();
    }

    public L2ZoneType getZoneById(int id) {
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            L2ZoneType z = map.get(id);
            if (z == null) continue;
            return z;
        }
        return null;
    }

    public L2ZoneType getZoneByName(String name) {
        for (Map<Integer, ? extends L2ZoneType> map : this._classZones.values()) {
            for (L2ZoneType l2ZoneType : map.values()) {
                if (!l2ZoneType.getName().equals(name)) continue;
                return l2ZoneType;
            }
        }
        return null;
    }

    public <T extends L2ZoneType> T getZoneById(int id, Class<T> zoneType) {
        return (T)this._classZones.get(zoneType).get(id);
    }

    public List<L2ZoneType> getZones(L2Object object) {
        return this.getZones(object.getX(), object.getY(), object.getZ());
    }

    public <T extends L2ZoneType> T getZone(L2Object object, Class<T> type) {
        if (object == null) {
            return null;
        }
        return this.getZone(object.getX(), object.getY(), object.getZ(), type);
    }

    public List<L2ZoneType> getZones(int x, int y) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        ArrayList<L2ZoneType> temp = new ArrayList<L2ZoneType>();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y)) continue;
            temp.add(zone);
        }
        return temp;
    }

    public List<L2ZoneType> getZones(int x, int y, int z) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        ArrayList<L2ZoneType> temp = new ArrayList<L2ZoneType>();
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z)) continue;
            temp.add(zone);
        }
        return temp;
    }

    public <T extends L2ZoneType> T getZone(int x, int y, int z, Class<T> type) {
        L2WorldRegion region = L2World.getInstance().getRegion(x, y);
        for (L2ZoneType zone : region.getZones()) {
            if (!zone.isInsideZone(x, y, z) || !type.isInstance(zone)) continue;
            return (T)zone;
        }
        return null;
    }

    public NpcSpawnTerritory getSpawnTerritory(String name) {
        return this._spawnTerritories.get(name);
    }

    public List<NpcSpawnTerritory> getSpawnTerritories(L2Object object) {
        ArrayList<NpcSpawnTerritory> temp = new ArrayList<NpcSpawnTerritory>();
        for (NpcSpawnTerritory territory : this._spawnTerritories.values()) {
            if (!territory.isInsideZone(object.getX(), object.getY(), object.getZ())) continue;
            temp.add(territory);
        }
        return temp;
    }

    public final L2ArenaZone getArena(L2Character character) {
        if (character == null) {
            return null;
        }
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2ArenaZone) || !temp.isCharacterInZone(character)) continue;
            return (L2ArenaZone)temp;
        }
        return null;
    }

    public final L2OlympiadStadiumZone getOlympiadStadium(L2Character character) {
        if (character == null) {
            return null;
        }
        for (L2ZoneType temp : ZoneManager.getInstance().getZones(character.getX(), character.getY(), character.getZ())) {
            if (!(temp instanceof L2OlympiadStadiumZone) || !temp.isCharacterInZone(character)) continue;
            return (L2OlympiadStadiumZone)temp;
        }
        return null;
    }

    public <T extends L2ZoneType> T getClosestZone(L2Object obj, Class<T> type) {
        Object zone = this.getZone(obj, type);
        if (zone == null) {
            double closestdis = Double.MAX_VALUE;
            for (L2ZoneType l2ZoneType : this._classZones.get(type).values()) {
                double distance = l2ZoneType.getDistanceToZone(obj);
                if (!(distance < closestdis)) continue;
                closestdis = distance;
                zone = l2ZoneType;
            }
        }
        return zone;
    }

    public List<L2ItemInstance> getDebugItems() {
        if (this._debugItems == null) {
            this._debugItems = new ArrayList<L2ItemInstance>();
        }
        return this._debugItems;
    }

    public void clearDebugItems() {
        if (this._debugItems != null) {
            Iterator<L2ItemInstance> it = this._debugItems.iterator();
            while (it.hasNext()) {
                L2ItemInstance item = it.next();
                if (item != null) {
                    item.decayMe();
                }
                it.remove();
            }
        }
    }

    public static AbstractZoneSettings getSettings(String name) {
        return _settings.get(name);
    }

    public static final ZoneManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final ZoneManager _instance = new ZoneManager();

        private SingletonHolder() {
        }
    }
}

