/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.CreatureSay;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractPlayerGroup {
    public abstract List<L2PcInstance> getMembers();

    public List<Integer> getMembersObjectId() {
        final ArrayList<Integer> ids = new ArrayList<Integer>();
        this.forEachMember(new IProcedure<L2PcInstance, Boolean>(){

            public boolean execute(L2PcInstance member) {
                ids.add(member.getObjectId());
                return true;
            }
        });
        return ids;
    }

    public abstract L2PcInstance getLeader();

    public abstract void setLeader(L2PcInstance var1);

    public int getLeaderObjectId() {
        return this.getLeader().getObjectId();
    }

    public boolean isLeader(L2PcInstance player) {
        return this.getLeaderObjectId() == player.getObjectId();
    }

    public int getMemberCount() {
        return this.getMembers().size();
    }

    public abstract int getLevel();

    public void broadcastPacket(final L2GameServerPacket packet) {
        this.forEachMember(new IProcedure<L2PcInstance, Boolean>(){

            public boolean execute(L2PcInstance member) {
                if (member != null) {
                    member.sendPacket(packet);
                }
                return true;
            }
        });
    }

    public void broadcastMessage(SystemMessageId message) {
        this.broadcastPacket(SystemMessage.getSystemMessage(message));
    }

    public void broadcastString(String text) {
        this.broadcastPacket(SystemMessage.sendString(text));
    }

    public void broadcastCreatureSay(final CreatureSay msg, final L2PcInstance broadcaster) {
        this.forEachMember(new IProcedure<L2PcInstance, Boolean>(){

            public boolean execute(L2PcInstance member) {
                if (member != null && !BlockList.isBlocked(member, broadcaster)) {
                    member.sendPacket(msg);
                }
                return true;
            }
        });
    }

    public boolean containsPlayer(L2PcInstance player) {
        return this.getMembers().contains(player);
    }

    public L2PcInstance getRandomPlayer() {
        return this.getMembers().get(Rnd.get(this.getMemberCount()));
    }

    public boolean forEachMember(IProcedure<L2PcInstance, Boolean> procedure) {
        for (L2PcInstance player : this.getMembers()) {
            if (procedure.execute(player)) continue;
            return false;
        }
        return true;
    }
}

