/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.AbstractEffect;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.EffectScope;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.serverpackets.AbnormalStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadSpelledInfo;
import com.l2jserver.gameserver.network.serverpackets.PartySpelled;
import com.l2jserver.gameserver.network.serverpackets.ShortBuffStatusUpdate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javolution.util.FastMap;

public final class CharEffectList {
    private static final Logger _log = Logger.getLogger(CharEffectList.class.getName());
    private volatile FastMap<Integer, BuffInfo> _buffs;
    private volatile FastMap<Integer, BuffInfo> _triggered;
    private volatile FastMap<Integer, BuffInfo> _dances;
    private volatile FastMap<Integer, BuffInfo> _toggles;
    private volatile FastMap<Integer, BuffInfo> _debuffs;
    private volatile FastMap<Integer, BuffInfo> _passives;
    private volatile Map<AbnormalType, BuffInfo> _stackedEffects;
    private volatile Set<AbnormalType> _blockedBuffSlots = null;
    private BuffInfo _shortBuff = null;
    private volatile boolean _hasBuffsRemovedOnAnyAction = false;
    private volatile boolean _hasBuffsRemovedOnDamage = false;
    private volatile boolean _hasDebuffsRemovedOnDamage = false;
    private int _effectFlags;
    private boolean _partyOnly = false;
    private final L2Character _owner;
    private final AtomicInteger _hiddenBuffs = new AtomicInteger();

    public CharEffectList(L2Character owner) {
        this._owner = owner;
    }

    public final List<AbstractEffect> getAllEffects() {
        if (this.hasBuffs() || this.hasDebuffs()) {
            ArrayList<AbstractEffect> effects = new ArrayList<AbstractEffect>(this.getBuffs().size() + this.getDebuffs().size());
            if (this.hasBuffs()) {
                for (BuffInfo b : this.getBuffs().values()) {
                    effects.addAll(b.getEffects());
                }
            }
            if (this.hasDebuffs()) {
                for (BuffInfo b : this.getDebuffs().values()) {
                    effects.addAll(b.getEffects());
                }
            }
            return effects;
        }
        return Collections.emptyList();
    }

    public final Map<Integer, BuffInfo> getBuffs() {
        return this._buffs != null ? this._buffs : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> buffs() {
        if (this._buffs == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._buffs == null) {
                    this._buffs = new FastMap();
                    this._buffs.shared();
                }
            }
        }
        return this._buffs;
    }

    public final Map<Integer, BuffInfo> getTriggered() {
        return this._triggered != null ? this._triggered : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> triggered() {
        if (this._triggered == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._triggered == null) {
                    this._triggered = new FastMap();
                    this._triggered.shared();
                }
            }
        }
        return this._triggered;
    }

    public final Map<Integer, BuffInfo> getDances() {
        return this._dances != null ? this._dances : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> dances() {
        if (this._dances == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._dances == null) {
                    this._dances = new FastMap();
                    this._dances.shared();
                }
            }
        }
        return this._dances;
    }

    public final Map<Integer, BuffInfo> getToggles() {
        return this._toggles != null ? this._toggles : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> toggles() {
        if (this._toggles == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._toggles == null) {
                    this._toggles = new FastMap();
                    this._toggles.shared();
                }
            }
        }
        return this._toggles;
    }

    public final Map<Integer, BuffInfo> getDebuffs() {
        return this._debuffs != null ? this._debuffs : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> debuffs() {
        if (this._debuffs == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._debuffs == null) {
                    this._debuffs = new FastMap();
                    this._debuffs.shared();
                }
            }
        }
        return this._debuffs;
    }

    public final Map<Integer, BuffInfo> getPassives() {
        return this._passives != null ? this._passives : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, BuffInfo> passives() {
        if (this._passives == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._passives == null) {
                    this._passives = new FastMap();
                    this._passives.shared();
                }
            }
        }
        return this._passives;
    }

    public List<BuffInfo> getEffects() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<BuffInfo> buffs = new ArrayList<BuffInfo>();
        if (this.hasBuffs()) {
            buffs.addAll(this._buffs.values());
        }
        if (this.hasTriggered()) {
            buffs.addAll(this._triggered.values());
        }
        if (this.hasDances()) {
            buffs.addAll(this._dances.values());
        }
        if (this.hasToggles()) {
            buffs.addAll(this._toggles.values());
        }
        if (this.hasDebuffs()) {
            buffs.addAll(this._debuffs.values());
        }
        return buffs;
    }

    private Map<Integer, BuffInfo> getEffectList(Skill skill) {
        if (skill == null) {
            return null;
        }
        Map<Integer, BuffInfo> effects = skill.isPassive() ? this.passives() : (skill.isDebuff() ? this.debuffs() : (skill.isTriggeredSkill() ? this.triggered() : (skill.isDance() ? this.dances() : (skill.isToggle() ? this.toggles() : this.buffs()))));
        return effects;
    }

    public BuffInfo getFirstEffect(L2EffectType type) {
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    return info;
                }
            }
        }
        return null;
    }

    public boolean isAffectedBySkill(int skillId) {
        return this.isAffectedBySkill((Integer)skillId);
    }

    public boolean isAffectedBySkill(Integer skillId) {
        return this.hasBuffs() && this._buffs.containsKey((Object)skillId) || this.hasDebuffs() && this._debuffs.containsKey((Object)skillId) || this.hasTriggered() && this._triggered.containsKey((Object)skillId) || this.hasDances() && this._dances.containsKey((Object)skillId) || this.hasToggles() && this._toggles.containsKey((Object)skillId) || this.hasPassives() && this._passives.containsKey((Object)skillId);
    }

    public BuffInfo getBuffInfoBySkillId(int skillId) {
        return this.getBuffInfoBySkillId((Integer)skillId);
    }

    public BuffInfo getBuffInfoBySkillId(Integer skillId) {
        BuffInfo info;
        return this.hasBuffs() && (info = (BuffInfo)this._buffs.get((Object)skillId)) != null || this.hasTriggered() && (info = (BuffInfo)this._triggered.get((Object)skillId)) != null || this.hasDances() && (info = (BuffInfo)this._dances.get((Object)skillId)) != null || this.hasToggles() && (info = (BuffInfo)this._toggles.get((Object)skillId)) != null || this.hasDebuffs() && (info = (BuffInfo)this._debuffs.get((Object)skillId)) != null || this.hasPassives() && (info = (BuffInfo)this._passives.get((Object)skillId)) != null ? info : null;
    }

    public BuffInfo getBuffInfoByAbnormalType(AbnormalType type) {
        return this._stackedEffects != null ? this._stackedEffects.get((Object)type) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockedBuffSlots(Set<AbnormalType> blockedBuffSlots) {
        if (this._blockedBuffSlots == null) {
            CharEffectList charEffectList = this;
            synchronized (charEffectList) {
                if (this._blockedBuffSlots == null) {
                    this._blockedBuffSlots = new CopyOnWriteArraySet<AbnormalType>();
                }
            }
        }
        this._blockedBuffSlots.addAll(blockedBuffSlots);
    }

    public boolean removeBlockedBuffSlots(Set<AbnormalType> blockedBuffSlots) {
        if (this._blockedBuffSlots != null) {
            return this._blockedBuffSlots.removeAll(blockedBuffSlots);
        }
        return false;
    }

    public Set<AbnormalType> getAllBlockedBuffSlots() {
        return this._blockedBuffSlots;
    }

    public BuffInfo getShortBuff() {
        return this._shortBuff;
    }

    public void shortBuffStatusUpdate(BuffInfo info) {
        if (this._owner.isPlayer()) {
            this._shortBuff = info;
            if (info == null) {
                this._owner.sendPacket(ShortBuffStatusUpdate.RESET_SHORT_BUFF);
            } else {
                this._owner.sendPacket(new ShortBuffStatusUpdate(info.getSkill().getId(), info.getSkill().getLevel(), info.getTime()));
            }
        }
    }

    private boolean doesStack(Skill skill) {
        AbnormalType type = skill.getAbnormalType();
        if (type.isNone() || this.isEmpty()) {
            return false;
        }
        Map<Integer, BuffInfo> effects = this.getEffectList(skill);
        if (effects == null || effects.isEmpty()) {
            return false;
        }
        for (BuffInfo info : effects.values()) {
            if (info == null || info.getSkill().getAbnormalType() != type) continue;
            return true;
        }
        return false;
    }

    public int getBuffCount() {
        return this.hasBuffs() ? this.getBuffs().size() - this._hiddenBuffs.get() - (this.getShortBuff() != null ? 1 : 0) : 0;
    }

    public int getDanceCount() {
        return this.hasDances() ? this._dances.size() : 0;
    }

    public int getTriggeredBuffCount() {
        return this.hasTriggered() ? this._triggered.size() : 0;
    }

    public int getHiddenBuffsCount() {
        return this._hiddenBuffs.get();
    }

    private void stopAndRemove(boolean removed, BuffInfo info, Map<Integer, BuffInfo> effects) {
        info.stopAllEffects(removed);
        if (!info.isInUse()) {
            this._hiddenBuffs.decrementAndGet();
        } else if (this._stackedEffects != null) {
            this._stackedEffects.remove((Object)info.getSkill().getAbnormalType());
        }
        effects.remove(info.getSkill().getId());
        if (info.getSkill().isAbnormalInstant() && this.hasBuffs()) {
            for (BuffInfo buff : this._buffs.values()) {
                if (buff == null || buff.getSkill().getAbnormalType() != info.getSkill().getAbnormalType() || buff.isInUse()) continue;
                buff.setInUse(true);
                buff.addStats();
                if (this._stackedEffects != null) {
                    this._stackedEffects.put(buff.getSkill().getAbnormalType(), buff);
                }
                this._hiddenBuffs.decrementAndGet();
                break;
            }
        }
        if (!removed) {
            info.getSkill().applyEffectScope(EffectScope.END, info, true, false);
        }
    }

    private void stopAndRemove(BuffInfo info, Map<Integer, BuffInfo> effects) {
        this.stopAndRemove(true, info, effects);
    }

    public void stopAllEffects() {
        boolean update = false;
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null) continue;
                info.stopAllEffects(false);
            }
            this._buffs.clear();
            this._hiddenBuffs.set(0);
            update = true;
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null) continue;
                info.stopAllEffects(false);
            }
            this._triggered.clear();
            update = true;
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null) continue;
                info.stopAllEffects(false);
            }
            this._dances.clear();
            update = true;
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                info.stopAllEffects(false);
            }
            this._toggles.clear();
            update = true;
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                if (info == null) continue;
                info.stopAllEffects(false);
            }
            this._debuffs.clear();
            update = true;
        }
        if (this._stackedEffects != null) {
            this._stackedEffects.clear();
        }
        this.updateEffectList(update);
    }

    public void stopAllEffectsExceptThoseThatLastThroughDeath() {
        boolean update = false;
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null || info.getSkill().isStayAfterDeath()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._buffs);
                update = true;
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null || info.getSkill().isStayAfterDeath()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._triggered);
                update = true;
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null || info.getSkill().isStayAfterDeath()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._dances);
                update = true;
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null || info.getSkill().isStayAfterDeath()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
                update = true;
            }
        }
        this.updateEffectList(update);
    }

    public void stopAllEffectsNotStayOnSubclassChange() {
        boolean update = false;
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null || info.getSkill().isStayOnSubclassChange()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._buffs);
                update = true;
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null || info.getSkill().isStayOnSubclassChange()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._triggered);
                update = true;
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null || info.getSkill().isStayOnSubclassChange()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._dances);
                update = true;
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null || info.getSkill().isStayOnSubclassChange()) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
                update = true;
            }
        }
        this.updateEffectList(update);
    }

    public void stopAllToggles() {
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
            }
            this.updateEffectList(true);
        }
    }

    public void stopAllDances() {
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null) continue;
                this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._dances);
            }
            this.updateEffectList(true);
        }
    }

    public void stopEffects(L2EffectType type) {
        boolean update = false;
        if (this.hasBuffs()) {
            block0: for (BuffInfo info : this._buffs.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._buffs);
                    update = true;
                    continue block0;
                }
            }
        }
        if (this.hasTriggered()) {
            block2: for (BuffInfo info : this._triggered.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._triggered);
                    update = true;
                    continue block2;
                }
            }
        }
        if (this.hasDances()) {
            block4: for (BuffInfo info : this._dances.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._dances);
                    update = true;
                    continue block4;
                }
            }
        }
        if (this.hasToggles()) {
            block6: for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
                    update = true;
                    continue block6;
                }
            }
        }
        if (this.hasDebuffs()) {
            block8: for (BuffInfo info : this._debuffs.values()) {
                if (info == null) continue;
                for (AbstractEffect effect : info.getEffects()) {
                    if (effect == null || effect.getEffectType() != type) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._debuffs);
                    update = true;
                    continue block8;
                }
            }
        }
        this.updateEffectList(update);
    }

    public void stopSkillEffects(boolean removed, int skillId) {
        BuffInfo info = this.getBuffInfoBySkillId(skillId);
        if (info != null) {
            this.stopSkillEffects(removed, info.getSkill());
        }
    }

    public void stopSkillEffects(boolean removed, Skill skill) {
        if (skill == null || !this.isAffectedBySkill(skill.getId())) {
            return;
        }
        Map<Integer, BuffInfo> effects = this.getEffectList(skill);
        if (effects != null) {
            this.remove(removed, effects.get(skill.getId()));
        }
    }

    public boolean stopSkillEffects(boolean removed, AbnormalType type) {
        BuffInfo old;
        if (this._stackedEffects != null && (old = this._stackedEffects.remove((Object)type)) != null) {
            this.stopSkillEffects(removed, old.getSkill());
            return true;
        }
        return false;
    }

    public void stopEffectsOnAction() {
        if (this._hasBuffsRemovedOnAnyAction) {
            boolean update = false;
            if (this.hasBuffs()) {
                for (BuffInfo info : this._buffs.values()) {
                    if (info == null || !info.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._buffs);
                    update = true;
                }
            }
            if (this.hasTriggered()) {
                for (BuffInfo info : this._triggered.values()) {
                    if (info == null || !info.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._triggered);
                    update = true;
                }
            }
            if (this.hasToggles()) {
                for (BuffInfo info : this._toggles.values()) {
                    if (info == null || !info.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
                    update = true;
                }
            }
            if (this.hasDebuffs()) {
                for (BuffInfo info : this._debuffs.values()) {
                    if (info == null || !info.getSkill().isRemovedOnAnyActionExceptMove()) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._debuffs);
                    update = true;
                }
            }
            this.updateEffectList(update);
        }
    }

    public void stopEffectsOnDamage(boolean awake) {
        if (awake) {
            boolean update = false;
            if (this._hasBuffsRemovedOnDamage) {
                if (this.hasBuffs()) {
                    for (BuffInfo info : this._buffs.values()) {
                        if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                        this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._buffs);
                        update = true;
                    }
                }
                if (this.hasTriggered()) {
                    for (BuffInfo info : this._triggered.values()) {
                        if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                        this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._triggered);
                        update = true;
                    }
                }
                if (this.hasToggles()) {
                    for (BuffInfo info : this._toggles.values()) {
                        if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                        this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._toggles);
                        update = true;
                    }
                }
            }
            if (this._hasDebuffsRemovedOnDamage && this.hasDebuffs()) {
                for (BuffInfo info : this._debuffs.values()) {
                    if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                    this.stopAndRemove(info, (Map<Integer, BuffInfo>)this._debuffs);
                    update = true;
                }
            }
            this.updateEffectList(update);
        }
    }

    public void updateEffectIcons(boolean partyOnly) {
        if (partyOnly) {
            this._partyOnly = true;
        }
        this.updateEffectList(true);
    }

    public boolean isEmpty() {
        return !this.hasBuffs() && !this.hasTriggered() && !this.hasDances() && !this.hasDebuffs();
    }

    public boolean hasBuffs() {
        return this._buffs != null && !this._buffs.isEmpty();
    }

    public boolean hasTriggered() {
        return this._triggered != null && !this._triggered.isEmpty();
    }

    public boolean hasDances() {
        return this._dances != null && !this._dances.isEmpty();
    }

    public boolean hasToggles() {
        return this._toggles != null && !this._toggles.isEmpty();
    }

    public boolean hasDebuffs() {
        return this._debuffs != null && !this._debuffs.isEmpty();
    }

    public boolean hasPassives() {
        return this._passives != null && !this._passives.isEmpty();
    }

    public boolean forEach(IProcedure<BuffInfo, Boolean> procedure, boolean dances) {
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (procedure.execute(info)) continue;
                return false;
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (procedure.execute(info)) continue;
                return false;
            }
        }
        if (dances && this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (procedure.execute(info)) continue;
                return false;
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (procedure.execute(info)) continue;
                return false;
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                if (procedure.execute(info)) continue;
                return false;
            }
        }
        this.updateEffectList(true);
        return true;
    }

    public void remove(boolean removed, BuffInfo info) {
        if (info == null || !this.isAffectedBySkill(info.getSkill().getId())) {
            return;
        }
        this.stopAndRemove(removed, info, this.getEffectList(info.getSkill()));
        this.updateEffectList(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(BuffInfo info) {
        if (info == null) {
            return;
        }
        Skill skill = info.getSkill();
        if (this._blockedBuffSlots != null && this._blockedBuffSlots.contains((Object)skill.getAbnormalType())) {
            return;
        }
        if (skill.isPassive()) {
            BuffInfo infoToRemove;
            if (!skill.getAbnormalType().isNone()) {
                _log.warning("Passive " + skill + " with abnormal type: " + (Object)((Object)skill.getAbnormalType()) + "!");
            }
            if ((infoToRemove = this.passives().put(skill.getId(), info)) != null) {
                infoToRemove.setInUse(false);
                infoToRemove.removeStats();
            }
            info.initializeEffects();
            return;
        }
        if (skill.getAbnormalType().isNone()) {
            this.stopSkillEffects(false, skill);
        } else {
            if (this._stackedEffects == null) {
                CharEffectList infoToRemove = this;
                synchronized (infoToRemove) {
                    if (this._stackedEffects == null) {
                        this._stackedEffects = new ConcurrentHashMap<AbnormalType, BuffInfo>();
                    }
                }
            }
            if (this._stackedEffects.containsKey((Object)skill.getAbnormalType())) {
                BuffInfo stackedInfo = this._stackedEffects.get((Object)skill.getAbnormalType());
                if (stackedInfo != null && skill.getAbnormalLvl() >= stackedInfo.getSkill().getAbnormalLvl()) {
                    if (skill.isAbnormalInstant()) {
                        if (stackedInfo.getSkill().isAbnormalInstant()) {
                            this.stopSkillEffects(false, skill.getAbnormalType());
                            stackedInfo = this._stackedEffects.get((Object)skill.getAbnormalType());
                        }
                        if (stackedInfo != null) {
                            stackedInfo.setInUse(false);
                            stackedInfo.removeStats();
                            this._hiddenBuffs.incrementAndGet();
                        }
                    } else {
                        if (stackedInfo.getSkill().isAbnormalInstant()) {
                            this.stopSkillEffects(false, skill.getAbnormalType());
                        }
                        this.stopSkillEffects(false, skill.getAbnormalType());
                    }
                } else {
                    return;
                }
            }
            this._stackedEffects.put(skill.getAbnormalType(), info);
        }
        Map<Integer, BuffInfo> effects = this.getEffectList(skill);
        if (!(skill.isDebuff() || skill.isToggle() || skill.is7Signs() || this.doesStack(skill))) {
            int buffsToRemove = -1;
            if (skill.isDance()) {
                buffsToRemove = this.getDanceCount() - Config.DANCES_MAX_AMOUNT;
            } else if (skill.isTriggeredSkill()) {
                buffsToRemove = this.getTriggeredBuffCount() - Config.TRIGGERED_BUFFS_MAX_AMOUNT;
            } else if (!skill.isHealingPotionSkill()) {
                buffsToRemove = this.getBuffCount() - this._owner.getMaxBuffCount();
            }
            for (Map.Entry<Integer, BuffInfo> entry : effects.entrySet()) {
                if (buffsToRemove < 0) break;
                if (!entry.getValue().isInUse()) continue;
                this.stopAndRemove(entry.getValue(), effects);
                --buffsToRemove;
            }
        }
        effects.put(skill.getId(), info);
        info.initializeEffects();
        this.updateEffectList(true);
    }

    private void updateEffectIcons() {
        OlympiadGameTask game;
        if (this._owner == null) {
            return;
        }
        this.updateEffectFlags();
        if (!this._owner.isPlayable()) {
            return;
        }
        AbnormalStatusUpdate asu = null;
        PartySpelled ps = null;
        PartySpelled psSummon = null;
        ExOlympiadSpelledInfo os = null;
        boolean isSummon = false;
        if (this._owner.isPlayer()) {
            if (this._partyOnly) {
                this._partyOnly = false;
            } else {
                asu = new AbnormalStatusUpdate();
            }
            if (this._owner.isInParty()) {
                ps = new PartySpelled(this._owner);
            }
            if (this._owner.getActingPlayer().isInOlympiadMode() && this._owner.getActingPlayer().isOlympiadStart()) {
                os = new ExOlympiadSpelledInfo(this._owner.getActingPlayer());
            }
        } else if (this._owner.isSummon()) {
            isSummon = true;
            ps = new PartySpelled(this._owner);
            psSummon = new PartySpelled(this._owner);
        }
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info.getSkill().isHealingPotionSkill()) {
                    this.shortBuffStatusUpdate(info);
                    continue;
                }
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                this.addIcon(info, asu, ps, psSummon, os, isSummon);
            }
        }
        if (asu != null) {
            this._owner.sendPacket(asu);
        }
        if (ps != null) {
            if (this._owner.isSummon()) {
                L2PcInstance summonOwner = ((L2Summon)this._owner).getOwner();
                if (summonOwner != null) {
                    if (summonOwner.isInParty()) {
                        summonOwner.getParty().broadcastToPartyMembers(summonOwner, psSummon);
                        summonOwner.sendPacket(ps);
                    } else {
                        summonOwner.sendPacket(ps);
                    }
                }
            } else if (this._owner.isPlayer() && this._owner.isInParty()) {
                this._owner.getParty().broadcastPacket(ps);
            }
        }
        if (os != null && (game = OlympiadGameManager.getInstance().getOlympiadTask(this._owner.getActingPlayer().getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastPacketToObservers(os);
        }
    }

    private void addIcon(BuffInfo info, AbnormalStatusUpdate asu, PartySpelled ps, PartySpelled psSummon, ExOlympiadSpelledInfo os, boolean isSummon) {
        if (info == null || !info.isInUse()) {
            return;
        }
        Skill skill = info.getSkill();
        if (asu != null) {
            asu.addSkill(info);
        }
        if (ps != null && (isSummon || !skill.isToggle())) {
            ps.addSkill(info);
        }
        if (psSummon != null && !skill.isToggle()) {
            psSummon.addSkill(info);
        }
        if (os != null) {
            os.addSkill(info);
        }
    }

    private void updateEffectList(boolean update) {
        if (update) {
            this.updateEffectIcons();
            this.computeEffectFlags();
        }
    }

    private void updateEffectFlags() {
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                if (info.getSkill().isRemovedOnAnyActionExceptMove()) {
                    this._hasBuffsRemovedOnAnyAction = true;
                }
                if (!info.getSkill().isRemovedOnDamage()) continue;
                this._hasBuffsRemovedOnDamage = true;
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                if (info == null || !info.getSkill().isRemovedOnDamage()) continue;
                this._hasDebuffsRemovedOnDamage = true;
            }
        }
    }

    private void computeEffectFlags() {
        int flags = 0;
        if (this.hasBuffs()) {
            for (BuffInfo info : this._buffs.values()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasTriggered()) {
            for (BuffInfo info : this._triggered.values()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasDances()) {
            for (BuffInfo info : this._dances.values()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasToggles()) {
            for (BuffInfo info : this._toggles.values()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        if (this.hasDebuffs()) {
            for (BuffInfo info : this._debuffs.values()) {
                if (info == null) continue;
                for (AbstractEffect e : info.getEffects()) {
                    flags |= e.getEffectFlags();
                }
            }
        }
        this._effectFlags = flags;
    }

    public boolean isAffected(EffectFlag flag) {
        return (this._effectFlags & flag.getMask()) != 0;
    }
}

