/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.handler.ActionHandler;
import com.l2jserver.gameserver.handler.ActionShiftHandler;
import com.l2jserver.gameserver.handler.IActionHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.knownlist.ObjectKnownList;
import com.l2jserver.gameserver.model.actor.poly.ObjectPoly;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.interfaces.IDecayable;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.INamable;
import com.l2jserver.gameserver.model.interfaces.IPositionable;
import com.l2jserver.gameserver.model.interfaces.ISpawnable;
import com.l2jserver.gameserver.model.interfaces.IUniqueId;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ExSendUIEvent;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.Map;
import javolution.util.FastMap;

public abstract class L2Object
implements IIdentifiable,
INamable,
ISpawnable,
IUniqueId,
IDecayable,
IPositionable {
    private String _name;
    private int _objectId;
    private L2WorldRegion _worldRegion;
    private InstanceType _instanceType = null;
    private volatile Map<String, Object> _scripts;
    private int _x;
    private int _y;
    private int _z;
    private int _heading;
    private int _instanceId;
    private boolean _isVisible;
    private ObjectKnownList _knownList;

    public L2Object(int objectId) {
        this.setInstanceType(InstanceType.L2Object);
        this._objectId = objectId;
        this.initKnownList();
    }

    public final InstanceType getInstanceType() {
        return this._instanceType;
    }

    protected final void setInstanceType(InstanceType newInstanceType) {
        this._instanceType = newInstanceType;
    }

    public final boolean isInstanceTypes(InstanceType ... instanceTypes) {
        return this._instanceType.isTypes(instanceTypes);
    }

    public final boolean isInstanceTypes(InstanceType instanceType) {
        return this._instanceType.isType(instanceType);
    }

    public final boolean isInstanceType(InstanceType instanceType) {
        return this._instanceType.isType(instanceType);
    }

    public final void onAction(L2PcInstance player) {
        this.onAction(player, true);
    }

    public void onAction(L2PcInstance player, boolean interact) {
        IActionHandler handler = ActionHandler.getInstance().getHandler(this.getInstanceType());
        if (handler != null) {
            handler.action(player, this, interact);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onActionShift(L2PcInstance player) {
        IActionHandler handler = ActionShiftHandler.getInstance().getHandler(this.getInstanceType());
        if (handler != null) {
            handler.action(player, this, true);
        }
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onForcedAttack(L2PcInstance player) {
        player.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void onSpawn() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decayMe() {
        assert (this.getWorldRegion() != null);
        L2WorldRegion reg = this.getWorldRegion();
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = false;
            this.setWorldRegion(null);
        }
        L2World.getInstance().removeVisibleObject(this, reg);
        L2World.getInstance().removeObject(this);
        return true;
    }

    public void refreshID() {
        L2World.getInstance().removeObject(this);
        IdFactory.getInstance().releaseId(this.getObjectId());
        this._objectId = IdFactory.getInstance().getNextId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean spawnMe() {
        assert (this.getWorldRegion() == null && this.getPosition().getX() != 0 && this.getPosition().getY() != 0 && this.getPosition().getZ() != 0);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            this.setWorldRegion(L2World.getInstance().getRegion(this.getPosition()));
            L2World.getInstance().storeObject(this);
            this.getWorldRegion().addVisibleObject(this);
        }
        L2World.getInstance().addVisibleObject(this, this.getWorldRegion());
        this.onSpawn();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void spawnMe(int x, int y, int z) {
        assert (this.getWorldRegion() == null);
        L2Object l2Object = this;
        synchronized (l2Object) {
            this._isVisible = true;
            if (x > 229376) {
                x = 224376;
            }
            if (x < -294912) {
                x = -289912;
            }
            if (y > 294912) {
                y = 289912;
            }
            if (y < -262144) {
                y = -257144;
            }
            this.setXYZ(x, y, z);
            this.setWorldRegion(L2World.getInstance().getRegion(this.getPosition()));
        }
        L2World.getInstance().storeObject(this);
        this.getWorldRegion().addVisibleObject(this);
        L2World.getInstance().addVisibleObject(this, this.getWorldRegion());
        this.onSpawn();
    }

    public boolean canBeAttacked() {
        return false;
    }

    public abstract boolean isAutoAttackable(L2Character var1);

    public final boolean isVisible() {
        return this.getWorldRegion() != null;
    }

    public final void setIsVisible(boolean value) {
        this._isVisible = value;
        if (!this._isVisible) {
            this.setWorldRegion(null);
        }
    }

    public void toggleVisible() {
        if (this.isVisible()) {
            this.decayMe();
        } else {
            this.spawnMe();
        }
    }

    public ObjectKnownList getKnownList() {
        return this._knownList;
    }

    public void initKnownList() {
        this._knownList = new ObjectKnownList(this);
    }

    public final void setKnownList(ObjectKnownList value) {
        this._knownList = value;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String value) {
        this._name = value;
    }

    @Override
    public final int getObjectId() {
        return this._objectId;
    }

    public final ObjectPoly getPoly() {
        ObjectPoly poly = this.getScript(ObjectPoly.class);
        return poly == null ? this.addScript(new ObjectPoly(this)) : poly;
    }

    public abstract void sendInfo(L2PcInstance var1);

    public void sendPacket(L2GameServerPacket mov) {
    }

    public void sendPacket(SystemMessageId id) {
    }

    public L2PcInstance getActingPlayer() {
        return null;
    }

    public boolean isAttackable() {
        return false;
    }

    public boolean isCharacter() {
        return false;
    }

    public boolean isDoor() {
        return false;
    }

    public boolean isMonster() {
        return false;
    }

    public boolean isNpc() {
        return false;
    }

    public boolean isPet() {
        return false;
    }

    public boolean isPlayer() {
        return false;
    }

    public boolean isPlayable() {
        return false;
    }

    public boolean isServitor() {
        return false;
    }

    public boolean isSummon() {
        return false;
    }

    public boolean isTrap() {
        return false;
    }

    public boolean isItem() {
        return false;
    }

    public boolean isWalker() {
        return false;
    }

    public boolean isTargetable() {
        return true;
    }

    public boolean isInsideZone(ZoneId zone) {
        return false;
    }

    public boolean isChargedShot(ShotType type) {
        return false;
    }

    public void setChargedShot(ShotType type, boolean charged) {
    }

    public void rechargeShots(boolean physical, boolean magical) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T addScript(T script) {
        if (this._scripts == null) {
            L2Object l2Object = this;
            synchronized (l2Object) {
                if (this._scripts == null) {
                    this._scripts = new FastMap().shared();
                }
            }
        }
        this._scripts.put(script.getClass().getName(), script);
        return script;
    }

    public final <T> T removeScript(Class<T> script) {
        if (this._scripts == null) {
            return null;
        }
        return (T)this._scripts.remove(script.getName());
    }

    public final <T> T getScript(Class<T> script) {
        if (this._scripts == null) {
            return null;
        }
        return (T)this._scripts.get(script.getName());
    }

    public void removeStatusListener(L2Character object) {
    }

    protected void badCoords() {
        if (this.isCharacter()) {
            this.decayMe();
        } else if (this.isPlayer()) {
            ((L2Character)this).teleToLocation(0, 0, 0, false);
            ((L2Character)this).sendMessage("Error with your coords, Please ask a GM for help!");
        }
    }

    public final void setXYZInvisible(int x, int y, int z) {
        assert (this.getWorldRegion() == null);
        if (x > 229376) {
            x = 224376;
        }
        if (x < -294912) {
            x = -289912;
        }
        if (y > 294912) {
            y = 289912;
        }
        if (y < -262144) {
            y = -257144;
        }
        this.setXYZ(x, y, z);
        this.setIsVisible(false);
    }

    public final void setLocationInvisible(ILocational loc) {
        this.setXYZInvisible(loc.getX(), loc.getY(), loc.getZ());
    }

    public void updateWorldRegion() {
        if (!this.isVisible()) {
            return;
        }
        L2WorldRegion newRegion = L2World.getInstance().getRegion(this.getPosition());
        if (newRegion != this.getWorldRegion()) {
            this.getWorldRegion().removeVisibleObject(this);
            this.setWorldRegion(newRegion);
            this.getWorldRegion().addVisibleObject(this);
        }
    }

    public final L2WorldRegion getWorldRegion() {
        return this._worldRegion;
    }

    public void setWorldRegion(L2WorldRegion value) {
        if (this.getWorldRegion() != null && this.isCharacter()) {
            if (value != null) {
                this.getWorldRegion().revalidateZones((L2Character)this);
            } else {
                this.getWorldRegion().removeFromZones((L2Character)this);
            }
        }
        this._worldRegion = value;
    }

    @Override
    public int getX() {
        return this._x;
    }

    @Override
    public int getY() {
        return this._y;
    }

    @Override
    public int getZ() {
        return this._z;
    }

    @Override
    public int getHeading() {
        return this._heading;
    }

    @Override
    public int getInstanceId() {
        return this._instanceId;
    }

    @Override
    public Location getLocation() {
        return new Location(this.getX(), this.getY(), this.getZ(), this.getHeading(), this.getInstanceId());
    }

    public final ILocational getPosition() {
        return this;
    }

    public final void setPosition(ILocational loc) {
        this._x = loc.getX();
        this._y = loc.getY();
        this._z = loc.getZ();
        this._heading = loc.getHeading();
        this._instanceId = loc.getInstanceId();
    }

    @Override
    public void setX(int newX) {
        this._x = newX;
    }

    @Override
    public void setY(int newY) {
        this._y = newY;
    }

    @Override
    public void setZ(int newZ) {
        this._z = newZ;
    }

    @Override
    public final void setXYZ(int newX, int newY, int newZ) {
        assert (this.getWorldRegion() != null);
        this.setX(newX);
        this.setY(newY);
        this.setZ(newZ);
        try {
            if (L2World.getInstance().getRegion(this.getPosition()) != this.getWorldRegion()) {
                this.updateWorldRegion();
            }
        }
        catch (Exception e) {
            this.badCoords();
        }
    }

    @Override
    public void setXYZ(ILocational loc) {
        this.setXYZ(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    public void setHeading(int newHeading) {
        this._heading = newHeading;
    }

    @Override
    public void setInstanceId(int instanceId) {
        if (instanceId < 0 || this.getInstanceId() == instanceId) {
            return;
        }
        Instance oldI = InstanceManager.getInstance().getInstance(this.getInstanceId());
        Instance newI = InstanceManager.getInstance().getInstance(instanceId);
        if (newI == null) {
            return;
        }
        if (this.isPlayer()) {
            L2PcInstance player = this.getActingPlayer();
            if (this.getInstanceId() > 0 && oldI != null) {
                oldI.removePlayer(this.getObjectId());
                if (oldI.isShowTimer()) {
                    this.hideInstanceTimer();
                }
            }
            if (instanceId > 0) {
                newI.addPlayer(this.getObjectId());
                if (newI.isShowTimer()) {
                    this.showInstanceTimer(newI);
                }
            }
            if (player.hasSummon()) {
                player.getSummon().setInstanceId(instanceId);
            }
        } else if (this.isNpc()) {
            L2Npc npc = (L2Npc)this;
            if (this.getInstanceId() > 0 && oldI != null) {
                oldI.removeNpc(npc);
            }
            if (instanceId > 0) {
                newI.addNpc(npc);
            }
        }
        this._instanceId = instanceId;
        if (this._isVisible && this._knownList != null && !this.isPlayer()) {
            this.decayMe();
            this.spawnMe();
        }
    }

    @Override
    public void setLocation(Location loc) {
        this._x = loc.getX();
        this._y = loc.getY();
        this._z = loc.getZ();
        this._heading = loc.getHeading();
        this._instanceId = loc.getInstanceId();
    }

    public final double calculateDistance(int x, int y, int z, boolean includeZAxis, boolean squared) {
        double distance = Math.pow(x - this.getX(), 2.0) + Math.pow(y - this.getY(), 2.0) + (includeZAxis ? Math.pow(z - this.getZ(), 2.0) : 0.0);
        return squared ? distance : Math.sqrt(distance);
    }

    public final double calculateDistance(ILocational loc, boolean includeZAxis, boolean squared) {
        return this.calculateDistance(loc.getX(), loc.getY(), loc.getZ(), includeZAxis, squared);
    }

    public final double calculateDirectionTo(ILocational target) {
        int heading = Util.calculateHeadingFrom(this, target) - this.getHeading() & 0xFFFF;
        return Util.convertHeadingToDegree(heading);
    }

    public void showInstanceTimer(Instance instance) {
        int end;
        int start;
        int npcString;
        String timerText = instance.getTimerText();
        if (timerText != null && timerText.startsWith("#")) {
            npcString = timerText.equals("#1911119") ? 1911119 : (timerText.equals("#1911120") ? 1911120 : Integer.parseInt(timerText.substring(1)));
            timerText = null;
        } else {
            npcString = -1;
        }
        if (instance.isTimerIncrease()) {
            start = (int)((System.currentTimeMillis() - instance.getInstanceStartTime()) / 1000L);
            end = (int)((instance.getInstanceEndTime() - instance.getInstanceStartTime()) / 1000L);
            assert (start <= end);
            assert (start >= 0);
            assert (end >= 0);
        } else {
            end = 0;
            start = (int)((instance.getInstanceEndTime() - System.currentTimeMillis()) / 1000L);
            assert (end <= start);
            assert (start >= 0);
        }
        this.sendPacket(new ExSendUIEvent(this.getActingPlayer(), false, instance.isTimerIncrease(), start, end, timerText, npcString, null));
    }

    public void hideInstanceTimer() {
        this.sendPacket(new ExSendUIEvent(this.getActingPlayer(), true, true, 0, 0, -1));
    }

    public boolean equals(Object obj) {
        return obj instanceof L2Object && ((L2Object)obj).getObjectId() == this.getObjectId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":" + this.getName() + "[" + this.getObjectId() + "]";
    }
}

