/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.interfaces.IProcedure;
import com.l2jserver.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class L2World {
    private static final Logger _log = Logger.getLogger(L2World.class.getName());
    public static final int GRACIA_MAX_X = -166168;
    public static final int GRACIA_MAX_Z = 6105;
    public static final int GRACIA_MIN_Z = -895;
    public static final int SHIFT_BY = 12;
    private static final int TILE_SIZE = 32768;
    public static final int TILE_X_MIN = 11;
    public static final int TILE_Y_MIN = 10;
    public static final int TILE_X_MAX = 26;
    public static final int TILE_Y_MAX = 26;
    public static final int TILE_ZERO_COORD_X = 20;
    public static final int TILE_ZERO_COORD_Y = 18;
    public static final int MAP_MIN_X = -294912;
    public static final int MAP_MIN_Y = -262144;
    public static final int MAP_MAX_X = 229376;
    public static final int MAP_MAX_Y = 294912;
    public static final int OFFSET_X = Math.abs(-72);
    public static final int OFFSET_Y = Math.abs(-64);
    private static final int REGIONS_X = 56 + OFFSET_X;
    private static final int REGIONS_Y = 72 + OFFSET_Y;
    private final FastIntObjectMap<L2PcInstance> _allPlayers = new FastIntObjectMap().shared();
    private final FastIntObjectMap<L2Object> _allObjects = new FastIntObjectMap().shared();
    private final FastIntObjectMap<String> _allObjectsDebug = new FastIntObjectMap().shared();
    private final FastIntObjectMap<L2PetInstance> _petsInstance = new FastIntObjectMap().shared();
    private L2WorldRegion[][] _worldRegions;

    protected L2World() {
        this.initRegions();
    }

    public void storeObject(L2Object object) {
        L2Object previous = (L2Object)this._allObjects.put(object.getObjectId(), (Object)object);
        if (previous != null) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Current object: " + object + " already exist in OID map!\n" + StringUtil.getTraceString(Thread.currentThread().getStackTrace()));
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Previous object: " + previous + " already exist in OID map!\n" + (String)this._allObjectsDebug.get(object.getObjectId()));
            _log.log(Level.WARNING, "---------------------- End ---------------------");
            return;
        }
        this._allObjectsDebug.put(object.getObjectId(), (Object)StringUtil.getTraceString(Thread.currentThread().getStackTrace()));
    }

    public void removeObject(L2Object object) {
        this._allObjects.remove(object.getObjectId());
        this._allObjectsDebug.remove(object.getObjectId());
    }

    public void removeObjects(List<L2Object> list) {
        for (L2Object o : list) {
            if (o == null) continue;
            this._allObjects.remove(o.getObjectId());
            this._allObjectsDebug.remove(o.getObjectId());
        }
    }

    public void removeObjects(L2Object[] objects) {
        for (L2Object o : objects) {
            this._allObjects.remove(o.getObjectId());
            this._allObjectsDebug.remove(o.getObjectId());
        }
    }

    public L2Object findObject(int oID) {
        return (L2Object)this._allObjects.get(oID);
    }

    public Collection<L2Object> getVisibleObjects() {
        return this._allObjects.values();
    }

    public int getVisibleObjectsCount() {
        return this._allObjects.size();
    }

    public List<L2PcInstance> getAllGMs() {
        return AdminTable.getInstance().getAllGms(true);
    }

    public Collection<L2PcInstance> getPlayers() {
        return this._allPlayers.values();
    }

    public L2PcInstance[] getPlayersSortedBy(Comparator<L2PcInstance> comparator) {
        L2PcInstance[] players = this._allPlayers.values().toArray(new L2PcInstance[this._allPlayers.values().size()]);
        Arrays.sort(players, comparator);
        return players;
    }

    public boolean forEachPlayer(IProcedure<L2PcInstance, Boolean> procedure) {
        for (L2PcInstance player : this._allPlayers.values()) {
            if (procedure.execute(player)) continue;
            return false;
        }
        return true;
    }

    public int getAllPlayersCount() {
        return this._allPlayers.size();
    }

    public L2PcInstance getPlayer(String name) {
        return this.getPlayer(CharNameTable.getInstance().getIdByName(name));
    }

    public L2PcInstance getPlayer(int playerObjId) {
        return (L2PcInstance)this._allPlayers.get(playerObjId);
    }

    public L2PetInstance getPet(int ownerId) {
        return (L2PetInstance)this._petsInstance.get(ownerId);
    }

    public L2PetInstance addPet(int ownerId, L2PetInstance pet) {
        return (L2PetInstance)this._petsInstance.put(ownerId, (Object)pet);
    }

    public void removePet(int ownerId) {
        this._petsInstance.remove(ownerId);
    }

    public void removePet(L2PetInstance pet) {
        this._petsInstance.remove(pet.getOwner().getObjectId());
    }

    public void addVisibleObject(L2Object object, L2WorldRegion newRegion) {
        L2PcInstance player;
        if (object.isPlayer() && !(player = object.getActingPlayer()).isTeleporting()) {
            L2PcInstance old = this.getPlayer(player.getObjectId());
            if (old != null) {
                _log.warning("Duplicate character!? Closing both characters (" + player.getName() + ")");
                player.logout();
                old.logout();
                return;
            }
            this.addPlayerToWorld(player);
        }
        if (!newRegion.isActive()) {
            return;
        }
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            for (L2Object visible : regi.getVisibleObjects().values()) {
                if (visible == null || visible.equals(object)) continue;
                visible.getKnownList().addKnownObject(object);
                object.getKnownList().addKnownObject(visible);
            }
        }
    }

    public void addPlayerToWorld(L2PcInstance player) {
        this._allPlayers.put(player.getObjectId(), (Object)player);
    }

    public void removeFromAllPlayers(L2PcInstance player) {
        this._allPlayers.remove(player.getObjectId());
    }

    public void removeVisibleObject(L2Object object, L2WorldRegion oldRegion) {
        if (object == null) {
            return;
        }
        if (oldRegion != null) {
            L2PcInstance player;
            oldRegion.removeVisibleObject(object);
            for (L2WorldRegion reg : oldRegion.getSurroundingRegions()) {
                Collection vObj = reg.getVisibleObjects().values();
                for (L2Object obj : vObj) {
                    if (obj == null) continue;
                    obj.getKnownList().removeKnownObject(object);
                }
            }
            object.getKnownList().removeAllKnownObjects();
            if (object.isPlayer() && !(player = object.getActingPlayer()).isTeleporting()) {
                this.removeFromAllPlayers(player);
            }
        }
    }

    public List<L2Object> getVisibleObjects(L2Object object) {
        L2WorldRegion reg = object.getWorldRegion();
        if (reg == null) {
            return null;
        }
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        for (L2WorldRegion regi : reg.getSurroundingRegions()) {
            Collection vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                if (_object == null || _object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Object> getVisibleObjects(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return Collections.emptyList();
        }
        int sqRadius = radius * radius;
        List<L2Object> result = null;
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            Collection vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                if (_object == null || _object.equals(object) || !((double)sqRadius > object.calculateDistance(_object, false, true))) continue;
                if (result == null) {
                    result = new ArrayList<L2Object>();
                }
                result.add(_object);
            }
        }
        return result != null ? result : Collections.emptyList();
    }

    public List<L2Object> getVisibleObjects3D(L2Object object, int radius) {
        if (object == null || !object.isVisible()) {
            return new ArrayList<L2Object>();
        }
        int sqRadius = radius * radius;
        ArrayList<L2Object> result = new ArrayList<L2Object>();
        for (L2WorldRegion regi : object.getWorldRegion().getSurroundingRegions()) {
            Collection vObj = regi.getVisibleObjects().values();
            for (L2Object _object : vObj) {
                if (_object == null || _object.equals(object) || !((double)sqRadius > object.calculateDistance(_object, true, true))) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public List<L2Playable> getVisiblePlayable(L2Object object) {
        L2WorldRegion reg = object.getWorldRegion();
        if (reg == null) {
            return null;
        }
        ArrayList<L2Playable> result = new ArrayList<L2Playable>();
        for (L2WorldRegion regi : reg.getSurroundingRegions()) {
            for (L2Playable _object : regi.getVisiblePlayable().values()) {
                if (_object == null || _object.equals(object) || !_object.isVisible()) continue;
                result.add(_object);
            }
        }
        return result;
    }

    public L2WorldRegion getRegion(ILocational point) {
        return this._worldRegions[(point.getX() >> 12) + OFFSET_X][(point.getY() >> 12) + OFFSET_Y];
    }

    public L2WorldRegion getRegion(int x, int y) {
        return this._worldRegions[(x >> 12) + OFFSET_X][(y >> 12) + OFFSET_Y];
    }

    public L2WorldRegion[][] getWorldRegions() {
        return this._worldRegions;
    }

    private boolean validRegion(int x, int y) {
        return x >= 0 && x <= REGIONS_X && y >= 0 && y <= REGIONS_Y;
    }

    private void initRegions() {
        this._worldRegions = new L2WorldRegion[REGIONS_X + 1][REGIONS_Y + 1];
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j] = new L2WorldRegion(i, j);
            }
        }
        for (int x = 0; x <= REGIONS_X; ++x) {
            for (int y = 0; y <= REGIONS_Y; ++y) {
                for (int a = -1; a <= 1; ++a) {
                    for (int b = -1; b <= 1; ++b) {
                        if (!this.validRegion(x + a, y + b)) continue;
                        this._worldRegions[x + a][y + b].addSurroundingRegion(this._worldRegions[x][y]);
                    }
                }
            }
        }
        _log.info("L2World: (" + REGIONS_X + " by " + REGIONS_Y + ") World Region Grid set up.");
    }

    public void deleteVisibleNpcSpawns() {
        _log.info("Deleting all visible NPC's.");
        for (int i = 0; i <= REGIONS_X; ++i) {
            for (int j = 0; j <= REGIONS_Y; ++j) {
                this._worldRegions[i][j].deleteVisibleNpcSpawns();
            }
        }
        _log.info("All visible NPC's deleted.");
    }

    public static L2World getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final L2World _instance = new L2World();

        private SingletonHolder() {
        }
    }
}

