/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.model.MobGroup;
import com.l2jserver.gameserver.model.actor.instance.L2ControllableMobInstance;
import java.util.Map;
import javolution.util.FastMap;

public class MobGroupTable {
    private final Map<Integer, MobGroup> _groupMap = new FastMap();
    public static final int FOLLOW_RANGE = 300;
    public static final int RANDOM_RANGE = 300;

    protected MobGroupTable() {
    }

    public static MobGroupTable getInstance() {
        return SingletonHolder._instance;
    }

    public void addGroup(int groupKey, MobGroup group) {
        this._groupMap.put(groupKey, group);
    }

    public MobGroup getGroup(int groupKey) {
        return this._groupMap.get(groupKey);
    }

    public int getGroupCount() {
        return this._groupMap.size();
    }

    public MobGroup getGroupForMob(L2ControllableMobInstance mobInst) {
        for (MobGroup mobGroup : this._groupMap.values()) {
            if (!mobGroup.isGroupMember(mobInst)) continue;
            return mobGroup;
        }
        return null;
    }

    public MobGroup[] getGroups() {
        return this._groupMap.values().toArray(new MobGroup[this.getGroupCount()]);
    }

    public boolean removeGroup(int groupKey) {
        return this._groupMap.remove(groupKey) != null;
    }

    private static class SingletonHolder {
        protected static final MobGroupTable _instance = new MobGroupTable();

        private SingletonHolder() {
        }
    }
}

