/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model;

import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2NpcWalkerNode;
import com.l2jserver.gameserver.model.L2WalkRoute;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.concurrent.ScheduledFuture;

public class WalkInfo {
    private final L2WalkRoute _walkRoute;
    private ScheduledFuture<?> _walkCheckTask;
    private boolean _blocked = false;
    private boolean _suspended = false;
    private boolean _stoppedByAttack = false;
    private int _currentNode = 0;
    private int _direction = 1;
    private long _lastActionTime;

    public WalkInfo(String routeName) {
        this._walkRoute = WalkingManager.getInstance().getRoute(routeName);
    }

    public String getRouteName() {
        return this._walkRoute.getName();
    }

    public void setNodeId(int nodeId) {
        this._currentNode = nodeId;
    }

    public L2WalkRoute getRoute() {
        return this._walkRoute;
    }

    public L2NpcWalkerNode getCurrentNode() {
        return this.getRoute().getNodeList().get(this._currentNode);
    }

    public void calculateNextNode(L2Npc npc) {
        if (this._walkRoute.getRepeatType() == 3) {
            int newNode;
            while ((newNode = Rnd.get(this._walkRoute.getNodesCount())) == this._currentNode) {
            }
            this._currentNode = newNode;
            npc.sendDebugMessage("Route: " + this.getRouteName() + ", next random node is " + this._currentNode);
        } else {
            this._currentNode += this._direction;
            if (this._currentNode == this._walkRoute.getNodesCount()) {
                List<Quest> eventQuests = npc.getTemplate().getEventQuests(QuestEventType.ON_ROUTE_FINISHED);
                if (eventQuests != null) {
                    for (Quest quest : eventQuests) {
                        quest.notifyRouteFinished(npc);
                    }
                }
                npc.sendDebugMessage("Route: " + this.getRouteName() + ", last node arrived");
                if (!this._walkRoute.repeatWalk()) {
                    WalkingManager.getInstance().cancelMoving(npc);
                    return;
                }
                switch (this._walkRoute.getRepeatType()) {
                    case 0: {
                        this._direction = -1;
                        this._currentNode -= 2;
                        break;
                    }
                    case 1: {
                        this._currentNode = 0;
                        break;
                    }
                    case 2: {
                        npc.teleToLocation(npc.getSpawn().getLocation());
                        this._currentNode = 0;
                    }
                }
            } else if (this._currentNode == -1) {
                this._currentNode = 1;
                this._direction = 1;
            }
        }
    }

    public boolean isBlocked() {
        return this._blocked;
    }

    public void setBlocked(boolean val) {
        this._blocked = val;
    }

    public boolean isSuspended() {
        return this._suspended;
    }

    public void setSuspended(boolean val) {
        this._suspended = val;
    }

    public boolean isStoppedByAttack() {
        return this._stoppedByAttack;
    }

    public void setStoppedByAttack(boolean val) {
        this._stoppedByAttack = val;
    }

    public int getCurrentNodeId() {
        return this._currentNode;
    }

    public long getLastAction() {
        return this._lastActionTime;
    }

    public void setLastAction(long val) {
        this._lastActionTime = val;
    }

    public ScheduledFuture<?> getWalkCheckTask() {
        return this._walkCheckTask;
    }

    public void setWalkCheckTask(ScheduledFuture<?> val) {
        this._walkCheckTask = val;
    }
}

