/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.events;

import com.l2jserver.gameserver.model.actor.events.listeners.IEventListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public abstract class AbstractCharEvents {
    private static volatile List<IEventListener> _staticListeners = null;
    private volatile List<IEventListener> _listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void registerStaticListener(IEventListener listener) {
        if (_staticListeners == null) {
            Class<AbstractCharEvents> clazz = AbstractCharEvents.class;
            // MONITORENTER : com.l2jserver.gameserver.model.actor.events.AbstractCharEvents.class
            if (_staticListeners == null) {
                _staticListeners = new CopyOnWriteArrayList<IEventListener>();
            }
            // MONITOREXIT : clazz
        }
        _staticListeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerListener(IEventListener listener) {
        if (this._listeners == null) {
            AbstractCharEvents abstractCharEvents = this;
            synchronized (abstractCharEvents) {
                if (this._listeners == null) {
                    this._listeners = new CopyOnWriteArrayList<IEventListener>();
                }
            }
        }
        this._listeners.add(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unregisterStaticListener(IEventListener listener) {
        if (_staticListeners == null) {
            return;
        }
        if (_staticListeners.contains(listener)) {
            _staticListeners.remove(listener);
        }
        if (!_staticListeners.isEmpty()) return;
        Class<AbstractCharEvents> clazz = AbstractCharEvents.class;
        synchronized (AbstractCharEvents.class) {
            if (!_staticListeners.isEmpty()) return;
            _staticListeners = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void unregisterListener(IEventListener listener) {
        if (this._listeners == null) {
            return;
        }
        if (this._listeners.contains(listener)) {
            this._listeners.remove(listener);
        }
        if (this._listeners.isEmpty()) {
            AbstractCharEvents abstractCharEvents = this;
            synchronized (abstractCharEvents) {
                if (this._listeners.isEmpty()) {
                    this._listeners = null;
                }
            }
        }
    }

    protected static boolean hasStaticEventListeners() {
        return _staticListeners != null;
    }

    protected final boolean hasEventListeners() {
        return this._listeners != null;
    }

    protected final boolean hasListeners() {
        return this._listeners != null || _staticListeners != null;
    }

    protected final <T> List<T> getEventListeners(Class<T> clazz) {
        if (!this.hasListeners()) {
            return Collections.emptyList();
        }
        ArrayList<T> listeners = new ArrayList<T>();
        if (this.hasEventListeners()) {
            for (IEventListener listener : this._listeners) {
                if (!clazz.isInstance(listener)) continue;
                listeners.add(clazz.cast(listener));
            }
        }
        if (AbstractCharEvents.hasStaticEventListeners()) {
            for (IEventListener listener : _staticListeners) {
                if (!clazz.isInstance(listener)) continue;
                listeners.add(clazz.cast(listener));
            }
        }
        return listeners;
    }
}

