/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.instancemanager.AuctionManager;
import com.l2jserver.gameserver.instancemanager.ClanHallManager;
import com.l2jserver.gameserver.instancemanager.MapRegionManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.entity.Auction;
import com.l2jserver.gameserver.model.entity.clanhall.AuctionableHall;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.util.Util;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javolution.util.FastMap;

public final class L2AuctioneerInstance
extends L2Npc {
    private static final int COND_ALL_FALSE = 0;
    private static final int COND_BUSY_BECAUSE_OF_SIEGE = 1;
    private static final int COND_REGULAR = 3;
    private final Map<Integer, Auction> _pendingAuctions = new FastMap();

    public L2AuctioneerInstance(int objectId, L2NpcTemplate template) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2AuctioneerInstance);
    }

    @Override
    public void onBypassFeedback(L2PcInstance player, String command) {
        int condition = this.validateCondition(player);
        if (condition <= 0) {
            player.sendMessage("Wrong conditions.");
            return;
        }
        if (condition == 1) {
            String filename = "data/html/auction/auction-busy.htm";
            NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
            html.setFile(player.getHtmlPrefix(), filename);
            html.replace((CharSequence)"%objectId%", this.getObjectId());
            player.sendPacket(html);
            return;
        }
        if (condition == 3) {
            StringTokenizer st = new StringTokenizer(command, " ");
            String actualCommand = st.nextToken();
            String val = "";
            if (st.countTokens() >= 1) {
                val = st.nextToken();
            }
            if (actualCommand.equalsIgnoreCase("auction")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int days = Integer.parseInt(val);
                    try {
                        Auction a;
                        SimpleDateFormat format = new SimpleDateFormat("yyyy \u5e74 MM \u6708 dd \u65e5 H \u6642");
                        long bid = 0L;
                        if (st.countTokens() >= 1) {
                            bid = Math.min(Long.parseLong(st.nextToken()), Inventory.MAX_ADENA);
                        }
                        if (this._pendingAuctions.get((a = new Auction(player.getClan().getHideoutId(), player.getClan(), (long)days * 86400000L, bid, ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getName())).getId()) != null) {
                            this._pendingAuctions.remove(a.getId());
                        }
                        this._pendingAuctions.put(a.getId(), a);
                        String filename = "data/html/auction/AgitSale3.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%x%", val);
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MIN%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale2");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction duration!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("confirmAuction")) {
                try {
                    Auction a = this._pendingAuctions.get(player.getClan().getHideoutId());
                    a.confirmAuction();
                    this._pendingAuctions.remove(player.getClan().getHideoutId());
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidding")) {
                if (val.isEmpty()) {
                    return;
                }
                if (Config.DEBUG) {
                    _log.warning("bidding show successful");
                }
                try {
                    Auction a;
                    SimpleDateFormat format = new SimpleDateFormat("yyyy \u5e74 MM \u6708 dd \u65e5 H \u6642");
                    int auctionId = Integer.parseInt(val);
                    if (Config.DEBUG) {
                        _log.warning("auction test started");
                    }
                    if ((a = AuctionManager.getInstance().getAuction(auctionId)) != null) {
                        String filename = "data/html/auction/AgitAuctionInfo.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocNameHtm());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + "\u6642\u9593" + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + "\u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_COUNT%", a.getBidders().size());
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_list");
                        html.replace((CharSequence)"%AGIT_LINK_BIDLIST%", "bypass -h npc_" + this.getObjectId() + "_bidlist " + a.getId());
                        html.replace((CharSequence)"%AGIT_LINK_RE%", "bypass -h npc_" + this.getObjectId() + "_bid1 " + a.getId());
                        player.sendPacket(html);
                    } else {
                        player.sendPacket(SystemMessageId.NO_CLAN_HALLS_UP_FOR_AUCTION);
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid")) {
                if (val.isEmpty()) {
                    return;
                }
                try {
                    int auctionId = Integer.parseInt(val);
                    try {
                        long bid = 0L;
                        if (st.countTokens() >= 1) {
                            bid = Math.min(Long.parseLong(st.nextToken()), Inventory.MAX_ADENA);
                        }
                        AuctionManager.getInstance().getAuction(auctionId).setBid(player, bid);
                    }
                    catch (Exception e) {
                        player.sendMessage("Invalid bid!");
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("bid1")) {
                if (player.getClan() == null || player.getClan().getLevel() < 2) {
                    player.sendPacket(SystemMessageId.AUCTION_ONLY_CLAN_LEVEL_2_HIGHER);
                    return;
                }
                if (val.isEmpty()) {
                    return;
                }
                if (player.getClan().getAuctionBiddedAt() > 0 && player.getClan().getAuctionBiddedAt() != Integer.parseInt(val)) {
                    player.sendPacket(SystemMessageId.ALREADY_SUBMITTED_BID);
                    return;
                }
                if (player.getClan().getHideoutId() > 0 || player.getClan().getCastleId() > 0) {
                    player.sendPacket(SystemMessageId.CANNOT_PARTICIPATE_IN_AN_AUCTION);
                    return;
                }
                try {
                    String filename = "data/html/auction/AgitBid1.htm";
                    long minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getHighestBidderMaxBid();
                    if (minimumBid == 0L) {
                        minimumBid = AuctionManager.getInstance().getAuction(Integer.parseInt(val)).getStartingBid();
                    }
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_bidding " + val);
                    html.replace((CharSequence)"%PLEDGE_ADENA%", Util.formatAdena(player.getClan().getWarehouse().getAdena()));
                    html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(minimumBid));
                    html.replace((CharSequence)"npc_%objectId%_bid", "npc_" + this.getObjectId() + "_bid " + val);
                    player.sendPacket(html);
                    return;
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                    return;
                }
            }
            if (actualCommand.equalsIgnoreCase("list")) {
                int start;
                List<Auction> auctions = AuctionManager.getInstance().getAuctions();
                SimpleDateFormat format = new SimpleDateFormat("yy/MM/dd");
                int limit = 15;
                int i = 1;
                double npage = Math.ceil((float)auctions.size() / (float)limit);
                if (val.isEmpty()) {
                    start = 1;
                } else {
                    start = limit * (Integer.parseInt(val) - 1) + 1;
                    limit *= Integer.parseInt(val);
                }
                if (Config.DEBUG) {
                    _log.warning("cmd list: auction test started");
                }
                StringBuilder items = new StringBuilder(256);
                items.append("<table width=280 border=0><tr>");
                int j = 1;
                while ((double)j <= npage) {
                    items.append("<td><center><a action=\"bypass -h npc_").append(this.getObjectId()).append("_list ").append(j).append("\"> Page ").append(j).append(" </a></center></td>");
                    ++j;
                }
                items.append("</tr></table><table width=280 border=0>");
                for (Auction a : auctions) {
                    if (a == null) continue;
                    if (i > limit) break;
                    if (i < start) {
                        ++i;
                        continue;
                    }
                    ++i;
                    items.append("<tr><td>").append(ClanHallManager.getInstance().getAuctionableHallById(a.getItemId()).getLocNameHtm()).append("</td><td><a action=\"bypass -h npc_").append(this.getObjectId()).append("_bidding ").append(a.getId()).append("\">").append(a.getItemName()).append("</a></td><td>").append(format.format(a.getEndDate())).append("</td><td>").append(Util.formatAdena(a.getStartingBid())).append("</td></tr>");
                }
                items.append("</table>");
                String filename = "data/html/auction/AgitAuctionList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                html.replace((CharSequence)"%itemsField%", items);
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("bidlist")) {
                int auctionId = 0;
                if (val.isEmpty()) {
                    if (player.getClan().getAuctionBiddedAt() <= 0) {
                        return;
                    }
                    auctionId = player.getClan().getAuctionBiddedAt();
                } else {
                    auctionId = Integer.parseInt(val);
                }
                if (Config.DEBUG) {
                    _log.warning("cmd bidlist: auction test started");
                }
                StringBuilder biders = new StringBuilder(256);
                Map<Integer, Auction.Bidder> bidders = AuctionManager.getInstance().getAuction(auctionId).getBidders();
                for (Auction.Bidder b : bidders.values()) {
                    biders.append("<tr><td>").append(b.getClanName()).append("</td><td>").append(b.getName()).append("</td><td>").append(b.getTimeBid().get(1)).append('/').append(b.getTimeBid().get(2) + 1).append('/').append(b.getTimeBid().get(5)).append("</td><td>").append(Util.formatAdena(b.getBid())).append("</td></tr>");
                }
                String filename = "data/html/auction/AgitBidderList.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_LIST%", biders);
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                html.replace((CharSequence)"%x%", val);
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("selectedItems")) {
                if (player.getClan() == null) {
                    player.sendPacket(SystemMessageId.CANNOT_PARTICIPATE_IN_AN_AUCTION);
                    return;
                }
                if (player.getClan().getHideoutId() == 0 && player.getClan().getAuctionBiddedAt() > 0) {
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt());
                    if (a != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy \u5e74 MM \u6708 dd \u65e5 H \u6642");
                        String filename = "data/html/auction/AgitBidInfo.htm";
                        AuctionableHall item = ClanHallManager.getInstance().getAuctionableHallById(a.getItemId());
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", item.getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(item.getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", item.getLocNameHtm());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + "\u6642\u9593" + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + "\u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MYBID%", Util.formatAdena(a.getBidders().get(player.getClanId()).getBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", item.getDesc());
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        player.sendPacket(html);
                    } else {
                        player.sendPacket(SystemMessageId.NO_CLAN_HALLS_UP_FOR_AUCTION);
                    }
                    return;
                }
                if (AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()) != null) {
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getHideoutId());
                    if (a != null) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy \u5e74 MM \u6708 dd \u65e5 H \u6642");
                        String filename = "data/html/auction/AgitSaleInfo.htm";
                        AuctionableHall item = ClanHallManager.getInstance().getAuctionableHallById(a.getItemId());
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%AGIT_NAME%", a.getItemName());
                        html.replace((CharSequence)"%AGIT_OWNER_PLEDGE_NAME%", a.getSellerClanName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", a.getSellerName());
                        html.replace((CharSequence)"%AGIT_SIZE%", item.getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(item.getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", item.getLocNameHtm());
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_AUCTION_REMAIN%", (a.getEndDate() - System.currentTimeMillis()) / 3600000L + "\u6642\u9593" + (a.getEndDate() - System.currentTimeMillis()) / 60000L % 60L + "\u5206");
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_BIDCOUNT%", a.getBidders().size());
                        html.replace((CharSequence)"%AGIT_AUCTION_DESC%", item.getDesc());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace((CharSequence)"%id%", a.getId());
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                    } else {
                        player.sendPacket(SystemMessageId.NO_CLAN_HALLS_UP_FOR_AUCTION);
                    }
                    return;
                }
                if (player.getClan().getHideoutId() != 0) {
                    int ItemId = player.getClan().getHideoutId();
                    AuctionableHall item = ClanHallManager.getInstance().getAuctionableHallById(ItemId);
                    if (item != null) {
                        String filename = "data/html/auction/AgitInfo.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%AGIT_NAME%", item.getNameHtm());
                        html.replace((CharSequence)"%AGIT_OWNER_PLEDGE_NAME%", player.getClan().getName());
                        html.replace((CharSequence)"%OWNER_PLEDGE_MASTER%", player.getClan().getLeaderName());
                        html.replace((CharSequence)"%AGIT_SIZE%", item.getGrade() * 10);
                        html.replace((CharSequence)"%AGIT_LEASE%", Util.formatAdena(item.getLease()));
                        html.replace((CharSequence)"%AGIT_LOCATION%", item.getLocNameHtm());
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                        html.replace((CharSequence)"%objectId%", this.getObjectId());
                        player.sendPacket(html);
                    } else {
                        player.sendPacket(SystemMessageId.CLAN_HAS_NO_CLAN_HALL);
                    }
                    return;
                }
                if (player.getClan().getHideoutId() == 0) {
                    player.sendPacket(SystemMessageId.NO_OFFERINGS_OWN_OR_MADE_BID_FOR);
                    return;
                }
                player.sendPacket(SystemMessageId.CANNOT_PARTICIPATE_IN_AN_AUCTION);
                return;
            }
            if (actualCommand.equalsIgnoreCase("cancelBid")) {
                long bid = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()).getBidders().get(player.getClanId()).getBid();
                String filename = "data/html/auction/AgitBidCancel.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_BID%", Util.formatAdena(bid));
                html.replace((CharSequence)"%AGIT_BID_REMAIN%", Util.formatAdena((long)((double)bid * 0.9)));
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("doCancelBid")) {
                if (AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()) != null) {
                    AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt()).cancelBid(player.getClanId());
                    player.sendPacket(SystemMessageId.CANCELED_BID);
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("cancelAuction")) {
                if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                    String filename = "data/html/auction/not_authorized.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                String filename = "data/html/auction/AgitSaleCancel.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_DEPOSIT%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("doCancelAuction")) {
                if (AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()) != null) {
                    AuctionManager.getInstance().getAuction(player.getClan().getHideoutId()).cancelAuction();
                    player.sendMessage("Your auction has been canceled");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("sale2")) {
                String filename = "data/html/auction/AgitSale2.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_LAST_PRICE%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_sale");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("sale")) {
                if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                    String filename = "data/html/auction/not_authorized.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                String filename = "data/html/auction/AgitSale1.htm";
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), filename);
                html.replace((CharSequence)"%AGIT_DEPOSIT%", Util.formatAdena(ClanHallManager.getInstance().getClanHallByOwner(player.getClan()).getLease()));
                html.replace((CharSequence)"%AGIT_PLEDGE_ADENA%", Util.formatAdena(player.getClan().getWarehouse().getAdena()));
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                html.replace((CharSequence)"%objectId%", this.getObjectId());
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("rebid")) {
                SimpleDateFormat format = new SimpleDateFormat("yyyy \u5e74 MM \u6708 dd \u65e5 H \u6642");
                if (!player.hasClanPrivilege(ClanPrivilege.CH_AUCTION)) {
                    String filename = "data/html/auction/not_authorized.htm";
                    NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                    html.setFile(player.getHtmlPrefix(), filename);
                    html.replace((CharSequence)"%objectId%", this.getObjectId());
                    player.sendPacket(html);
                    return;
                }
                try {
                    Auction a = AuctionManager.getInstance().getAuction(player.getClan().getAuctionBiddedAt());
                    if (a != null) {
                        String filename = "data/html/auction/AgitBid2.htm";
                        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                        html.setFile(player.getHtmlPrefix(), filename);
                        html.replace((CharSequence)"%AGIT_AUCTION_BID%", Util.formatAdena(a.getBidders().get(player.getClanId()).getBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_MINBID%", Util.formatAdena(a.getStartingBid()));
                        html.replace((CharSequence)"%AGIT_AUCTION_END%", format.format(a.getEndDate()));
                        html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_selectedItems");
                        html.replace((CharSequence)"npc_%objectId%_bid1", "npc_" + this.getObjectId() + "_bid1 " + a.getId());
                        player.sendPacket(html);
                    } else {
                        player.sendPacket(SystemMessageId.NO_CLAN_HALLS_UP_FOR_AUCTION);
                    }
                }
                catch (Exception e) {
                    player.sendMessage("Invalid auction!");
                }
                return;
            }
            if (actualCommand.equalsIgnoreCase("location")) {
                NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
                html.setFile(player.getHtmlPrefix(), "data/html/auction/location.htm");
                html.replace((CharSequence)"%location%", MapRegionManager.getInstance().getClosestTownName(player));
                html.replace((CharSequence)"%LOCATION%", this.getPictureName(player));
                html.replace((CharSequence)"%AGIT_LINK_BACK%", "bypass -h npc_" + this.getObjectId() + "_start");
                player.sendPacket(html);
                return;
            }
            if (actualCommand.equalsIgnoreCase("start")) {
                this.showChatWindow(player);
                return;
            }
        }
        super.onBypassFeedback(player, command);
    }

    @Override
    public void showChatWindow(L2PcInstance player) {
        int condition = this.validateCondition(player);
        String filename = condition == 1 ? "data/html/auction/auction-busy.htm" : "data/html/auction/auction.htm";
        NpcHtmlMessage html = new NpcHtmlMessage(this.getObjectId());
        html.setFile(player.getHtmlPrefix(), filename);
        html.replace((CharSequence)"%objectId%", this.getObjectId());
        html.replace((CharSequence)"%npcId%", this.getId());
        html.replace((CharSequence)"%npcname%", this.getName());
        player.sendPacket(html);
    }

    private int validateCondition(L2PcInstance player) {
        if (this.getCastle() != null && this.getCastle().getResidenceId() > 0) {
            if (this.getCastle().getSiege().getIsInProgress()) {
                return 1;
            }
            return 3;
        }
        return 0;
    }

    private String getPictureName(L2PcInstance plyr) {
        String nearestTown;
        int nearestTownId = MapRegionManager.getInstance().getMapRegionLocId(plyr);
        switch (nearestTownId) {
            case 911: {
                nearestTown = "GLUDIN";
                break;
            }
            case 912: {
                nearestTown = "GLUDIO";
                break;
            }
            case 916: {
                nearestTown = "DION";
                break;
            }
            case 918: {
                nearestTown = "GIRAN";
                break;
            }
            case 1537: {
                nearestTown = "RUNE";
                break;
            }
            case 1538: {
                nearestTown = "GODARD";
                break;
            }
            case 1714: {
                nearestTown = "SCHUTTGART";
                break;
            }
            default: {
                nearestTown = "ADEN";
            }
        }
        return nearestTown;
    }
}

