/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.instance;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ItemsAutoDestroy;
import com.l2jserver.gameserver.LoginServerThread;
import com.l2jserver.gameserver.RecipeController;
import com.l2jserver.gameserver.SevenSigns;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.cache.HtmCache;
import com.l2jserver.gameserver.cache.WarehouseCacheManager;
import com.l2jserver.gameserver.communitybbs.BB.Forum;
import com.l2jserver.gameserver.communitybbs.Manager.RegionBBSManager;
import com.l2jserver.gameserver.datatables.AdminTable;
import com.l2jserver.gameserver.datatables.CategoryData;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.datatables.CharSummonTable;
import com.l2jserver.gameserver.datatables.CharTemplateTable;
import com.l2jserver.gameserver.datatables.ClanTable;
import com.l2jserver.gameserver.datatables.ClassListData;
import com.l2jserver.gameserver.datatables.EnchantSkillGroupsData;
import com.l2jserver.gameserver.datatables.ExperienceTable;
import com.l2jserver.gameserver.datatables.FishData;
import com.l2jserver.gameserver.datatables.HennaData;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.NpcData;
import com.l2jserver.gameserver.datatables.PetDataTable;
import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.datatables.SkillTreesData;
import com.l2jserver.gameserver.enums.CategoryType;
import com.l2jserver.gameserver.enums.HtmlActionScope;
import com.l2jserver.gameserver.enums.IllegalActionPunishmentType;
import com.l2jserver.gameserver.enums.InstanceType;
import com.l2jserver.gameserver.enums.MountType;
import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.enums.PlayerAction;
import com.l2jserver.gameserver.enums.PrivateStoreType;
import com.l2jserver.gameserver.enums.QuestEventType;
import com.l2jserver.gameserver.enums.Sex;
import com.l2jserver.gameserver.enums.ShortcutType;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.enums.Team;
import com.l2jserver.gameserver.handler.IItemHandler;
import com.l2jserver.gameserver.handler.ItemHandler;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.instancemanager.AntiFeedManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CoupleManager;
import com.l2jserver.gameserver.instancemanager.CursedWeaponsManager;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.DuelManager;
import com.l2jserver.gameserver.instancemanager.FortManager;
import com.l2jserver.gameserver.instancemanager.FortSiegeManager;
import com.l2jserver.gameserver.instancemanager.GrandBossManager;
import com.l2jserver.gameserver.instancemanager.HandysBlockCheckerManager;
import com.l2jserver.gameserver.instancemanager.InstanceManager;
import com.l2jserver.gameserver.instancemanager.ItemsOnGroundManager;
import com.l2jserver.gameserver.instancemanager.PunishmentManager;
import com.l2jserver.gameserver.instancemanager.QuestManager;
import com.l2jserver.gameserver.instancemanager.SiegeManager;
import com.l2jserver.gameserver.instancemanager.TerritoryWarManager;
import com.l2jserver.gameserver.instancemanager.ZoneManager;
import com.l2jserver.gameserver.model.ArenaParticipantsHolder;
import com.l2jserver.gameserver.model.BlockList;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.L2AccessLevel;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.L2ClanMember;
import com.l2jserver.gameserver.model.L2CommandChannel;
import com.l2jserver.gameserver.model.L2ContactList;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2Party;
import com.l2jserver.gameserver.model.L2PetData;
import com.l2jserver.gameserver.model.L2PetLevelData;
import com.l2jserver.gameserver.model.L2PremiumItem;
import com.l2jserver.gameserver.model.L2Radar;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2Request;
import com.l2jserver.gameserver.model.L2SkillLearn;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.L2WorldRegion;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroList;
import com.l2jserver.gameserver.model.PartyMatchRoom;
import com.l2jserver.gameserver.model.PartyMatchRoomList;
import com.l2jserver.gameserver.model.PartyMatchWaitingList;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.ShortCuts;
import com.l2jserver.gameserver.model.Shortcut;
import com.l2jserver.gameserver.model.TeleportBookmark;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.TerritoryWard;
import com.l2jserver.gameserver.model.TimeStamp;
import com.l2jserver.gameserver.model.TradeList;
import com.l2jserver.gameserver.model.UIKeysSettings;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Decoy;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.L2Vehicle;
import com.l2jserver.gameserver.model.actor.appearance.PcAppearance;
import com.l2jserver.gameserver.model.actor.events.PlayerEvents;
import com.l2jserver.gameserver.model.actor.instance.L2AirShipInstance;
import com.l2jserver.gameserver.model.actor.instance.L2BoatInstance;
import com.l2jserver.gameserver.model.actor.instance.L2ControlTowerInstance;
import com.l2jserver.gameserver.model.actor.instance.L2CubicInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PetInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TamedBeastInstance;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.model.actor.knownlist.PcKnownList;
import com.l2jserver.gameserver.model.actor.stat.PcStat;
import com.l2jserver.gameserver.model.actor.status.PcStatus;
import com.l2jserver.gameserver.model.actor.tasks.player.DismountTask;
import com.l2jserver.gameserver.model.actor.tasks.player.FameTask;
import com.l2jserver.gameserver.model.actor.tasks.player.GameGuardCheckTask;
import com.l2jserver.gameserver.model.actor.tasks.player.InventoryEnableTask;
import com.l2jserver.gameserver.model.actor.tasks.player.LookingForFishTask;
import com.l2jserver.gameserver.model.actor.tasks.player.PetFeedTask;
import com.l2jserver.gameserver.model.actor.tasks.player.PvPFlagTask;
import com.l2jserver.gameserver.model.actor.tasks.player.RecoBonusTaskEnd;
import com.l2jserver.gameserver.model.actor.tasks.player.RecoGiveTask;
import com.l2jserver.gameserver.model.actor.tasks.player.RentPetTask;
import com.l2jserver.gameserver.model.actor.tasks.player.ResetChargesTask;
import com.l2jserver.gameserver.model.actor.tasks.player.ResetSoulsTask;
import com.l2jserver.gameserver.model.actor.tasks.player.SitDownTask;
import com.l2jserver.gameserver.model.actor.tasks.player.StandUpTask;
import com.l2jserver.gameserver.model.actor.tasks.player.TeleportWatchdogTask;
import com.l2jserver.gameserver.model.actor.tasks.player.VitalityTask;
import com.l2jserver.gameserver.model.actor.tasks.player.WarnUserTakeBreakTask;
import com.l2jserver.gameserver.model.actor.tasks.player.WaterTask;
import com.l2jserver.gameserver.model.actor.templates.L2PcTemplate;
import com.l2jserver.gameserver.model.actor.transform.Transform;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.base.ClassLevel;
import com.l2jserver.gameserver.model.base.PlayerClass;
import com.l2jserver.gameserver.model.base.SubClass;
import com.l2jserver.gameserver.model.effects.EffectFlag;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.entity.Fort;
import com.l2jserver.gameserver.model.entity.Hero;
import com.l2jserver.gameserver.model.entity.Instance;
import com.l2jserver.gameserver.model.entity.L2Event;
import com.l2jserver.gameserver.model.entity.Siege;
import com.l2jserver.gameserver.model.entity.TvTEvent;
import com.l2jserver.gameserver.model.fishing.L2Fish;
import com.l2jserver.gameserver.model.fishing.L2Fishing;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.PlayerEventHolder;
import com.l2jserver.gameserver.model.holders.SkillUseHolder;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcFreight;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.itemcontainer.PcRefund;
import com.l2jserver.gameserver.model.itemcontainer.PcWarehouse;
import com.l2jserver.gameserver.model.itemcontainer.PetInventory;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Henna;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2ActionType;
import com.l2jserver.gameserver.model.items.type.L2ArmorType;
import com.l2jserver.gameserver.model.items.type.L2EtcItemType;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameTask;
import com.l2jserver.gameserver.model.olympiad.OlympiadManager;
import com.l2jserver.gameserver.model.punishment.PunishmentAffect;
import com.l2jserver.gameserver.model.punishment.PunishmentType;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;
import com.l2jserver.gameserver.model.quest.State;
import com.l2jserver.gameserver.model.skills.AbnormalType;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.stats.Formulas;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.variables.AccountVariables;
import com.l2jserver.gameserver.model.variables.PlayerVariables;
import com.l2jserver.gameserver.model.zone.L2ZoneType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.model.zone.type.L2BossZone;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.communityserver.CommunityServerThread;
import com.l2jserver.gameserver.network.communityserver.writepackets.WorldInfo;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ChangeWaitType;
import com.l2jserver.gameserver.network.serverpackets.CharInfo;
import com.l2jserver.gameserver.network.serverpackets.ConfirmDlg;
import com.l2jserver.gameserver.network.serverpackets.EtcStatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.ExAutoSoulShot;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExDominionWarStart;
import com.l2jserver.gameserver.network.serverpackets.ExDuelUpdateUserInfo;
import com.l2jserver.gameserver.network.serverpackets.ExFishingEnd;
import com.l2jserver.gameserver.network.serverpackets.ExFishingStart;
import com.l2jserver.gameserver.network.serverpackets.ExGetBookMarkInfoPacket;
import com.l2jserver.gameserver.network.serverpackets.ExGetOnAirShip;
import com.l2jserver.gameserver.network.serverpackets.ExOlympiadMode;
import com.l2jserver.gameserver.network.serverpackets.ExPrivateStoreSetWholeMsg;
import com.l2jserver.gameserver.network.serverpackets.ExSetCompassZoneCode;
import com.l2jserver.gameserver.network.serverpackets.ExStartScenePlayer;
import com.l2jserver.gameserver.network.serverpackets.ExStorageMaxCount;
import com.l2jserver.gameserver.network.serverpackets.ExUseSharedGroupItem;
import com.l2jserver.gameserver.network.serverpackets.FlyToLocation;
import com.l2jserver.gameserver.network.serverpackets.FriendStatusPacket;
import com.l2jserver.gameserver.network.serverpackets.GameGuardQuery;
import com.l2jserver.gameserver.network.serverpackets.GetOnVehicle;
import com.l2jserver.gameserver.network.serverpackets.HennaInfo;
import com.l2jserver.gameserver.network.serverpackets.InventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.LeaveWorld;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.MyTargetSelected;
import com.l2jserver.gameserver.network.serverpackets.NicknameChanged;
import com.l2jserver.gameserver.network.serverpackets.NpcHtmlMessage;
import com.l2jserver.gameserver.network.serverpackets.ObservationMode;
import com.l2jserver.gameserver.network.serverpackets.ObservationReturn;
import com.l2jserver.gameserver.network.serverpackets.PartySmallWindowUpdate;
import com.l2jserver.gameserver.network.serverpackets.PetInventoryUpdate;
import com.l2jserver.gameserver.network.serverpackets.PlaySound;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListDelete;
import com.l2jserver.gameserver.network.serverpackets.PledgeShowMemberListUpdate;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreManageListSell;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgBuy;
import com.l2jserver.gameserver.network.serverpackets.PrivateStoreMsgSell;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopMsg;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopSellList;
import com.l2jserver.gameserver.network.serverpackets.RelationChanged;
import com.l2jserver.gameserver.network.serverpackets.Ride;
import com.l2jserver.gameserver.network.serverpackets.ServerClose;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.ShortCutInit;
import com.l2jserver.gameserver.network.serverpackets.SkillCoolTime;
import com.l2jserver.gameserver.network.serverpackets.SkillList;
import com.l2jserver.gameserver.network.serverpackets.Snoop;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.TargetSelected;
import com.l2jserver.gameserver.network.serverpackets.TargetUnselected;
import com.l2jserver.gameserver.network.serverpackets.TradeDone;
import com.l2jserver.gameserver.network.serverpackets.TradeOtherDone;
import com.l2jserver.gameserver.network.serverpackets.TradeStart;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.scripting.scriptengine.events.EquipmentEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.HennaEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ProfessionChangeEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.TransformEvent;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.EquipmentListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.EventListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.HennaListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.ProfessionChangeListener;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.player.TransformListener;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.gameserver.util.FloodProtectors;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.EnumIntBitmask;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import javolution.util.FastList;
import javolution.util.FastMap;
import javolution.util.FastSet;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public final class L2PcInstance
extends L2Playable {
    private static final String RESTORE_SKILLS_FOR_CHAR = "SELECT skill_id,skill_level FROM character_skills WHERE charId=? AND class_index=?";
    private static final String ADD_NEW_SKILL = "INSERT INTO character_skills (charId,skill_id,skill_level,class_index) VALUES (?,?,?,?)";
    private static final String UPDATE_CHARACTER_SKILL_LEVEL = "UPDATE character_skills SET skill_level=? WHERE skill_id=? AND charId=? AND class_index=?";
    private static final String DELETE_SKILL_FROM_CHAR = "DELETE FROM character_skills WHERE skill_id=? AND charId=? AND class_index=?";
    private static final String DELETE_CHAR_SKILLS = "DELETE FROM character_skills WHERE charId=? AND class_index=?";
    private static final String ADD_SKILL_SAVE = "INSERT INTO character_skills_save (charId,skill_id,skill_level,remaining_time,reuse_delay,systime,restore_type,class_index,buff_index) VALUES (?,?,?,?,?,?,?,?,?)";
    private static final String RESTORE_SKILL_SAVE = "SELECT skill_id,skill_level,remaining_time, reuse_delay, systime, restore_type FROM character_skills_save WHERE charId=? AND class_index=? ORDER BY buff_index ASC";
    private static final String DELETE_SKILL_SAVE = "DELETE FROM character_skills_save WHERE charId=? AND class_index=?";
    private static final String ADD_ITEM_REUSE_SAVE = "INSERT INTO character_item_reuse_save (charId,itemId,itemObjId,reuseDelay,systime) VALUES (?,?,?,?,?)";
    private static final String RESTORE_ITEM_REUSE_SAVE = "SELECT charId,itemId,itemObjId,reuseDelay,systime FROM character_item_reuse_save WHERE charId=?";
    private static final String DELETE_ITEM_REUSE_SAVE = "DELETE FROM character_item_reuse_save WHERE charId=?";
    private static final String INSERT_CHARACTER = "INSERT INTO characters (account_name,charId,char_name,level,maxHp,curHp,maxCp,curCp,maxMp,curMp,face,hairStyle,hairColor,sex,exp,sp,karma,fame,pvpkills,pkkills,clanid,race,classid,deletetime,cancraft,title,title_color,accesslevel,online,isin7sdungeon,clan_privs,wantspeace,base_class,newbie,nobless,power_grade,createDate) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_CHARACTER = "UPDATE characters SET level=?,maxHp=?,curHp=?,maxCp=?,curCp=?,maxMp=?,curMp=?,face=?,hairStyle=?,hairColor=?,sex=?,heading=?,x=?,y=?,z=?,exp=?,expBeforeDeath=?,sp=?,karma=?,fame=?,pvpkills=?,pkkills=?,clanid=?,race=?,classid=?,deletetime=?,title=?,title_color=?,accesslevel=?,online=?,isin7sdungeon=?,clan_privs=?,wantspeace=?,base_class=?,onlinetime=?,newbie=?,nobless=?,power_grade=?,subpledge=?,lvl_joined_academy=?,apprentice=?,sponsor=?,clan_join_expiry_time=?,clan_create_expiry_time=?,char_name=?,death_penalty_level=?,bookmarkslot=?,vitality_points=?,language=?,hero=? WHERE charId=?";
    private static final String RESTORE_CHARACTER = "SELECT * FROM characters WHERE charId=?";
    private static final String INSERT_TP_BOOKMARK = "REPLACE INTO character_tpbookmark (charId,Id,x,y,z,icon,tag,name) values (?,?,?,?,?,?,?,?)";
    private static final String UPDATE_TP_BOOKMARK = "UPDATE character_tpbookmark SET icon=?,tag=?,name=? where charId=? AND Id=?";
    private static final String RESTORE_TP_BOOKMARK = "SELECT Id,x,y,z,icon,tag,name FROM character_tpbookmark WHERE charId=?";
    private static final String DELETE_TP_BOOKMARK = "DELETE FROM character_tpbookmark WHERE charId=? AND Id=?";
    private static final String RESTORE_CHAR_SUBCLASSES = "SELECT class_id,exp,sp,level,class_index FROM character_subclasses WHERE charId=? ORDER BY class_index ASC";
    private static final String ADD_CHAR_SUBCLASS = "INSERT INTO character_subclasses (charId,class_id,exp,sp,level,class_index) VALUES (?,?,?,?,?,?)";
    private static final String UPDATE_CHAR_SUBCLASS = "UPDATE character_subclasses SET exp=?,sp=?,level=?,class_id=? WHERE charId=? AND class_index =?";
    private static final String DELETE_CHAR_SUBCLASS = "DELETE FROM character_subclasses WHERE charId=? AND class_index=?";
    private static final String RESTORE_CHAR_HENNAS = "SELECT slot,symbol_id FROM character_hennas WHERE charId=? AND class_index=?";
    private static final String ADD_CHAR_HENNA = "INSERT INTO character_hennas (charId,symbol_id,slot,class_index) VALUES (?,?,?,?)";
    private static final String DELETE_CHAR_HENNA = "DELETE FROM character_hennas WHERE charId=? AND slot=? AND class_index=?";
    private static final String DELETE_CHAR_HENNAS = "DELETE FROM character_hennas WHERE charId=? AND class_index=?";
    private static final String DELETE_CHAR_SHORTCUTS = "DELETE FROM character_shortcuts WHERE charId=? AND class_index=?";
    private static final String COND_OVERRIDE_KEY = "cond_override";
    public static final String NEWBIE_KEY = "NEWBIE";
    public static final int ID_NONE = -1;
    public static final int REQUEST_TIMEOUT = 15;
    private static final FastList<HennaListener> HENNA_LISTENERS = new FastList().shared();
    private static final FastList<EquipmentListener> GLOBAL_EQUIPMENT_LISTENERS = new FastList().shared();
    private static final FastList<ProfessionChangeListener> GLOBAL_PROFESSION_CHANGE_LISTENERS = new FastList().shared();
    private final FastList<EquipmentListener> _equipmentListeners = new FastList().shared();
    private final FastList<TransformListener> _transformListeners = new FastList().shared();
    private final FastList<ProfessionChangeListener> _professionChangeListeners = new FastList().shared();
    private final FastList<EventListener> _eventListeners = new FastList().shared();
    private L2GameClient _client;
    private final String _accountName;
    private long _deleteTimer;
    private Calendar _createDate = Calendar.getInstance();
    private String _lang = null;
    private String _htmlPrefix = null;
    private volatile boolean _isOnline = false;
    private long _onlineTime;
    private long _onlineBeginTime;
    private long _lastAccess;
    private long _uptime;
    private final ReentrantLock _subclassLock = new ReentrantLock();
    protected int _baseClass;
    protected int _activeClass;
    protected int _classIndex = 0;
    private int _controlItemId;
    private L2PetData _data;
    private L2PetLevelData _leveldata;
    private int _curFeed;
    protected Future<?> _mountFeedTask;
    private ScheduledFuture<?> _dismountTask;
    private boolean _petItems = false;
    private Map<Integer, SubClass> _subClasses;
    private final PcAppearance _appearance;
    private long _expBeforeDeath;
    private int _karma;
    private int _pvpKills;
    private int _pkKills;
    private byte _pvpFlag;
    private int _fame;
    private ScheduledFuture<?> _fameTask;
    private ScheduledFuture<?> _vitalityTask;
    private volatile ScheduledFuture<?> _teleportWatchdog;
    private byte _siegeState = 0;
    private int _siegeSide = 0;
    private int _curWeightPenalty = 0;
    private int _lastCompassZone;
    private boolean _isIn7sDungeon = false;
    private final L2ContactList _contactList = new L2ContactList(this);
    private int _bookmarkslot = 0;
    private final ArrayList<TeleportBookmark> _tpbookmarks = new ArrayList<TeleportBookmark>(){

        @Override
        public TeleportBookmark get(int index) {
            return --index < 0 || index >= this.size() ? null : (TeleportBookmark)super.get(index);
        }

        @Override
        public TeleportBookmark remove(int index) {
            return --index < 0 || index >= this.size() ? null : (TeleportBookmark)super.remove(index);
        }

        @Override
        public TeleportBookmark set(int index, TeleportBookmark element) {
            return super.set(--index, element);
        }
    };
    private boolean _canFeed;
    private boolean _isInSiege;
    private boolean _isInHideoutSiege = false;
    private boolean _inOlympiadMode = false;
    private boolean _OlympiadStart = false;
    private int _olympiadGameId = -1;
    private int _olympiadSide = -1;
    public int olyBuff = 0;
    private boolean _isInDuel = false;
    private int _duelState = 0;
    private int _duelId = 0;
    private SystemMessageId _noDuelReason = SystemMessageId.THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL;
    private L2Vehicle _vehicle = null;
    private Location _inVehiclePosition;
    public ScheduledFuture<?> _taskforfish;
    private MountType _mountType = MountType.NONE;
    private int _mountNpcId;
    private int _mountLevel;
    private int _mountObjectID = 0;
    public int _telemode = 0;
    private boolean _inCrystallize;
    private boolean _inCraftMode;
    private long _offlineShopStart = 0L;
    private Transform _transformation;
    private final FastMap<Integer, L2RecipeList> _dwarvenRecipeBook = new FastMap();
    private final FastMap<Integer, L2RecipeList> _commonRecipeBook = new FastMap();
    private final FastMap<Integer, L2PremiumItem> _premiumItems = new FastMap();
    private boolean _waitTypeSitting;
    private final Location _lastLoc = new Location(0, 0, 0);
    private boolean _observerMode = false;
    private final Location _lastServerPosition = new Location(0, 0, 0);
    private int _recomHave;
    private int _recomLeft;
    private ScheduledFuture<?> _recoBonusTask;
    private ScheduledFuture<?> _recoGiveTask;
    protected boolean _recoTwoHoursGiven = false;
    private final PcInventory _inventory = new PcInventory(this);
    private final PcFreight _freight = new PcFreight(this);
    private PcWarehouse _warehouse;
    private PcRefund _refund;
    private PrivateStoreType _privateStoreType = PrivateStoreType.NONE;
    private TradeList _activeTradeList;
    private ItemContainer _activeWarehouse;
    private volatile Map<Integer, L2ManufactureItem> _manufactureItems;
    private String _storeName = "";
    private TradeList _sellList;
    private TradeList _buyList;
    private PreparedListContainer _currentMultiSell = null;
    private int _newbie;
    private boolean _noble = false;
    private boolean _hero = false;
    public boolean aura = false;
    public boolean voteServerRestart = false;
    private L2Npc _lastFolkNpc = null;
    private int _questNpcObject = 0;
    private final FastMap<String, QuestState> _quests = new FastMap();
    private final ShortCuts _shortCuts = new ShortCuts(this);
    private final MacroList _macros = new MacroList(this);
    private final FastList<L2PcInstance> _snoopListener = new FastList();
    private final FastList<L2PcInstance> _snoopedPlayer = new FastList();
    private final L2Henna[] _henna = new L2Henna[3];
    private int _hennaSTR;
    private int _hennaINT;
    private int _hennaDEX;
    private int _hennaMEN;
    private int _hennaWIT;
    private int _hennaCON;
    private L2Summon _summon = null;
    private L2Decoy _decoy = null;
    private L2TrapInstance _trap = null;
    private int _agathionId = 0;
    private FastList<L2TamedBeastInstance> _tamedBeast = null;
    private boolean _minimapAllowed = false;
    private int _partyroom = 0;
    private int _clanId;
    private L2Clan _clan;
    private int _apprentice = 0;
    private int _sponsor = 0;
    private long _clanJoinExpiryTime;
    private long _clanCreateExpiryTime;
    private int _powerGrade = 0;
    private volatile EnumIntBitmask<ClanPrivilege> _clanPrivileges = new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false);
    private int _pledgeClass = 0;
    private int _pledgeType = 0;
    private int _lvlJoinedAcademy = 0;
    private int _wantsPeace = 0;
    private int _deathPenaltyBuffLevel = 0;
    private final AtomicInteger _charges = new AtomicInteger();
    private ScheduledFuture<?> _chargeTask = null;
    private int _souls = 0;
    private ScheduledFuture<?> _soulTask = null;
    private Location _currentSkillWorldPosition;
    private L2AccessLevel _accessLevel;
    private boolean _messageRefusal = false;
    private boolean _silenceMode = false;
    private List<Integer> _silenceModeExcluded;
    private boolean _dietMode = false;
    private boolean _tradeRefusal = false;
    private boolean _exchangeRefusal = false;
    private L2Party _party;
    private L2PcInstance _activeRequester;
    private long _requestExpireTime = 0L;
    private final L2Request _request = new L2Request(this);
    private L2ItemInstance _arrowItem;
    private L2ItemInstance _boltItem;
    private long _protectEndTime = 0L;
    private L2ItemInstance _lure = null;
    private long _teleportProtectEndTime = 0L;
    private long _recentFakeDeathEndTime = 0L;
    private boolean _isFakeDeath;
    private L2Weapon _fistsWeaponItem;
    private final FastMap<Integer, String> _chars = new FastMap();
    private int _expertiseArmorPenalty = 0;
    private int _expertiseWeaponPenalty = 0;
    private int _expertisePenaltyBonus = 0;
    private boolean _isEnchanting = false;
    private int _activeEnchantItemId = -1;
    private int _activeEnchantSupportItemId = -1;
    private int _activeEnchantAttrItemId = -1;
    private long _activeEnchantTimestamp = 0L;
    protected boolean _inventoryDisable = false;
    private final FastIntObjectMap<L2CubicInstance> _cubics = new FastIntObjectMap().shared();
    protected FastSet<Integer> _activeSoulShots = new FastSet().shared();
    public final ReentrantLock soulShotLock = new ReentrantLock();
    private PlayerEventHolder eventStatus = null;
    private byte _handysBlockCheckerEventArena = (byte)-1;
    private final int[] _loto = new int[5];
    private final int[] _race = new int[2];
    private final BlockList _blockList = new BlockList(this);
    private L2Fishing _fishCombat;
    private boolean _fishing = false;
    private int _fishx = 0;
    private int _fishy = 0;
    private int _fishz = 0;
    private volatile Set<Integer> _transformAllowedSkills;
    private ScheduledFuture<?> _taskRentPet;
    private ScheduledFuture<?> _taskWater;
    private final int[] _htmlActionOriginObjectIds = new int[HtmlActionScope.values().length];
    private int _lastHtmlActionOriginObjId;
    private final LinkedList<String>[] _htmlActionCaches = new LinkedList[HtmlActionScope.values().length];
    private SkillUseHolder _currentSkill;
    private SkillUseHolder _currentPetSkill;
    private SkillUseHolder _queuedSkill;
    private int _cursedWeaponEquippedId = 0;
    private boolean _combatFlagEquippedId = false;
    private int _reviveRequested = 0;
    private double _revivePower = 0.0;
    private boolean _revivePet = false;
    private double _cpUpdateIncCheck = 0.0;
    private double _cpUpdateDecCheck = 0.0;
    private double _cpUpdateInterval = 0.0;
    private double _mpUpdateIncCheck = 0.0;
    private double _mpUpdateDecCheck = 0.0;
    private double _mpUpdateInterval = 0.0;
    private int _clientX;
    private int _clientY;
    private int _clientZ;
    private int _clientHeading;
    private static final int FALLING_VALIDATION_DELAY = 10000;
    private volatile long _fallingTimestamp = 0L;
    private int _multiSocialTarget = 0;
    private int _multiSociaAction = 0;
    private int _movieId = 0;
    private String _adminConfirmCmd = null;
    private volatile long _lastItemAuctionInfoRequest = 0L;
    private Future<?> _PvPRegTask;
    private long _pvpFlagLasts;
    private long _notMoveUntil = 0L;
    private Map<Integer, Skill> _customSkills = null;
    private boolean _canRevive = true;
    private volatile int _actionMask;
    private UIKeysSettings _uiKeySettings;
    private boolean _married = false;
    private int _partnerId = 0;
    private int _coupleId = 0;
    private boolean _engagerequest = false;
    private int _engageid = 0;
    private boolean _marryrequest = false;
    private boolean _marryaccepted = false;
    private String _lastPetitionGmName = null;
    private volatile List<QuestState> _notifyQuestOfDeathList;
    private ClassId _learningClass = this.getClassId();
    private boolean _gmEnable = true;
    private ScheduledFuture<?> _taskWarnUserTakeBreak;
    private L2Fish _fish;
    private boolean _expGainOn = true;
    private final FastList<Integer> _friendList = new FastList();
    private long _exceptions = 0L;

    public boolean isSpawnProtected() {
        return this._protectEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public boolean isTeleportProtected() {
        return this._teleportProtectEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public void setPvpFlagLasts(long time) {
        this._pvpFlagLasts = time;
    }

    public long getPvpFlagLasts() {
        return this._pvpFlagLasts;
    }

    public void startPvPFlag() {
        this.updatePvPFlag(1);
        if (this._PvPRegTask == null) {
            this._PvPRegTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PvPFlagTask(this), 1000L, 1000L);
        }
    }

    public void stopPvpRegTask() {
        if (this._PvPRegTask != null) {
            this._PvPRegTask.cancel(true);
            this._PvPRegTask = null;
        }
    }

    public void stopPvPFlag() {
        this.stopPvpRegTask();
        this.updatePvPFlag(0);
        this._PvPRegTask = null;
    }

    public static L2PcInstance create(L2PcTemplate template, String accountName, String name, PcAppearance app) {
        L2PcInstance player = new L2PcInstance(IdFactory.getInstance().getNextId(), template, accountName, app);
        player.setName(name);
        player.setCreateDate(Calendar.getInstance());
        player.setBaseClass(player.getClassId());
        player.setNewbie(1);
        player.setRecomLeft(20);
        return player.createDb() ? player : null;
    }

    public String getAccountName() {
        if (this.getClient() == null) {
            return this.getAccountNamePlayer();
        }
        return this.getClient().getAccountName();
    }

    public String getAccountNamePlayer() {
        return this._accountName;
    }

    public String getAccountName2() {
        return this._accountName;
    }

    public Map<Integer, String> getAccountChars() {
        return this._chars;
    }

    public int getRelation(L2PcInstance target) {
        int result = 0;
        if (this.getClan() != null) {
            result |= 0x40;
            if (this.getClan() == target.getClan()) {
                result |= 0x100;
            }
            if (this.getAllyId() != 0) {
                result |= 0x10000;
            }
        }
        if (this.isClanLeader()) {
            result |= 0x80;
        }
        if (this.getParty() != null && this.getParty() == target.getParty()) {
            result |= 0x20;
            block11: for (int i = 0; i < this.getParty().getMembers().size(); ++i) {
                if (this.getParty().getMembers().get(i) != this) continue;
                switch (i) {
                    case 0: {
                        result |= 0x10;
                        continue block11;
                    }
                    case 1: {
                        result |= 8;
                        continue block11;
                    }
                    case 2: {
                        result |= 7;
                        continue block11;
                    }
                    case 3: {
                        result |= 6;
                        continue block11;
                    }
                    case 4: {
                        result |= 5;
                        continue block11;
                    }
                    case 5: {
                        result |= 4;
                        continue block11;
                    }
                    case 6: {
                        result |= 3;
                        continue block11;
                    }
                    case 7: {
                        result |= 2;
                        continue block11;
                    }
                    case 8: {
                        result |= 1;
                    }
                }
            }
        }
        if (this.getSiegeState() != 0) {
            if (TerritoryWarManager.getInstance().getRegisteredTerritoryId(this) != 0) {
                result |= 0x80000;
            } else {
                result |= 0x200;
                result = this.getSiegeState() != target.getSiegeState() ? (result |= 0x1000) : (result |= 0x800);
                if (this.getSiegeState() == 1) {
                    result |= 0x400;
                }
            }
        }
        if (this.getClan() != null && target.getClan() != null && target.getPledgeType() != -1 && this.getPledgeType() != -1 && target.getClan().isAtWarWith(this.getClan().getId())) {
            result |= 0x8000;
            if (this.getClan().isAtWarWith(target.getClan().getId())) {
                result |= 0x4000;
            }
        }
        if (this.getBlockCheckerArena() != -1) {
            result |= 0x200;
            ArenaParticipantsHolder holder = HandysBlockCheckerManager.getInstance().getHolder(this.getBlockCheckerArena());
            result = holder.getPlayerTeam(this) == 1 ? (result |= 0x1000) : (result |= 0x800);
            result |= 0x400;
        }
        return result;
    }

    public static L2PcInstance load(int objectId) {
        return L2PcInstance.restore(objectId);
    }

    private void initPcStatusUpdateValues() {
        this._cpUpdateInterval = (double)this.getMaxCp() / 352.0;
        this._cpUpdateIncCheck = this.getMaxCp();
        this._cpUpdateDecCheck = (double)this.getMaxCp() - this._cpUpdateInterval;
        this._mpUpdateInterval = (double)this.getMaxMp() / 352.0;
        this._mpUpdateIncCheck = this.getMaxMp();
        this._mpUpdateDecCheck = (double)this.getMaxMp() - this._mpUpdateInterval;
    }

    private L2PcInstance(int objectId, L2PcTemplate template, String accountName, PcAppearance app) {
        super(objectId, template);
        this.setInstanceType(InstanceType.L2PcInstance);
        super.initCharStatusUpdateValues();
        this.initPcStatusUpdateValues();
        for (int i = 0; i < this._htmlActionCaches.length; ++i) {
            this._htmlActionCaches[i] = new LinkedList();
        }
        this._accountName = accountName;
        app.setOwner(this);
        this._appearance = app;
        this.getAI();
        this.startVitalityTask();
    }

    @Override
    public final PcKnownList getKnownList() {
        return (PcKnownList)super.getKnownList();
    }

    @Override
    public void initKnownList() {
        this.setKnownList(new PcKnownList(this));
    }

    @Override
    public final PcStat getStat() {
        return (PcStat)super.getStat();
    }

    @Override
    public void initCharStat() {
        this.setStat(new PcStat(this));
    }

    @Override
    public final PcStatus getStatus() {
        return (PcStatus)super.getStatus();
    }

    @Override
    public void initCharStatus() {
        this.setStatus(new PcStatus(this));
    }

    @Override
    public void initCharEvents() {
        this.setCharEvents(new PlayerEvents(this));
    }

    @Override
    public PlayerEvents getEvents() {
        return (PlayerEvents)super.getEvents();
    }

    public final PcAppearance getAppearance() {
        return this._appearance;
    }

    public final L2PcTemplate getBaseTemplate() {
        return CharTemplateTable.getInstance().getTemplate(this._baseClass);
    }

    @Override
    public final L2PcTemplate getTemplate() {
        return (L2PcTemplate)super.getTemplate();
    }

    public void setTemplate(ClassId newclass) {
        super.setTemplate(CharTemplateTable.getInstance().getTemplate(newclass));
    }

    @Override
    protected L2CharacterAI initAI() {
        return new L2PlayerAI(new AIAccessor());
    }

    @Override
    public final int getLevel() {
        return this.getStat().getLevel();
    }

    @Override
    public double getLevelMod() {
        double levelMod;
        if (this.isTransformed() && (levelMod = this.getTransformation().getLevelMod(this)) > -1.0) {
            return levelMod;
        }
        return super.getLevelMod();
    }

    public int getNewbie() {
        return this._newbie;
    }

    public void setNewbie(int newbieRewards) {
        this._newbie = newbieRewards;
    }

    public void setBaseClass(int baseClass) {
        this._baseClass = baseClass;
    }

    public void setBaseClass(ClassId classId) {
        this._baseClass = classId.ordinal();
    }

    public boolean isInStoreMode() {
        return this.getPrivateStoreType() != PrivateStoreType.NONE;
    }

    public boolean isInCraftMode() {
        return this._inCraftMode;
    }

    public void isInCraftMode(boolean b) {
        this._inCraftMode = b;
    }

    public void logout() {
        this.logout(true);
    }

    public void logout(boolean closeClient) {
        try {
            this.closeNetConnection(closeClient);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on logout(): " + e.getMessage(), e);
        }
    }

    public L2RecipeList[] getCommonRecipeBook() {
        return this._commonRecipeBook.values().toArray(new L2RecipeList[this._commonRecipeBook.values().size()]);
    }

    public L2RecipeList[] getDwarvenRecipeBook() {
        return this._dwarvenRecipeBook.values().toArray(new L2RecipeList[this._dwarvenRecipeBook.values().size()]);
    }

    public void registerCommonRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._commonRecipeBook.put((Object)recipe.getId(), (Object)recipe);
        if (saveToDb) {
            this.insertNewRecipeData(recipe.getId(), false);
        }
    }

    public void registerDwarvenRecipeList(L2RecipeList recipe, boolean saveToDb) {
        this._dwarvenRecipeBook.put((Object)recipe.getId(), (Object)recipe);
        if (saveToDb) {
            this.insertNewRecipeData(recipe.getId(), true);
        }
    }

    public boolean hasRecipeList(int recipeId) {
        return this._dwarvenRecipeBook.containsKey((Object)recipeId) || this._commonRecipeBook.containsKey((Object)recipeId);
    }

    public void unregisterRecipeList(int recipeId) {
        if (this._dwarvenRecipeBook.remove((Object)recipeId) != null) {
            this.deleteRecipeData(recipeId, true);
        } else if (this._commonRecipeBook.remove((Object)recipeId) != null) {
            this.deleteRecipeData(recipeId, false);
        } else {
            _log.warning("Attempted to remove unknown RecipeList: " + recipeId);
        }
        for (Shortcut sc : this.getAllShortCuts()) {
            if (sc == null || sc.getId() != recipeId || sc.getType() != ShortcutType.RECIPE) continue;
            this.deleteShortCut(sc.getSlot(), sc.getPage());
        }
    }

    private void insertNewRecipeData(int recipeId, boolean isDwarf) {
        block26: {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement("INSERT INTO character_recipebook (charId, id, classIndex, type) values(?,?,?,?)");){
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, recipeId);
                statement.setInt(3, isDwarf ? this._classIndex : 0);
                statement.setInt(4, isDwarf ? 1 : 0);
                statement.execute();
            }
            catch (SQLException e) {
                if (!_log.isLoggable(Level.SEVERE)) break block26;
                _log.log(Level.SEVERE, "SQL exception while inserting recipe: " + recipeId + " from character " + this.getObjectId(), e);
            }
        }
    }

    private void deleteRecipeData(int recipeId, boolean isDwarf) {
        block26: {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement("DELETE FROM character_recipebook WHERE charId=? AND id=? AND classIndex=?");){
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, recipeId);
                statement.setInt(3, isDwarf ? this._classIndex : 0);
                statement.execute();
            }
            catch (SQLException e) {
                if (!_log.isLoggable(Level.SEVERE)) break block26;
                _log.log(Level.SEVERE, "SQL exception while deleting recipe: " + recipeId + " from character " + this.getObjectId(), e);
            }
        }
    }

    public int getLastQuestNpcObject() {
        return this._questNpcObject;
    }

    public void setLastQuestNpcObject(int npcId) {
        this._questNpcObject = npcId;
    }

    public QuestState getQuestState(String quest) {
        return (QuestState)this._quests.get((Object)quest);
    }

    public void setQuestState(QuestState qs) {
        this._quests.put((Object)qs.getQuestName(), (Object)qs);
    }

    public boolean hasQuestState(String quest) {
        return this._quests.containsKey((Object)quest);
    }

    public void delQuestState(String quest) {
        this._quests.remove((Object)quest);
    }

    private QuestState[] addToQuestStateArray(QuestState[] questStateArray, QuestState state) {
        int len = questStateArray.length;
        QuestState[] tmp = new QuestState[len + 1];
        System.arraycopy(questStateArray, 0, tmp, 0, len);
        tmp[len] = state;
        return tmp;
    }

    public Quest[] getAllActiveQuests() {
        ArrayList<Quest> quests = new ArrayList<Quest>();
        for (QuestState qs : this._quests.values()) {
            if (qs == null || qs.getQuest() == null || !qs.isStarted() && !Config.DEVELOPER || !qs.getQuest().isQuests()) continue;
            quests.add(qs.getQuest());
        }
        return quests.toArray(new Quest[quests.size()]);
    }

    public QuestState[] getQuestsForAttacks(L2Npc npc) {
        QuestState[] states = null;
        for (Quest quest : npc.getTemplate().getEventQuests(QuestEventType.ON_ATTACK)) {
            if (this.getQuestState(quest.getName()) == null) continue;
            if (states == null) {
                states = new QuestState[]{this.getQuestState(quest.getName())};
                continue;
            }
            states = this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
        }
        return states;
    }

    public QuestState[] getQuestsForKills(L2Npc npc) {
        QuestState[] states = null;
        for (Quest quest : npc.getTemplate().getEventQuests(QuestEventType.ON_KILL)) {
            if (this.getQuestState(quest.getName()) == null) continue;
            if (states == null) {
                states = new QuestState[]{this.getQuestState(quest.getName())};
                continue;
            }
            states = this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
        }
        return states;
    }

    public QuestState[] getQuestsForTalk(int npcId) {
        QuestState[] states = null;
        List<Quest> quests = NpcData.getInstance().getTemplate(npcId).getEventQuests(QuestEventType.ON_TALK);
        if (quests != null) {
            for (Quest quest : quests) {
                if (quest == null || this.getQuestState(quest.getName()) == null) continue;
                if (states == null) {
                    states = new QuestState[]{this.getQuestState(quest.getName())};
                    continue;
                }
                states = this.addToQuestStateArray(states, this.getQuestState(quest.getName()));
            }
        }
        return states;
    }

    public QuestState processQuestEvent(String quest, String event) {
        L2Npc npc;
        QuestState[] states;
        L2Object object;
        QuestState qs;
        QuestState retval = null;
        if (event == null) {
            event = "";
        }
        if ((qs = this.getQuestState(quest)) == null && event.isEmpty()) {
            return retval;
        }
        if (qs == null) {
            Quest q = QuestManager.getInstance().getQuest(quest);
            if (q == null) {
                return retval;
            }
            qs = q.newQuestState(this);
        }
        if (qs != null && this.getLastQuestNpcObject() > 0 && this.getLastQuestNpcObject() == this.getLastHtmlActionOriginId() && (object = L2World.getInstance().findObject(this.getLastQuestNpcObject())) instanceof L2Npc && this.isInsideRadius(object, 150, false, false) && (states = this.getQuestsForTalk((npc = (L2Npc)object).getId())) != null) {
            for (QuestState state : states) {
                if (!state.getQuest().getName().equals(qs.getQuest().getName())) continue;
                if (qs.getQuest().notifyEvent(event, npc, this)) {
                    this.showQuestWindow(quest, npc, State.getStateName(qs.getState()));
                }
                retval = qs;
            }
        }
        return retval;
    }

    private void showQuestWindow(String questId, L2Npc npc, String stateId) {
        String path = "data/scripts/quests/" + questId + "/" + stateId + ".htm";
        String content = HtmCache.getInstance().getHtm(this.getHtmlPrefix(), path);
        if (content != null) {
            this.sendPacket(new NpcHtmlMessage(npc != null ? npc.getObjectId() : 0, content));
        }
        this.sendPacket(ActionFailed.STATIC_PACKET);
    }

    public void addNotifyQuestOfDeath(QuestState qs) {
        if (qs == null) {
            return;
        }
        if (!this.getNotifyQuestOfDeath().contains(qs)) {
            this.getNotifyQuestOfDeath().add(qs);
        }
    }

    public void removeNotifyQuestOfDeath(QuestState qs) {
        if (qs == null || this._notifyQuestOfDeathList == null) {
            return;
        }
        this._notifyQuestOfDeathList.remove(qs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List<QuestState> getNotifyQuestOfDeath() {
        if (this._notifyQuestOfDeathList == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._notifyQuestOfDeathList == null) {
                    this._notifyQuestOfDeathList = new FastList();
                }
            }
        }
        return this._notifyQuestOfDeathList;
    }

    public final boolean isNotifyQuestOfDeathEmpty() {
        return this._notifyQuestOfDeathList == null || this._notifyQuestOfDeathList.isEmpty();
    }

    public Collection<Shortcut> getAllShortCuts() {
        return this._shortCuts.getAllShortCuts();
    }

    public Shortcut getShortCut(int slot, int page) {
        return this._shortCuts.getShortCut(slot, page);
    }

    public void registerShortCut(Shortcut shortcut) {
        this._shortCuts.registerShortCut(shortcut);
    }

    public void updateShortCuts(int skillId, int skillLevel) {
        this._shortCuts.updateShortCuts(skillId, skillLevel);
    }

    public void deleteShortCut(int slot, int page) {
        this._shortCuts.deleteShortCut(slot, page);
    }

    public void registerMacro(Macro macro) {
        this._macros.registerMacro(macro);
    }

    public void deleteMacro(int id) {
        this._macros.deleteMacro(id);
    }

    public MacroList getMacros() {
        return this._macros;
    }

    public void setSiegeState(byte siegeState) {
        this._siegeState = siegeState;
    }

    public byte getSiegeState() {
        return this._siegeState;
    }

    public void setSiegeSide(int val) {
        this._siegeSide = val;
    }

    public boolean isRegisteredOnThisSiegeField(int val) {
        return this._siegeSide == val || this._siegeSide >= 81 && this._siegeSide <= 89;
    }

    public int getSiegeSide() {
        return this._siegeSide;
    }

    public void setPvpFlag(int pvpFlag) {
        this._pvpFlag = (byte)pvpFlag;
    }

    @Override
    public byte getPvpFlag() {
        return this._pvpFlag;
    }

    @Override
    public void updatePvPFlag(int value) {
        if (this.getPvpFlag() == value) {
            return;
        }
        this.setPvpFlag(value);
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        if (this.hasSummon()) {
            this.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(this), false));
        }
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance target : plrs) {
            target.sendPacket(new RelationChanged(this, this.getRelation(target), this.isAutoAttackable(target)));
            if (!this.hasSummon()) continue;
            target.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(target), this.isAutoAttackable(target)));
        }
    }

    @Override
    public void revalidateZone(boolean force) {
        if (this.getWorldRegion() == null) {
            return;
        }
        if (force) {
            this._zoneValidateCounter = (byte)4;
        } else {
            this._zoneValidateCounter = (byte)(this._zoneValidateCounter - 1);
            if (this._zoneValidateCounter < 0) {
                this._zoneValidateCounter = (byte)4;
            } else {
                return;
            }
        }
        this.getWorldRegion().revalidateZones(this);
        if (Config.ALLOW_WATER) {
            this.checkWaterState();
        }
        if (this.isInsideZone(ZoneId.ALTERED)) {
            if (this._lastCompassZone == 8) {
                return;
            }
            this._lastCompassZone = 8;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(8);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.SIEGE)) {
            if (this._lastCompassZone == 11) {
                return;
            }
            this._lastCompassZone = 11;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(11);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.PVP)) {
            if (this._lastCompassZone == 14) {
                return;
            }
            this._lastCompassZone = 14;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(14);
            this.sendPacket(cz);
        } else if (this.isIn7sDungeon()) {
            if (this._lastCompassZone == 13) {
                return;
            }
            this._lastCompassZone = 13;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(13);
            this.sendPacket(cz);
        } else if (this.isInsideZone(ZoneId.PEACE)) {
            if (this._lastCompassZone == 12) {
                return;
            }
            this._lastCompassZone = 12;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(12);
            this.sendPacket(cz);
        } else {
            if (this._lastCompassZone == 15) {
                return;
            }
            if (this._lastCompassZone == 11) {
                this.updatePvPStatus();
            }
            this._lastCompassZone = 15;
            ExSetCompassZoneCode cz = new ExSetCompassZoneCode(15);
            this.sendPacket(cz);
        }
    }

    public boolean hasDwarvenCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_DWARVEN.getId()) >= 1;
    }

    public int getDwarvenCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_DWARVEN.getId());
    }

    public boolean hasCommonCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_COMMON.getId()) >= 1;
    }

    public int getCommonCraft() {
        return this.getSkillLevel(CommonSkill.CREATE_COMMON.getId());
    }

    public int getPkKills() {
        return this._pkKills;
    }

    public void setPkKills(int pkKills) {
        if (!this.getEvents().onPKChange(this._pkKills, pkKills)) {
            return;
        }
        this._pkKills = pkKills;
    }

    public long getDeleteTimer() {
        return this._deleteTimer;
    }

    public void setDeleteTimer(long deleteTimer) {
        this._deleteTimer = deleteTimer;
    }

    public int getRecomHave() {
        return this._recomHave;
    }

    protected void incRecomHave() {
        if (this._recomHave < 255) {
            ++this._recomHave;
        }
    }

    public void setRecomHave(int value) {
        this._recomHave = Math.min(Math.max(value, 0), 255);
    }

    public void setRecomLeft(int value) {
        this._recomLeft = Math.min(Math.max(value, 0), 255);
    }

    public int getRecomLeft() {
        return this._recomLeft;
    }

    protected void decRecomLeft() {
        if (this._recomLeft > 0) {
            --this._recomLeft;
        }
    }

    public void giveRecom(L2PcInstance target) {
        target.incRecomHave();
        this.decRecomLeft();
    }

    public void setExpBeforeDeath(long exp) {
        this._expBeforeDeath = exp;
    }

    public long getExpBeforeDeath() {
        return this._expBeforeDeath;
    }

    @Override
    public int getKarma() {
        return this._karma;
    }

    public void setKarma(int karma) {
        if (!this.getEvents().onKarmaChange(this._karma, karma)) {
            return;
        }
        if (karma < 0) {
            karma = 0;
        }
        if (this._karma == 0 && karma > 0) {
            Collection objs = this.getKnownList().getKnownObjects().values();
            for (L2Object object : objs) {
                if (!(object instanceof L2GuardInstance) || ((L2GuardInstance)object).getAI().getIntention() != CtrlIntention.AI_INTENTION_IDLE) continue;
                ((L2GuardInstance)object).getAI().setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null);
            }
        } else if (this._karma > 0 && karma == 0) {
            this.setKarmaFlag(0);
        }
        this._karma = karma;
        this.broadcastKarma();
    }

    public int getExpertiseArmorPenalty() {
        return this._expertiseArmorPenalty;
    }

    public int getExpertiseWeaponPenalty() {
        return this._expertiseWeaponPenalty;
    }

    public int getExpertisePenaltyBonus() {
        return this._expertisePenaltyBonus;
    }

    public void setExpertisePenaltyBonus(int bonus) {
        this._expertisePenaltyBonus = bonus;
    }

    public int getWeightPenalty() {
        if (this._dietMode) {
            return 0;
        }
        return this._curWeightPenalty;
    }

    public void refreshOverloaded() {
        long weightproc;
        int newWeightPenalty;
        int maxLoad = this.getMaxLoad();
        if (maxLoad > 0 && this._curWeightPenalty != (newWeightPenalty = (weightproc = (long)((this.getCurrentLoad() - this.getBonusWeightPenalty()) * 1000 / this.getMaxLoad())) < 500L || this._dietMode ? 0 : (weightproc < 666L ? 1 : (weightproc < 800L ? 2 : (weightproc < 1000L ? 3 : 4))))) {
            this._curWeightPenalty = newWeightPenalty;
            if (newWeightPenalty > 0 && !this._dietMode) {
                this.addSkill(SkillData.getInstance().getSkill(4270, newWeightPenalty));
                this.setIsOverloaded(this.getCurrentLoad() > maxLoad);
            } else {
                this.removeSkill(this.getKnownSkill(4270), false, true);
                this.setIsOverloaded(false);
            }
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new EtcStatusUpdate(this));
            this.broadcastPacket(new CharInfo(this));
            this.broadcastPacket(new ExBrExtraUserInfo(this));
        }
    }

    public void refreshExpertisePenalty() {
        if (!Config.EXPERTISE_PENALTY) {
            return;
        }
        int expertiseLevel = this.getExpertiseLevel();
        int armorPenalty = 0;
        int weaponPenalty = 0;
        for (L2ItemInstance item : this.getInventory().getItems()) {
            int crystaltype;
            if (item == null || !item.isEquipped() || item.getItemType() == L2EtcItemType.ARROW || item.getItemType() == L2EtcItemType.BOLT || (crystaltype = item.getItem().getCrystalType()) <= expertiseLevel) continue;
            if (item.isWeapon() && crystaltype > weaponPenalty) {
                weaponPenalty = crystaltype;
                continue;
            }
            if (crystaltype <= armorPenalty) continue;
            armorPenalty = crystaltype;
        }
        boolean changed = false;
        int bonus = this.getExpertisePenaltyBonus();
        weaponPenalty = weaponPenalty - expertiseLevel - bonus;
        weaponPenalty = Math.min(Math.max(weaponPenalty, 0), 4);
        if (this.getExpertiseWeaponPenalty() != weaponPenalty || this.getSkillLevel(CommonSkill.WEAPON_GRADE_PENALTY.getId()) != weaponPenalty) {
            this._expertiseWeaponPenalty = weaponPenalty;
            if (this._expertiseWeaponPenalty > 0) {
                this.addSkill(SkillData.getInstance().getSkill(CommonSkill.WEAPON_GRADE_PENALTY.getId(), this._expertiseWeaponPenalty));
            } else {
                this.removeSkill(this.getKnownSkill(CommonSkill.WEAPON_GRADE_PENALTY.getId()), false, true);
            }
            changed = true;
        }
        armorPenalty = armorPenalty - expertiseLevel - bonus;
        armorPenalty = Math.min(Math.max(armorPenalty, 0), 4);
        if (this.getExpertiseArmorPenalty() != armorPenalty || this.getSkillLevel(CommonSkill.ARMOR_GRADE_PENALTY.getId()) != armorPenalty) {
            this._expertiseArmorPenalty = armorPenalty;
            if (this._expertiseArmorPenalty > 0) {
                this.addSkill(SkillData.getInstance().getSkill(CommonSkill.ARMOR_GRADE_PENALTY.getId(), this._expertiseArmorPenalty));
            } else {
                this.removeSkill(this.getKnownSkill(CommonSkill.ARMOR_GRADE_PENALTY.getId()), false, true);
            }
            changed = true;
        }
        if (changed) {
            this.sendPacket(new EtcStatusUpdate(this));
        }
    }

    public void useEquippableItem(L2ItemInstance item, boolean abortAttack) {
        L2ItemInstance[] items = null;
        boolean isEquiped = item.isEquipped();
        int oldInvLimit = this.getInventoryLimit();
        SystemMessage sm = null;
        if (!this.fireEquipmentListeners(isEquiped, item)) {
            return;
        }
        if (isEquiped) {
            if (item.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(item.getEnchantLevel());
                sm.addItemName(item);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(item);
            }
            this.sendPacket(sm);
            int slot = this.getInventory().getSlotFromItem(item);
            items = slot == 0x400000 ? this.getInventory().unEquipItemInSlotAndRecord(item.getLocationSlot()) : this.getInventory().unEquipItemInBodySlotAndRecord(slot);
        } else {
            items = this.getInventory().equipItemAndRecord(item);
            if (item.isEquipped()) {
                if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_S2_EQUIPPED);
                    sm.addInt(item.getEnchantLevel());
                    sm.addItemName(item);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_EQUIPPED);
                    sm.addItemName(item);
                }
                this.sendPacket(sm);
                item.decreaseMana(false);
                if ((item.getItem().getBodyPart() & 0x4080) != 0) {
                    this.rechargeShots(true, true);
                }
            } else {
                this.sendPacket(SystemMessageId.CANNOT_EQUIP_ITEM_DUE_TO_BAD_CONDITION);
            }
        }
        this.refreshExpertisePenalty();
        this.checkAuraItemEquipped();
        this.broadcastUserInfo();
        InventoryUpdate iu = new InventoryUpdate();
        iu.addItems(Arrays.asList(items));
        this.sendPacket(iu);
        if (abortAttack) {
            this.abortAttack();
        }
        if (this.getInventoryLimit() != oldInvLimit) {
            this.sendPacket(new ExStorageMaxCount(this));
        }
    }

    public int getPvpKills() {
        return this._pvpKills;
    }

    public void setPvpKills(int pvpKills) {
        if (!this.getEvents().onPvPChange(this._pvpKills, pvpKills)) {
            return;
        }
        this._pvpKills = pvpKills;
    }

    public int getFame() {
        return this._fame;
    }

    public void setFame(int fame) {
        if (!this.getEvents().onFameChange(this._fame, fame)) {
            return;
        }
        this._fame = fame > Config.MAX_PERSONAL_FAME_POINTS ? Config.MAX_PERSONAL_FAME_POINTS : fame;
    }

    public ClassId getClassId() {
        return this.getTemplate().getClassId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setClassId(int Id) {
        if (!this._subclassLock.tryLock()) {
            return;
        }
        try {
            if (this.getLvlJoinedAcademy() != 0 && this._clan != null && PlayerClass.values()[Id].getLevel() == ClassLevel.Third) {
                if (this.getLvlJoinedAcademy() <= 16) {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MAX_REP_SCORE, true);
                } else if (this.getLvlJoinedAcademy() >= 39) {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MIN_REP_SCORE, true);
                } else {
                    this._clan.addReputationScore(Config.JOIN_ACADEMY_MAX_REP_SCORE - (this.getLvlJoinedAcademy() - 16) * 20, true);
                }
                this.setLvlJoinedAcademy(0);
                SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CLAN_MEMBER_S1_EXPELLED);
                msg.addPcName(this);
                this._clan.broadcastToOnlineMembers(msg);
                this._clan.broadcastToOnlineMembers(new PledgeShowMemberListDelete(this.getName()));
                this._clan.removeClanMember(this.getObjectId(), 0L);
                this.sendPacket(SystemMessageId.ACADEMY_MEMBERSHIP_TERMINATED);
                this.getInventory().addItem("Gift", 8181, 1L, this, null);
            }
            if (this.isSubClassActive()) {
                this.getSubClasses().get(this._classIndex).setClassId(Id);
            }
            this.setTarget(this);
            this.broadcastPacket(new MagicSkillUse(this, 5103, 1, 1000, 0));
            this.setClassTemplate(Id);
            if (this.getClassId().level() == 3) {
                this.sendPacket(SystemMessageId.THIRD_CLASS_TRANSFER);
            } else {
                this.sendPacket(SystemMessageId.CLASS_TRANSFER);
            }
            if (this.isInParty()) {
                this.getParty().broadcastPacket(new PartySmallWindowUpdate(this));
            }
            if (this.getClan() != null) {
                this.getClan().broadcastToOnlineMembers(new PledgeShowMemberListUpdate(this));
            }
            this.rewardSkills();
            if (!this.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && Config.DECREASE_SKILL_LEVEL) {
                this.checkPlayerSkills();
            }
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public ClassId getLearningClass() {
        return this._learningClass;
    }

    public void setLearningClass(ClassId learningClass) {
        this._learningClass = learningClass;
    }

    public long getExp() {
        return this.getStat().getExp();
    }

    public void setActiveEnchantAttrItemId(int objectId) {
        this._activeEnchantAttrItemId = objectId;
    }

    public int getActiveEnchantAttrItemId() {
        return this._activeEnchantAttrItemId;
    }

    public void setActiveEnchantItemId(int objectId) {
        if (objectId == -1) {
            this.setActiveEnchantSupportItemId(-1);
            this.setActiveEnchantTimestamp(0L);
            this.setIsEnchanting(false);
        }
        this._activeEnchantItemId = objectId;
    }

    public int getActiveEnchantItemId() {
        return this._activeEnchantItemId;
    }

    public void setActiveEnchantSupportItemId(int objectId) {
        this._activeEnchantSupportItemId = objectId;
    }

    public int getActiveEnchantSupportItemId() {
        return this._activeEnchantSupportItemId;
    }

    public long getActiveEnchantTimestamp() {
        return this._activeEnchantTimestamp;
    }

    public void setActiveEnchantTimestamp(long val) {
        this._activeEnchantTimestamp = val;
    }

    public void setIsEnchanting(boolean val) {
        this._isEnchanting = val;
    }

    public boolean isEnchanting() {
        return this._isEnchanting;
    }

    public void setFistsWeaponItem(L2Weapon weaponItem) {
        this._fistsWeaponItem = weaponItem;
    }

    public L2Weapon getFistsWeaponItem() {
        return this._fistsWeaponItem;
    }

    public L2Weapon findFistsWeaponItem(int classId) {
        L2Weapon weaponItem = null;
        if (classId >= 0 && classId <= 9) {
            L2Item temp = ItemTable.getInstance().getTemplate(246);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 10 && classId <= 17) {
            L2Item temp = ItemTable.getInstance().getTemplate(251);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 18 && classId <= 24) {
            L2Item temp = ItemTable.getInstance().getTemplate(244);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 25 && classId <= 30) {
            L2Item temp = ItemTable.getInstance().getTemplate(249);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 31 && classId <= 37) {
            L2Item temp = ItemTable.getInstance().getTemplate(245);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 38 && classId <= 43) {
            L2Item temp = ItemTable.getInstance().getTemplate(250);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 44 && classId <= 48) {
            L2Item temp = ItemTable.getInstance().getTemplate(248);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 49 && classId <= 52) {
            L2Item temp = ItemTable.getInstance().getTemplate(252);
            weaponItem = (L2Weapon)temp;
        } else if (classId >= 53 && classId <= 57) {
            L2Item temp = ItemTable.getInstance().getTemplate(247);
            weaponItem = (L2Weapon)temp;
        }
        return weaponItem;
    }

    public void rewardSkills() {
        if (Config.AUTO_LEARN_SKILLS) {
            this.giveAvailableSkills(Config.AUTO_LEARN_FS_SKILLS, true);
        } else {
            this.giveAvailableAutoGetSkills();
        }
        this.checkPlayerSkills();
        this.checkItemRestriction();
        this.sendSkillList();
    }

    public void regiveTemporarySkills() {
        if (this.isNoble()) {
            this.setNoble(true);
        }
        if (this.isHero()) {
            this.setHero(true);
        }
        if (this.getClan() != null) {
            L2Clan clan = this.getClan();
            clan.addSkillEffects(this);
            if (clan.getLevel() >= SiegeManager.getInstance().getSiegeClanMinLevel() && this.isClanLeader()) {
                SiegeManager.getInstance().addSiegeSkills(this);
            }
            if (this.getClan().getCastleId() > 0) {
                CastleManager.getInstance().getCastleByOwner(this.getClan()).giveResidentialSkills(this);
            }
            if (this.getClan().getFortId() > 0) {
                FortManager.getInstance().getFortByOwner(this.getClan()).giveResidentialSkills(this);
            }
        }
        this.getInventory().reloadEquippedItems();
        this.restoreDeathPenaltyBuffLevel();
    }

    public int giveAvailableSkills(boolean includedByFs, boolean includeAutoGet) {
        int skillCounter = 0;
        Collection<Skill> skills = SkillTreesData.getInstance().getAllAvailableSkills(this, this.getClassId(), includedByFs, includeAutoGet);
        for (Skill sk : skills) {
            if (this.getKnownSkill(sk.getId()) == sk) continue;
            if (this.getSkillLevel(sk.getId()) == -1) {
                ++skillCounter;
            }
            if (sk.isToggle() && this.isAffectedBySkill(sk.getId())) {
                this.stopSkillEffects(true, sk.getId());
            }
            this.addSkill(sk, true);
        }
        if (Config.AUTO_LEARN_SKILLS && skillCounter > 0) {
            this.sendMessage(skillCounter + "\u500b\u306e\u30b9\u30ad\u30eb\u3092\u7fd2\u5f97\u3057\u307e\u3057\u305f\u3002");
        }
        return skillCounter;
    }

    public void giveAvailableAutoGetSkills() {
        List<L2SkillLearn> autoGetSkills = SkillTreesData.getInstance().getAvailableAutoGetSkills(this);
        SkillData st = SkillData.getInstance();
        for (L2SkillLearn s : autoGetSkills) {
            Skill skill = st.getSkill(s.getSkillId(), s.getSkillLevel());
            if (skill != null) {
                this.addSkill(skill, true);
                continue;
            }
            _log.warning("Skipping null auto-get skill for player: " + this.toString());
        }
    }

    public void setExp(long exp) {
        if (exp < 0L) {
            exp = 0L;
        }
        this.getStat().setExp(exp);
    }

    public PcRace getRace() {
        if (!this.isSubClassActive()) {
            return this.getTemplate().getRace();
        }
        return CharTemplateTable.getInstance().getTemplate(this._baseClass).getRace();
    }

    public L2Radar getRadar() {
        return new L2Radar(this);
    }

    public boolean isMinimapAllowed() {
        return this._minimapAllowed;
    }

    public void setMinimapAllowed(boolean b) {
        this._minimapAllowed = b;
    }

    public int getSp() {
        return this.getStat().getSp();
    }

    public void setSp(int sp) {
        if (sp < 0) {
            sp = 0;
        }
        super.getStat().setSp(sp);
    }

    public boolean isCastleLord(int castleId) {
        Castle castle;
        L2Clan clan = this.getClan();
        return clan != null && clan.getLeader().getPlayerInstance() == this && (castle = CastleManager.getInstance().getCastleByOwner(clan)) != null && castle == CastleManager.getInstance().getCastleById(castleId);
    }

    @Override
    public int getClanId() {
        return this._clanId;
    }

    public int getClanCrestId() {
        if (this._clan != null) {
            return this._clan.getCrestId();
        }
        return 0;
    }

    public int getClanCrestLargeId() {
        if (this._clan != null && (this._clan.getCastleId() != 0 || this._clan.getHideoutId() != 0)) {
            return this._clan.getCrestLargeId();
        }
        return 0;
    }

    public long getClanJoinExpiryTime() {
        return this._clanJoinExpiryTime;
    }

    public void setClanJoinExpiryTime(long time) {
        this._clanJoinExpiryTime = time;
    }

    public long getClanCreateExpiryTime() {
        return this._clanCreateExpiryTime;
    }

    public void setClanCreateExpiryTime(long time) {
        this._clanCreateExpiryTime = time;
    }

    public void setOnlineTime(long time) {
        this._onlineTime = time;
        this._onlineBeginTime = System.currentTimeMillis();
    }

    @Override
    public PcInventory getInventory() {
        return this._inventory;
    }

    public void removeItemFromShortCut(int objectId) {
        this._shortCuts.deleteShortCutByObjectId(objectId);
    }

    public boolean isSitting() {
        return this._waitTypeSitting;
    }

    public void setIsSitting(boolean state) {
        this._waitTypeSitting = state;
    }

    public void sitDown() {
        this.sitDown(true);
    }

    public void sitDown(boolean checkCast) {
        if (checkCast && this.isCastingNow()) {
            return;
        }
        if (!(this._waitTypeSitting || this.isAttackingDisabled() || this.isOutOfControl() || this.isImmobilized())) {
            this.breakAttack();
            this.setIsSitting(true);
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_REST);
            this.broadcastPacket(new ChangeWaitType(this, 0));
            ThreadPoolManager.getInstance().scheduleGeneral(new SitDownTask(this), 2500L);
            this.setIsParalyzed(true);
        }
    }

    public void standUp() {
        if (L2Event.isParticipant(this) && this.getEventStatus().isSitForced()) {
            this.sendMessage("A dark force beyond your mortal understanding makes your knees to shake when you try to stand up...");
        } else if (this._waitTypeSitting && !this.isInStoreMode() && !this.isAlikeDead()) {
            if (this.getEffectList().isAffected(EffectFlag.RELAXING)) {
                this.stopEffects(L2EffectType.RELAXING);
            }
            this.broadcastPacket(new ChangeWaitType(this, 1));
            ThreadPoolManager.getInstance().scheduleGeneral(new StandUpTask(this), 2500L);
        }
    }

    public PcWarehouse getWarehouse() {
        if (this._warehouse == null) {
            this._warehouse = new PcWarehouse(this);
            this._warehouse.restore();
        }
        if (Config.WAREHOUSE_CACHE) {
            WarehouseCacheManager.getInstance().addCacheTask(this);
        }
        return this._warehouse;
    }

    public void clearWarehouse() {
        if (this._warehouse != null) {
            this._warehouse.deleteMe();
        }
        this._warehouse = null;
    }

    public PcFreight getFreight() {
        return this._freight;
    }

    public boolean hasRefund() {
        return this._refund != null && this._refund.getSize() > 0 && Config.ALLOW_REFUND;
    }

    public PcRefund getRefund() {
        if (this._refund == null) {
            this._refund = new PcRefund(this);
        }
        return this._refund;
    }

    public void clearRefund() {
        if (this._refund != null) {
            this._refund.deleteMe();
        }
        this._refund = null;
    }

    public long getAdena() {
        return this._inventory.getAdena();
    }

    public long getAncientAdena() {
        return this._inventory.getAncientAdena();
    }

    public void addAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S1_ADENA);
            sm.addItemNumber(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAdena(process, count, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance adenaItem = this._inventory.getAdenaInstance();
            if (!this._inventory.reduceAdena(process, count, this, reference)) {
                return false;
            }
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(adenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA);
                sm.addItemNumber(count);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public void addAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
            sm.addItemName(5575);
            sm.addItemNumber(count);
            this.sendPacket(sm);
        }
        if (count > 0L) {
            this._inventory.addAncientAdena(process, count, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(this._inventory.getAncientAdenaInstance());
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
        }
    }

    public boolean reduceAncientAdena(String process, long count, L2Object reference, boolean sendMessage) {
        if (count > this.getAncientAdena()) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
            }
            return false;
        }
        if (count > 0L) {
            L2ItemInstance ancientAdenaItem = this._inventory.getAncientAdenaInstance();
            if (!this._inventory.reduceAncientAdena(process, count, this, reference)) {
                return false;
            }
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate iu = new InventoryUpdate();
                iu.addItem(ancientAdenaItem);
                this.sendPacket(iu);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            if (sendMessage) {
                SystemMessage sm;
                if (count > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                    sm.addItemName(5575);
                    sm.addItemNumber(count);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(5575);
                    this.sendPacket(sm);
                }
            }
        }
        return true;
    }

    public void addItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        if (item.getCount() > 0L) {
            TerritoryWard ward;
            if (sendMessage) {
                SystemMessage sm;
                if (item.getCount() > 1L) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                    sm.addItemName(item);
                    sm.addItemNumber(item.getCount());
                    this.sendPacket(sm);
                } else if (item.getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_A_S1_S2);
                    sm.addInt(item.getEnchantLevel());
                    sm.addItemName(item);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(item);
                    this.sendPacket(sm);
                }
            }
            L2ItemInstance newitem = this._inventory.addItem(process, item, this, reference);
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                playerIU.addItem(newitem);
                this.sendPacket(playerIU);
            } else {
                this.sendPacket(new ItemList(this, false));
            }
            StatusUpdate su = new StatusUpdate(this);
            su.addAttribute(14, this.getCurrentLoad());
            this.sendPacket(su);
            if (!(this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) || this._inventory.validateCapacity(0L, item.isQuestItem()) || !newitem.isDropable() || newitem.isStackable() && newitem.getLastChange() == 2)) {
                this.dropItem("InvDrop", newitem, null, true, true);
            } else if (CursedWeaponsManager.getInstance().isCursed(newitem.getId())) {
                CursedWeaponsManager.getInstance().activate(this, newitem);
            } else if (FortSiegeManager.getInstance().isCombat(item.getId())) {
                if (FortSiegeManager.getInstance().activateCombatFlag(this, item)) {
                    Fort fort = FortManager.getInstance().getFort(this);
                    fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.C1_ACQUIRED_THE_FLAG), this.getName());
                }
            } else if (item.getId() >= 13560 && item.getId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(item.getId() - 13479)) != null) {
                ward.activate(this, item);
            }
        }
    }

    public L2ItemInstance addItem(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (count > 0L) {
            L2ItemInstance item = null;
            if (ItemTable.getInstance().getTemplate(itemId) == null) {
                _log.log(Level.SEVERE, "Item doesn't exist so cannot be added. Item ID: " + itemId);
                return null;
            }
            item = ItemTable.getInstance().createDummyItem(itemId);
            if (sendMessage && (!this.isCastingNow() && item.getItem().hasExImmediateEffect() || !item.getItem().hasExImmediateEffect())) {
                SystemMessage sm;
                if (count > 1L) {
                    if (process.equalsIgnoreCase("Sweeper") || process.equalsIgnoreCase("Quest")) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                        sm.addItemName(itemId);
                        sm.addItemNumber(count);
                        this.sendPacket(sm);
                    } else {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1_S2);
                        sm.addItemName(itemId);
                        sm.addItemNumber(count);
                        this.sendPacket(sm);
                    }
                } else if (process.equalsIgnoreCase("Sweeper") || process.equalsIgnoreCase("Quest")) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_PICKED_UP_S1);
                    sm.addItemName(itemId);
                    this.sendPacket(sm);
                }
            }
            if (item.getItem().hasExImmediateEffect()) {
                IItemHandler handler = ItemHandler.getInstance().getHandler(item.getEtcItem());
                if (handler == null) {
                    _log.warning("No item handler registered for Herb ID " + item.getId() + "!");
                } else {
                    handler.useItem(this, new L2ItemInstance(itemId), false);
                }
            } else {
                TerritoryWard ward;
                L2ItemInstance createdItem = this._inventory.addItem(process, itemId, count, this, reference);
                if (!(this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS) || this._inventory.validateCapacity(0L, item.isQuestItem()) || !createdItem.isDropable() || createdItem.isStackable() && createdItem.getLastChange() == 2)) {
                    this.dropItem("InvDrop", createdItem, null, true);
                } else if (CursedWeaponsManager.getInstance().isCursed(createdItem.getId())) {
                    CursedWeaponsManager.getInstance().activate(this, createdItem);
                } else if (FortSiegeManager.getInstance().isCombat(createdItem.getId())) {
                    if (FortSiegeManager.getInstance().activateCombatFlag(this, item)) {
                        Fort fort = FortManager.getInstance().getFort(this);
                        fort.getSiege().announceToPlayer(SystemMessage.getSystemMessage(SystemMessageId.C1_ACQUIRED_THE_FLAG), this.getName());
                    }
                } else if (createdItem.getId() >= 13560 && createdItem.getId() <= 13568 && (ward = TerritoryWarManager.getInstance().getTerritoryWard(createdItem.getId() - 13479)) != null) {
                    ward.activate(this, createdItem);
                }
                return createdItem;
            }
        }
        return null;
    }

    public void addItem(String process, ItemHolder item, L2Object reference, boolean sendMessage) {
        this.addItem(process, item.getId(), item.getCount(), reference, sendMessage);
    }

    public boolean destroyItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.destroyItem(process, item, item.getCount(), reference, sendMessage);
    }

    public boolean destroyItem(String process, L2ItemInstance item, long count, L2Object reference, boolean sendMessage) {
        if ((item = this._inventory.destroyItem(process, item, count, this, (Object)reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            if (item.getId() == 57) {
                this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED_ADENA).addItemNumber(count));
            } else if (count > 1L) {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                sm.addItemName(item);
                sm.addItemNumber(count);
                this.sendPacket(sm);
            } else {
                SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                sm.addItemName(item);
                this.sendPacket(sm);
            }
        }
        return true;
    }

    @Override
    public boolean destroyItem(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        return this.destroyItem(process, item, count, reference, sendMessage);
    }

    public boolean destroyItemWithoutTrace(String process, int objectId, long count, L2Object reference, boolean sendMessage) {
        L2ItemInstance item = this._inventory.getItemByObjectId(objectId);
        if (item == null || item.getCount() < count) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        return this.destroyItem(null, item, count, reference, sendMessage);
    }

    @Override
    public boolean destroyItemByItemId(String process, int itemId, long count, L2Object reference, boolean sendMessage) {
        if (itemId == 57) {
            return this.reduceAdena(process, count, reference, sendMessage);
        }
        L2ItemInstance item = this._inventory.getItemByItemId(itemId);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.NOT_ENOUGH_REQUIRED_ITEMS);
            }
            return false;
        }
        return this.destroyItem(process, item, count, reference, sendMessage);
    }

    public L2ItemInstance transferItem(String process, int objectId, long count, Inventory target, L2Object reference) {
        L2ItemInstance oldItem = this.checkItemManipulation(objectId, count, "transfer");
        if (oldItem == null) {
            return null;
        }
        L2ItemInstance newItem = this.getInventory().transferItem(process, objectId, count, target, this, reference);
        if (newItem == null) {
            return null;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            if (oldItem.getCount() > 0L && oldItem != newItem) {
                playerIU.addModifiedItem(oldItem);
            } else {
                playerIU.addRemovedItem(oldItem);
            }
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate playerSU = new StatusUpdate(this);
        playerSU.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(playerSU);
        if (target instanceof PcInventory) {
            L2PcInstance targetPlayer = ((PcInventory)target).getOwner();
            if (!Config.FORCE_INVENTORY_UPDATE) {
                InventoryUpdate playerIU = new InventoryUpdate();
                if (newItem.getCount() > count) {
                    playerIU.addModifiedItem(newItem);
                } else {
                    playerIU.addNewItem(newItem);
                }
                targetPlayer.sendPacket(playerIU);
            } else {
                targetPlayer.sendPacket(new ItemList(targetPlayer, false));
            }
            playerSU = new StatusUpdate(targetPlayer);
            playerSU.addAttribute(14, targetPlayer.getCurrentLoad());
            targetPlayer.sendPacket(playerSU);
        } else if (target instanceof PetInventory) {
            PetInventoryUpdate petIU = new PetInventoryUpdate();
            if (newItem.getCount() > count) {
                petIU.addModifiedItem(newItem);
            } else {
                petIU.addNewItem(newItem);
            }
            ((PetInventory)target).getOwner().sendPacket(petIU);
        }
        return newItem;
    }

    public boolean exchangeItemsById(String process, L2Object reference, int coinId, long cost, int rewardId, long count, boolean sendMessage) {
        PcInventory inv = this.getInventory();
        if (!inv.validateCapacityByItemId(rewardId, count)) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.SLOTS_FULL);
            }
            return false;
        }
        if (!inv.validateWeightByItemId(rewardId, count)) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.WEIGHT_LIMIT_EXCEEDED);
            }
            return false;
        }
        if (this.destroyItemByItemId(process, coinId, cost, reference, sendMessage)) {
            this.addItem(process, rewardId, count, reference, sendMessage);
            return true;
        }
        return false;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage, boolean protectItem) {
        if ((item = this._inventory.dropItem(process, item, this, reference)) == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.ITEM_NOT_DISCARDED);
            }
            return false;
        }
        item.dropMe(this, this.getX() + Rnd.get(50) - 25, this.getY() + Rnd.get(50) - 25, this.getZ() + 20);
        if (Config.AUTODESTROY_ITEM_AFTER > 0 && Config.DESTROY_DROPPED_PLAYER_ITEM && !Config.LIST_PROTECTED_ITEMS.contains(item.getId()) && (item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            if (item.isStackable() && item.getCount() < 2L) {
                item.setProtected(false);
            } else if (!item.isEquipable() || item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(item);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return true;
    }

    public boolean dropItem(String process, L2ItemInstance item, L2Object reference, boolean sendMessage) {
        return this.dropItem(process, item, reference, sendMessage, false);
    }

    public L2ItemInstance dropItem(String process, int objectId, long count, int x, int y, int z, L2Object reference, boolean sendMessage, boolean protectItem) {
        L2ItemInstance invitem = this._inventory.getItemByObjectId(objectId);
        L2ItemInstance item = this._inventory.dropItem(process, objectId, count, this, reference);
        if (item == null) {
            if (sendMessage) {
                this.sendPacket(SystemMessageId.ITEM_NOT_DISCARDED);
            }
            return null;
        }
        item.dropMe(this, x, y, z);
        if (Config.AUTODESTROY_ITEM_AFTER > 0 && Config.DESTROY_DROPPED_PLAYER_ITEM && !Config.LIST_PROTECTED_ITEMS.contains(item.getId()) && (item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM || !item.isEquipable())) {
            ItemsAutoDestroy.getInstance().addItem(item);
        }
        if (Config.DESTROY_DROPPED_PLAYER_ITEM) {
            if (item.isStackable() && item.getCount() < 2L) {
                item.setProtected(false);
            } else if (!item.isEquipable() || item.isEquipable() && Config.DESTROY_EQUIPABLE_PLAYER_ITEM) {
                item.setProtected(false);
            } else {
                item.setProtected(true);
            }
        } else {
            item.setProtected(true);
        }
        if (protectItem) {
            item.getDropProtection().protect(this);
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate playerIU = new InventoryUpdate();
            playerIU.addItem(invitem);
            this.sendPacket(playerIU);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(14, this.getCurrentLoad());
        this.sendPacket(su);
        if (sendMessage) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DROPPED_S1);
            sm.addItemName(item);
            this.sendPacket(sm);
        }
        return item;
    }

    public L2ItemInstance checkItemManipulation(int objectId, long count, String action) {
        if (L2World.getInstance().findObject(objectId) == null) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item not available in L2World");
            return null;
        }
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item he is not owner of");
            return null;
        }
        if (count < 0L || count > 1L && !item.isStackable()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item with invalid count: " + count);
            return null;
        }
        if (count > item.getCount()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " more items than he owns");
            return null;
        }
        if (this.hasSummon() && this.getSummon().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ": player tried to " + action + " item controling pet");
            }
            return null;
        }
        if (this.getActiveEnchantItemId() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ":player tried to " + action + " an enchant scroll he was using");
            }
            return null;
        }
        if (item.isAugmented() && (this.isCastingNow() || this.isCastingSimultaneouslyNow())) {
            return null;
        }
        return item;
    }

    public void setProtection(boolean protect) {
        if (Config.DEVELOPER && (protect || this._protectEndTime > 0L)) {
            _log.warning(this.getName() + ": Protection " + (protect ? "ON " + (GameTimeController.getInstance().getGameTicks() + Config.PLAYER_SPAWN_PROTECTION * 10) : "OFF") + " (currently " + GameTimeController.getInstance().getGameTicks() + ")");
        }
        this._protectEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Config.PLAYER_SPAWN_PROTECTION * 10) : 0L;
    }

    public void setTeleportProtection(boolean protect) {
        if (Config.DEVELOPER && (protect || this._teleportProtectEndTime > 0L)) {
            _log.warning(this.getName() + ": Tele Protection " + (protect ? "ON " + (GameTimeController.getInstance().getGameTicks() + Config.PLAYER_TELEPORT_PROTECTION * 10) : "OFF") + " (currently " + GameTimeController.getInstance().getGameTicks() + ")");
        }
        this._teleportProtectEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Config.PLAYER_TELEPORT_PROTECTION * 10) : 0L;
    }

    public void setRecentFakeDeath(boolean protect) {
        this._recentFakeDeathEndTime = protect ? (long)(GameTimeController.getInstance().getGameTicks() + Config.PLAYER_FAKEDEATH_UP_PROTECTION * 10) : 0L;
    }

    public boolean isRecentFakeDeath() {
        return this._recentFakeDeathEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public final boolean isFakeDeath() {
        return this._isFakeDeath;
    }

    public final void setIsFakeDeath(boolean value) {
        this._isFakeDeath = value;
    }

    @Override
    public final boolean isAlikeDead() {
        return super.isAlikeDead() || this.isFakeDeath();
    }

    public L2GameClient getClient() {
        return this._client;
    }

    public void setClient(L2GameClient client) {
        this._client = client;
    }

    public String getIPAddress() {
        String ip = "N/A";
        if (this._client != null && this._client.getConnectionAddress() != null) {
            ip = this._client.getConnectionAddress().getHostAddress();
        }
        return ip;
    }

    private void closeNetConnection(boolean closeClient) {
        L2GameClient client = this._client;
        if (client != null) {
            if (client.isDetached()) {
                client.cleanMe(true);
            } else if (!client.getConnection().isClosed()) {
                if (closeClient) {
                    client.close(LeaveWorld.STATIC_PACKET);
                } else {
                    client.close(ServerClose.STATIC_PACKET);
                }
            }
        }
    }

    public Location getCurrentSkillWorldPosition() {
        return this._currentSkillWorldPosition;
    }

    public void setCurrentSkillWorldPosition(Location worldPosition) {
        this._currentSkillWorldPosition = worldPosition;
    }

    @Override
    public void enableSkill(Skill skill) {
        super.enableSkill(skill);
        this.removeTimeStamp(skill);
    }

    @Override
    public boolean checkDoCastConditions(Skill skill) {
        if (!super.checkDoCastConditions(skill)) {
            return false;
        }
        if (this.isMounted() || this.inObserverMode()) {
            return false;
        }
        if (this.isInOlympiadMode() && skill.isBlockedInOlympiad()) {
            this.sendPacket(SystemMessageId.THIS_SKILL_IS_NOT_AVAILABLE_FOR_THE_OLYMPIAD_EVENT);
            return false;
        }
        if (this.getCharges() < skill.getChargeConsume() || this.isInAirShip() && !skill.hasEffectType(L2EffectType.REFUEL_AIRSHIP)) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
            sm.addSkillName(skill);
            this.sendPacket(sm);
            return false;
        }
        return true;
    }

    private boolean needCpUpdate() {
        double currentCp = this.getCurrentCp();
        if (currentCp <= 1.0 || (double)this.getMaxCp() < 352.0) {
            return true;
        }
        if (currentCp <= this._cpUpdateDecCheck || currentCp >= this._cpUpdateIncCheck) {
            if (currentCp == (double)this.getMaxCp()) {
                this._cpUpdateIncCheck = currentCp + 1.0;
                this._cpUpdateDecCheck = currentCp - this._cpUpdateInterval;
            } else {
                double doubleMulti = currentCp / this._cpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._cpUpdateDecCheck = this._cpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._cpUpdateIncCheck = this._cpUpdateDecCheck + this._cpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    private boolean needMpUpdate() {
        double currentMp = this.getCurrentMp();
        if (currentMp <= 1.0 || (double)this.getMaxMp() < 352.0) {
            return true;
        }
        if (currentMp <= this._mpUpdateDecCheck || currentMp >= this._mpUpdateIncCheck) {
            if (currentMp == (double)this.getMaxMp()) {
                this._mpUpdateIncCheck = currentMp + 1.0;
                this._mpUpdateDecCheck = currentMp - this._mpUpdateInterval;
            } else {
                double doubleMulti = currentMp / this._mpUpdateInterval;
                int intMulti = (int)doubleMulti;
                this._mpUpdateDecCheck = this._mpUpdateInterval * (double)(doubleMulti < (double)intMulti ? intMulti-- : intMulti);
                this._mpUpdateIncCheck = this._mpUpdateDecCheck + this._mpUpdateInterval;
            }
            return true;
        }
        return false;
    }

    @Override
    public void broadcastStatusUpdate() {
        OlympiadGameTask game;
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(10, this.getMaxHp());
        su.addAttribute(9, (int)this.getCurrentHp());
        su.addAttribute(12, this.getMaxMp());
        su.addAttribute(11, (int)this.getCurrentMp());
        su.addAttribute(34, this.getMaxCp());
        su.addAttribute(33, (int)this.getCurrentCp());
        this.sendPacket(su);
        boolean needCpUpdate = this.needCpUpdate();
        boolean needHpUpdate = this.needHpUpdate();
        if (this.isInParty() && (needCpUpdate || needHpUpdate || this.needMpUpdate())) {
            this.getParty().broadcastToPartyMembers(this, new PartySmallWindowUpdate(this));
        }
        if (this.isInOlympiadMode() && this.isOlympiadStart() && (needCpUpdate || needHpUpdate) && (game = OlympiadGameManager.getInstance().getOlympiadTask(this.getOlympiadGameId())) != null && game.isBattleStarted()) {
            game.getZone().broadcastStatusUpdate(this);
        }
        if (this.isInDuel() && (needCpUpdate || needHpUpdate)) {
            DuelManager.getInstance().broadcastToOppositTeam(this, new ExDuelUpdateUserInfo(this));
        }
    }

    public final void broadcastUserInfo() {
        this.sendPacket(new UserInfo(this));
        this.broadcastPacket(new CharInfo(this));
        this.broadcastPacket(new ExBrExtraUserInfo(this));
        if (TerritoryWarManager.getInstance().isTWInProgress() && (TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getObjectId()) || TerritoryWarManager.getInstance().checkIsRegistered(-1, this.getClan()))) {
            this.broadcastPacket(new ExDominionWarStart(this));
        }
    }

    public final void broadcastTitleInfo() {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.broadcastPacket(new NicknameChanged(this));
    }

    @Override
    public final void broadcastPacket(L2GameServerPacket mov) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.getAppearance().getInvisible());
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = (Integer)this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), relation, this.isAutoAttackable(player)));
        }
    }

    @Override
    public void broadcastPacket(L2GameServerPacket mov, int radiusInKnownlist) {
        if (!(mov instanceof CharInfo)) {
            this.sendPacket(mov);
        }
        mov.setInvisible(this.getAppearance().getInvisible());
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            if (player == null || !this.isInsideRadius(player, radiusInKnownlist, false, false)) continue;
            player.sendPacket(mov);
            if (!(mov instanceof CharInfo)) continue;
            int relation = this.getRelation(player);
            Integer oldrelation = (Integer)this.getKnownList().getKnownRelations().get(player.getObjectId());
            if (oldrelation == null || oldrelation == relation) continue;
            player.sendPacket(new RelationChanged(this, relation, this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), relation, this.isAutoAttackable(player)));
        }
    }

    @Override
    public int getAllyId() {
        if (this._clan == null) {
            return 0;
        }
        return this._clan.getAllyId();
    }

    public int getAllyCrestId() {
        if (this.getClanId() == 0) {
            return 0;
        }
        if (this.getClan().getAllyId() == 0) {
            return 0;
        }
        return this.getClan().getAllyCrestId();
    }

    public void queryGameGuard() {
        if (this.getClient() != null) {
            this.getClient().setGameGuardOk(false);
            this.sendPacket(GameGuardQuery.STATIC_PACKET);
        }
        if (Config.GAMEGUARD_ENFORCE) {
            ThreadPoolManager.getInstance().scheduleGeneral(new GameGuardCheckTask(this), 30000L);
        }
    }

    @Override
    public void sendPacket(L2GameServerPacket packet) {
        if (this._client != null) {
            this._client.sendPacket(packet);
        }
    }

    @Override
    public void sendPacket(SystemMessageId id) {
        this.sendPacket(SystemMessage.getSystemMessage(id));
    }

    public void doInteract(L2Character target) {
        if (target instanceof L2PcInstance) {
            L2PcInstance temp = (L2PcInstance)target;
            this.sendPacket(ActionFailed.STATIC_PACKET);
            if (temp.getPrivateStoreType() == PrivateStoreType.SELL || temp.getPrivateStoreType() == PrivateStoreType.PACKAGE_SELL) {
                this.sendPacket(new PrivateStoreListSell(this, temp));
            } else if (temp.getPrivateStoreType() == PrivateStoreType.BUY) {
                this.sendPacket(new PrivateStoreListBuy(this, temp));
            } else if (temp.getPrivateStoreType() == PrivateStoreType.MANUFACTURE) {
                this.sendPacket(new RecipeShopSellList(this, temp));
            }
        } else if (target != null) {
            target.onAction(this);
        }
    }

    public void doAutoLoot(L2Attackable target, int itemId, long itemCount) {
        if (this.isInParty() && !ItemTable.getInstance().getTemplate(itemId).hasExImmediateEffect()) {
            this.getParty().distributeItem(this, itemId, itemCount, false, target);
        } else if (itemId == 57) {
            this.addAdena("Loot", itemCount, target, true);
        } else {
            this.addItem("Loot", itemId, itemCount, target, true);
        }
    }

    public void doAutoLoot(L2Attackable target, ItemHolder item) {
        this.doAutoLoot(target, item.getId(), item.getCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPickupItem(L2Object object) {
        if (this.isAlikeDead() || this.isFakeDeath()) {
            return;
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        if (!(object instanceof L2ItemInstance)) {
            _log.warning(this + " trying to pickup wrong target." + this.getTarget());
            return;
        }
        L2ItemInstance target = (L2ItemInstance)object;
        this.sendPacket(ActionFailed.STATIC_PACKET);
        StopMove sm = new StopMove(this);
        this.sendPacket(sm);
        L2ItemInstance l2ItemInstance = target;
        synchronized (l2ItemInstance) {
            if (!target.isVisible()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            if (!target.getDropProtection().tryPickUp(this)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if ((this.isInParty() && this.getParty().getLootDistribution() == 0 || !this.isInParty()) && !this._inventory.validateCapacity(target)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.SLOTS_FULL);
                return;
            }
            if (this.isInvul() && !this.canOverrideCond(PcCondOverride.ITEM_CONDITIONS)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                smsg.addItemName(target);
                this.sendPacket(smsg);
                return;
            }
            if (target.getOwnerId() != 0 && target.getOwnerId() != this.getObjectId() && !this.isInLooterParty(target.getOwnerId())) {
                SystemMessage smsg;
                if (target.getId() == 57) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1_ADENA);
                    smsg.addItemNumber(target.getCount());
                } else if (target.getCount() > 1L) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S2_S1_S);
                    smsg.addItemName(target);
                    smsg.addItemNumber(target.getCount());
                } else {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.FAILED_TO_PICKUP_S1);
                    smsg.addItemName(target);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(smsg);
                return;
            }
            if (FortSiegeManager.getInstance().isCombat(target.getId()) && !FortSiegeManager.getInstance().checkIfCanPickup(this)) {
                return;
            }
            if (target.getItemLootShedule() != null && (target.getOwnerId() == this.getObjectId() || this.isInLooterParty(target.getOwnerId()))) {
                target.resetOwnerTimer();
            }
            target.pickupMe(this);
            if (Config.SAVE_DROPPED_ITEM) {
                ItemsOnGroundManager.getInstance().removeObject(target);
            }
        }
        if (target.getItem().hasExImmediateEffect()) {
            IItemHandler handler = ItemHandler.getInstance().getHandler(target.getEtcItem());
            if (handler == null) {
                _log.warning("No item handler registered for item ID: " + target.getId() + ".");
            } else {
                handler.useItem(this, target, false);
            }
            ItemTable.getInstance().destroyItem("Consume", target, this, null);
        } else if (CursedWeaponsManager.getInstance().isCursed(target.getId())) {
            this.addItem("Pickup", target, null, true);
        } else if (FortSiegeManager.getInstance().isCombat(target.getId())) {
            this.addItem("Pickup", target, null, true);
        } else {
            if (target.getItemType() instanceof L2ArmorType || target.getItemType() instanceof L2WeaponType) {
                SystemMessage smsg;
                if (target.getEnchantLevel() > 0) {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2_S3);
                    smsg.addPcName(this);
                    smsg.addInt(target.getEnchantLevel());
                    smsg.addItemName(target.getId());
                    this.broadcastPacket(smsg, 1400);
                } else {
                    smsg = SystemMessage.getSystemMessage(SystemMessageId.ANNOUNCEMENT_C1_PICKED_UP_S2);
                    smsg.addPcName(this);
                    smsg.addItemName(target.getId());
                    this.broadcastPacket(smsg, 1400);
                }
            }
            if (this.isInParty()) {
                this.getParty().distributeItem(this, target);
            } else if (target.getId() == 57 && this.getInventory().getAdenaInstance() != null) {
                this.addAdena("Pickup", target.getCount(), null, true);
                ItemTable.getInstance().destroyItem("Pickup", target, this, null);
            } else {
                L2EtcItem etcItem;
                this.addItem("Pickup", target, null, true);
                L2ItemInstance weapon = this.getInventory().getPaperdollItem(5);
                if (weapon != null && (etcItem = target.getEtcItem()) != null) {
                    L2EtcItemType itemType = etcItem.getItemType();
                    if (weapon.getItemType() == L2WeaponType.BOW && itemType == L2EtcItemType.ARROW) {
                        this.checkAndEquipArrows();
                    } else if (weapon.getItemType() == L2WeaponType.CROSSBOW && itemType == L2EtcItemType.BOLT) {
                        this.checkAndEquipBolts();
                    }
                }
            }
        }
    }

    public boolean canOpenPrivateStore() {
        return !this.isAlikeDead() && !this.isInOlympiadMode() && !this.isMounted() && !this.isInsideZone(ZoneId.NO_STORE) && !this.isCastingNow();
    }

    public void tryOpenPrivateBuyStore() {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == PrivateStoreType.BUY || this.getPrivateStoreType() == PrivateStoreType.BUY_MANAGE) {
                this.setPrivateStoreType(PrivateStoreType.NONE);
            }
            if (this.getPrivateStoreType() == PrivateStoreType.NONE) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(PrivateStoreType.BUY_MANAGE);
                this.sendPacket(new PrivateStoreManageListBuy(this));
            }
        } else {
            if (this.isInsideZone(ZoneId.NO_STORE)) {
                this.sendPacket(SystemMessageId.NO_PRIVATE_STORE_HERE);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public void tryOpenPrivateSellStore(boolean isPackageSale) {
        if (this.canOpenPrivateStore()) {
            if (this.getPrivateStoreType() == PrivateStoreType.SELL || this.getPrivateStoreType() == PrivateStoreType.SELL_MANAGE || this.getPrivateStoreType() == PrivateStoreType.PACKAGE_SELL) {
                this.setPrivateStoreType(PrivateStoreType.NONE);
            }
            if (this.getPrivateStoreType() == PrivateStoreType.NONE) {
                if (this.isSitting()) {
                    this.standUp();
                }
                this.setPrivateStoreType(PrivateStoreType.SELL_MANAGE);
                this.sendPacket(new PrivateStoreManageListSell(this, isPackageSale));
            }
        } else {
            if (this.isInsideZone(ZoneId.NO_STORE)) {
                this.sendPacket(SystemMessageId.NO_PRIVATE_STORE_HERE);
            }
            this.sendPacket(ActionFailed.STATIC_PACKET);
        }
    }

    public final PreparedListContainer getMultiSell() {
        return this._currentMultiSell;
    }

    public final void setMultiSell(PreparedListContainer list) {
        this._currentMultiSell = list;
    }

    @Override
    public boolean isTransformed() {
        return this._transformation != null && !this._transformation.isStance();
    }

    public boolean isInStance() {
        return this._transformation != null && this._transformation.isStance();
    }

    public void transform(Transform transformation) {
        if (this._transformation != null) {
            SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.YOU_ALREADY_POLYMORPHED_AND_CANNOT_POLYMORPH_AGAIN);
            this.sendPacket(msg);
            return;
        }
        if (!this.fireTransformListeners(transformation, true)) {
            return;
        }
        this.setQueuedSkill(null, false, false);
        if (this.isMounted()) {
            this.dismount();
        }
        this._transformation = transformation;
        this.getEffectList().stopAllToggles();
        transformation.onTransform(this);
        this.sendSkillList();
        this.sendPacket(new SkillCoolTime(this));
        this.broadcastUserInfo();
    }

    @Override
    public void untransform() {
        if (this._transformation != null) {
            if (!this.fireTransformListeners(this._transformation, false)) {
                return;
            }
            this.setQueuedSkill(null, false, false);
            this._transformation.onUntransform(this);
            this._transformation = null;
            this.getEffectList().stopSkillEffects(false, AbnormalType.TRANSFORM);
            this.sendSkillList();
            this.sendPacket(new SkillCoolTime(this));
            this.broadcastUserInfo();
        }
    }

    @Override
    public Transform getTransformation() {
        return this._transformation;
    }

    public int getTransformationId() {
        return this.isTransformed() ? this.getTransformation().getId() : 0;
    }

    public int getTransformationDisplayId() {
        return this.isTransformed() ? this.getTransformation().getDisplayId() : 0;
    }

    @Override
    public void setTarget(L2Object newTarget) {
        L2Object oldTarget;
        if (newTarget != null) {
            boolean isInParty;
            boolean bl = isInParty = newTarget.isPlayer() && this.isInParty() && this.getParty().containsPlayer(newTarget.getActingPlayer());
            if (!isInParty && Math.abs(newTarget.getZ() - this.getZ()) > 1000) {
                newTarget = null;
            }
            if (newTarget != null && !isInParty && !newTarget.isVisible()) {
                newTarget = null;
            }
            if (!this.isGM() && newTarget instanceof L2Vehicle) {
                newTarget = null;
            }
        }
        if ((oldTarget = this.getTarget()) != null) {
            if (oldTarget.equals(newTarget)) {
                if (newTarget != null && newTarget.getObjectId() != this.getObjectId()) {
                    this.sendPacket(new ValidateLocation(newTarget));
                }
                return;
            }
            oldTarget.removeStatusListener(this);
        }
        if (newTarget instanceof L2Character) {
            L2Character target = (L2Character)newTarget;
            if (newTarget.getObjectId() != this.getObjectId()) {
                this.sendPacket(new ValidateLocation(target));
            }
            this.sendPacket(new MyTargetSelected(this, target));
            target.addStatusListener(this);
            StatusUpdate su = new StatusUpdate(target);
            su.addAttribute(10, target.getMaxHp());
            su.addAttribute(9, (int)target.getCurrentHp());
            this.sendPacket(su);
            Broadcast.toKnownPlayers(this, new TargetSelected(this.getObjectId(), newTarget.getObjectId(), this.getX(), this.getY(), this.getZ()));
        }
        if (newTarget == null && this.getTarget() != null) {
            this.broadcastPacket(new TargetUnselected(this));
        }
        super.setTarget(newTarget);
    }

    @Override
    public L2ItemInstance getActiveWeaponInstance() {
        return this.getInventory().getPaperdollItem(5);
    }

    @Override
    public L2Weapon getActiveWeaponItem() {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon == null) {
            return this.getFistsWeaponItem();
        }
        return (L2Weapon)weapon.getItem();
    }

    public L2ItemInstance getChestArmorInstance() {
        return this.getInventory().getPaperdollItem(6);
    }

    public L2ItemInstance getLegsArmorInstance() {
        return this.getInventory().getPaperdollItem(11);
    }

    public L2Armor getActiveChestArmorItem() {
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor == null) {
            return null;
        }
        return (L2Armor)armor.getItem();
    }

    public L2Armor getActiveLegsArmorItem() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        if (legs == null) {
            return null;
        }
        return (L2Armor)legs.getItem();
    }

    public boolean isWearingHeavyArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.HEAVY && (L2ArmorType)armor.getItemType() == L2ArmorType.HEAVY) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.HEAVY;
    }

    public boolean isWearingLightArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.LIGHT && (L2ArmorType)armor.getItemType() == L2ArmorType.LIGHT) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.LIGHT;
    }

    public boolean isWearingMagicArmor() {
        L2ItemInstance legs = this.getLegsArmorInstance();
        L2ItemInstance armor = this.getChestArmorInstance();
        if (armor != null && legs != null && (L2ArmorType)legs.getItemType() == L2ArmorType.MAGIC && (L2ArmorType)armor.getItemType() == L2ArmorType.MAGIC) {
            return true;
        }
        return armor != null && this.getInventory().getPaperdollItem(6).getItem().getBodyPart() == 32768 && (L2ArmorType)armor.getItemType() == L2ArmorType.MAGIC;
    }

    public boolean isMarried() {
        return this._married;
    }

    public void setMarried(boolean state) {
        this._married = state;
    }

    public boolean isEngageRequest() {
        return this._engagerequest;
    }

    public void setEngageRequest(boolean state, int playerid) {
        this._engagerequest = state;
        this._engageid = playerid;
    }

    public void setMarryRequest(boolean state) {
        this._marryrequest = state;
    }

    public boolean isMarryRequest() {
        return this._marryrequest;
    }

    public void setMarryAccepted(boolean state) {
        this._marryaccepted = state;
    }

    public boolean isMarryAccepted() {
        return this._marryaccepted;
    }

    public int getEngageId() {
        return this._engageid;
    }

    public int getPartnerId() {
        return this._partnerId;
    }

    public void setPartnerId(int partnerid) {
        this._partnerId = partnerid;
    }

    public int getCoupleId() {
        return this._coupleId;
    }

    public void setCoupleId(int coupleId) {
        this._coupleId = coupleId;
    }

    public void engageAnswer(int answer) {
        if (!this._engagerequest) {
            return;
        }
        if (this._engageid == 0) {
            return;
        }
        L2PcInstance ptarget = L2World.getInstance().getPlayer(this._engageid);
        this.setEngageRequest(false, 0);
        if (ptarget != null) {
            if (answer == 1) {
                CoupleManager.getInstance().createCouple(ptarget, this);
                ptarget.sendMessage("Request to Engage has been >ACCEPTED<");
            } else {
                ptarget.sendMessage("Request to Engage has been >DENIED<!");
            }
        }
    }

    @Override
    public L2ItemInstance getSecondaryWeaponInstance() {
        return this.getInventory().getPaperdollItem(7);
    }

    @Override
    public L2Item getSecondaryWeaponItem() {
        L2ItemInstance item = this.getInventory().getPaperdollItem(7);
        if (item != null) {
            return item.getItem();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doDie(L2Character killer) {
        L2BossZone zone;
        if (!super.doDie(killer)) {
            return false;
        }
        if (this.isMounted()) {
            this.stopFeed();
        }
        L2PcInstance l2PcInstance = this;
        synchronized (l2PcInstance) {
            if (this.isFakeDeath()) {
                this.stopFakeDeath(true);
            }
        }
        if (killer != null) {
            L2PcInstance pk = killer.getActingPlayer();
            if (pk != null) {
                pk.getEvents().onPvPKill(this);
                TvTEvent.onKill(killer, this);
                if (L2Event.isParticipant(pk)) {
                    pk.getEventStatus().getKills().add(this);
                }
                if (Config.ANNOUNCE_PK_PVP && !pk.isGM()) {
                    SystemMessage sm;
                    String msg = "";
                    if (this.getPvpFlag() == 0) {
                        msg = Config.ANNOUNCE_PK_MSG.replace("$killer", pk.getName()).replace("$target", this.getName());
                        if (Config.ANNOUNCE_PK_PVP_NORMAL_MESSAGE) {
                            sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
                            sm.addString(msg);
                            Announcements.getInstance().announceToAll(sm);
                        } else {
                            Announcements.getInstance().announceToAll(msg);
                        }
                    } else if (this.getPvpFlag() != 0) {
                        msg = Config.ANNOUNCE_PVP_MSG.replace("$killer", pk.getName()).replace("$target", this.getName());
                        if (Config.ANNOUNCE_PK_PVP_NORMAL_MESSAGE) {
                            sm = SystemMessage.getSystemMessage(SystemMessageId.S1);
                            sm.addString(msg);
                            Announcements.getInstance().announceToAll(sm);
                        } else {
                            Announcements.getInstance().announceToAll(msg);
                        }
                    }
                }
            }
            this.broadcastStatusUpdate();
            this.setExpBeforeDeath(0L);
            if (this.isCursedWeaponEquipped()) {
                CursedWeaponsManager.getInstance().drop(this._cursedWeaponEquippedId, killer);
            } else if (this.isCombatFlagEquipped()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    TerritoryWarManager.getInstance().dropCombatFlag(this, true, false);
                } else {
                    Fort fort = FortManager.getInstance().getFort(this);
                    if (fort != null) {
                        FortSiegeManager.getInstance().dropCombatFlag(this, fort.getResidenceId());
                    } else {
                        int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                        this.getInventory().unEquipItemInBodySlot(slot);
                        this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                    }
                }
            } else if (pk == null || !pk.isCursedWeaponEquipped()) {
                this.onDieDropItem(killer);
                if ((!this.isInsideZone(ZoneId.PVP) || this.isInsideZone(ZoneId.SIEGE)) && pk != null && pk.getClan() != null && this.getClan() != null && !this.isAcademyMember() && !pk.isAcademyMember() && (this._clan.isAtWarWith(pk.getClanId()) && pk.getClan().isAtWarWith(this._clan.getId()) || this.isInSiege() && pk.isInSiege()) && AntiFeedManager.getInstance().check(killer, this)) {
                    if (this.getClan().getReputationScore() > 0) {
                        pk.getClan().addReputationScore(Config.REPUTATION_SCORE_PER_KILL, false);
                    }
                    if (pk.getClan().getReputationScore() > 0) {
                        this._clan.takeReputationScore(Config.REPUTATION_SCORE_PER_KILL, false);
                    }
                }
                if (Config.ALT_GAME_DELEVEL && !this.isLucky()) {
                    boolean siegeNpc = killer instanceof L2DefenderInstance || killer instanceof L2FortCommanderInstance;
                    boolean atWar = pk != null && this.getClan() != null && this.getClan().isAtWarWith(pk.getClanId());
                    this.deathPenalty(atWar, pk != null, siegeNpc);
                }
            }
        }
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift()) {
            this.getParty().getDimensionalRift().getDeadMemberList().add((Object)this);
        }
        if (this.getAgathionId() != 0) {
            this.setAgathionId(0);
        }
        this.calculateDeathPenaltyBuffLevel(killer);
        this.stopRentPet();
        this.stopWaterTask();
        AntiFeedManager.getInstance().setLastDeathTime(this.getObjectId());
        if (this.isPhoenixBlessed() || this.isAffected(EffectFlag.CHARM_OF_COURAGE) && this.isInSiege()) {
            this.reviveRequest(this, null, false, 0);
        }
        if ((zone = GrandBossManager.getInstance().getZone(this)) != null) {
            zone.checkAnnihilated(this);
        }
        return true;
    }

    private void onDieDropItem(L2Character killer) {
        if (L2Event.isParticipant(this) || killer == null) {
            return;
        }
        L2PcInstance pk = killer.getActingPlayer();
        if (this.getKarma() <= 0 && pk != null && pk.getClan() != null && this.getClan() != null && pk.getClan().isAtWarWith(this.getClanId())) {
            return;
        }
        if (!(this.isInsideZone(ZoneId.PVP) && pk != null || this.isGM() && !Config.KARMA_DROP_GM)) {
            boolean isKarmaDrop = false;
            boolean isKillerNpc = killer instanceof L2Npc;
            int pkLimit = Config.KARMA_PK_LIMIT;
            int dropEquip = 0;
            int dropEquipWeapon = 0;
            int dropItem = 0;
            int dropLimit = 0;
            int dropPercent = 0;
            if (this.getKarma() > 0 && this.getPkKills() >= pkLimit) {
                isKarmaDrop = true;
                dropPercent = Config.KARMA_RATE_DROP;
                dropEquip = Config.KARMA_RATE_DROP_EQUIP;
                dropEquipWeapon = Config.KARMA_RATE_DROP_EQUIP_WEAPON;
                dropItem = Config.KARMA_RATE_DROP_ITEM;
                dropLimit = Config.KARMA_DROP_LIMIT;
            } else if (isKillerNpc && this.getLevel() > 4 && !this.isFestivalParticipant()) {
                dropPercent = Config.PLAYER_RATE_DROP;
                dropEquip = Config.PLAYER_RATE_DROP_EQUIP;
                dropEquipWeapon = Config.PLAYER_RATE_DROP_EQUIP_WEAPON;
                dropItem = Config.PLAYER_RATE_DROP_ITEM;
                dropLimit = Config.PLAYER_DROP_LIMIT;
            }
            if (dropPercent > 0 && Rnd.get(100) < dropPercent) {
                int dropCount = 0;
                int itemDropPercent = 0;
                for (L2ItemInstance itemDrop : this.getInventory().getItems()) {
                    if (itemDrop.isShadowItem() || itemDrop.isTimeLimitedItem() || !itemDrop.isDropable() || itemDrop.getId() == 57 || itemDrop.getItem().getType2() == 3 || this.hasSummon() && this.getSummon().getControlObjectId() == itemDrop.getId() || Arrays.binarySearch(Config.KARMA_LIST_NONDROPPABLE_ITEMS, itemDrop.getId()) >= 0 || Arrays.binarySearch(Config.KARMA_LIST_NONDROPPABLE_PET_ITEMS, itemDrop.getId()) >= 0) continue;
                    if (itemDrop.isEquipped()) {
                        itemDropPercent = itemDrop.getItem().getType2() == 0 ? dropEquipWeapon : dropEquip;
                        this.getInventory().unEquipItemInSlot(itemDrop.getLocationSlot());
                    } else {
                        itemDropPercent = dropItem;
                    }
                    if (Rnd.get(100) >= itemDropPercent) continue;
                    this.dropItem("DieDrop", itemDrop, killer, true);
                    if (isKarmaDrop) {
                        _log.warning(this.getName() + " has karma and dropped id = " + itemDrop.getId() + ", count = " + itemDrop.getCount());
                    } else {
                        _log.warning(this.getName() + " dropped id = " + itemDrop.getId() + ", count = " + itemDrop.getCount());
                    }
                    if (++dropCount >= dropLimit) break;
                }
            }
        }
    }

    public void onKillUpdatePvPKarma(L2Character target) {
        if (target == null || !target.isPlayable()) {
            return;
        }
        L2PcInstance targetPlayer = target.getActingPlayer();
        if (targetPlayer == null || targetPlayer == this) {
            return;
        }
        if (this.isCursedWeaponEquipped() && target.isPlayer()) {
            CursedWeaponsManager.getInstance().increaseKills(this._cursedWeaponEquippedId);
            return;
        }
        if (this.isInDuel() && targetPlayer.isInDuel()) {
            return;
        }
        if (this.isInsideZone(ZoneId.PVP) || targetPlayer.isInsideZone(ZoneId.PVP)) {
            if (this.getSiegeState() > 0 && targetPlayer.getSiegeState() > 0 && this.getSiegeState() != targetPlayer.getSiegeState()) {
                L2Clan killerClan = this.getClan();
                L2Clan targetClan = targetPlayer.getClan();
                if (killerClan != null && targetClan != null) {
                    killerClan.addSiegeKill();
                    targetClan.addSiegeDeath();
                }
            }
            return;
        }
        if (this.checkIfPvP(target) && targetPlayer.getPvpFlag() != 0 || this.isInsideZone(ZoneId.PVP) && targetPlayer.isInsideZone(ZoneId.PVP)) {
            this.increasePvpKills(target);
        } else {
            if (targetPlayer.getClan() != null && this.getClan() != null && this.getClan().isAtWarWith(targetPlayer.getClanId()) && targetPlayer.getClan().isAtWarWith(this.getClanId()) && targetPlayer.getPledgeType() != -1 && this.getPledgeType() != -1) {
                this.increasePvpKills(target);
                return;
            }
            if (targetPlayer.getKarma() > 0) {
                if (Config.KARMA_AWARD_PK_KILL) {
                    this.increasePvpKills(target);
                }
            } else if (targetPlayer.getPvpFlag() == 0) {
                this.increasePkKillsAndKarma(target);
                this.checkItemRestriction();
            }
        }
    }

    public void increasePvpKills(L2Character target) {
        if (target instanceof L2PcInstance && AntiFeedManager.getInstance().check(this, target)) {
            this.setPvpKills(this.getPvpKills() + 1);
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
    }

    public void increasePkKillsAndKarma(L2Character target) {
        if (target == null || !target.isPlayable()) {
            return;
        }
        if (target.isPlayer()) {
            this.setPkKills(this.getPkKills() + 1);
        }
        this.setKarma(this.getKarma() + Formulas.calculateKarmaGain(this.getPkKills(), target.isSummon()));
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
    }

    public void updatePvPStatus() {
        if (this.isInsideZone(ZoneId.PVP)) {
            return;
        }
        this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_NORMAL_TIME);
        if (this.getPvpFlag() == 0) {
            this.startPvPFlag();
        }
    }

    public void updatePvPStatus(L2Character target) {
        L2PcInstance player_target = target.getActingPlayer();
        if (player_target == null) {
            return;
        }
        if (this.isInDuel() && player_target.getDuelId() == this.getDuelId()) {
            return;
        }
        if (!(this.isInsideZone(ZoneId.PVP) && player_target.isInsideZone(ZoneId.PVP) || player_target.getKarma() != 0)) {
            if (this.checkIfPvP(player_target)) {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_PVP_TIME);
            } else {
                this.setPvpFlagLasts(System.currentTimeMillis() + (long)Config.PVP_NORMAL_TIME);
            }
            if (this.getPvpFlag() == 0) {
                this.startPvPFlag();
            }
        }
    }

    public boolean isLucky() {
        return this.getLevel() <= 9 && this.isAffectedBySkill(CommonSkill.LUCKY.getId());
    }

    public void restoreExp(double restorePercent) {
        if (this.getExpBeforeDeath() > 0L) {
            this.getStat().addExp(Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * restorePercent / 100.0));
            this.setExpBeforeDeath(0L);
        }
    }

    public void deathPenalty(boolean atwar, boolean killed_by_pc, boolean killed_by_siege_npc) {
        int lvl = this.getLevel();
        int clan_luck = this.getSkillLevel(CommonSkill.CLAN_LUCK.getId());
        double clan_luck_modificator = 1.0;
        if (!killed_by_pc) {
            switch (clan_luck) {
                case 3: {
                    clan_luck_modificator = 0.8;
                    break;
                }
                case 2: {
                    clan_luck_modificator = 0.8;
                    break;
                }
                case 1: {
                    clan_luck_modificator = 0.88;
                    break;
                }
                default: {
                    clan_luck_modificator = 1.0;
                    break;
                }
            }
        } else {
            switch (clan_luck) {
                case 3: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                case 2: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                case 1: {
                    clan_luck_modificator = 0.5;
                    break;
                }
                default: {
                    clan_luck_modificator = 1.0;
                }
            }
        }
        double percentLost = Config.PLAYER_XP_PERCENT_LOST[this.getLevel()] * clan_luck_modificator;
        if (this.getKarma() > 0) {
            percentLost *= (double)Config.RATE_KARMA_EXP_LOST;
        }
        if (this.isFestivalParticipant() || atwar) {
            percentLost /= 4.0;
        }
        long lostExp = 0L;
        if (!L2Event.isParticipant(this)) {
            lostExp = lvl < ExperienceTable.getInstance().getMaxLevel() ? Math.round((double)(this.getStat().getExpForLevel(lvl + 1) - this.getStat().getExpForLevel(lvl)) * percentLost / 100.0) : Math.round((double)(this.getStat().getExpForLevel(ExperienceTable.getInstance().getMaxLevel()) - this.getStat().getExpForLevel(ExperienceTable.getInstance().getMaxLevel() - 1)) * percentLost / 100.0);
        }
        this.setExpBeforeDeath(this.getExp());
        if (this.isInsideZone(ZoneId.PVP)) {
            if (this.isInsideZone(ZoneId.SIEGE)) {
                if (this.isInSiege() && (killed_by_pc || killed_by_siege_npc)) {
                    lostExp = 0L;
                }
            } else if (killed_by_pc) {
                lostExp = 0L;
            }
        }
        this.getStat().addExp(-lostExp);
    }

    public boolean isPartyWaiting() {
        return PartyMatchWaitingList.getInstance().getPlayers().contains(this);
    }

    public void setPartyRoom(int id) {
        this._partyroom = id;
    }

    public int getPartyRoom() {
        return this._partyroom;
    }

    public boolean isInPartyMatchRoom() {
        return this._partyroom > 0;
    }

    public void stopAllTimers() {
        this.stopHpMpRegeneration();
        this.stopWarnUserTakeBreak();
        this.stopWaterTask();
        this.stopFeed();
        this.clearPetData();
        this.storePetFood(this._mountNpcId);
        this.stopRentPet();
        this.stopPvpRegTask();
        this.stopSoulTask();
        this.stopChargeTask();
        this.stopFameTask();
        this.stopVitalityTask();
        this.stopRecoBonusTask();
        this.stopRecoGiveTask();
    }

    @Override
    public L2Summon getSummon() {
        return this._summon;
    }

    public L2Decoy getDecoy() {
        return this._decoy;
    }

    public L2TrapInstance getTrap() {
        return this._trap;
    }

    public void setPet(L2Summon summon) {
        this._summon = summon;
    }

    public void setDecoy(L2Decoy decoy) {
        this._decoy = decoy;
    }

    public void setTrap(L2TrapInstance trap) {
        this._trap = trap;
    }

    public List<L2TamedBeastInstance> getTrainedBeasts() {
        return this._tamedBeast;
    }

    public void addTrainedBeast(L2TamedBeastInstance tamedBeast) {
        if (this._tamedBeast == null) {
            this._tamedBeast = new FastList();
        }
        this._tamedBeast.add((Object)tamedBeast);
    }

    public L2Request getRequest() {
        return this._request;
    }

    public void setActiveRequester(L2PcInstance requester) {
        this._activeRequester = requester;
    }

    public L2PcInstance getActiveRequester() {
        L2PcInstance requester = this._activeRequester;
        if (requester != null && requester.isRequestExpired() && this._activeTradeList == null) {
            this._activeRequester = null;
        }
        return this._activeRequester;
    }

    public boolean isProcessingRequest() {
        return this.getActiveRequester() != null || this._requestExpireTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public boolean isProcessingTransaction() {
        return this.getActiveRequester() != null || this._activeTradeList != null || this._requestExpireTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    public void onTransactionRequest(L2PcInstance partner) {
        this._requestExpireTime = GameTimeController.getInstance().getGameTicks() + 150;
        partner.setActiveRequester(this);
    }

    public boolean isRequestExpired() {
        return this._requestExpireTime <= (long)GameTimeController.getInstance().getGameTicks();
    }

    public void onTransactionResponse() {
        this._requestExpireTime = 0L;
    }

    public void setActiveWarehouse(ItemContainer warehouse) {
        this._activeWarehouse = warehouse;
    }

    public ItemContainer getActiveWarehouse() {
        return this._activeWarehouse;
    }

    public void setActiveTradeList(TradeList tradeList) {
        this._activeTradeList = tradeList;
    }

    public TradeList getActiveTradeList() {
        return this._activeTradeList;
    }

    public void onTradeStart(L2PcInstance partner) {
        this._activeTradeList = new TradeList(this);
        this._activeTradeList.setPartner(partner);
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.BEGIN_TRADE_WITH_C1);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(new TradeStart(this));
    }

    public void onTradeConfirm(L2PcInstance partner) {
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CONFIRMED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
        this.sendPacket(TradeOtherDone.STATIC_PACKET);
    }

    public void onTradeCancel(L2PcInstance partner) {
        if (this._activeTradeList == null) {
            return;
        }
        this._activeTradeList.lock();
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(0));
        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.C1_CANCELED_TRADE);
        msg.addPcName(partner);
        this.sendPacket(msg);
    }

    public void onTradeFinish(boolean successfull) {
        this._activeTradeList = null;
        this.sendPacket(new TradeDone(1));
        if (successfull) {
            this.sendPacket(SystemMessageId.TRADE_SUCCESSFUL);
        }
    }

    public void startTrade(L2PcInstance partner) {
        this.onTradeStart(partner);
        partner.onTradeStart(this);
    }

    public void cancelActiveTrade() {
        if (this._activeTradeList == null) {
            return;
        }
        L2PcInstance partner = this._activeTradeList.getPartner();
        if (partner != null) {
            partner.onTradeCancel(this);
        }
        this.onTradeCancel(this);
    }

    public boolean hasManufactureShop() {
        return this._manufactureItems != null && !this._manufactureItems.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, L2ManufactureItem> getManufactureItems() {
        if (this._manufactureItems == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._manufactureItems == null) {
                    this._manufactureItems = Collections.synchronizedMap(new LinkedHashMap());
                }
            }
        }
        return this._manufactureItems;
    }

    public String getStoreName() {
        return this._storeName;
    }

    public void setStoreName(String name) {
        this._storeName = name == null ? "" : name;
    }

    public TradeList getSellList() {
        if (this._sellList == null) {
            this._sellList = new TradeList(this);
        }
        return this._sellList;
    }

    public TradeList getBuyList() {
        if (this._buyList == null) {
            this._buyList = new TradeList(this);
        }
        return this._buyList;
    }

    public void setPrivateStoreType(PrivateStoreType privateStoreType) {
        this._privateStoreType = privateStoreType;
        if (Config.OFFLINE_DISCONNECT_FINISHED && privateStoreType == PrivateStoreType.NONE && (this.getClient() == null || this.getClient().isDetached())) {
            this.deleteMe();
        }
    }

    public PrivateStoreType getPrivateStoreType() {
        return this._privateStoreType;
    }

    public void setClan(L2Clan clan) {
        this._clan = clan;
        this.setTitle("");
        if (clan == null) {
            this._clanId = 0;
            this._clanPrivileges = new EnumIntBitmask<ClanPrivilege>(ClanPrivilege.class, false);
            this._pledgeType = 0;
            this._powerGrade = 0;
            this._lvlJoinedAcademy = 0;
            this._apprentice = 0;
            this._sponsor = 0;
            this._activeWarehouse = null;
            if (this._isOnline) {
                CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 1));
            }
            return;
        }
        if (!clan.isMember(this.getObjectId())) {
            this.setClan(null);
            return;
        }
        this._clanId = clan.getId();
        if (this._isOnline) {
            CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 1));
        }
    }

    public L2Clan getClan() {
        return this._clan;
    }

    public boolean isClanLeader() {
        if (this.getClan() == null) {
            return false;
        }
        return this.getObjectId() == this.getClan().getLeaderId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void reduceArrowCount(boolean bolts) {
        L2ItemInstance arrows = this.getInventory().getPaperdollItem(7);
        if (arrows == null) {
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (arrows.getCount() > 1L) {
            L2ItemInstance l2ItemInstance = arrows;
            synchronized (l2ItemInstance) {
                arrows.changeCountWithoutTrace(-1, this, null);
                arrows.setLastChange(2);
                if (GameTimeController.getInstance().getGameTicks() % 10 == 0) {
                    arrows.updateDatabase();
                }
                this._inventory.refreshWeight();
            }
        } else {
            this._inventory.destroyItem("Consume", arrows, this, null);
            this.getInventory().unEquipItemInSlot(7);
            if (bolts) {
                this._boltItem = null;
            } else {
                this._arrowItem = null;
            }
            this.sendPacket(new ItemList(this, false));
            return;
        }
        if (!Config.FORCE_INVENTORY_UPDATE) {
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(arrows);
            this.sendPacket(iu);
        } else {
            this.sendPacket(new ItemList(this, false));
        }
    }

    @Override
    protected boolean checkAndEquipArrows() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._arrowItem = this.getInventory().findArrowForBow(this.getActiveWeaponItem());
            if (this._arrowItem != null) {
                this.getInventory().setPaperdollItem(7, this._arrowItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._arrowItem = this.getInventory().getPaperdollItem(7);
        }
        return this._arrowItem != null;
    }

    @Override
    protected boolean checkAndEquipBolts() {
        if (this.getInventory().getPaperdollItem(7) == null) {
            this._boltItem = this.getInventory().findBoltForCrossBow(this.getActiveWeaponItem());
            if (this._boltItem != null) {
                this.getInventory().setPaperdollItem(7, this._boltItem);
                ItemList il = new ItemList(this, false);
                this.sendPacket(il);
            }
        } else {
            this._boltItem = this.getInventory().getPaperdollItem(7);
        }
        return this._boltItem != null;
    }

    public boolean disarmWeapons() {
        L2ItemInstance wpn = this.getInventory().getPaperdollItem(5);
        if (wpn == null) {
            return true;
        }
        if (this.isCursedWeaponEquipped()) {
            return false;
        }
        if (this.isCombatFlagEquipped()) {
            return false;
        }
        if (wpn.getWeaponItem().isForceEquip()) {
            return false;
        }
        L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(wpn.getItem().getBodyPart());
        InventoryUpdate iu = new InventoryUpdate();
        for (L2ItemInstance itm : unequiped) {
            iu.addModifiedItem(itm);
        }
        this.sendPacket(iu);
        this.abortAttack();
        this.broadcastUserInfo();
        if (unequiped.length > 0) {
            SystemMessage sm;
            if (unequiped[0].getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(unequiped[0].getEnchantLevel());
                sm.addItemName(unequiped[0]);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(unequiped[0]);
            }
            this.sendPacket(sm);
        }
        return true;
    }

    public boolean disarmShield() {
        L2ItemInstance sld = this.getInventory().getPaperdollItem(7);
        if (sld != null) {
            L2ItemInstance[] unequiped = this.getInventory().unEquipItemInBodySlotAndRecord(sld.getItem().getBodyPart());
            InventoryUpdate iu = new InventoryUpdate();
            for (L2ItemInstance itm : unequiped) {
                iu.addModifiedItem(itm);
            }
            this.sendPacket(iu);
            this.abortAttack();
            this.broadcastUserInfo();
            if (unequiped.length > 0) {
                SystemMessage sm = null;
                if (unequiped[0].getEnchantLevel() > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                    sm.addInt(unequiped[0].getEnchantLevel());
                    sm.addItemName(unequiped[0]);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                    sm.addItemName(unequiped[0]);
                }
                this.sendPacket(sm);
            }
        }
        return true;
    }

    public boolean mount(L2Summon pet) {
        if (!this.disarmWeapons() || !this.disarmShield() || this.isTransformed()) {
            return false;
        }
        this.getEffectList().stopAllToggles();
        this.setMount(pet.getId(), pet.getLevel());
        this.setMountObjectID(pet.getControlObjectId());
        this.clearPetData();
        this.startFeed(pet.getId());
        this.broadcastPacket(new Ride(this));
        this.broadcastUserInfo();
        pet.unSummon(this);
        return true;
    }

    public boolean mount(int npcId, int controlItemObjId, boolean useFood) {
        if (!this.disarmWeapons() || !this.disarmShield() || this.isTransformed()) {
            return false;
        }
        this.getEffectList().stopAllToggles();
        this.setMount(npcId, this.getLevel());
        this.clearPetData();
        this.setMountObjectID(controlItemObjId);
        this.broadcastPacket(new Ride(this));
        this.broadcastUserInfo();
        if (useFood) {
            this.startFeed(npcId);
        }
        return true;
    }

    public boolean mountPlayer(L2Summon pet) {
        if (pet != null && pet.isMountable() && !this.isMounted() && !this.isBetrayed()) {
            if (this.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_DEAD);
                return false;
            }
            if (pet.isDead()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.DEAD_STRIDER_CANT_BE_RIDDEN);
                return false;
            }
            if (pet.isInCombat() || pet.isRooted()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_IN_BATLLE_CANT_BE_RIDDEN);
                return false;
            }
            if (this.isInCombat()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CANT_BE_RIDDEN_WHILE_IN_BATTLE);
                return false;
            }
            if (this.isSitting()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.STRIDER_CAN_BE_RIDDEN_ONLY_WHILE_STANDING);
                return false;
            }
            if (this.isFishing()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.CANNOT_DO_WHILE_FISHING_2);
                return false;
            }
            if (this.isTransformed() || this.isCursedWeaponEquipped()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.getInventory().getItemByItemId(9819) != null) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendMessage("You cannot mount a steed while holding a flag.");
                return false;
            }
            if (pet.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT);
                return false;
            }
            if (!Util.checkIfInRange(200, this, pet, true)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.TOO_FAR_AWAY_FROM_FENRIR_TO_MOUNT);
                return false;
            }
            if (!pet.isDead() && !this.isMounted()) {
                this.mount(pet);
            }
        } else if (this.isRentedPet()) {
            this.stopRentPet();
        } else if (this.isMounted()) {
            if (this.getMountType() == MountType.WYVERN && this.isInsideZone(ZoneId.NO_LANDING)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.NO_DISMOUNT_HERE);
                return false;
            }
            if (this.isHungry()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                this.sendPacket(SystemMessageId.HUNGRY_STRIDER_NOT_MOUNT);
                return false;
            }
            this.dismount();
        }
        return true;
    }

    public boolean dismount() {
        if (this.checkLandingState() && this.getMountType() == MountType.WYVERN && !Config.ALT_WYVERN_MAKEALANDING) {
            if (!this.isGM() && Config.ALT_DISMOUNT_WYVERN_IN_NOLANDING) {
                this.teleToLocation(TeleportWhereType.TOWN);
            } else {
                return false;
            }
        }
        boolean wasFlying = this.isFlying();
        this.sendPacket(new SetupGauge(3, 0, 0));
        int petId = this._mountNpcId;
        this.setMount(0, 0);
        this.stopFeed();
        this.clearPetData();
        if (wasFlying) {
            this.removeSkill(CommonSkill.WYVERN_BREATH.getSkill());
        }
        this.broadcastPacket(new Ride(this));
        this.setMountObjectID(0);
        this.storePetFood(petId);
        this.broadcastUserInfo();
        return true;
    }

    public void setUptime(long time) {
        this._uptime = time;
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._uptime;
    }

    @Override
    public boolean isInvul() {
        return super.isInvul() || this._teleportProtectEndTime > (long)GameTimeController.getInstance().getGameTicks();
    }

    @Override
    public boolean isInParty() {
        return this._party != null;
    }

    public void setParty(L2Party party) {
        this._party = party;
    }

    public void joinParty(L2Party party) {
        if (party != null) {
            this._party = party;
            party.addPartyMember(this);
        }
    }

    public void leaveParty() {
        if (this.isInParty()) {
            this._party.removePartyMember(this, L2Party.messageType.Disconnected);
            this._party = null;
        }
    }

    @Override
    public L2Party getParty() {
        return this._party;
    }

    @Override
    public boolean isGM() {
        return this.getAccessLevel().isGm();
    }

    public void setAccessLevel(int level) {
        this._accessLevel = AdminTable.getInstance().getAccessLevel(level);
        this.getAppearance().setNameColor(this._accessLevel.getNameColor());
        this.getAppearance().setTitleColor(this._accessLevel.getTitleColor());
        this.broadcastUserInfo();
        CharNameTable.getInstance().addName(this);
        if (!AdminTable.getInstance().hasAccessLevel(level)) {
            _log.warning("Tryed to set unregistered access level " + level + " for " + this.toString() + ". Setting access level without privileges!");
        } else if (level > 0) {
            _log.warning(this._accessLevel.getName() + " access level set for character " + this.getName() + "! Just a warning to be careful ;)");
        }
    }

    public void setAccountAccesslevel(int level) {
        LoginServerThread.getInstance().sendAccessLevel(this.getAccountName(), level);
    }

    public void setGmEnable(boolean value) {
        this._gmEnable = value;
    }

    public boolean getGmEnable() {
        return this._gmEnable;
    }

    @Override
    public L2AccessLevel getAccessLevel() {
        if (this._gmEnable) {
            return this.getL2AccessLevel();
        }
        return AdminTable.getInstance().getAccessLevel(0);
    }

    public L2AccessLevel getL2AccessLevel() {
        if (Config.EVERYBODY_HAS_ADMIN_RIGHTS) {
            return AdminTable.getInstance().getMasterAccessLevel();
        }
        if (this._accessLevel == null) {
            this.setAccessLevel(0);
        }
        return this._accessLevel;
    }

    public void updateAndBroadcastStatus(int broadcastType) {
        this.refreshOverloaded();
        this.refreshExpertisePenalty();
        if (broadcastType == 1) {
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
        }
        if (broadcastType == 2) {
            this.broadcastUserInfo();
        }
    }

    public void setKarmaFlag(int flag) {
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void broadcastKarma() {
        StatusUpdate su = new StatusUpdate(this);
        su.addAttribute(27, this.getKarma());
        this.sendPacket(su);
        Collection plrs = this.getKnownList().getKnownPlayers().values();
        for (L2PcInstance player : plrs) {
            player.sendPacket(new RelationChanged(this, this.getRelation(player), this.isAutoAttackable(player)));
            if (!this.hasSummon()) continue;
            player.sendPacket(new RelationChanged(this.getSummon(), this.getRelation(player), this.isAutoAttackable(player)));
        }
    }

    public void setOnlineStatus(boolean isOnline, boolean updateInDb) {
        if (this._isOnline != isOnline) {
            this._isOnline = isOnline;
        }
        if (updateInDb) {
            this.updateOnlineStatus();
        }
    }

    public void setIsIn7sDungeon(boolean isIn7sDungeon) {
        this._isIn7sDungeon = isIn7sDungeon;
    }

    public void updateOnlineStatus() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE characters SET online=?, lastAccess=? WHERE charId=?");){
            statement.setInt(1, this.isOnlineInt());
            statement.setLong(2, System.currentTimeMillis());
            statement.setInt(3, this.getObjectId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed updating character online status.", e);
        }
    }

    private boolean createDb() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(INSERT_CHARACTER);){
            statement.setString(1, this._accountName);
            statement.setInt(2, this.getObjectId());
            statement.setString(3, this.getName());
            statement.setInt(4, this.getLevel());
            statement.setInt(5, this.getMaxHp());
            statement.setDouble(6, this.getCurrentHp());
            statement.setInt(7, this.getMaxCp());
            statement.setDouble(8, this.getCurrentCp());
            statement.setInt(9, this.getMaxMp());
            statement.setDouble(10, this.getCurrentMp());
            statement.setInt(11, this.getAppearance().getFace());
            statement.setInt(12, this.getAppearance().getHairStyle());
            statement.setInt(13, this.getAppearance().getHairColor());
            statement.setInt(14, this.getAppearance().getSex() ? 1 : 0);
            statement.setLong(15, this.getExp());
            statement.setInt(16, this.getSp());
            statement.setInt(17, this.getKarma());
            statement.setInt(18, this.getFame());
            statement.setInt(19, this.getPvpKills());
            statement.setInt(20, this.getPkKills());
            statement.setInt(21, this.getClanId());
            statement.setInt(22, this.getRace().ordinal());
            statement.setInt(23, this.getClassId().getId());
            statement.setLong(24, this.getDeleteTimer());
            statement.setInt(25, this.hasDwarvenCraft() ? 1 : 0);
            statement.setString(26, this.getTitle());
            statement.setInt(27, this.getAppearance().getTitleColor());
            statement.setInt(28, this.getL2AccessLevel().getLevel());
            statement.setInt(29, this.isOnlineInt());
            statement.setInt(30, this.isIn7sDungeon() ? 1 : 0);
            statement.setInt(31, this.getClanPrivileges().getBitmask());
            statement.setInt(32, this.getWantsPeace());
            statement.setInt(33, this.getBaseClass());
            statement.setInt(34, this.getNewbie());
            statement.setInt(35, this.isNoble() ? 1 : 0);
            statement.setLong(36, 0L);
            statement.setDate(37, new Date(this.getCreateDate().getTimeInMillis()));
            statement.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not insert char data: " + e.getMessage(), e);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static L2PcInstance restore(int objectId) {
        L2PcInstance player = null;
        double currentCp = 0.0;
        double currentHp = 0.0;
        double currentMp = 0.0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_CHARACTER);){
            ResultSet rset;
            block92: {
                statement.setInt(1, objectId);
                rset = statement.executeQuery();
                Throwable throwable = null;
                try {
                    if (!rset.next()) break block92;
                    int activeClassId = rset.getInt("classid");
                    boolean female = rset.getInt("sex") != Sex.MALE.ordinal();
                    L2PcTemplate template = CharTemplateTable.getInstance().getTemplate(activeClassId);
                    PcAppearance app = new PcAppearance(rset.getByte("face"), rset.getByte("hairColor"), rset.getByte("hairStyle"), female);
                    player = new L2PcInstance(objectId, template, rset.getString("account_name"), app);
                    player.setName(rset.getString("char_name"));
                    player._lastAccess = rset.getLong("lastAccess");
                    player.getStat().setExp(rset.getLong("exp"));
                    player.setExpBeforeDeath(rset.getLong("expBeforeDeath"));
                    player.getStat().setLevel(rset.getByte("level"));
                    player.getStat().setSp(rset.getInt("sp"));
                    player.setWantsPeace(rset.getInt("wantspeace"));
                    player.setHeading(rset.getInt("heading"));
                    player.setKarma(rset.getInt("karma"));
                    player.setFame(rset.getInt("fame"));
                    player.setPvpKills(rset.getInt("pvpkills"));
                    player.setPkKills(rset.getInt("pkkills"));
                    player.setOnlineTime(rset.getLong("onlinetime"));
                    player.setNewbie(rset.getInt("newbie"));
                    player.setNoble(rset.getInt("nobless") == 1);
                    player.setClanJoinExpiryTime(rset.getLong("clan_join_expiry_time"));
                    if (player.getClanJoinExpiryTime() < System.currentTimeMillis()) {
                        player.setClanJoinExpiryTime(0L);
                    }
                    player.setClanCreateExpiryTime(rset.getLong("clan_create_expiry_time"));
                    if (player.getClanCreateExpiryTime() < System.currentTimeMillis()) {
                        player.setClanCreateExpiryTime(0L);
                    }
                    int clanId = rset.getInt("clanid");
                    player.setPowerGrade(rset.getInt("power_grade"));
                    player.setPledgeType(rset.getInt("subpledge"));
                    if (clanId > 0) {
                        player.setClan(ClanTable.getInstance().getClan(clanId));
                    }
                    if (player.getClan() != null) {
                        if (player.getClan().getLeaderId() != player.getObjectId()) {
                            if (player.getPowerGrade() == 0) {
                                player.setPowerGrade(5);
                            }
                            player.setClanPrivileges(player.getClan().getRankPrivs(player.getPowerGrade()));
                        } else {
                            player.getClanPrivileges().setAll();
                            player.setPowerGrade(1);
                        }
                        player.setPledgeClass(L2ClanMember.calculatePledgeClass(player));
                    } else {
                        if (player.isNoble()) {
                            player.setPledgeClass(5);
                        }
                        if (player.isHero()) {
                            player.setPledgeClass(8);
                        }
                        player.getClanPrivileges().clear();
                    }
                    player.setDeleteTimer(rset.getLong("deletetime"));
                    player.setTitle(rset.getString("title"));
                    player.setAccessLevel(rset.getInt("accesslevel"));
                    int titleColor = rset.getInt("title_color");
                    if (titleColor != 15530402) {
                        player.getAppearance().setTitleColor(titleColor);
                    }
                    player.setFistsWeaponItem(player.findFistsWeaponItem(activeClassId));
                    player.setUptime(System.currentTimeMillis());
                    currentHp = rset.getDouble("curHp");
                    currentCp = rset.getDouble("curCp");
                    currentMp = rset.getDouble("curMp");
                    player.setHero(rset.getInt("hero") == 1);
                    player._classIndex = 0;
                    try {
                        player.setBaseClass(rset.getInt("base_class"));
                    }
                    catch (Exception e) {
                        player.setBaseClass(activeClassId);
                    }
                    if (L2PcInstance.restoreSubClassData(player) && activeClassId != player.getBaseClass()) {
                        for (SubClass subClass : player.getSubClasses().values()) {
                            if (subClass.getClassId() != activeClassId) continue;
                            player._classIndex = subClass.getClassIndex();
                        }
                    }
                    if (player.getClassIndex() == 0 && activeClassId != player.getBaseClass()) {
                        player.setClassId(player.getBaseClass());
                        _log.warning("Player " + player.getName() + " reverted to base class. Possibly has tried a relogin exploit while subclassing.");
                    } else {
                        player._activeClass = activeClassId;
                    }
                    player.setApprentice(rset.getInt("apprentice"));
                    player.setSponsor(rset.getInt("sponsor"));
                    player.setLvlJoinedAcademy(rset.getInt("lvl_joined_academy"));
                    player.setIsIn7sDungeon(rset.getInt("isin7sdungeon") == 1);
                    CursedWeaponsManager.getInstance().checkPlayer(player);
                    player.setDeathPenaltyBuffLevel(rset.getInt("death_penalty_level"));
                    player.setVitalityPoints(rset.getInt("vitality_points"), true);
                    player.setXYZInvisible(rset.getInt("x"), rset.getInt("y"), rset.getInt("z"));
                    player.setBookMarkSlot(rset.getInt("BookmarkSlot"));
                    player.getCreateDate().setTime(rset.getDate("createDate"));
                    player.setLang(rset.getString("language"));
                    try (PreparedStatement stmt = con.prepareStatement("SELECT charId, char_name FROM characters WHERE account_name=? AND charId<>?");){
                        stmt.setString(1, player._accountName);
                        stmt.setInt(2, objectId);
                        try (ResultSet chars = stmt.executeQuery();){
                            while (chars.next()) {
                                player._chars.put((Object)chars.getInt("charId"), (Object)chars.getString("char_name"));
                            }
                        }
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rset != null) {
                        if (throwable != null) {
                            try {
                                rset.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rset.close();
                        }
                    }
                }
            }
            if (player == null) {
                rset = null;
                return rset;
            }
            if (Hero.getInstance().isHero(objectId)) {
                player.setHero(true);
            }
            player.getInventory().restore();
            player.getFreight().restore();
            if (!Config.WAREHOUSE_CACHE) {
                player.getWarehouse();
            }
            player.restoreCharData();
            player.rewardSkills();
            player.restoreItemReuse();
            player.setCurrentCp(currentCp);
            player.setCurrentHp(currentHp);
            player.setCurrentMp(currentMp);
            if (currentHp < 0.5) {
                player.setIsDead(true);
                player.stopHpMpRegeneration();
            }
            player.setPet(L2World.getInstance().getPet(player.getObjectId()));
            if (player.hasSummon()) {
                player.getSummon().setOwner(player);
            }
            player.refreshOverloaded();
            player.refreshExpertisePenalty();
            player.restoreFriendList();
            if (Config.STORE_UI_SETTINGS) {
                player.restoreUISettings();
            }
            if (!player.isGM()) return player;
            long masks = player.getVariables().getLong(COND_OVERRIDE_KEY, PcCondOverride.getAllExceptionsMask());
            player.setOverrideCond(masks);
            return player;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed loading character.", e);
        }
        return player;
    }

    public Forum getMail() {
        throw new RuntimeException();
    }

    public void setMail(Forum forum) {
        throw new RuntimeException();
    }

    public Forum getMemo() {
        throw new RuntimeException();
    }

    public void setMemo(Forum forum) {
        throw new RuntimeException();
    }

    private static boolean restoreSubClassData(L2PcInstance player) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_CHAR_SUBCLASSES);){
            statement.setInt(1, player.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    SubClass subClass = new SubClass();
                    subClass.setClassId(rset.getInt("class_id"));
                    subClass.setLevel(rset.getByte("level"));
                    subClass.setExp(rset.getLong("exp"));
                    subClass.setSp(rset.getInt("sp"));
                    subClass.setClassIndex(rset.getInt("class_index"));
                    player.getSubClasses().put(subClass.getClassIndex(), subClass);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore classes for " + player.getName() + ": " + e.getMessage(), e);
        }
        return true;
    }

    private void restoreCharData() {
        this.restoreSkills();
        this._macros.restoreMe();
        this._shortCuts.restoreMe();
        this.restoreHenna();
        this.restoreTeleportBookmark();
        this.restoreRecipeBook(true);
        if (Config.STORE_RECIPE_SHOPLIST) {
            this.restoreRecipeShopList();
        }
        this.loadPremiumItemList();
        this.restorePetInventoryItems();
    }

    private void restoreRecipeBook(boolean loadCommon) {
        String sql = loadCommon ? "SELECT id, type, classIndex FROM character_recipebook WHERE charId=?" : "SELECT id FROM character_recipebook WHERE charId=? AND classIndex=? AND type = 1";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(sql);){
            statement.setInt(1, this.getObjectId());
            if (!loadCommon) {
                statement.setInt(2, this._classIndex);
            }
            try (ResultSet rset = statement.executeQuery();){
                this._dwarvenRecipeBook.clear();
                RecipeData rd = RecipeData.getInstance();
                while (rset.next()) {
                    L2RecipeList recipe = rd.getRecipeList(rset.getInt("id"));
                    if (loadCommon) {
                        if (rset.getInt(2) == 1) {
                            if (rset.getInt(3) != this._classIndex) continue;
                            this.registerDwarvenRecipeList(recipe, false);
                            continue;
                        }
                        this.registerCommonRecipeList(recipe, false);
                        continue;
                    }
                    this.registerDwarvenRecipeList(recipe, false);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore recipe book data:" + e.getMessage(), e);
        }
    }

    public Map<Integer, L2PremiumItem> getPremiumItemList() {
        return this._premiumItems;
    }

    private void loadPremiumItemList() {
        String sql = "SELECT itemNum, itemId, itemCount, itemSender FROM character_premium_items WHERE charId=?";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT itemNum, itemId, itemCount, itemSender FROM character_premium_items WHERE charId=?");){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int itemNum = rset.getInt("itemNum");
                    int itemId = rset.getInt("itemId");
                    long itemCount = rset.getLong("itemCount");
                    String itemSender = rset.getString("itemSender");
                    this._premiumItems.put((Object)itemNum, (Object)new L2PremiumItem(itemId, itemCount, itemSender));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore premium items: " + e.getMessage(), e);
        }
    }

    public void updatePremiumItem(int itemNum, long newcount) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE character_premium_items SET itemCount=? WHERE charId=? AND itemNum=? ");){
            statement.setLong(1, newcount);
            statement.setInt(2, this.getObjectId());
            statement.setInt(3, itemNum);
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update premium items: " + e.getMessage(), e);
        }
    }

    public void deletePremiumItem(int itemNum) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("DELETE FROM character_premium_items WHERE charId=? AND itemNum=? ");){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, itemNum);
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not delete premium item: " + e);
        }
    }

    public synchronized void store(boolean storeActiveEffects) {
        AccountVariables aVars;
        this.storeCharBase();
        this.storeCharSub();
        this.storeEffect(storeActiveEffects);
        this.storeItemReuseDelay();
        if (Config.STORE_RECIPE_SHOPLIST) {
            this.storeRecipeShopList();
        }
        if (Config.STORE_UI_SETTINGS) {
            this.storeUISettings();
        }
        SevenSigns.getInstance().saveSevenSignsData(this.getObjectId());
        PlayerVariables vars = this.getScript(PlayerVariables.class);
        if (vars != null) {
            vars.storeMe();
        }
        if ((aVars = this.getScript(AccountVariables.class)) != null) {
            aVars.storeMe();
        }
    }

    @Override
    public void storeMe() {
        this.store(true);
    }

    private void storeCharBase() {
        long exp = this.getStat().getBaseExp();
        byte level = this.getStat().getBaseLevel();
        int sp = this.getStat().getBaseSp();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(UPDATE_CHARACTER);){
            statement.setInt(1, level);
            statement.setInt(2, this.getMaxHp());
            statement.setDouble(3, this.getCurrentHp());
            statement.setInt(4, this.getMaxCp());
            statement.setDouble(5, this.getCurrentCp());
            statement.setInt(6, this.getMaxMp());
            statement.setDouble(7, this.getCurrentMp());
            statement.setInt(8, this.getAppearance().getFace());
            statement.setInt(9, this.getAppearance().getHairStyle());
            statement.setInt(10, this.getAppearance().getHairColor());
            statement.setInt(11, this.getAppearance().getSex() ? 1 : 0);
            statement.setInt(12, this.getHeading());
            statement.setInt(13, this._observerMode ? this._lastLoc.getX() : this.getX());
            statement.setInt(14, this._observerMode ? this._lastLoc.getY() : this.getY());
            statement.setInt(15, this._observerMode ? this._lastLoc.getZ() : this.getZ());
            statement.setLong(16, exp);
            statement.setLong(17, this.getExpBeforeDeath());
            statement.setInt(18, sp);
            statement.setInt(19, this.getKarma());
            statement.setInt(20, this.getFame());
            statement.setInt(21, this.getPvpKills());
            statement.setInt(22, this.getPkKills());
            statement.setInt(23, this.getClanId());
            statement.setInt(24, this.getRace().ordinal());
            statement.setInt(25, this.getClassId().getId());
            statement.setLong(26, this.getDeleteTimer());
            statement.setString(27, this.getTitle());
            statement.setInt(28, this.getAppearance().getTitleColor());
            statement.setInt(29, this.getL2AccessLevel().getLevel());
            statement.setInt(30, this.isOnlineInt());
            statement.setInt(31, this.isIn7sDungeon() ? 1 : 0);
            statement.setInt(32, this.getClanPrivileges().getBitmask());
            statement.setInt(33, this.getWantsPeace());
            statement.setInt(34, this.getBaseClass());
            long totalOnlineTime = this._onlineTime;
            if (this._onlineBeginTime > 0L) {
                totalOnlineTime += (System.currentTimeMillis() - this._onlineBeginTime) / 1000L;
            }
            statement.setLong(35, totalOnlineTime);
            statement.setInt(36, this.getNewbie());
            statement.setInt(37, this.isNoble() ? 1 : 0);
            statement.setInt(38, this.getPowerGrade());
            statement.setInt(39, this.getPledgeType());
            statement.setInt(40, this.getLvlJoinedAcademy());
            statement.setLong(41, this.getApprentice());
            statement.setLong(42, this.getSponsor());
            statement.setLong(43, this.getClanJoinExpiryTime());
            statement.setLong(44, this.getClanCreateExpiryTime());
            statement.setString(45, this.getName());
            statement.setLong(46, this.getDeathPenaltyBuffLevel());
            statement.setInt(47, this.getBookMarkSlot());
            statement.setInt(48, this.getVitalityPoints());
            statement.setString(49, this.getLang());
            statement.setInt(50, this.isHero() ? 1 : 0);
            statement.setInt(51, this.getObjectId());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store char base data: " + this + " - " + e.getMessage(), e);
        }
    }

    private void storeCharSub() {
        if (this.getTotalSubClasses() <= 0) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(UPDATE_CHAR_SUBCLASS);){
            for (SubClass subClass : this.getSubClasses().values()) {
                statement.setLong(1, subClass.getExp());
                statement.setInt(2, subClass.getSp());
                statement.setInt(3, subClass.getLevel());
                statement.setInt(4, subClass.getClassId());
                statement.setInt(5, this.getObjectId());
                statement.setInt(6, subClass.getClassIndex());
                statement.execute();
                statement.clearParameters();
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store sub class data for " + this.getName() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public void storeEffect(boolean storeEffects) {
        if (!Config.STORE_SKILL_COOLTIME) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement delete = con.prepareStatement(DELETE_SKILL_SAVE);
             PreparedStatement statement = con.prepareStatement(ADD_SKILL_SAVE);){
            FastIntObjectMap<TimeStamp> reuseTimeStamps;
            delete.setInt(1, this.getObjectId());
            delete.setInt(2, this.getClassIndex());
            delete.execute();
            int buff_index = 0;
            ArrayList<Integer> storedSkills = new ArrayList<Integer>();
            if (storeEffects) {
                for (BuffInfo info : this.getEffectList().getEffects()) {
                    Skill skill;
                    if (info == null || (skill = info.getSkill()).getAbnormalType() == AbnormalType.LIFE_FORCE_OTHERS || skill.isToggle() || skill.isDance() && !Config.ALT_STORE_DANCES || storedSkills.contains(skill.getReuseHashCode())) continue;
                    storedSkills.add(skill.getReuseHashCode());
                    statement.setInt(1, this.getObjectId());
                    statement.setInt(2, skill.getId());
                    statement.setInt(3, skill.getLevel());
                    statement.setInt(4, info.getTime());
                    TimeStamp t = this.getSkillReuseTimeStamp(skill.getReuseHashCode());
                    if (t != null && t.hasNotPassed()) {
                        statement.setLong(5, t.getReuse());
                        statement.setDouble(6, t.getStamp());
                    } else {
                        statement.setLong(5, 0L);
                        statement.setDouble(6, 0.0);
                    }
                    statement.setInt(7, 0);
                    statement.setInt(8, this.getClassIndex());
                    statement.setInt(9, ++buff_index);
                    statement.execute();
                }
            }
            if ((reuseTimeStamps = this.getSkillReuseTimeStamps()) != null) {
                for (IntObjectMap.Entry ts : reuseTimeStamps.entrySet()) {
                    TimeStamp t;
                    int hash = ts.getKey();
                    if (storedSkills.contains(hash) || (t = (TimeStamp)ts.getValue()) == null || !t.hasNotPassed()) continue;
                    storedSkills.add(hash);
                    statement.setInt(1, this.getObjectId());
                    statement.setInt(2, t.getSkillId());
                    statement.setInt(3, t.getSkillLvl());
                    statement.setInt(4, -1);
                    statement.setLong(5, t.getReuse());
                    statement.setDouble(6, t.getStamp());
                    statement.setInt(7, 1);
                    statement.setInt(8, this.getClassIndex());
                    statement.setInt(9, ++buff_index);
                    statement.execute();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store char effect data: ", e);
        }
    }

    private void storeItemReuseDelay() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps1 = con.prepareStatement(DELETE_ITEM_REUSE_SAVE);
             PreparedStatement ps2 = con.prepareStatement(ADD_ITEM_REUSE_SAVE);){
            ps1.setInt(1, this.getObjectId());
            ps1.execute();
            FastIntObjectMap<TimeStamp> itemReuseTimeStamps = this.getItemReuseTimeStamps();
            if (itemReuseTimeStamps != null) {
                for (TimeStamp ts : itemReuseTimeStamps.values()) {
                    if (ts == null || !ts.hasNotPassed()) continue;
                    ps2.setInt(1, this.getObjectId());
                    ps2.setInt(2, ts.getItemId());
                    ps2.setInt(3, ts.getItemObjectId());
                    ps2.setLong(4, ts.getReuse());
                    ps2.setDouble(5, ts.getStamp());
                    ps2.execute();
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not store char item reuse data: ", e);
        }
    }

    public boolean isOnline() {
        return this._isOnline;
    }

    public int isOnlineInt() {
        if (this._isOnline && this.getClient() != null) {
            return this.getClient().isDetached() ? 2 : 1;
        }
        return 0;
    }

    public boolean isIn7sDungeon() {
        return this._isIn7sDungeon;
    }

    @Override
    public Skill addSkill(Skill newSkill) {
        this.addCustomSkill(newSkill);
        return super.addSkill(newSkill);
    }

    public Skill addSkill(Skill newSkill, boolean store) {
        Skill oldSkill = this.addSkill(newSkill);
        if (store) {
            this.storeSkill(newSkill, oldSkill, -1);
        }
        return oldSkill;
    }

    @Override
    public Skill removeSkill(Skill skill, boolean store) {
        this.removeCustomSkill(skill);
        return store ? this.removeSkill(skill) : super.removeSkill(skill, true);
    }

    public Skill removeSkill(Skill skill, boolean store, boolean cancelEffect) {
        this.removeCustomSkill(skill);
        return store ? this.removeSkill(skill) : super.removeSkill(skill, cancelEffect);
    }

    public Skill removeSkill(Skill skill) {
        this.removeCustomSkill(skill);
        Skill oldSkill = super.removeSkill(skill, true);
        if (oldSkill != null) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(DELETE_SKILL_FROM_CHAR);){
                statement.setInt(1, oldSkill.getId());
                statement.setInt(2, this.getObjectId());
                statement.setInt(3, this.getClassIndex());
                statement.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error could not delete skill: " + e.getMessage(), e);
            }
        }
        if (this.getTransformationId() > 0 || this.isCursedWeaponEquipped()) {
            return oldSkill;
        }
        if (skill != null) {
            for (Shortcut sc : this.getAllShortCuts()) {
                if (sc == null || sc.getId() != skill.getId() || sc.getType() != ShortcutType.SKILL || skill.getId() >= 3080 && skill.getId() <= 3259) continue;
                this.deleteShortCut(sc.getSlot(), sc.getPage());
            }
        }
        return oldSkill;
    }

    private void storeSkill(Skill newSkill, Skill oldSkill, int newClassIndex) {
        block41: {
            int classIndex = this._classIndex;
            if (newClassIndex > -1) {
                classIndex = newClassIndex;
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                PreparedStatement ps;
                if (oldSkill != null && newSkill != null) {
                    ps = con.prepareStatement(UPDATE_CHARACTER_SKILL_LEVEL);
                    Throwable throwable = null;
                    try {
                        ps.setInt(1, newSkill.getLevel());
                        ps.setInt(2, oldSkill.getId());
                        ps.setInt(3, this.getObjectId());
                        ps.setInt(4, classIndex);
                        ps.execute();
                        break block41;
                    }
                    catch (Throwable x2) {
                        throwable = x2;
                        throw x2;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                if (newSkill != null) {
                    ps = con.prepareStatement(ADD_NEW_SKILL);
                    Throwable throwable = null;
                    try {
                        ps.setInt(1, this.getObjectId());
                        ps.setInt(2, newSkill.getId());
                        ps.setInt(3, newSkill.getLevel());
                        ps.setInt(4, classIndex);
                        ps.execute();
                        break block41;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (ps != null) {
                            if (throwable != null) {
                                try {
                                    ps.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                ps.close();
                            }
                        }
                    }
                }
                _log.warning("Could not store new skill, it's null!");
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Error could not store char skills: " + e.getMessage(), e);
            }
        }
    }

    private void restoreSkills() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_SKILLS_FOR_CHAR);){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int id = rset.getInt("skill_id");
                    int level = rset.getInt("skill_level");
                    Skill skill = SkillData.getInstance().getSkill(id, level);
                    if (skill == null) {
                        _log.warning("Skipped null skill Id: " + id + " Level: " + level + " while restoring player skills for playerObjId: " + this.getObjectId());
                        continue;
                    }
                    this.addSkill(skill);
                    if (!Config.SKILL_CHECK_ENABLE || this.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && !Config.SKILL_CHECK_GM || SkillTreesData.getInstance().isSkillAllowed(this, skill)) continue;
                    Util.handleIllegalPlayerAction(this, "Player " + this.getName() + " has invalid skill " + skill.getName() + " (" + skill.getId() + "/" + skill.getLevel() + "), class:" + ClassListData.getInstance().getClass(this.getClassId()).getClassName(), IllegalActionPunishmentType.BROADCAST);
                    if (!Config.SKILL_CHECK_REMOVE) continue;
                    this.removeSkill(skill);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore character " + this + " skills: " + e.getMessage(), e);
        }
    }

    @Override
    public void restoreEffects() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_SKILL_SAVE);){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int remainingTime = rset.getInt("remaining_time");
                    long reuseDelay = rset.getLong("reuse_delay");
                    long systime = rset.getLong("systime");
                    int restoreType = rset.getInt("restore_type");
                    Skill skill = SkillData.getInstance().getSkill(rset.getInt("skill_id"), rset.getInt("skill_level"));
                    if (skill == null) continue;
                    long time = systime - System.currentTimeMillis();
                    if (time > 10L) {
                        this.disableSkill(skill, time);
                        this.addTimeStamp(skill, reuseDelay, systime);
                    }
                    if (restoreType > 0) continue;
                    skill.applyEffects(this, this, false, remainingTime);
                }
            }
            var6_11 = null;
            try (PreparedStatement delete = con.prepareStatement(DELETE_SKILL_SAVE);){
                delete.setInt(1, this.getObjectId());
                delete.setInt(2, this.getClassIndex());
                delete.executeUpdate();
            }
            catch (Throwable throwable) {
                var6_11 = throwable;
                throw throwable;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore " + this + " active effect data: " + e.getMessage(), e);
        }
    }

    private void restoreItemReuse() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_ITEM_REUSE_SAVE);
             PreparedStatement delete = con.prepareStatement(DELETE_ITEM_REUSE_SAVE);){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int group;
                    long remainingTime;
                    int itemId = rset.getInt("itemId");
                    int itemObjId = rset.getInt("itemObjId");
                    long reuseDelay = rset.getLong("reuseDelay");
                    long systime = rset.getLong("systime");
                    boolean isInInventory = true;
                    L2ItemInstance item = this.getInventory().getItemByItemId(itemId);
                    if (item == null) {
                        item = this.getWarehouse().getItemByItemId(itemId);
                        isInInventory = false;
                    }
                    if (item == null || item.getId() != itemId || item.getReuseDelay() <= 0 || (remainingTime = systime - System.currentTimeMillis()) <= 10L) continue;
                    this.addTimeStampItem(item, reuseDelay, systime);
                    if (!isInInventory || !item.isEtcItem() || (group = item.getSharedReuseGroup()) <= 0) continue;
                    this.sendPacket(new ExUseSharedGroupItem(itemId, group, (int)remainingTime, (int)reuseDelay));
                }
            }
            delete.setInt(1, this.getObjectId());
            delete.executeUpdate();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not restore " + this + " Item Reuse data: " + e.getMessage(), e);
        }
    }

    private void restoreHenna() {
        for (int i = 0; i < 3; ++i) {
            this._henna[i] = null;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_CHAR_HENNAS);){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getClassIndex());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int symbolId;
                    int slot = rset.getInt("slot");
                    if (slot < 1 || slot > 3 || (symbolId = rset.getInt("symbol_id")) == 0) continue;
                    this._henna[slot - 1] = HennaData.getInstance().getHenna(symbolId);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed restoing character " + this + " hennas.", e);
        }
        this.recalcHennaStats();
    }

    public int getHennaEmptySlots() {
        int totalSlots = 0;
        totalSlots = this.getClassId().level() == 1 ? 2 : 3;
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] == null) continue;
            --totalSlots;
        }
        if (totalSlots <= 0) {
            return 0;
        }
        return totalSlots;
    }

    public boolean removeHenna(int slot) {
        L2Henna henna;
        if (!this.fireHennaListeners(this.getHenna(slot + 1), false)) {
            return false;
        }
        if (slot < 1 || slot > 3) {
            return false;
        }
        if ((henna = this._henna[--slot]) == null) {
            return false;
        }
        this._henna[slot] = null;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(DELETE_CHAR_HENNA);){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, slot + 1);
            statement.setInt(3, this.getClassIndex());
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed remocing character henna.", e);
        }
        this.recalcHennaStats();
        this.sendPacket(new HennaInfo(this));
        this.sendPacket(new UserInfo(this));
        this.sendPacket(new ExBrExtraUserInfo(this));
        this.getInventory().addItem("Henna", henna.getDyeItemId(), henna.getCancelCount(), this, null);
        this.reduceAdena("Henna", henna.getCancelFee(), this, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
        sm.addItemName(henna.getDyeItemId());
        sm.addItemNumber(henna.getCancelCount());
        this.sendPacket(sm);
        this.sendPacket(SystemMessageId.SYMBOL_DELETED);
        return true;
    }

    public boolean addHenna(L2Henna henna) {
        if (!this.fireHennaListeners(henna, true)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            if (this._henna[i] != null) continue;
            this._henna[i] = henna;
            this.recalcHennaStats();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(ADD_CHAR_HENNA);){
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, henna.getDyeId());
                statement.setInt(3, i + 1);
                statement.setInt(4, this.getClassIndex());
                statement.execute();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed saving character henna.", e);
            }
            this.sendPacket(new HennaInfo(this));
            this.sendPacket(new UserInfo(this));
            this.sendPacket(new ExBrExtraUserInfo(this));
            return true;
        }
        return false;
    }

    private void recalcHennaStats() {
        this._hennaINT = 0;
        this._hennaSTR = 0;
        this._hennaCON = 0;
        this._hennaMEN = 0;
        this._hennaWIT = 0;
        this._hennaDEX = 0;
        for (L2Henna h : this._henna) {
            if (h == null) continue;
            this._hennaINT += this._hennaINT + h.getStatINT() > 5 ? 5 - this._hennaINT : h.getStatINT();
            this._hennaSTR += this._hennaSTR + h.getStatSTR() > 5 ? 5 - this._hennaSTR : h.getStatSTR();
            this._hennaMEN += this._hennaMEN + h.getStatMEN() > 5 ? 5 - this._hennaMEN : h.getStatMEN();
            this._hennaCON += this._hennaCON + h.getStatCON() > 5 ? 5 - this._hennaCON : h.getStatCON();
            this._hennaWIT += this._hennaWIT + h.getStatWIT() > 5 ? 5 - this._hennaWIT : h.getStatWIT();
            this._hennaDEX += this._hennaDEX + h.getStatDEX() > 5 ? 5 - this._hennaDEX : h.getStatDEX();
        }
    }

    public L2Henna getHenna(int slot) {
        if (slot < 1 || slot > 3) {
            return null;
        }
        return this._henna[slot - 1];
    }

    public boolean hasHennas() {
        for (L2Henna henna : this._henna) {
            if (henna == null) continue;
            return true;
        }
        return false;
    }

    public L2Henna[] getHennaList() {
        return this._henna;
    }

    public int getHennaStatINT() {
        return this._hennaINT;
    }

    public int getHennaStatSTR() {
        return this._hennaSTR;
    }

    public int getHennaStatCON() {
        return this._hennaCON;
    }

    public int getHennaStatMEN() {
        return this._hennaMEN;
    }

    public int getHennaStatWIT() {
        return this._hennaWIT;
    }

    public int getHennaStatDEX() {
        return this._hennaDEX;
    }

    @Override
    public boolean isAutoAttackable(L2Character attacker) {
        if (attacker == null) {
            return false;
        }
        if (attacker == this || attacker == this.getSummon()) {
            return false;
        }
        if (attacker instanceof L2FriendlyMobInstance) {
            return false;
        }
        if (attacker.isMonster()) {
            return true;
        }
        if (attacker.isPlayer() && this.getDuelState() == 1 && this.getDuelId() == ((L2PcInstance)attacker).getDuelId()) {
            return true;
        }
        if (this.isInParty() && this.getParty().getMembers().contains(attacker)) {
            return false;
        }
        if (attacker.isPlayer() && attacker.getActingPlayer().isInOlympiadMode()) {
            return this.isInOlympiadMode() && this.isOlympiadStart() && ((L2PcInstance)attacker).getOlympiadGameId() == this.getOlympiadGameId();
        }
        if (this.isOnEvent()) {
            return true;
        }
        if (attacker.isPlayable()) {
            if (this.isInsideZone(ZoneId.PEACE)) {
                return false;
            }
            L2PcInstance attackerPlayer = attacker.getActingPlayer();
            if (this.getClan() != null) {
                Siege siege = SiegeManager.getInstance().getSiege(this.getX(), this.getY(), this.getZ());
                if (siege != null) {
                    if (siege.checkIsDefender(attackerPlayer.getClan()) && siege.checkIsDefender(this.getClan())) {
                        return false;
                    }
                    if (siege.checkIsAttacker(attackerPlayer.getClan()) && siege.checkIsAttacker(this.getClan())) {
                        return false;
                    }
                }
                if (this.getClan() != null && attackerPlayer.getClan() != null && this.getClan().isAtWarWith(attackerPlayer.getClanId()) && attackerPlayer.getClan().isAtWarWith(this.getClanId()) && this.getWantsPeace() == 0 && attackerPlayer.getWantsPeace() == 0 && !this.isAcademyMember()) {
                    return true;
                }
            }
            if (this.isInsideZone(ZoneId.PVP) && attackerPlayer.isInsideZone(ZoneId.PVP) && (!this.isInsideZone(ZoneId.SIEGE) || !attackerPlayer.isInsideZone(ZoneId.SIEGE))) {
                return true;
            }
            if (this.getClan() != null && this.getClan().isMember(attacker.getObjectId())) {
                return false;
            }
            if (attacker.isPlayer() && this.getAllyId() != 0 && this.getAllyId() == attackerPlayer.getAllyId()) {
                return false;
            }
            if (this.isInsideZone(ZoneId.PVP) && attackerPlayer.isInsideZone(ZoneId.PVP) && this.isInsideZone(ZoneId.SIEGE) && attackerPlayer.isInsideZone(ZoneId.SIEGE)) {
                return true;
            }
        } else if (attacker instanceof L2DefenderInstance && this.getClan() != null) {
            Siege siege = SiegeManager.getInstance().getSiege(this);
            return siege != null && siege.checkIsAttacker(this.getClan());
        }
        return this.getKarma() > 0 || this.getPvpFlag() > 0;
    }

    @Override
    public boolean useMagic(Skill skill, boolean forceUse, boolean dontMove) {
        if (skill.isPassive()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isCastingNow()) {
            SkillUseHolder currentSkill = this.getCurrentSkill();
            if (currentSkill != null && skill.getId() == currentSkill.getSkillId()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isSkillDisabled(skill)) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            this.setQueuedSkill(skill, forceUse, dontMove);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        this.setIsCastingNow(true);
        this.setCurrentSkill(skill, forceUse, dontMove);
        if (this.getQueuedSkill() != null) {
            this.setQueuedSkill(null, false, false);
        }
        if (!this.checkUseMagicConditions(skill, forceUse, dontMove)) {
            this.setIsCastingNow(false);
            return false;
        }
        L2Object target = null;
        switch (skill.getTargetType()) {
            case AURA: 
            case FRONT_AURA: 
            case BEHIND_AURA: 
            case GROUND: 
            case SELF: 
            case AURA_CORPSE_MOB: 
            case COMMAND_CHANNEL: {
                target = this;
                break;
            }
            default: {
                target = skill.getFirstOfTargetList(this);
            }
        }
        this.getAI().setIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        return true;
    }

    private boolean checkUseMagicConditions(Skill skill, boolean forceUse, boolean dontMove) {
        SystemMessage sm;
        L2PcInstance cha;
        Fort doorFort;
        L2DoorInstance door;
        Castle doorCastle;
        if (this.isOutOfControl() || this.isParalyzed() || this.isStunned() || this.isSleeping()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFishing() && !skill.hasEffectType(L2EffectType.FISHING, L2EffectType.FISHING_START)) {
            this.sendPacket(SystemMessageId.ONLY_FISHING_SKILLS_NOW);
            return false;
        }
        if (this.inObserverMode()) {
            this.sendPacket(SystemMessageId.OBSERVERS_CANNOT_PARTICIPATE);
            this.abortCast();
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isSitting()) {
            this.sendPacket(SystemMessageId.CANT_MOVE_SITTING);
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isToggle() && this.isAffectedBySkill(skill.getId())) {
            this.stopSkillEffects(true, skill.getId());
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isFakeDeath()) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        L2Object target = null;
        L2TargetType sklTargetType = skill.getTargetType();
        Location worldPosition = this.getCurrentSkillWorldPosition();
        if (sklTargetType == L2TargetType.GROUND && worldPosition == null) {
            _log.info("WorldPosition is null for skill: " + skill.getName() + ", player: " + this.getName() + ".");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case AURA: 
            case FRONT_AURA: 
            case BEHIND_AURA: 
            case GROUND: 
            case SELF: 
            case AURA_CORPSE_MOB: 
            case COMMAND_CHANNEL: 
            case PARTY: 
            case CLAN: 
            case PARTY_CLAN: 
            case AREA_SUMMON: {
                target = this;
                break;
            }
            case PET: 
            case SERVITOR: 
            case SUMMON: {
                target = this.getSummon();
                break;
            }
            default: {
                target = this.getTarget();
            }
        }
        if (target == null) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (target.isDoor() && ((doorCastle = (door = (L2DoorInstance)target).getCastle()) != null && doorCastle.getResidenceId() > 0 ? !doorCastle.getSiege().getIsInProgress() : (doorFort = door.getFort()) != null && doorFort.getResidenceId() > 0 && !door.getIsShowHp() && !doorFort.getSiege().getIsInProgress())) {
            return false;
        }
        if (this.isInDuel() && target instanceof L2Playable && (cha = target.getActingPlayer()).getDuelId() != this.getDuelId()) {
            this.sendMessage("You cannot do this while duelling.");
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (this.isSkillDisabled(skill)) {
            long remainingTime = this.getSkillRemainingReuseTime(skill.getReuseHashCode());
            if (remainingTime > 0L) {
                int hours = (int)((remainingTime += 999L) / 3600000L);
                int minutes = (int)(remainingTime / 60000L % 60L);
                int seconds = (int)(remainingTime / 1000L % 60L);
                if (hours > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_HOURS_S3_MINUTES_S4_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addInt(hours);
                    sm.addInt(minutes);
                } else if (minutes > 0) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_MINUTES_S3_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                    sm.addInt(minutes);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_SECONDS_REMAINING_FOR_REUSE_S1);
                    sm.addSkillName(skill);
                }
                sm.addInt(seconds);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_PREPARED_FOR_REUSE);
                sm.addSkillName(skill);
            }
            this.sendPacket(sm);
            return false;
        }
        if (!skill.checkCondition(this, target, false)) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        if (skill.isBad()) {
            if (this.isInsidePeaceZone(this, target) && !this.getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isInOlympiadMode() && !this.isOlympiadStart()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target.getActingPlayer() != null && this.getSiegeState() > 0 && this.isInsideZone(ZoneId.SIEGE) && target.getActingPlayer().getSiegeState() == this.getSiegeState() && target.getActingPlayer() != this && target.getActingPlayer().getSiegeSide() == this.getSiegeSide()) {
                if (TerritoryWarManager.getInstance().isTWInProgress()) {
                    this.sendPacket(SystemMessageId.YOU_CANNOT_ATTACK_A_MEMBER_OF_THE_SAME_TERRITORY);
                } else {
                    this.sendPacket(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS);
                }
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!target.canBeAttacked() && !this.getAccessLevel().allowPeaceAttack()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (target instanceof L2EventMonsterInstance && ((L2EventMonsterInstance)target).eventSkillAttackBlocked()) {
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (!target.isAutoAttackable(this) && !forceUse) {
                switch (sklTargetType) {
                    case AURA: 
                    case FRONT_AURA: 
                    case BEHIND_AURA: 
                    case GROUND: 
                    case SELF: 
                    case AURA_CORPSE_MOB: 
                    case PARTY: 
                    case CLAN: 
                    case AREA_SUMMON: 
                    case UNLOCKABLE: {
                        break;
                    }
                    default: {
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                }
            }
            if (dontMove) {
                if (sklTargetType == L2TargetType.GROUND) {
                    if (!this.isInsideRadius(worldPosition.getX(), worldPosition.getY(), worldPosition.getZ(), skill.getCastRange() + this.getTemplate().getCollisionRadius(), false, false)) {
                        this.sendPacket(SystemMessageId.TARGET_TOO_FAR);
                        this.sendPacket(ActionFailed.STATIC_PACKET);
                        return false;
                    }
                } else if (skill.getCastRange() > 0 && !this.isInsideRadius(target, skill.getCastRange() + this.getTemplate().getCollisionRadius(), false, false)) {
                    this.sendPacket(SystemMessageId.TARGET_TOO_FAR);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            }
        }
        if (skill.hasEffectType(L2EffectType.TELEPORT_TO_TARGET)) {
            if (this.isMovementDisabled()) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_CANNOT_BE_USED);
                sm.addSkillName(skill.getId());
                this.sendPacket(sm);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
            if (this.isInsideZone(ZoneId.PEACE)) {
                this.sendPacket(SystemMessageId.TARGET_IN_PEACEZONE);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.getEffectPoint() > 0 && target.isMonster() && !forceUse) {
            this.sendPacket(ActionFailed.STATIC_PACKET);
            return false;
        }
        switch (sklTargetType) {
            case AURA: 
            case FRONT_AURA: 
            case BEHIND_AURA: 
            case GROUND: 
            case SELF: 
            case PARTY: 
            case CLAN: 
            case PARTY_CLAN: {
                break;
            }
            default: {
                if (this.checkPvpSkill(target, skill) || this.getAccessLevel().allowPeaceAttack()) break;
                this.sendPacket(SystemMessageId.TARGET_IS_INCORRECT);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.getCastRange() > 0) {
            if (sklTargetType == L2TargetType.GROUND) {
                if (!GeoData.getInstance().canSeeTarget((L2Object)this, worldPosition)) {
                    this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                    this.sendPacket(ActionFailed.STATIC_PACKET);
                    return false;
                }
            } else if (!GeoData.getInstance().canSeeTarget((L2Object)this, target)) {
                this.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                this.sendPacket(ActionFailed.STATIC_PACKET);
                return false;
            }
        }
        if (skill.getFlyType() == FlyToLocation.FlyType.CHARGE && Config.GEODATA > 0 && !GeoData.getInstance().canMove(this, target)) {
            this.sendPacket(SystemMessageId.THE_TARGET_IS_LOCATED_WHERE_YOU_CANNOT_CHARGE);
            return false;
        }
        return true;
    }

    public boolean isInLooterParty(int LooterId) {
        L2PcInstance looter = L2World.getInstance().getPlayer(LooterId);
        if (this.isInParty() && this.getParty().isInCommandChannel() && looter != null) {
            return this.getParty().getCommandChannel().getMembers().contains(looter);
        }
        if (this.isInParty() && looter != null) {
            return this.getParty().getMembers().contains(looter);
        }
        return false;
    }

    public boolean checkPvpSkill(L2Object target, Skill skill) {
        return this.checkPvpSkill(target, skill, false);
    }

    public boolean checkPvpSkill(L2Object target, Skill skill, boolean srcIsSummon) {
        L2PcInstance targetPlayer;
        L2PcInstance l2PcInstance = targetPlayer = target != null ? target.getActingPlayer() : null;
        if (skill.isDebuff() || skill.hasEffectType(L2EffectType.STEAL_ABNORMAL) || skill.isBad() && skill.hasEffectType(L2EffectType.DISPEL)) {
            if (this == targetPlayer) {
                return false;
            }
            boolean isCtrlPressed = this.getCurrentSkill() != null && this.getCurrentSkill().isCtrlPressed();
            boolean isInsideSiegeZone = this.isInsideZone(ZoneId.SIEGE);
            if (targetPlayer != null) {
                Siege siege;
                L2CommandChannel chan;
                if (this.isInDuel()) {
                    if (!targetPlayer.isInDuel()) {
                        return false;
                    }
                    if (this.getDuelId() != 0 && this.getDuelId() == targetPlayer.getDuelId()) {
                        return true;
                    }
                }
                if (this.isInOlympiadMode()) {
                    if (!targetPlayer.isInOlympiadMode()) {
                        return false;
                    }
                    if (this.getOlympiadGameId() != 0 && this.getOlympiadGameId() == targetPlayer.getOlympiadGameId()) {
                        return true;
                    }
                } else if (targetPlayer.isInOlympiadMode()) {
                    return false;
                }
                if (targetPlayer.isInsideZone(ZoneId.PEACE)) {
                    return false;
                }
                if (this.isInParty() && targetPlayer.isInParty() && this.getParty().getLeader() == targetPlayer.getParty().getLeader()) {
                    return false;
                }
                L2Party activeCharParty = this.getParty();
                if (activeCharParty != null && (chan = activeCharParty.getCommandChannel()) != null && chan.containsPlayer(targetPlayer)) {
                    return false;
                }
                if (isInsideSiegeZone && this.isInSiege() && this.getSiegeState() != 0 && targetPlayer.getSiegeState() != 0 && (siege = SiegeManager.getInstance().getSiege(this.getX(), this.getY(), this.getZ())) != null && (siege.checkIsDefender(this.getClan()) && siege.checkIsDefender(targetPlayer.getClan()) || siege.checkIsAttacker(this.getClan()) && siege.checkIsAttacker(targetPlayer.getClan()))) {
                    this.sendPacket(SystemMessage.getSystemMessage(SystemMessageId.FORCED_ATTACK_IS_IMPOSSIBLE_AGAINST_SIEGE_SIDE_TEMPORARY_ALLIED_MEMBERS));
                    return false;
                }
                if (this.isInsideZone(ZoneId.PVP) && targetPlayer.isInsideZone(ZoneId.PVP)) {
                    return true;
                }
                L2Clan aClan = this.getClan();
                L2Clan tClan = targetPlayer.getClan();
                if (aClan != null && tClan != null && aClan.isAtWarWith(tClan.getId()) && tClan.isAtWarWith(aClan.getId())) {
                    return true;
                }
                if (this.getClanId() != 0 && this.getClanId() == targetPlayer.getClanId()) {
                    return false;
                }
                if (this.getAllyId() != 0 && this.getAllyId() == targetPlayer.getAllyId()) {
                    return false;
                }
                if (targetPlayer.getPvpFlag() == 0 && targetPlayer.getKarma() == 0) {
                    return false;
                }
                if (targetPlayer.getPvpFlag() > 0 || targetPlayer.getKarma() > 0) {
                    if (!isCtrlPressed) {
                        switch (skill.getTargetType()) {
                            case AURA: 
                            case FRONT_AURA: 
                            case BEHIND_AURA: 
                            case AREA: 
                            case BEHIND_AREA: 
                            case FRONT_AREA: {
                                return this.getPvpFlag() > 0 || this.getKarma() > 0;
                            }
                        }
                        return true;
                    }
                    return true;
                }
            }
        }
        if (!(targetPlayer == null || target == this || this.isInDuel() && targetPlayer.getDuelId() == this.getDuelId() || this.isInsideZone(ZoneId.PVP) || targetPlayer.isInsideZone(ZoneId.PVP))) {
            SkillUseHolder skilldat = this.getCurrentSkill();
            SkillUseHolder skilldatpet = this.getCurrentPetSkill();
            if (skilldat != null && !skilldat.isCtrlPressed() && skill.isBad() && !srcIsSummon || skilldatpet != null && !skilldatpet.isCtrlPressed() && skill.isBad() && srcIsSummon) {
                if (this.getClan() != null && targetPlayer.getClan() != null && this.getClan().isAtWarWith(targetPlayer.getClan().getId()) && targetPlayer.getClan().isAtWarWith(this.getClan().getId())) {
                    return true;
                }
                if (targetPlayer.getPvpFlag() == 0 && targetPlayer.getKarma() == 0) {
                    return false;
                }
            }
        }
        return true;
    }

    public boolean isMageClass() {
        return this.getClassId().isMage();
    }

    public boolean isMounted() {
        return this._mountType != MountType.NONE;
    }

    public boolean checkLandingState() {
        if (this.isInsideZone(ZoneId.NO_LANDING)) {
            return true;
        }
        return this.isInsideZone(ZoneId.SIEGE) && (this.getClan() == null || CastleManager.getInstance().getCastle(this) != CastleManager.getInstance().getCastleByOwner(this.getClan()) || this != this.getClan().getLeader().getPlayerInstance());
    }

    public void setMount(int npcId, int npcLevel) {
        MountType type = MountType.findByNpcId(npcId);
        switch (type) {
            case NONE: {
                this.setIsFlying(false);
                break;
            }
            case STRIDER: {
                if (!this.isNoble()) break;
                this.addSkill(CommonSkill.STRIDER_SIEGE_ASSAULT.getSkill(), false);
                break;
            }
            case WYVERN: {
                this.setIsFlying(true);
            }
        }
        this._mountType = type;
        this._mountNpcId = npcId;
        this._mountLevel = npcLevel;
    }

    public MountType getMountType() {
        return this._mountType;
    }

    @Override
    public final void stopAllEffects() {
        super.stopAllEffects();
        this.updateAndBroadcastStatus(2);
    }

    @Override
    public final void stopAllEffectsExceptThoseThatLastThroughDeath() {
        super.stopAllEffectsExceptThoseThatLastThroughDeath();
        this.updateAndBroadcastStatus(2);
    }

    public final void stopAllEffectsNotStayOnSubclassChange() {
        this.getEffectList().stopAllEffectsNotStayOnSubclassChange();
        this.updateAndBroadcastStatus(2);
    }

    public final void stopCubics() {
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
            this.broadcastUserInfo();
        }
    }

    public final void stopCubicsByOthers() {
        if (!this._cubics.isEmpty()) {
            boolean broadcast = false;
            for (L2CubicInstance cubic : this._cubics.values()) {
                if (!cubic.givenByOther()) continue;
                cubic.stopAction();
                cubic.cancelDisappear();
                this._cubics.remove(cubic.getId());
                broadcast = true;
            }
            if (broadcast) {
                this.broadcastUserInfo();
            }
        }
    }

    @Override
    public void updateAbnormalEffect() {
        this.broadcastUserInfo();
    }

    public void setInventoryBlockingStatus(boolean val) {
        this._inventoryDisable = val;
        if (val) {
            ThreadPoolManager.getInstance().scheduleGeneral(new InventoryEnableTask(this), 1500L);
        }
    }

    public boolean isInventoryDisabled() {
        return this._inventoryDisable;
    }

    public L2CubicInstance addCubic(int cubicId, int level, double cubicPower, int cubicDelay, int cubicSkillChance, int cubicMaxCount, int cubicDuration, boolean givenByOther) {
        return (L2CubicInstance)this._cubics.put(cubicId, (Object)new L2CubicInstance(this, cubicId, level, (int)cubicPower, cubicDelay, cubicSkillChance, cubicMaxCount, cubicDuration, givenByOther));
    }

    public FastIntObjectMap<L2CubicInstance> getCubics() {
        return this._cubics;
    }

    public L2CubicInstance getCubicById(int cubicId) {
        return (L2CubicInstance)this._cubics.get(cubicId);
    }

    public int getEnchantEffect() {
        L2ItemInstance wpn = this.getActiveWeaponInstance();
        if (wpn == null) {
            return 0;
        }
        return Math.min(127, wpn.getEnchantLevel());
    }

    public void setLastFolkNPC(L2Npc folkNpc) {
        this._lastFolkNpc = folkNpc;
    }

    public L2Npc getLastFolkNPC() {
        return this._lastFolkNpc;
    }

    public boolean isFestivalParticipant() {
        return SevenSignsFestival.getInstance().isParticipant(this);
    }

    public void addAutoSoulShot(int itemId) {
        this._activeSoulShots.add((Object)itemId);
    }

    public boolean removeAutoSoulShot(int itemId) {
        return this._activeSoulShots.remove((Object)itemId);
    }

    public Set<Integer> getAutoSoulShot() {
        return this._activeSoulShots;
    }

    @Override
    public void rechargeShots(boolean physical, boolean magic) {
        if (this._activeSoulShots == null || this._activeSoulShots.isEmpty()) {
            return;
        }
        Iterator i$ = this._activeSoulShots.iterator();
        while (i$.hasNext()) {
            int itemId = (Integer)i$.next();
            L2ItemInstance item = this.getInventory().getItemByItemId(itemId);
            if (item != null) {
                IItemHandler handler;
                if (magic && item.getItem().getDefaultAction() == L2ActionType.spiritshot && (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) != null) {
                    handler.useItem(this, item, false);
                }
                if (!physical || item.getItem().getDefaultAction() != L2ActionType.soulshot || (handler = ItemHandler.getInstance().getHandler(item.getEtcItem())) == null) continue;
                handler.useItem(this, item, false);
                continue;
            }
            this.removeAutoSoulShot(itemId);
        }
    }

    public void disableAutoShotByCrystalType(int crystalType) {
        Iterator i$ = this._activeSoulShots.iterator();
        while (i$.hasNext()) {
            int itemId = (Integer)i$.next();
            if (ItemTable.getInstance().getTemplate(itemId).getCrystalType() != crystalType) continue;
            this.disableAutoShot(itemId);
        }
    }

    public boolean disableAutoShot(int itemId) {
        if (this._activeSoulShots.contains((Object)itemId)) {
            this.removeAutoSoulShot(itemId);
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
            sm.addItemName(itemId);
            this.sendPacket(sm);
            return true;
        }
        return false;
    }

    public void disableAutoShotsAll() {
        Iterator i$ = this._activeSoulShots.iterator();
        while (i$.hasNext()) {
            int itemId = (Integer)i$.next();
            this.sendPacket(new ExAutoSoulShot(itemId, 0));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.AUTO_USE_OF_S1_CANCELLED);
            sm.addItemName(itemId);
            this.sendPacket(sm);
        }
        this._activeSoulShots.clear();
    }

    public EnumIntBitmask<ClanPrivilege> getClanPrivileges() {
        return this._clanPrivileges;
    }

    public void setClanPrivileges(EnumIntBitmask<ClanPrivilege> clanPrivileges) {
        this._clanPrivileges = clanPrivileges.clone();
    }

    public boolean hasClanPrivilege(ClanPrivilege privilege) {
        return this._clanPrivileges.has(privilege);
    }

    public void setPledgeClass(int classId) {
        this._pledgeClass = classId;
        this.checkItemRestriction();
    }

    public int getPledgeClass() {
        return this._pledgeClass;
    }

    public void setPledgeType(int typeId) {
        this._pledgeType = typeId;
    }

    public int getPledgeType() {
        return this._pledgeType;
    }

    public int getApprentice() {
        return this._apprentice;
    }

    public void setApprentice(int apprentice_id) {
        this._apprentice = apprentice_id;
    }

    public int getSponsor() {
        return this._sponsor;
    }

    public void setSponsor(int sponsor_id) {
        this._sponsor = sponsor_id;
    }

    public int getBookMarkSlot() {
        return this._bookmarkslot;
    }

    public void setBookMarkSlot(int slot) {
        this._bookmarkslot = slot;
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    @Override
    public void sendMessage(String message) {
        this.sendPacket(SystemMessage.sendString(message));
    }

    public void enterObserverMode(Location loc) {
        this.setLastLocation();
        this.getEffectList().stopSkillEffects(true, AbnormalType.HIDE);
        this._observerMode = true;
        this.setTarget(null);
        this.setIsParalyzed(true);
        this.startParalyze();
        this.setIsInvul(true);
        this.getAppearance().setInvisible();
        this.sendPacket(new ObservationMode(loc));
        this.teleToLocation((ILocational)loc, false);
        this.broadcastUserInfo();
    }

    public void setLastLocation() {
        this._lastLoc.setXYZ(this.getX(), this.getY(), this.getZ());
    }

    public void unsetLastLocation() {
        this._lastLoc.setXYZ(0, 0, 0);
    }

    public void enterOlympiadObserverMode(Location loc, int id) {
        if (this.hasSummon()) {
            this.getSummon().unSummon(this);
        }
        this.getEffectList().stopSkillEffects(true, AbnormalType.HIDE);
        if (!this._cubics.isEmpty()) {
            for (L2CubicInstance cubic : this._cubics.values()) {
                cubic.stopAction();
                cubic.cancelDisappear();
            }
            this._cubics.clear();
        }
        if (this.getParty() != null) {
            this.getParty().removePartyMember(this, L2Party.messageType.Expelled);
        }
        this._olympiadGameId = id;
        if (this.isSitting()) {
            this.standUp();
        }
        if (!this._observerMode) {
            this.setLastLocation();
        }
        this._observerMode = true;
        this.setTarget(null);
        this.setIsInvul(true);
        this.getAppearance().setInvisible();
        this.teleToLocation((ILocational)loc, false);
        this.sendPacket(new ExOlympiadMode(3));
        this.broadcastUserInfo();
    }

    public void leaveObserverMode() {
        this.setTarget(null);
        this.teleToLocation((ILocational)this._lastLoc, false);
        this.unsetLastLocation();
        this.sendPacket(new ObservationReturn(this.getLocation()));
        this.setIsParalyzed(false);
        if (!this.isGM()) {
            this.getAppearance().setVisible();
            this.setIsInvul(false);
        }
        if (this.hasAI()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.setFalling();
        this._observerMode = false;
        this.broadcastUserInfo();
    }

    public void leaveOlympiadObserverMode() {
        if (this._olympiadGameId == -1) {
            return;
        }
        this._olympiadGameId = -1;
        this._observerMode = false;
        this.setTarget(null);
        this.sendPacket(new ExOlympiadMode(0));
        this.setInstanceId(0);
        this.teleToLocation((ILocational)this._lastLoc, true);
        if (!this.isGM()) {
            this.getAppearance().setVisible();
            this.setIsInvul(false);
        }
        if (this.hasAI()) {
            this.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
        }
        this.unsetLastLocation();
        this.broadcastUserInfo();
    }

    public void setOlympiadSide(int i) {
        this._olympiadSide = i;
    }

    public int getOlympiadSide() {
        return this._olympiadSide;
    }

    public void setOlympiadGameId(int id) {
        this._olympiadGameId = id;
    }

    public int getOlympiadGameId() {
        return this._olympiadGameId;
    }

    public Location getLastLocation() {
        return this._lastLoc;
    }

    public boolean inObserverMode() {
        return this._observerMode;
    }

    public int getTeleMode() {
        return this._telemode;
    }

    public void setTeleMode(int mode) {
        this._telemode = mode;
    }

    public void setLoto(int i, int val) {
        this._loto[i] = val;
    }

    public int getLoto(int i) {
        return this._loto[i];
    }

    public void setRace(int i, int val) {
        this._race[i] = val;
    }

    public int getRace(int i) {
        return this._race[i];
    }

    public boolean getMessageRefusal() {
        return this._messageRefusal;
    }

    public void setMessageRefusal(boolean mode) {
        this._messageRefusal = mode;
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public void setDietMode(boolean mode) {
        this._dietMode = mode;
    }

    public boolean getDietMode() {
        return this._dietMode;
    }

    public void setTradeRefusal(boolean mode) {
        this._tradeRefusal = mode;
    }

    public boolean getTradeRefusal() {
        return this._tradeRefusal;
    }

    public void setExchangeRefusal(boolean mode) {
        this._exchangeRefusal = mode;
    }

    public boolean getExchangeRefusal() {
        return this._exchangeRefusal;
    }

    public BlockList getBlockList() {
        return this._blockList;
    }

    public void setHero(boolean hero) {
        if (hero && this._baseClass == this._activeClass) {
            for (Skill skill : SkillTreesData.getInstance().getHeroSkillTree().values()) {
                this.addSkill(skill, false);
            }
        } else {
            for (Skill skill : SkillTreesData.getInstance().getHeroSkillTree().values()) {
                this.removeSkill(skill, false, true);
            }
        }
        this._hero = hero;
        this.sendSkillList();
    }

    private boolean isAuraItem(L2ItemInstance item) {
        return false;
    }

    public void checkAuraItemEquipped() {
        for (L2ItemInstance item : this.getInventory().getItems()) {
            if (item == null || !item.isEquipped() || !this.isAuraItem(item)) continue;
            this.aura = true;
            return;
        }
        this.aura = false;
    }

    public void setIsInOlympiadMode(boolean b) {
        this._inOlympiadMode = b;
    }

    public void setIsOlympiadStart(boolean b) {
        this._OlympiadStart = b;
    }

    public boolean isOlympiadStart() {
        return this._OlympiadStart;
    }

    public boolean isHero() {
        return this._hero;
    }

    public boolean isInOlympiadMode() {
        return this._inOlympiadMode;
    }

    public boolean isInDuel() {
        return this._isInDuel;
    }

    public int getDuelId() {
        return this._duelId;
    }

    public void setDuelState(int mode) {
        this._duelState = mode;
    }

    public int getDuelState() {
        return this._duelState;
    }

    public void setIsInDuel(int duelId) {
        if (duelId > 0) {
            this._isInDuel = true;
            this._duelState = 1;
            this._duelId = duelId;
        } else {
            if (this._duelState == 2) {
                this.enableAllSkills();
                this.getStatus().startHpMpRegeneration();
            }
            this._isInDuel = false;
            this._duelState = 0;
            this._duelId = 0;
        }
    }

    public SystemMessage getNoDuelReason() {
        SystemMessage sm = SystemMessage.getSystemMessage(this._noDuelReason);
        sm.addPcName(this);
        this._noDuelReason = SystemMessageId.THERE_IS_NO_OPPONENT_TO_RECEIVE_YOUR_CHALLENGE_FOR_A_DUEL;
        return sm;
    }

    public boolean canDuel() {
        if (this.isInCombat() || this.isJailed()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_BATTLE;
            return false;
        }
        if (this.isDead() || this.isAlikeDead() || this.getCurrentHp() < (double)(this.getMaxHp() / 2) || this.getCurrentMp() < (double)(this.getMaxMp() / 2)) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_HP_OR_MP_IS_BELOW_50_PERCENT;
            return false;
        }
        if (this.isInDuel()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_ALREADY_ENGAGED_IN_A_DUEL;
            return false;
        }
        if (this.isInOlympiadMode()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_PARTICIPATING_IN_THE_OLYMPIAD;
            return false;
        }
        if (this.isCursedWeaponEquipped()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_IN_A_CHAOTIC_STATE;
            return false;
        }
        if (this.getPrivateStoreType() != PrivateStoreType.NONE) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_ENGAGED_IN_A_PRIVATE_STORE_OR_MANUFACTURE;
            return false;
        }
        if (this.isMounted() || this.isInBoat()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_RIDING_A_BOAT_STEED_OR_STRIDER;
            return false;
        }
        if (this.isFishing()) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_DUEL_BECAUSE_C1_IS_CURRENTLY_FISHING;
            return false;
        }
        if (this.isInsideZone(ZoneId.PVP) || this.isInsideZone(ZoneId.PEACE) || this.isInsideZone(ZoneId.SIEGE)) {
            this._noDuelReason = SystemMessageId.C1_CANNOT_MAKE_A_CHALLANGE_TO_A_DUEL_BECAUSE_C1_IS_CURRENTLY_IN_A_DUEL_PROHIBITED_AREA;
            return false;
        }
        return true;
    }

    public boolean isNoble() {
        return this._noble;
    }

    public void setNoble(boolean val) {
        Collection<Skill> nobleSkillTree = SkillTreesData.getInstance().getNobleSkillTree().values();
        if (val) {
            for (Skill skill : nobleSkillTree) {
                this.addSkill(skill, false);
            }
        } else {
            for (Skill skill : nobleSkillTree) {
                this.removeSkill(skill, false, true);
            }
        }
        this._noble = val;
        this.sendSkillList();
    }

    public void setLvlJoinedAcademy(int lvl) {
        this._lvlJoinedAcademy = lvl;
    }

    public int getLvlJoinedAcademy() {
        return this._lvlJoinedAcademy;
    }

    public boolean isAcademyMember() {
        return this._lvlJoinedAcademy > 0;
    }

    @Override
    public void setTeam(Team team) {
        super.setTeam(team);
        this.broadcastUserInfo();
        if (this.hasSummon()) {
            this.getSummon().broadcastStatusUpdate();
        }
    }

    public void setWantsPeace(int wantsPeace) {
        this._wantsPeace = wantsPeace;
    }

    public int getWantsPeace() {
        return this._wantsPeace;
    }

    public boolean isFishing() {
        return this._fishing;
    }

    public void setFishing(boolean fishing) {
        this._fishing = fishing;
    }

    public void sendSkillList() {
        boolean isDisabled = false;
        SkillList sl = new SkillList();
        for (Skill s : this.getAllSkills()) {
            boolean isEnchantable;
            if (s == null || this._transformation != null && !this.hasTransformSkill(s.getId()) && !s.allowOnTransform()) continue;
            if (this.getClan() != null) {
                boolean bl = isDisabled = s.isClanSkill() && this.getClan().getReputationScore() < 0;
            }
            if (isEnchantable = SkillData.getInstance().isEnchantable(s.getId())) {
                L2EnchantSkillLearn esl = EnchantSkillGroupsData.getInstance().getSkillEnchantmentBySkillId(s.getId());
                if (esl != null) {
                    if (s.getLevel() < esl.getBaseLevel()) {
                        isEnchantable = false;
                    }
                } else {
                    isEnchantable = false;
                }
            }
            sl.addSkill(s.getDisplayId(), s.getDisplayLevel(), s.isPassive(), isDisabled, isEnchantable);
        }
        this.sendPacket(sl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addSubClass(int classId, int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            if (this.getTotalSubClasses() == Config.MAX_SUBCLASS || classIndex == 0) {
                boolean bl = false;
                return bl;
            }
            if (this.getSubClasses().containsKey(classIndex)) {
                boolean bl = false;
                return bl;
            }
            SubClass newClass = new SubClass();
            newClass.setClassId(classId);
            newClass.setClassIndex(classIndex);
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(ADD_CHAR_SUBCLASS);){
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, newClass.getClassId());
                statement.setLong(3, newClass.getExp());
                statement.setInt(4, newClass.getSp());
                statement.setInt(5, newClass.getLevel());
                statement.setInt(6, newClass.getClassIndex());
                statement.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "WARNING: Could not add character sub class for " + this.getName() + ": " + e.getMessage(), e);
                boolean bl = false;
                this._subclassLock.unlock();
                return bl;
            }
            this.getSubClasses().put(newClass.getClassIndex(), newClass);
            ClassId subTemplate = ClassId.getClassId(classId);
            Map<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(subTemplate);
            HashMap<Integer, Skill> prevSkillList = new HashMap<Integer, Skill>();
            for (L2SkillLearn skillInfo : skillTree.values()) {
                if (skillInfo.getGetLevel() > 40) continue;
                Skill prevSkill = (Skill)prevSkillList.get(skillInfo.getSkillId());
                Skill newSkill = SkillData.getInstance().getSkill(skillInfo.getSkillId(), skillInfo.getSkillLevel());
                if (prevSkill != null && prevSkill.getLevel() > newSkill.getLevel()) continue;
                prevSkillList.put(newSkill.getId(), newSkill);
                this.storeSkill(newSkill, prevSkill, classIndex);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean modifySubClass(int classIndex, int newClassId) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement deleteHennas = con.prepareStatement(DELETE_CHAR_HENNAS);
                 PreparedStatement deleteShortcuts = con.prepareStatement(DELETE_CHAR_SHORTCUTS);
                 PreparedStatement deleteSkillReuse = con.prepareStatement(DELETE_SKILL_SAVE);
                 PreparedStatement deleteSkills = con.prepareStatement(DELETE_CHAR_SKILLS);
                 PreparedStatement deleteSubclass = con.prepareStatement(DELETE_CHAR_SUBCLASS);){
                deleteHennas.setInt(1, this.getObjectId());
                deleteHennas.setInt(2, classIndex);
                deleteHennas.execute();
                deleteShortcuts.setInt(1, this.getObjectId());
                deleteShortcuts.setInt(2, classIndex);
                deleteShortcuts.execute();
                deleteSkillReuse.setInt(1, this.getObjectId());
                deleteSkillReuse.setInt(2, classIndex);
                deleteSkillReuse.execute();
                deleteSkills.setInt(1, this.getObjectId());
                deleteSkills.setInt(2, classIndex);
                deleteSkills.execute();
                deleteSubclass.setInt(1, this.getObjectId());
                deleteSubclass.setInt(2, classIndex);
                deleteSubclass.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not modify sub class for " + this.getName() + " to class index " + classIndex + ": " + e.getMessage(), e);
                this.getSubClasses().remove(classIndex);
                boolean bl = false;
                this._subclassLock.unlock();
                return bl;
            }
            this.getSubClasses().remove(classIndex);
        }
        finally {
            this._subclassLock.unlock();
        }
        return this.addSubClass(newClassId, classIndex);
    }

    public boolean isSubClassActive() {
        return this._classIndex > 0;
    }

    public Map<Integer, SubClass> getSubClasses() {
        if (this._subClasses == null) {
            this._subClasses = new FastMap();
        }
        return this._subClasses;
    }

    public int getTotalSubClasses() {
        return this.getSubClasses().size();
    }

    public int getBaseClass() {
        return this._baseClass;
    }

    public int getActiveClass() {
        return this._activeClass;
    }

    public int getClassIndex() {
        return this._classIndex;
    }

    private void setClassTemplate(int classId) {
        this._activeClass = classId;
        L2PcTemplate pcTemplate = CharTemplateTable.getInstance().getTemplate(classId);
        if (pcTemplate == null) {
            _log.severe("Missing template for classId: " + classId);
            throw new Error();
        }
        this.setTemplate(pcTemplate);
        this.fireProfessionChangeListeners(pcTemplate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setActiveClass(int classIndex) {
        if (!this._subclassLock.tryLock()) {
            return false;
        }
        try {
            if (this._transformation != null) {
                boolean bl = false;
                return bl;
            }
            for (L2ItemInstance item : this.getInventory().getAugmentedItems()) {
                if (item == null || !item.isEquipped()) continue;
                item.getAugmentation().removeBonus(this);
            }
            this.abortCast();
            if (this.isChannelized()) {
                this.getSkillChannelized().abortChannelization();
            }
            this.store(Config.SUBCLASS_STORE_SKILL_COOLTIME);
            this.resetTimeStamps();
            this._charges.set(0);
            this.stopChargeTask();
            if (this.hasServitor()) {
                this.getSummon().unSummon(this);
            }
            if (classIndex == 0) {
                this.setClassTemplate(this.getBaseClass());
            } else {
                try {
                    this.setClassTemplate(this.getSubClasses().get(classIndex).getClassId());
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "Could not switch " + this.getName() + "'s sub class to class index " + classIndex + ": " + e.getMessage(), e);
                    int len$ = 0;
                    this._subclassLock.unlock();
                    return len$ != 0;
                }
            }
            this._classIndex = classIndex;
            this.setLearningClass(this.getClassId());
            if (this.isInParty()) {
                this.getParty().recalculatePartyLevel();
            }
            for (Skill oldSkill : this.getAllSkills()) {
                this.removeSkill(oldSkill, false, true);
            }
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
            this.stopAllEffectsNotStayOnSubclassChange();
            this.stopCubics();
            this.restoreRecipeBook(false);
            this.restoreDeathPenaltyBuffLevel();
            this.restoreSkills();
            this.rewardSkills();
            this.regiveTemporarySkills();
            this.resetDisabledSkills();
            this.restoreEffects();
            this.sendPacket(new EtcStatusUpdate(this));
            QuestState st = this.getQuestState("422_RepentYourSins");
            if (st != null) {
                st.exitQuest(true);
            }
            for (int i = 0; i < 3; ++i) {
                this._henna[i] = null;
            }
            this.restoreHenna();
            this.sendPacket(new HennaInfo(this));
            if (this.getCurrentHp() > (double)this.getMaxHp()) {
                this.setCurrentHp(this.getMaxHp());
            }
            if (this.getCurrentMp() > (double)this.getMaxMp()) {
                this.setCurrentMp(this.getMaxMp());
            }
            if (this.getCurrentCp() > (double)this.getMaxCp()) {
                this.setCurrentCp(this.getMaxCp());
            }
            this.refreshOverloaded();
            this.refreshExpertisePenalty();
            this.broadcastUserInfo();
            this.setExpBeforeDeath(0L);
            this._shortCuts.restoreMe();
            this.sendPacket(new ShortCutInit(this));
            this.broadcastPacket(new SocialAction(this.getObjectId(), 2122));
            this.sendPacket(new SkillCoolTime(this));
            this.sendPacket(new ExStorageMaxCount(this));
            boolean bl = true;
            return bl;
        }
        finally {
            this._subclassLock.unlock();
        }
    }

    public boolean isLocked() {
        return this._subclassLock.isLocked();
    }

    public void stopWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak != null) {
            this._taskWarnUserTakeBreak.cancel(true);
            this._taskWarnUserTakeBreak = null;
        }
    }

    public void startWarnUserTakeBreak() {
        if (this._taskWarnUserTakeBreak == null) {
            this._taskWarnUserTakeBreak = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new WarnUserTakeBreakTask(this), 0x6DDD00L, 0x6DDD00L);
        }
    }

    public void stopRentPet() {
        if (this._taskRentPet != null) {
            if (this.checkLandingState() && this.getMountType() == MountType.WYVERN) {
                this.teleToLocation(TeleportWhereType.TOWN);
            }
            if (this.dismount()) {
                this._taskRentPet.cancel(true);
                this._taskRentPet = null;
            }
        }
    }

    public void startRentPet(int seconds) {
        if (this._taskRentPet == null) {
            this._taskRentPet = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RentPetTask(this), (long)seconds * 1000L, (long)seconds * 1000L);
        }
    }

    public boolean isRentedPet() {
        return this._taskRentPet != null;
    }

    public void stopWaterTask() {
        if (this._taskWater != null) {
            this._taskWater.cancel(false);
            this._taskWater = null;
            this.sendPacket(new SetupGauge(2, 0));
        }
    }

    public void startWaterTask() {
        if (!this.isDead() && this._taskWater == null) {
            int timeinwater = (int)this.calcStat(Stats.BREATH, 60000.0, this, null);
            this.sendPacket(new SetupGauge(2, timeinwater));
            this._taskWater = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new WaterTask(this), timeinwater, 1000L);
        }
    }

    public boolean isInWater() {
        return this._taskWater != null;
    }

    public void checkWaterState() {
        if (this.isInsideZone(ZoneId.WATER)) {
            this.startWaterTask();
        } else {
            this.stopWaterTask();
        }
    }

    public void onPlayerEnter() {
        this.startWarnUserTakeBreak();
        if (SevenSigns.getInstance().isSealValidationPeriod() || SevenSigns.getInstance().isCompResultsPeriod()) {
            if (!this.isGM() && this.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(this.getObjectId()) != SevenSigns.getInstance().getCabalHighestScore()) {
                this.teleToLocation(TeleportWhereType.TOWN);
                this.setIsIn7sDungeon(false);
                this.sendMessage("You have been teleported to the nearest town due to the beginning of the Seal Validation period.");
            }
        } else if (!this.isGM() && this.isIn7sDungeon() && SevenSigns.getInstance().getPlayerCabal(this.getObjectId()) == 0) {
            this.teleToLocation(TeleportWhereType.TOWN);
            this.setIsIn7sDungeon(false);
            this.sendMessage("You have been teleported to the nearest town because you have not signed for any cabal.");
        }
        if (this.isGM()) {
            if (this.isInvul()) {
                this.sendMessage("Entering world in Invulnerable mode.");
            }
            if (this.getAppearance().getInvisible()) {
                this.sendMessage("Entering world in Invisible mode.");
            }
            if (this.isSilenceMode()) {
                this.sendMessage("Entering world in Silence mode.");
            }
        }
        if (Config.STORE_SKILL_COOLTIME) {
            this.restoreEffects();
        }
        this.revalidateZone(true);
        this.notifyFriends();
        if (!this.canOverrideCond(PcCondOverride.SKILL_CONDITIONS) && Config.DECREASE_SKILL_LEVEL) {
            this.checkPlayerSkills();
        }
        this.getEvents().onPlayerLogin();
        try {
            for (L2ZoneType zone : ZoneManager.getInstance().getZones(this)) {
                zone.onPlayerLoginInside(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "", e);
        }
        if (Config.ENABLE_BLOCK_CHECKER_EVENT) {
            HandysBlockCheckerManager.getInstance().onPlayerEnter(this);
        }
    }

    public long getLastAccess() {
        return this._lastAccess;
    }

    @Override
    public void doRevive() {
        Instance instance;
        super.doRevive();
        this.stopEffects(L2EffectType.CHARMOFCOURAGE);
        this.updateEffectIcons();
        this.sendPacket(new EtcStatusUpdate(this));
        this._reviveRequested = 0;
        this._revivePower = 0.0;
        if (this.isMounted()) {
            this.startFeed(this._mountNpcId);
        }
        if (this.isInParty() && this.getParty().isInDimensionalRift() && !DimensionalRiftManager.getInstance().checkIfInPeaceZone(this.getX(), this.getY(), this.getZ())) {
            this.getParty().getDimensionalRift().memberRessurected(this);
        }
        if (this.getInstanceId() > 0 && (instance = InstanceManager.getInstance().getInstance(this.getInstanceId())) != null) {
            instance.cancelEjectDeadPlayer(this);
        }
    }

    @Override
    public void setName(String value) {
        super.setName(value);
        if (Config.CACHE_CHAR_NAMES) {
            CharNameTable.getInstance().addName(this);
        }
    }

    @Override
    public void doRevive(double revivePower) {
        this.restoreExp(revivePower);
        this.doRevive();
    }

    public void reviveRequest(L2PcInstance reviver, Skill skill, boolean Pet, int power) {
        if (this.isResurrectionBlocked()) {
            return;
        }
        if (this._reviveRequested == 1) {
            if (this._revivePet == Pet) {
                reviver.sendPacket(SystemMessageId.RES_HAS_ALREADY_BEEN_PROPOSED);
            } else if (Pet) {
                reviver.sendPacket(SystemMessageId.CANNOT_RES_PET2);
            } else {
                reviver.sendPacket(SystemMessageId.MASTER_CANNOT_RES);
            }
            return;
        }
        if (Pet && this.hasSummon() && this.getSummon().isDead() || !Pet && this.isDead()) {
            this._reviveRequested = 1;
            int restoreExp = 0;
            this._revivePower = this.isPhoenixBlessed() ? 100.0 : (this.isAffected(EffectFlag.CHARM_OF_COURAGE) ? 0.0 : Formulas.calculateSkillResurrectRestorePercent(power, reviver));
            restoreExp = (int)Math.round((double)(this.getExpBeforeDeath() - this.getExp()) * this._revivePower / 100.0);
            this._revivePet = Pet;
            if (this.isAffected(EffectFlag.CHARM_OF_COURAGE)) {
                ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESURRECT_USING_CHARM_OF_COURAGE.getId());
                dlg.setTime(60000);
                this.sendPacket(dlg);
                return;
            }
            ConfirmDlg dlg = new ConfirmDlg(SystemMessageId.RESURRECTION_REQUEST_BY_C1_FOR_S2_XP.getId());
            dlg.addPcName(reviver);
            dlg.addString(Integer.toString(restoreExp));
            this.sendPacket(dlg);
        }
    }

    public void reviveAnswer(int answer) {
        if (this._reviveRequested != 1 || !this.isDead() && !this._revivePet || this._revivePet && this.hasSummon() && !this.getSummon().isDead()) {
            return;
        }
        if (answer == 0 && this.isPhoenixBlessed()) {
            this.stopEffects(L2EffectType.PHOENIX_BLESSING);
            this.stopAllEffectsExceptThoseThatLastThroughDeath();
        }
        if (answer == 1) {
            if (!this._revivePet) {
                if (this._revivePower != 0.0) {
                    this.doRevive(this._revivePower);
                } else {
                    this.doRevive();
                }
            } else if (this.hasSummon()) {
                if (this._revivePower != 0.0) {
                    this.getSummon().doRevive(this._revivePower);
                } else {
                    this.getSummon().doRevive();
                }
            }
        }
        this._reviveRequested = 0;
        this._revivePower = 0.0;
    }

    public boolean isReviveRequested() {
        return this._reviveRequested == 1;
    }

    public boolean isRevivingPet() {
        return this._revivePet;
    }

    public void removeReviving() {
        this._reviveRequested = 0;
        this._revivePower = 0.0;
    }

    public void onActionRequest() {
        if (this.isSpawnProtected()) {
            this.sendPacket(SystemMessageId.YOU_ARE_NO_LONGER_PROTECTED_FROM_AGGRESSIVE_MONSTERS);
            if (Config.RESTORE_SERVITOR_ON_RECONNECT && !this.hasSummon() && CharSummonTable.getInstance().getServitors().containsKey(this.getObjectId())) {
                CharSummonTable.getInstance().restoreServitor(this);
            }
            if (Config.RESTORE_PET_ON_RECONNECT && !this.hasSummon() && CharSummonTable.getInstance().getPets().containsKey(this.getObjectId())) {
                CharSummonTable.getInstance().restorePet(this);
            }
        }
        if (this.isTeleportProtected()) {
            this.sendMessage("Teleport spawn protection ended.");
        }
        this.setProtection(false);
        this.setTeleportProtection(false);
    }

    public int getExpertiseLevel() {
        int level = this.getSkillLevel(239);
        if (level < 0) {
            level = 0;
        }
        return level;
    }

    @Override
    public void teleToLocation(int x, int y, int z, int heading, int instanceId, int randomOffset) {
        if (this.getVehicle() != null && !this.getVehicle().isTeleporting()) {
            this.setVehicle(null);
        }
        if (this.isFlyingMounted() && z < -1005) {
            z = -1005;
        }
        super.teleToLocation(x, y, z, heading, instanceId, randomOffset);
    }

    @Override
    public final void onTeleported() {
        L2Summon summon;
        super.onTeleported();
        if (this.isInAirShip()) {
            this.getAirShip().sendInfo(this);
        }
        this.revalidateZone(true);
        this.checkItemRestriction();
        if (Config.PLAYER_TELEPORT_PROTECTION > 0 && !this.isInOlympiadMode()) {
            this.setTeleportProtection(true);
        }
        if (this.getTrainedBeasts() != null) {
            for (L2TamedBeastInstance tamedBeast : this.getTrainedBeasts()) {
                tamedBeast.deleteMe();
            }
            this.getTrainedBeasts().clear();
        }
        if ((summon = this.getSummon()) != null) {
            summon.setFollowStatus(false);
            summon.teleToLocation(this.getPosition(), false);
            ((L2SummonAI)summon.getAI()).setStartFollowController(true);
            summon.setFollowStatus(true);
            summon.updateAndBroadcastStatus(0);
        }
        TvTEvent.onTeleported(this);
    }

    @Override
    public void setIsTeleporting(boolean teleport) {
        this.setIsTeleporting(teleport, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setIsTeleporting(boolean teleport, boolean useWatchDog) {
        super.setIsTeleporting(teleport);
        if (!useWatchDog) {
            return;
        }
        if (teleport) {
            if (this._teleportWatchdog == null && Config.TELEPORT_WATCHDOG_TIMEOUT > 0) {
                L2PcInstance l2PcInstance = this;
                synchronized (l2PcInstance) {
                    if (this._teleportWatchdog == null) {
                        this._teleportWatchdog = ThreadPoolManager.getInstance().scheduleGeneral(new TeleportWatchdogTask(this), Config.TELEPORT_WATCHDOG_TIMEOUT * 1000);
                    }
                }
            }
        } else if (this._teleportWatchdog != null) {
            this._teleportWatchdog.cancel(false);
            this._teleportWatchdog = null;
        }
    }

    public void setLastServerPosition(int x, int y, int z) {
        this._lastServerPosition.setXYZ(x, y, z);
    }

    public Location getLastServerPosition() {
        return this._lastServerPosition;
    }

    public int getLastServerDistance(int x, int y, int z) {
        return (int)Util.calculateDistance(x, y, z, this._lastServerPosition.getX(), this._lastServerPosition.getY(), this._lastServerPosition.getZ(), true, false);
    }

    @Override
    public void addExpAndSp(long addToExp, int addToSp) {
        this.getStat().addExpAndSp(addToExp, addToSp, false);
    }

    public void addExpAndSp(long addToExp, int addToSp, boolean useVitality) {
        if (!this._expGainOn) {
            return;
        }
        int experienceMaxLevel = this.getLevel() + Config.LIMIT_LEVEL_STEPUP;
        if (experienceMaxLevel <= ExperienceTable.getInstance().getMaxLevel()) {
            addToExp = Math.min(addToExp, ExperienceTable.getInstance().getExpForLevel(experienceMaxLevel) - ExperienceTable.getInstance().getExpForLevel(this.getLevel()));
        }
        this.getStat().addExpAndSp(addToExp, addToSp, useVitality);
    }

    public void removeExpAndSp(long removeExp, int removeSp) {
        this.getStat().removeExpAndSp(removeExp, removeSp, true);
    }

    public void removeExpAndSp(long removeExp, int removeSp, boolean sendMessage) {
        this.getStat().removeExpAndSp(removeExp, removeSp, sendMessage);
    }

    @Override
    public void reduceCurrentHp(double value, L2Character attacker, boolean awake, boolean isDOT, Skill skill) {
        if (skill != null) {
            this.getStatus().reduceHp(value, attacker, awake, isDOT, skill.isToggle(), skill.getDmgDirectlyToHP());
        } else {
            this.getStatus().reduceHp(value, attacker, awake, isDOT, false, false);
        }
        if (this.getTrainedBeasts() != null) {
            for (L2TamedBeastInstance tamedBeast : this.getTrainedBeasts()) {
                tamedBeast.onOwnerGotAttacked(attacker);
            }
        }
    }

    public void broadcastSnoop(int type, String name, String _text) {
        if (!this._snoopListener.isEmpty()) {
            Snoop sn = new Snoop(this.getObjectId(), this.getName(), type, name, _text);
            for (L2PcInstance pci : this._snoopListener) {
                if (pci == null) continue;
                pci.sendPacket(sn);
            }
        }
    }

    public void addSnooper(L2PcInstance pci) {
        if (!this._snoopListener.contains((Object)pci)) {
            this._snoopListener.add((Object)pci);
        }
    }

    public void removeSnooper(L2PcInstance pci) {
        this._snoopListener.remove((Object)pci);
    }

    public void addSnooped(L2PcInstance pci) {
        if (!this._snoopedPlayer.contains((Object)pci)) {
            this._snoopedPlayer.add((Object)pci);
        }
    }

    public void removeSnooped(L2PcInstance pci) {
        this._snoopedPlayer.remove((Object)pci);
    }

    public void addHtmlAction(HtmlActionScope scope, String action) {
        this._htmlActionCaches[scope.ordinal()].add(action);
    }

    public void clearHtmlActions(HtmlActionScope scope) {
        this._htmlActionCaches[scope.ordinal()].clear();
    }

    public void setHtmlActionOriginObjectId(HtmlActionScope scope, int npcObjId) {
        if (npcObjId < 0) {
            throw new IllegalArgumentException();
        }
        this._htmlActionOriginObjectIds[scope.ordinal()] = npcObjId;
    }

    public int getLastHtmlActionOriginId() {
        return this._lastHtmlActionOriginObjId;
    }

    private boolean validateHtmlAction(Iterable<String> actionIter, String action) {
        for (String cachedAction : actionIter) {
            if (!(cachedAction.charAt(cachedAction.length() - 1) == '$' ? action.startsWith(cachedAction.substring(0, cachedAction.length() - 1).trim()) : cachedAction.equals(action))) continue;
            return true;
        }
        return false;
    }

    public int validateHtmlAction(String action) {
        for (int i = 0; i < this._htmlActionCaches.length; ++i) {
            if (!this.validateHtmlAction(this._htmlActionCaches[i], action)) continue;
            this._lastHtmlActionOriginObjId = this._htmlActionOriginObjectIds[i];
            return this._lastHtmlActionOriginObjId;
        }
        return -1;
    }

    public boolean validateItemManipulation(int objectId, String action) {
        L2ItemInstance item = this.getInventory().getItemByObjectId(objectId);
        if (item == null || item.getOwnerId() != this.getObjectId()) {
            _log.finest(this.getObjectId() + ": player tried to " + action + " item he is not owner of");
            return false;
        }
        if (this.hasSummon() && this.getSummon().getControlObjectId() == objectId || this.getMountObjectID() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ": player tried to " + action + " item controling pet");
            }
            return false;
        }
        if (this.getActiveEnchantItemId() == objectId) {
            if (Config.DEBUG) {
                _log.finest(this.getObjectId() + ":player tried to " + action + " an enchant scroll he was using");
            }
            return false;
        }
        return !CursedWeaponsManager.getInstance().isCursed(item.getId());
    }

    public boolean isInBoat() {
        return this._vehicle != null && this._vehicle.isBoat();
    }

    public L2BoatInstance getBoat() {
        return (L2BoatInstance)this._vehicle;
    }

    public boolean isInAirShip() {
        return this._vehicle != null && this._vehicle.isAirShip();
    }

    public L2AirShipInstance getAirShip() {
        return (L2AirShipInstance)this._vehicle;
    }

    public L2Vehicle getVehicle() {
        return this._vehicle;
    }

    public void setVehicle(L2Vehicle v) {
        if (v == null && this._vehicle != null) {
            this._vehicle.removePassenger(this);
        }
        this._vehicle = v;
    }

    public boolean isInVehicle() {
        return this._vehicle != null;
    }

    public void setInCrystallize(boolean inCrystallize) {
        this._inCrystallize = inCrystallize;
    }

    public boolean isInCrystallize() {
        return this._inCrystallize;
    }

    public Location getInVehiclePosition() {
        return this._inVehiclePosition;
    }

    public void setInVehiclePosition(Location pt) {
        this._inVehiclePosition = pt;
    }

    @Override
    public boolean deleteMe() {
        this.cleanup();
        this.storeMe();
        return super.deleteMe();
    }

    private synchronized void cleanup() {
        this.getEvents().onPlayerLogout();
        try {
            for (L2ZoneType zone : ZoneManager.getInstance().getZones(this)) {
                zone.onPlayerLogoutInside(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (!this.isOnline()) {
                _log.log(Level.SEVERE, "deleteMe() called on offline character " + this, new RuntimeException());
            }
            this.setOnlineStatus(false, true);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (Config.ENABLE_BLOCK_CHECKER_EVENT && this.getBlockCheckerArena() != -1) {
                HandysBlockCheckerManager.getInstance().onDisconnect(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this._isOnline = false;
            this.abortAttack();
            this.abortCast();
            this.stopMove(null);
            this.setDebug(null);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (this.getInventory().getItemByItemId(9819) != null) {
                Fort fort = FortManager.getInstance().getFort(this);
                if (fort != null) {
                    FortSiegeManager.getInstance().dropCombatFlag(this, fort.getResidenceId());
                } else {
                    int slot = this.getInventory().getSlotFromItem(this.getInventory().getItemByItemId(9819));
                    this.getInventory().unEquipItemInBodySlot(slot);
                    this.destroyItem("CombatFlag", this.getInventory().getItemByItemId(9819), null, true);
                }
            } else if (this.isCombatFlagEquipped()) {
                TerritoryWarManager.getInstance().dropCombatFlag(this, false, false);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            PartyMatchRoom room;
            PartyMatchWaitingList.getInstance().removePlayer(this);
            if (this._partyroom != 0 && (room = PartyMatchRoomList.getInstance().getRoom(this._partyroom)) != null) {
                room.deleteMember(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            if (this.isFlying()) {
                this.removeSkill(SkillData.getInstance().getSkill(4289, 1));
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            CommunityServerThread.getInstance().sendPacket(new WorldInfo(this, null, 2));
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.storeRecommendations();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.stopAllTimers();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.setIsTeleporting(false);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            RecipeController.getInstance().requestMakeItemAbort(this);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.setTarget(null);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.isChannelized()) {
            this.getSkillChannelized().abortChannelization();
        }
        this.getEffectList().stopAllToggles();
        L2WorldRegion oldRegion = this.getWorldRegion();
        if (oldRegion != null) {
            oldRegion.removeFromZones(this);
        }
        try {
            this.decayMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.isInParty()) {
            try {
                this.leaveParty();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (OlympiadManager.getInstance().isRegistered(this) || this.getOlympiadGameId() != -1) {
            OlympiadManager.getInstance().removeDisconnectedCompetitor(this);
        }
        if (this.hasSummon()) {
            try {
                this.getSummon().setRestoreSummon(true);
                this.getSummon().unSummon(this);
                if (this.hasSummon()) {
                    this.getSummon().broadcastNpcInfo(0);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (this.getClan() != null) {
            try {
                L2ClanMember clanMember = this.getClan().getClanMember(this.getObjectId());
                if (clanMember != null) {
                    clanMember.setPlayerInstance(null);
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        if (this.getActiveRequester() != null) {
            this.setActiveRequester(null);
            this.cancelActiveTrade();
        }
        if (this.getL2AccessLevel().isGm()) {
            try {
                AdminTable.getInstance().deleteGm(this);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        try {
            if (this.inObserverMode()) {
                this.setLocationInvisible(this._lastLoc);
            }
            if (this.getVehicle() != null) {
                this.getVehicle().oustPlayer(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            Instance inst;
            int instanceId = this.getInstanceId();
            if (instanceId != 0 && !Config.RESTORE_PLAYER_INSTANCE && (inst = InstanceManager.getInstance().getInstance(instanceId)) != null) {
                inst.removePlayer(this.getObjectId());
                Location loc = inst.getSpawnLoc();
                if (loc != null) {
                    int x = loc.getX() + Rnd.get(-30, 30);
                    int y = loc.getY() + Rnd.get(-30, 30);
                    this.setXYZInvisible(x, y, loc.getZ());
                    if (this.hasSummon()) {
                        this.getSummon().teleToLocation((ILocational)loc, true);
                        this.getSummon().setInstanceId(0);
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            TvTEvent.onLogout(this);
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.getInventory().deleteMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.clearWarehouse();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (Config.WAREHOUSE_CACHE) {
            WarehouseCacheManager.getInstance().remCacheTask(this);
        }
        try {
            this.getFreight().deleteMe();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        try {
            this.clearRefund();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.isCursedWeaponEquipped()) {
            try {
                CursedWeaponsManager.getInstance().getCursedWeapon(this._cursedWeaponEquippedId).setPlayer(null);
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "deleteMe()", e);
            }
        }
        try {
            this.getKnownList().removeAllKnownObjects();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "deleteMe()", e);
        }
        if (this.getClanId() > 0) {
            this.getClan().broadcastToOtherOnlineMembers(new PledgeShowMemberListUpdate(this), this);
        }
        for (L2PcInstance player : this._snoopedPlayer) {
            player.removeSnooper(this);
        }
        for (L2PcInstance player : this._snoopListener) {
            player.removeSnooped(this);
        }
        L2World.getInstance().removeObject(this);
        L2World.getInstance().removeFromAllPlayers(this);
        try {
            RegionBBSManager.getInstance().changeCommunityBoard();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on deleteMe() changeCommunityBoard: " + e.getMessage(), e);
        }
        try {
            this.notifyFriends();
            this.getBlockList().playerLogout();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on deleteMe() notifyFriends: " + e.getMessage(), e);
        }
    }

    public void startFishing(int _x, int _y, int _z) {
        this.stopMove(null);
        this.setIsImmobilized(true);
        this._fishing = true;
        this._fishx = _x;
        this._fishy = _y;
        this._fishz = _z;
        int lvl = this.getRandomFishLvl();
        int grade = this.getRandomFishGrade();
        int group = this.getRandomFishGroup(grade);
        List<L2Fish> fishs = FishData.getInstance().getFish(lvl, group, grade);
        if (fishs == null || fishs.isEmpty()) {
            this.sendMessage("Error - Fishes are not definied");
            this.endFishing(false);
            return;
        }
        int check = Rnd.get(fishs.size());
        this._fish = fishs.get(check).clone();
        fishs.clear();
        fishs = null;
        this.sendPacket(SystemMessageId.CAST_LINE_AND_START_FISHING);
        if (!GameTimeController.getInstance().isNight() && this._lure.isNightLure()) {
            this._fish.setFishGroup(-1);
        }
        this.broadcastPacket(new ExFishingStart(this, this._fish.getFishGroup(), _x, _y, _z, this._lure.isNightLure()));
        this.sendPacket(new PlaySound(1, "SF_P_01", 0, 0, 0, 0, 0));
        this.startLookingForFishTask();
    }

    public void stopLookingForFishTask() {
        if (this._taskforfish != null) {
            this._taskforfish.cancel(false);
            this._taskforfish = null;
        }
    }

    public void startLookingForFishTask() {
        if (!this.isDead() && this._taskforfish == null) {
            int checkDelay = 0;
            boolean isNoob = false;
            boolean isUpperGrade = false;
            if (this._lure != null) {
                int lureid = this._lure.getId();
                isNoob = this._fish.getFishGrade() == 0;
                boolean bl = isUpperGrade = this._fish.getFishGrade() == 2;
                if (lureid == 6519 || lureid == 6522 || lureid == 6525 || lureid == 8505 || lureid == 8508 || lureid == 8511) {
                    checkDelay = this._fish.getGutsCheckTime() * 133;
                } else if (lureid == 6520 || lureid == 6523 || lureid == 6526 || lureid >= 8505 && lureid <= 8513 || lureid >= 7610 && lureid <= 7613 || lureid >= 7807 && lureid <= 7809 || lureid >= 8484 && lureid <= 8486) {
                    checkDelay = this._fish.getGutsCheckTime() * 100;
                } else if (lureid == 6521 || lureid == 6524 || lureid == 6527 || lureid == 8507 || lureid == 8510 || lureid == 8513) {
                    checkDelay = this._fish.getGutsCheckTime() * 66;
                }
            }
            this._taskforfish = ThreadPoolManager.getInstance().scheduleEffectAtFixedRate(new LookingForFishTask(this, this._fish.getStartCombatTime(), this._fish.getFishGuts(), this._fish.getFishGroup(), isNoob, isUpperGrade), 10000L, checkDelay);
        }
    }

    private int getRandomFishGrade() {
        switch (this._lure.getId()) {
            case 7807: 
            case 7808: 
            case 7809: 
            case 8486: {
                return 0;
            }
            case 8485: 
            case 8506: 
            case 8509: 
            case 8512: {
                return 2;
            }
        }
        return 1;
    }

    private int getRandomFishGroup(int group) {
        int check = Rnd.get(100);
        int type = 1;
        block0 : switch (group) {
            case 0: {
                switch (this._lure.getId()) {
                    case 7807: {
                        if (check <= 54) {
                            type = 5;
                            break;
                        }
                        if (check <= 77) {
                            type = 4;
                            break;
                        }
                        type = 6;
                        break;
                    }
                    case 7808: {
                        if (check <= 54) {
                            type = 4;
                            break;
                        }
                        if (check <= 77) {
                            type = 6;
                            break;
                        }
                        type = 5;
                        break;
                    }
                    case 7809: {
                        if (check <= 54) {
                            type = 6;
                            break;
                        }
                        if (check <= 77) {
                            type = 5;
                            break;
                        }
                        type = 4;
                        break;
                    }
                    case 8486: {
                        type = check <= 33 ? 4 : (check <= 66 ? 5 : 6);
                    }
                }
                break;
            }
            case 1: {
                switch (this._lure.getId()) {
                    case 7610: 
                    case 7611: 
                    case 7612: 
                    case 7613: {
                        type = 3;
                        break;
                    }
                    case 6519: 
                    case 6520: 
                    case 6521: 
                    case 8505: 
                    case 8507: {
                        if (check <= 54) {
                            type = 1;
                            break;
                        }
                        if (check <= 74) {
                            type = 0;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6522: 
                    case 6523: 
                    case 6524: 
                    case 8508: 
                    case 8510: {
                        if (check <= 54) {
                            type = 0;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 2;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 6525: 
                    case 6526: 
                    case 6527: 
                    case 8511: 
                    case 8513: {
                        if (check <= 55) {
                            type = 2;
                            break;
                        }
                        if (check <= 74) {
                            type = 1;
                            break;
                        }
                        if (check <= 94) {
                            type = 0;
                            break;
                        }
                        type = 3;
                        break;
                    }
                    case 8484: {
                        type = check <= 33 ? 0 : (check <= 66 ? 1 : 2);
                    }
                }
                break;
            }
            case 2: {
                switch (this._lure.getId()) {
                    case 8506: {
                        if (check <= 54) {
                            type = 8;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 7;
                            break block0;
                        }
                        type = 9;
                        break block0;
                    }
                    case 8509: {
                        if (check <= 54) {
                            type = 7;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 9;
                            break block0;
                        }
                        type = 8;
                        break block0;
                    }
                    case 8512: {
                        if (check <= 54) {
                            type = 9;
                            break block0;
                        }
                        if (check <= 77) {
                            type = 8;
                            break block0;
                        }
                        type = 7;
                        break block0;
                    }
                    case 8485: {
                        type = check <= 33 ? 7 : (check <= 66 ? 8 : 9);
                    }
                }
            }
        }
        return type;
    }

    private int getRandomFishLvl() {
        int randomlvl;
        int skilllvl = this.getSkillLevel(1315);
        BuffInfo info = this.getEffectList().getBuffInfoBySkillId(2274);
        if (info != null) {
            skilllvl = (int)info.getSkill().getPower();
        }
        if (skilllvl <= 0) {
            return 1;
        }
        int check = Rnd.get(100);
        if (check <= 50) {
            randomlvl = skilllvl;
        } else if (check <= 85) {
            randomlvl = skilllvl - 1;
            if (randomlvl <= 0) {
                randomlvl = 1;
            }
        } else {
            randomlvl = skilllvl + 1;
            if (randomlvl > 27) {
                randomlvl = 27;
            }
        }
        return randomlvl;
    }

    public void startFishCombat(boolean isNoob, boolean isUpperGrade) {
        this._fishCombat = new L2Fishing(this, this._fish, isNoob, isUpperGrade);
    }

    public void endFishing(boolean win) {
        this._fishing = false;
        this._fishx = 0;
        this._fishy = 0;
        this._fishz = 0;
        if (this._fishCombat == null) {
            this.sendPacket(SystemMessageId.BAIT_LOST_FISH_GOT_AWAY);
        }
        this._fishCombat = null;
        this._lure = null;
        this.broadcastPacket(new ExFishingEnd(win, this));
        this.sendPacket(SystemMessageId.REEL_LINE_AND_STOP_FISHING);
        this.setIsImmobilized(false);
        this.stopLookingForFishTask();
    }

    public L2Fishing getFishCombat() {
        return this._fishCombat;
    }

    public int getFishx() {
        return this._fishx;
    }

    public int getFishy() {
        return this._fishy;
    }

    public int getFishz() {
        return this._fishz;
    }

    public void setLure(L2ItemInstance lure) {
        this._lure = lure;
    }

    public L2ItemInstance getLure() {
        return this._lure;
    }

    public int getInventoryLimit() {
        int ivlim = this.isGM() ? Config.INVENTORY_MAXIMUM_GM : (this.getRace() == PcRace.Dwarf ? Config.INVENTORY_MAXIMUM_DWARF : Config.INVENTORY_MAXIMUM_NO_DWARF);
        return ivlim += (int)this.getStat().calcStat(Stats.INV_LIM, 0.0, null, null);
    }

    public int getWareHouseLimit() {
        int whlim = this.getRace() == PcRace.Dwarf ? Config.WAREHOUSE_SLOTS_DWARF : Config.WAREHOUSE_SLOTS_NO_DWARF;
        return whlim += (int)this.getStat().calcStat(Stats.WH_LIM, 0.0, null, null);
    }

    public int getPrivateSellStoreLimit() {
        int pslim = this.getRace() == PcRace.Dwarf ? Config.MAX_PVTSTORESELL_SLOTS_DWARF : Config.MAX_PVTSTORESELL_SLOTS_OTHER;
        return pslim += (int)this.getStat().calcStat(Stats.P_SELL_LIM, 0.0, null, null);
    }

    public int getPrivateBuyStoreLimit() {
        int pblim = this.getRace() == PcRace.Dwarf ? Config.MAX_PVTSTOREBUY_SLOTS_DWARF : Config.MAX_PVTSTOREBUY_SLOTS_OTHER;
        return pblim += (int)this.getStat().calcStat(Stats.P_BUY_LIM, 0.0, null, null);
    }

    public int getDwarfRecipeLimit() {
        int recdlim = Config.DWARF_RECIPE_LIMIT;
        return recdlim += (int)this.getStat().calcStat(Stats.REC_D_LIM, 0.0, null, null);
    }

    public int getCommonRecipeLimit() {
        int recclim = Config.COMMON_RECIPE_LIMIT;
        return recclim += (int)this.getStat().calcStat(Stats.REC_C_LIM, 0.0, null, null);
    }

    public int getMountNpcId() {
        return this._mountNpcId;
    }

    public int getMountLevel() {
        return this._mountLevel;
    }

    public void setMountObjectID(int newID) {
        this._mountObjectID = newID;
    }

    public int getMountObjectID() {
        return this._mountObjectID;
    }

    public SkillUseHolder getCurrentSkill() {
        return this._currentSkill;
    }

    public void setCurrentSkill(Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            this._currentSkill = null;
            return;
        }
        this._currentSkill = new SkillUseHolder(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillUseHolder getCurrentPetSkill() {
        return this._currentPetSkill;
    }

    public void setCurrentPetSkill(Skill currentSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (currentSkill == null) {
            this._currentPetSkill = null;
            return;
        }
        this._currentPetSkill = new SkillUseHolder(currentSkill, ctrlPressed, shiftPressed);
    }

    public SkillUseHolder getQueuedSkill() {
        return this._queuedSkill;
    }

    public void setQueuedSkill(Skill queuedSkill, boolean ctrlPressed, boolean shiftPressed) {
        if (queuedSkill == null) {
            this._queuedSkill = null;
            return;
        }
        this._queuedSkill = new SkillUseHolder(queuedSkill, ctrlPressed, shiftPressed);
    }

    public boolean isJailed() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.JAIL) || PunishmentManager.getInstance().hasPunishment(this.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.JAIL) || PunishmentManager.getInstance().hasPunishment(this.getIPAddress(), PunishmentAffect.IP, PunishmentType.JAIL);
    }

    public boolean isChatBanned() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.CHAT_BAN) || PunishmentManager.getInstance().hasPunishment(this.getAccountName(), PunishmentAffect.ACCOUNT, PunishmentType.CHAT_BAN) || PunishmentManager.getInstance().hasPunishment(this.getIPAddress(), PunishmentAffect.IP, PunishmentType.CHAT_BAN);
    }

    public void startFameTask(long delay, int fameFixRate) {
        if (this.getLevel() < 40 || this.getClassId().level() < 2) {
            return;
        }
        if (this._fameTask == null) {
            this._fameTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new FameTask(this, fameFixRate), delay, delay);
        }
    }

    public void stopFameTask() {
        if (this._fameTask != null) {
            this._fameTask.cancel(false);
            this._fameTask = null;
        }
    }

    public void startVitalityTask() {
        if (Config.ENABLE_VITALITY && this._vitalityTask == null) {
            this._vitalityTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new VitalityTask(this), 1000L, 60000L);
        }
    }

    public void stopVitalityTask() {
        if (this._vitalityTask != null) {
            this._vitalityTask.cancel(false);
            this._vitalityTask = null;
        }
    }

    public int getPowerGrade() {
        return this._powerGrade;
    }

    public void setPowerGrade(int power) {
        this._powerGrade = power;
    }

    public boolean isCursedWeaponEquipped() {
        return this._cursedWeaponEquippedId != 0;
    }

    public void setCursedWeaponEquippedId(int value) {
        this._cursedWeaponEquippedId = value;
    }

    public int getCursedWeaponEquippedId() {
        return this._cursedWeaponEquippedId;
    }

    public boolean isCombatFlagEquipped() {
        return this._combatFlagEquippedId;
    }

    public void setCombatFlagEquipped(boolean value) {
        this._combatFlagEquippedId = value;
    }

    public int getChargedSouls() {
        return this._souls;
    }

    public void increaseSouls(int count) {
        this._souls += count;
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOUR_SOUL_HAS_INCREASED_BY_S1_SO_IT_IS_NOW_AT_S2);
        sm.addInt(count);
        sm.addInt(this._souls);
        this.sendPacket(sm);
        this.restartSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean decreaseSouls(int count, Skill skill) {
        this._souls -= count;
        if (this.getChargedSouls() < 0) {
            this._souls = 0;
        }
        if (this.getChargedSouls() == 0) {
            this.stopSoulTask();
        } else {
            this.restartSoulTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return true;
    }

    public void clearSouls() {
        this._souls = 0;
        this.stopSoulTask();
        this.sendPacket(new EtcStatusUpdate(this));
    }

    private void restartSoulTask() {
        if (this._soulTask != null) {
            this._soulTask.cancel(false);
            this._soulTask = null;
        }
        this._soulTask = ThreadPoolManager.getInstance().scheduleGeneral(new ResetSoulsTask(this), 600000L);
    }

    public void stopSoulTask() {
        if (this._soulTask != null) {
            this._soulTask.cancel(false);
            this._soulTask = null;
        }
    }

    public int getDeathPenaltyBuffLevel() {
        return this._deathPenaltyBuffLevel;
    }

    public void setDeathPenaltyBuffLevel(int level) {
        this._deathPenaltyBuffLevel = level;
    }

    public void calculateDeathPenaltyBuffLevel(L2Character killer) {
        if (!(this.getKarma() <= 0 && Rnd.get(1, 100) > Config.DEATH_PENALTY_CHANCE || killer instanceof L2PcInstance || this.canOverrideCond(PcCondOverride.DEATH_PENALTY) || this.isCharmOfLuckAffected() && killer.isRaid() || this.isPhoenixBlessed() || this.isLucky() || this.isBlockedFromDeathPenalty() || this.isInsideZone(ZoneId.PVP) || this.isInsideZone(ZoneId.SIEGE))) {
            this.increaseDeathPenaltyBuffLevel();
        }
    }

    public void increaseDeathPenaltyBuffLevel() {
        Skill skill;
        if (this.getDeathPenaltyBuffLevel() >= 15) {
            return;
        }
        if (this.getDeathPenaltyBuffLevel() != 0 && (skill = SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel())) != null) {
            this.removeSkill(skill, true);
        }
        ++this._deathPenaltyBuffLevel;
        this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
        this.sendPacket(new EtcStatusUpdate(this));
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
        sm.addInt(this.getDeathPenaltyBuffLevel());
        this.sendPacket(sm);
    }

    public void reduceDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() <= 0) {
            return;
        }
        Skill skill = SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel());
        if (skill != null) {
            this.removeSkill(skill, true);
        }
        --this._deathPenaltyBuffLevel;
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
            this.sendPacket(new EtcStatusUpdate(this));
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.DEATH_PENALTY_LEVEL_S1_ADDED);
            sm.addInt(this.getDeathPenaltyBuffLevel());
            this.sendPacket(sm);
        } else {
            this.sendPacket(new EtcStatusUpdate(this));
            this.sendPacket(SystemMessageId.DEATH_PENALTY_LIFTED);
        }
    }

    public void restoreDeathPenaltyBuffLevel() {
        if (this.getDeathPenaltyBuffLevel() > 0) {
            this.addSkill(SkillData.getInstance().getSkill(5076, this.getDeathPenaltyBuffLevel()), false);
        }
    }

    @Override
    public L2PcInstance getActingPlayer() {
        return this;
    }

    @Override
    public final void sendDamageMessage(L2Character target, int damage, boolean mcrit, boolean pcrit, boolean miss) {
        SystemMessage sm;
        if (miss) {
            SystemMessage sm2;
            if (target.isPlayer()) {
                sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_EVADED_C2_ATTACK);
                sm2.addPcName(target.getActingPlayer());
                sm2.addCharName(this);
                target.sendPacket(sm2);
            }
            sm2 = SystemMessage.getSystemMessage(SystemMessageId.C1_ATTACK_WENT_ASTRAY);
            sm2.addPcName(this);
            this.sendPacket(sm2);
            return;
        }
        if (pcrit) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_HAD_CRITICAL_HIT);
            sm.addPcName(this);
            this.sendPacket(sm);
        }
        if (mcrit) {
            this.sendPacket(SystemMessageId.CRITICAL_HIT_MAGIC);
        }
        if (this.isInOlympiadMode() && target.isPlayer() && target.getActingPlayer().isInOlympiadMode() && target.getActingPlayer().getOlympiadGameId() == this.getOlympiadGameId()) {
            OlympiadGameManager.getInstance().notifyCompetitorDamage(this, damage);
        }
        if (target.isInvul() && !target.isNpc()) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.ATTACK_WAS_BLOCKED);
        } else if (target.isDoor() || target instanceof L2ControlTowerInstance) {
            sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_DID_S1_DMG);
            sm.addInt(damage);
        } else {
            sm = SystemMessage.getSystemMessage(SystemMessageId.C1_DONE_S3_DAMAGE_TO_C2);
            sm.addPcName(this);
            sm.addCharName(target);
            sm.addInt(damage);
        }
        this.sendPacket(sm);
    }

    public void setAgathionId(int npcId) {
        this._agathionId = npcId;
    }

    public int getAgathionId() {
        return this._agathionId;
    }

    public int getVitalityPoints() {
        return this.getStat().getVitalityPoints();
    }

    public int getVitalityLevel() {
        return this.getStat().getVitalityLevel();
    }

    public void setVitalityPoints(int points, boolean quiet) {
        this.getStat().setVitalityPoints(points, quiet);
    }

    public void updateVitalityPoints(float points, boolean useRates, boolean quiet) {
        this.getStat().updateVitalityPoints(points, useRates, quiet);
    }

    public void setExpGainOn(boolean value) {
        this._expGainOn = value;
    }

    public void checkItemRestriction() {
        for (int i = 0; i < 25; ++i) {
            L2ItemInstance equippedItem = this.getInventory().getPaperdollItem(i);
            if (equippedItem == null || equippedItem.getItem().checkCondition(this, this, false)) continue;
            this.getInventory().unEquipItemInSlot(i);
            InventoryUpdate iu = new InventoryUpdate();
            iu.addModifiedItem(equippedItem);
            this.sendPacket(iu);
            SystemMessage sm = null;
            if (equippedItem.getItem().getBodyPart() == 8192) {
                this.sendPacket(SystemMessageId.CLOAK_REMOVED_BECAUSE_ARMOR_SET_REMOVED);
                return;
            }
            if (equippedItem.getEnchantLevel() > 0) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EQUIPMENT_S1_S2_REMOVED);
                sm.addInt(equippedItem.getEnchantLevel());
                sm.addItemName(equippedItem);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISARMED);
                sm.addItemName(equippedItem);
            }
            this.sendPacket(sm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransformSkill(int id) {
        if (this._transformAllowedSkills == null) {
            L2PcInstance l2PcInstance = this;
            synchronized (l2PcInstance) {
                if (this._transformAllowedSkills == null) {
                    this._transformAllowedSkills = new HashSet<Integer>();
                }
            }
        }
        this._transformAllowedSkills.add(id);
    }

    public boolean hasTransformSkill(int id) {
        return this._transformAllowedSkills != null && this._transformAllowedSkills.contains(id);
    }

    public synchronized void removeAllTransformSkills() {
        this._transformAllowedSkills = null;
    }

    protected void startFeed(int npcId) {
        boolean bl = this._canFeed = npcId > 0;
        if (!this.isMounted()) {
            return;
        }
        if (this.hasSummon()) {
            this.setCurrentFeed(((L2PetInstance)this.getSummon()).getCurrentFed());
            this._controlItemId = this.getSummon().getControlObjectId();
            this.sendPacket(new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume()));
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PetFeedTask(this), 10000L, 10000L);
            }
        } else if (this._canFeed) {
            this.setCurrentFeed(this.getMaxFeed());
            SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
            this.sendPacket(sg);
            if (!this.isDead()) {
                this._mountFeedTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new PetFeedTask(this), 10000L, 10000L);
            }
        }
    }

    public void stopFeed() {
        if (this._mountFeedTask != null) {
            this._mountFeedTask.cancel(false);
            this._mountFeedTask = null;
        }
    }

    private final void clearPetData() {
        this._data = null;
    }

    public final L2PetData getPetData(int npcId) {
        if (this._data == null) {
            this._data = PetDataTable.getInstance().getPetData(npcId);
        }
        return this._data;
    }

    private final L2PetLevelData getPetLevelData(int npcId) {
        if (this._leveldata == null) {
            this._leveldata = PetDataTable.getInstance().getPetData(npcId).getPetLevelData(this.getMountLevel());
        }
        return this._leveldata;
    }

    public int getCurrentFeed() {
        return this._curFeed;
    }

    public int getFeedConsume() {
        if (this.isAttackingNow()) {
            return this.getPetLevelData(this._mountNpcId).getPetFeedBattle();
        }
        return this.getPetLevelData(this._mountNpcId).getPetFeedNormal();
    }

    public void setCurrentFeed(int num) {
        boolean lastHungryState = this.isHungry();
        this._curFeed = num > this.getMaxFeed() ? this.getMaxFeed() : num;
        SetupGauge sg = new SetupGauge(3, this.getCurrentFeed() * 10000 / this.getFeedConsume(), this.getMaxFeed() * 10000 / this.getFeedConsume());
        this.sendPacket(sg);
        if (lastHungryState != this.isHungry()) {
            this.broadcastUserInfo();
        }
    }

    private int getMaxFeed() {
        return this.getPetLevelData(this._mountNpcId).getPetMaxFeed();
    }

    public boolean isHungry() {
        return this._canFeed ? (float)this.getCurrentFeed() < (float)this.getPetData(this.getMountNpcId()).getHungryLimit() / 100.0f * (float)this.getPetLevelData(this.getMountNpcId()).getPetMaxFeed() : false;
    }

    public void enteredNoLanding(int delay) {
        this._dismountTask = ThreadPoolManager.getInstance().scheduleGeneral(new DismountTask(this), delay * 1000);
    }

    public void exitedNoLanding() {
        if (this._dismountTask != null) {
            this._dismountTask.cancel(true);
            this._dismountTask = null;
        }
    }

    public void storePetFood(int petId) {
        if (this._controlItemId != 0 && petId != 0) {
            String req = "UPDATE pets SET fed=? WHERE item_obj_id = ?";
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(req);){
                statement.setInt(1, this.getCurrentFeed());
                statement.setInt(2, this._controlItemId);
                statement.executeUpdate();
                this._controlItemId = 0;
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Failed to store Pet [NpcId: " + petId + "] data", e);
            }
        }
    }

    public void setIsInSiege(boolean b) {
        this._isInSiege = b;
    }

    public boolean isInSiege() {
        return this._isInSiege;
    }

    public void setIsInHideoutSiege(boolean isInHideoutSiege) {
        this._isInHideoutSiege = isInHideoutSiege;
    }

    public boolean isInHideoutSiege() {
        return this._isInHideoutSiege;
    }

    public FloodProtectors getFloodProtectors() {
        return this.getClient().getFloodProtectors();
    }

    public boolean isFlyingMounted() {
        return this.isTransformed() && this.getTransformation().isFlying();
    }

    public int getCharges() {
        return this._charges.get();
    }

    public void increaseCharges(int count, int max) {
        if (this._charges.get() >= max) {
            this.sendPacket(SystemMessageId.FORCE_MAXLEVEL_REACHED);
            return;
        }
        this.restartChargeTask();
        if (this._charges.addAndGet(count) >= max) {
            this._charges.set(max);
            this.sendPacket(SystemMessageId.FORCE_MAXLEVEL_REACHED);
        } else {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FORCE_INCREASED_TO_S1);
            sm.addInt(this._charges.get());
            this.sendPacket(sm);
        }
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public boolean decreaseCharges(int count) {
        if (this._charges.get() < count) {
            return false;
        }
        if (this._charges.addAndGet(-count) == 0) {
            this.stopChargeTask();
        } else {
            this.restartChargeTask();
        }
        this.sendPacket(new EtcStatusUpdate(this));
        return true;
    }

    public void clearCharges() {
        this._charges.set(0);
        this.sendPacket(new EtcStatusUpdate(this));
    }

    private void restartChargeTask() {
        if (this._chargeTask != null) {
            this._chargeTask.cancel(false);
            this._chargeTask = null;
        }
        this._chargeTask = ThreadPoolManager.getInstance().scheduleGeneral(new ResetChargesTask(this), 600000L);
    }

    public void stopChargeTask() {
        if (this._chargeTask != null) {
            this._chargeTask.cancel(false);
            this._chargeTask = null;
        }
    }

    public void teleportBookmarkModify(int ix, int icon, String tag, String name) {
        TeleportBookmark bookmark = this._tpbookmarks.get(ix);
        if (bookmark != null) {
            int id = bookmark.getId();
            bookmark.setIcon(icon);
            bookmark.setTag(tag);
            bookmark.setName(name);
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(UPDATE_TP_BOOKMARK);){
                statement.setInt(1, icon);
                statement.setString(2, tag);
                statement.setString(3, name);
                statement.setInt(4, this.getObjectId());
                statement.setInt(5, id);
                statement.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not update character teleport bookmark data: " + e.getMessage(), e);
            }
            this.sendPacket(new ExGetBookMarkInfoPacket(this));
        }
    }

    public void teleportBookmarkDelete(int ix) {
        TeleportBookmark bookmark = this._tpbookmarks.remove(ix);
        if (bookmark != null) {
            int id = bookmark.getId();
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement statement = con.prepareStatement(DELETE_TP_BOOKMARK);){
                statement.setInt(1, this.getObjectId());
                statement.setInt(2, id);
                statement.execute();
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "Could not delete character teleport bookmark data: " + e.getMessage(), e);
            }
            this.sendPacket(new ExGetBookMarkInfoPacket(this));
        }
    }

    public void teleportBookmarkGo(int ix) {
        TeleportBookmark bookmark = this._tpbookmarks.get(ix);
        if (bookmark != null) {
            if (!this.teleportBookmarkCondition(0)) {
                return;
            }
            int myTeleportScroll = 20025;
            if (!this.destroyItemByItemId("Consume", 20025, 1L, null, false)) {
                myTeleportScroll = 13302;
                if (!this.destroyItemByItemId("Consume", 13302, 1L, null, false)) {
                    myTeleportScroll = 13016;
                    if (!this.destroyItemByItemId("Consume", 13016, 1L, null, false)) {
                        this.sendPacket(SystemMessageId.YOU_CANNOT_TELEPORT_BECAUSE_YOU_DO_NOT_HAVE_A_TELEPORT_ITEM);
                        return;
                    }
                }
            }
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
            sm.addItemName(myTeleportScroll);
            this.sendPacket(sm);
            this.teleToLocation((ILocational)bookmark, false);
            this.sendPacket(new ExGetBookMarkInfoPacket(this));
        }
    }

    public boolean teleportBookmarkCondition(int type) {
        if (this.isInCombat()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_BATTLE);
            return false;
        }
        if (this.isInSiege() || this.getSiegeState() != 0) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING);
            return false;
        }
        if (this.isInDuel()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_DURING_A_DUEL);
            return false;
        }
        if (this.isFlying()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_FLYING);
            return false;
        }
        if (this.isInOlympiadMode()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_PARTICIPATING_IN_AN_OLYMPIAD_MATCH);
            return false;
        }
        if (this.isParalyzed()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_PARALYZED);
            return false;
        }
        if (this.isDead()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_WHILE_YOU_ARE_DEAD);
            return false;
        }
        if (type == 1 && (this.isIn7sDungeon() || this.isInParty() && this.getParty().isInDimensionalRift())) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            return false;
        }
        if (this.isInWater()) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_UNDERWATER);
            return false;
        }
        if (type == 1 && (this.isInsideZone(ZoneId.SIEGE) || this.isInsideZone(ZoneId.CLAN_HALL) || this.isInsideZone(ZoneId.JAIL) || this.isInsideZone(ZoneId.CASTLE) || this.isInsideZone(ZoneId.NO_SUMMON_FRIEND) || this.isInsideZone(ZoneId.FORT))) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            return false;
        }
        if (this.isInsideZone(ZoneId.NO_BOOKMARK) || this.isInBoat() || this.isInAirShip()) {
            if (type == 0) {
                this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_IN_THIS_AREA);
            } else if (type == 1) {
                this.sendPacket(SystemMessageId.YOU_CANNOT_USE_MY_TELEPORTS_TO_REACH_THIS_AREA);
            }
            return false;
        }
        return true;
    }

    public void teleportBookmarkAdd(int x, int y, int z, int icon, String tag, String name) {
        int MY_TELEPORT_FLAG = 20033;
        if (!this.teleportBookmarkCondition(1)) {
            return;
        }
        int size = this._tpbookmarks.size();
        if (size >= this._bookmarkslot) {
            this.sendPacket(SystemMessageId.YOU_HAVE_NO_SPACE_TO_SAVE_THE_TELEPORT_LOCATION);
            return;
        }
        if (this.getInventory().getInventoryItemCount(20033, 0) == 0L) {
            this.sendPacket(SystemMessageId.YOU_CANNOT_BOOKMARK_THIS_LOCATION_BECAUSE_YOU_DO_NOT_HAVE_A_MY_TELEPORT_FLAG);
            return;
        }
        int id = size == 0 ? 1 : this._tpbookmarks.get(size).getId() + 1;
        this._tpbookmarks.add(new TeleportBookmark(id, x, y, z, icon, tag, name));
        this.destroyItem("Consume", this.getInventory().getItemByItemId(20033).getObjectId(), 1L, null, false);
        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
        sm.addItemName(20033);
        this.sendPacket(sm);
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(INSERT_TP_BOOKMARK);){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, id);
            statement.setInt(3, x);
            statement.setInt(4, y);
            statement.setInt(5, z);
            statement.setInt(6, icon);
            statement.setString(7, tag);
            statement.setString(8, name);
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Could not insert character teleport bookmark data: " + e.getMessage(), e);
        }
        this.sendPacket(new ExGetBookMarkInfoPacket(this));
    }

    public void restoreTeleportBookmark() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement(RESTORE_TP_BOOKMARK);){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    this._tpbookmarks.add(new TeleportBookmark(rset.getInt("Id"), rset.getInt("x"), rset.getInt("y"), rset.getInt("z"), rset.getInt("icon"), rset.getString("tag"), rset.getString("name")));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Failed restoing character teleport bookmark.", e);
        }
    }

    @Override
    public void sendInfo(L2PcInstance activeChar) {
        if (this.isInBoat()) {
            this.setXYZ(this.getBoat().getPosition());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = (Integer)this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = (Integer)activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new GetOnVehicle(this.getObjectId(), this.getBoat().getObjectId(), this.getInVehiclePosition()));
        } else if (this.isInAirShip()) {
            this.setXYZ(this.getAirShip().getPosition());
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = (Integer)this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = (Integer)activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
            activeChar.sendPacket(new ExGetOnAirShip(this, this.getAirShip()));
        } else {
            activeChar.sendPacket(new CharInfo(this));
            activeChar.sendPacket(new ExBrExtraUserInfo(this));
            int relation1 = this.getRelation(activeChar);
            int relation2 = activeChar.getRelation(this);
            Integer oldrelation = (Integer)this.getKnownList().getKnownRelations().get(activeChar.getObjectId());
            if (oldrelation != null && oldrelation != relation1) {
                activeChar.sendPacket(new RelationChanged(this, relation1, this.isAutoAttackable(activeChar)));
                if (this.hasSummon()) {
                    activeChar.sendPacket(new RelationChanged(this.getSummon(), relation1, this.isAutoAttackable(activeChar)));
                }
            }
            if ((oldrelation = (Integer)activeChar.getKnownList().getKnownRelations().get(this.getObjectId())) != null && oldrelation != relation2) {
                this.sendPacket(new RelationChanged(activeChar, relation2, activeChar.isAutoAttackable(this)));
                if (activeChar.hasSummon()) {
                    this.sendPacket(new RelationChanged(activeChar.getSummon(), relation2, activeChar.isAutoAttackable(this)));
                }
            }
        }
        switch (this.getPrivateStoreType()) {
            case SELL: {
                activeChar.sendPacket(new PrivateStoreMsgSell(this));
                break;
            }
            case PACKAGE_SELL: {
                activeChar.sendPacket(new ExPrivateStoreSetWholeMsg(this));
                break;
            }
            case BUY: {
                activeChar.sendPacket(new PrivateStoreMsgBuy(this));
                break;
            }
            case MANUFACTURE: {
                activeChar.sendPacket(new RecipeShopMsg(this));
            }
        }
    }

    public void showQuestMovie(int id) {
        if (this._movieId > 0) {
            return;
        }
        this.abortAttack();
        this.abortCast();
        this.stopMove(null);
        this._movieId = id;
        this.sendPacket(new ExStartScenePlayer(id));
    }

    public boolean isAllowedToEnchantSkills() {
        if (this.isLocked()) {
            return false;
        }
        if (this.isTransformed() || this.isInStance()) {
            return false;
        }
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this)) {
            return false;
        }
        if (this.isCastingNow() || this.isCastingSimultaneouslyNow()) {
            return false;
        }
        return !this.isInBoat() && !this.isInAirShip();
    }

    public void setCreateDate(Calendar createDate) {
        this._createDate = createDate;
    }

    public Calendar getCreateDate() {
        return this._createDate;
    }

    public int checkBirthDay() {
        GregorianCalendar now = new GregorianCalendar();
        Calendar birth = (Calendar)this._createDate.clone();
        if (birth.get(2) == 1 && birth.get(5) == 29 && !now.isLeapYear(now.get(1))) {
            birth.add(5, -1);
        }
        for (int i = 0; i <= 5; ++i) {
            if (now.get(2) == birth.get(2) && now.get(5) == birth.get(5) && now.get(1) != birth.get(1)) {
                return i;
            }
            now.add(5, 1);
        }
        return -1;
    }

    public List<Integer> getFriendList() {
        return this._friendList;
    }

    public void restoreFriendList() {
        this._friendList.clear();
        String sqlQuery = "SELECT friendId FROM character_friends WHERE charId=? AND relation=0";
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT friendId FROM character_friends WHERE charId=? AND relation=0");){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    int friendId = rset.getInt("friendId");
                    if (friendId == this.getObjectId()) continue;
                    this._friendList.add((Object)friendId);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error found in " + this.getName() + "'s FriendList: " + e.getMessage(), e);
        }
    }

    private void notifyFriends() {
        FriendStatusPacket pkt = new FriendStatusPacket(this.getObjectId());
        Iterator i$ = this._friendList.iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            L2PcInstance friend = L2World.getInstance().getPlayer(id);
            if (friend == null) continue;
            friend.sendPacket(pkt);
        }
    }

    public boolean isSilenceMode() {
        return this._silenceMode;
    }

    public boolean isSilenceMode(int playerObjId) {
        if (Config.SILENCE_MODE_EXCLUDE && this._silenceMode && this._silenceModeExcluded != null) {
            return !this._silenceModeExcluded.contains(playerObjId);
        }
        return this._silenceMode;
    }

    public void setSilenceMode(boolean mode) {
        this._silenceMode = mode;
        if (this._silenceModeExcluded != null) {
            this._silenceModeExcluded.clear();
        }
        this.sendPacket(new EtcStatusUpdate(this));
    }

    public void addSilenceModeExcluded(int playerObjId) {
        if (this._silenceModeExcluded == null) {
            this._silenceModeExcluded = new ArrayList<Integer>(1);
        }
        this._silenceModeExcluded.add(playerObjId);
    }

    private void storeRecipeShopList() {
        if (this.hasManufactureShop()) {
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
                try (PreparedStatement st = con.prepareStatement("DELETE FROM character_recipeshoplist WHERE charId=?");){
                    st.setInt(1, this.getObjectId());
                    st.execute();
                }
                st = con.prepareStatement("INSERT INTO character_recipeshoplist (`charId`, `recipeId`, `price`, `index`) VALUES (?, ?, ?, ?)");
                var4_7 = null;
                try {
                    int i = 1;
                    for (L2ManufactureItem item : this._manufactureItems.values()) {
                        st.setInt(1, this.getObjectId());
                        st.setInt(2, item.getRecipeId());
                        st.setLong(3, item.getCost());
                        st.setInt(4, i++);
                        st.addBatch();
                    }
                    st.executeBatch();
                }
                catch (Throwable throwable) {
                    var4_7 = throwable;
                    throw throwable;
                }
                finally {
                    if (st != null) {
                        if (var4_7 != null) {
                            try {
                                st.close();
                            }
                            catch (Throwable x2) {
                                var4_7.addSuppressed(x2);
                            }
                        } else {
                            st.close();
                        }
                    }
                }
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, "Could not store recipe shop for playerId " + this.getObjectId() + ": ", e);
            }
        }
    }

    private void restoreRecipeShopList() {
        if (this._manufactureItems != null) {
            this._manufactureItems.clear();
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT * FROM character_recipeshoplist WHERE charId=? ORDER BY `index`");){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                while (rset.next()) {
                    this.getManufactureItems().put(rset.getInt("recipeId"), new L2ManufactureItem(rset.getInt("recipeId"), rset.getLong("price")));
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore recipe shop list data for playerId: " + this.getObjectId(), e);
        }
    }

    public double getCollisionRadius() {
        if (this.isMounted() && this.getMountNpcId() > 0) {
            return NpcData.getInstance().getTemplate(this.getMountNpcId()).getfCollisionRadius();
        }
        if (this.isTransformed()) {
            return this.getTransformation().getCollisionRadius(this);
        }
        return this.getAppearance().getSex() ? this.getBaseTemplate().getFCollisionRadiusFemale() : this.getBaseTemplate().getfCollisionRadius();
    }

    public double getCollisionHeight() {
        if (this.isMounted() && this.getMountNpcId() > 0) {
            return NpcData.getInstance().getTemplate(this.getMountNpcId()).getfCollisionHeight();
        }
        if (this.isTransformed()) {
            return this.getTransformation().getCollisionHeight(this);
        }
        return this.getAppearance().getSex() ? this.getBaseTemplate().getFCollisionHeightFemale() : this.getBaseTemplate().getfCollisionHeight();
    }

    public final int getClientX() {
        return this._clientX;
    }

    public final int getClientY() {
        return this._clientY;
    }

    public final int getClientZ() {
        return this._clientZ;
    }

    public final int getClientHeading() {
        return this._clientHeading;
    }

    public final void setClientX(int val) {
        this._clientX = val;
    }

    public final void setClientY(int val) {
        this._clientY = val;
    }

    public final void setClientZ(int val) {
        this._clientZ = val;
    }

    public final void setClientHeading(int val) {
        this._clientHeading = val;
    }

    public final boolean isFalling(int z) {
        if (this.isDead() || this.isFlying() || this.isFlyingMounted() || this.isInsideZone(ZoneId.WATER)) {
            return false;
        }
        if (System.currentTimeMillis() < this._fallingTimestamp) {
            return true;
        }
        int deltaZ = this.getZ() - z;
        if (deltaZ <= this.getBaseTemplate().getSafeFallHeight()) {
            return false;
        }
        int damage = (int)Formulas.calcFallDam(this, deltaZ);
        if (damage > 0) {
            this.reduceCurrentHp(Math.min((double)damage, this.getCurrentHp() - 1.0), null, false, true, null);
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.FALL_DAMAGE_S1);
            sm.addInt(damage);
            this.sendPacket(sm);
        }
        this.setFalling();
        return false;
    }

    public final void setFalling() {
        this._fallingTimestamp = System.currentTimeMillis() + 10000L;
    }

    public int getMovieId() {
        return this._movieId;
    }

    public void setMovieId(int id) {
        this._movieId = id;
    }

    public void updateLastItemAuctionRequest() {
        this._lastItemAuctionInfoRequest = System.currentTimeMillis();
    }

    public boolean isItemAuctionPolling() {
        return System.currentTimeMillis() - this._lastItemAuctionInfoRequest < 2000L;
    }

    @Override
    public boolean isMovementDisabled() {
        return super.isMovementDisabled() || this._movieId > 0;
    }

    private void restoreUISettings() {
        this._uiKeySettings = new UIKeysSettings(this.getObjectId());
    }

    private void storeUISettings() {
        if (this._uiKeySettings == null) {
            return;
        }
        if (!this._uiKeySettings.isSaved()) {
            this._uiKeySettings.saveInDB();
        }
    }

    public UIKeysSettings getUISettings() {
        return this._uiKeySettings;
    }

    public String getHtmlPrefix() {
        if (!Config.L2JMOD_MULTILANG_ENABLE) {
            return null;
        }
        return this._htmlPrefix;
    }

    public String getLang() {
        return this._lang;
    }

    public boolean setLang(String lang) {
        boolean result = false;
        if (Config.L2JMOD_MULTILANG_ENABLE) {
            if (Config.L2JMOD_MULTILANG_ALLOWED.contains(lang)) {
                this._lang = lang;
                result = true;
            } else {
                this._lang = Config.L2JMOD_MULTILANG_DEFAULT;
            }
            this._htmlPrefix = "data/lang/" + this._lang + "/";
        } else {
            this._lang = null;
            this._htmlPrefix = null;
        }
        return result;
    }

    public long getOfflineStartTime() {
        return this._offlineShopStart;
    }

    public void setOfflineStartTime(long time) {
        this._offlineShopStart = time;
    }

    public void removeFromBossZone() {
        try {
            for (L2BossZone _zone : GrandBossManager.getInstance().getZones()) {
                _zone.removePlayer(this);
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Exception on removeFromBossZone(): " + e.getMessage(), e);
        }
    }

    public void checkPlayerSkills() {
        for (Skill skill : this.getSkills().values()) {
            int lvlDiff;
            L2SkillLearn learn = SkillTreesData.getInstance().getClassSkill(skill.getId(), skill.getLevel() % 100, this.getClassId());
            if (learn == null) continue;
            int n = lvlDiff = skill.getId() == CommonSkill.EXPERTISE.getId() ? 0 : 9;
            if (this.getLevel() >= learn.getGetLevel() - lvlDiff) continue;
            this.deacreaseSkillLevel(skill, lvlDiff);
        }
    }

    private void deacreaseSkillLevel(Skill skill, int lvlDiff) {
        int nextLevel = -1;
        Map<Integer, L2SkillLearn> skillTree = SkillTreesData.getInstance().getCompleteClassSkillTree(this.getClassId());
        for (L2SkillLearn sl : skillTree.values()) {
            if (sl.getSkillId() != skill.getId() || nextLevel >= sl.getSkillLevel() || this.getLevel() < sl.getGetLevel() - lvlDiff) continue;
            nextLevel = sl.getSkillLevel();
        }
        if (nextLevel == -1) {
            _log.info("Removing skill " + skill + " from player " + this.toString());
            this.removeSkill(skill, true);
        } else {
            _log.info("Decreasing skill " + skill + " to " + nextLevel + " for player " + this.toString());
            this.addSkill(SkillData.getInstance().getSkill(skill.getId(), nextLevel), true);
        }
    }

    public boolean canMakeSocialAction() {
        return this.getPrivateStoreType() == PrivateStoreType.NONE && this.getActiveRequester() == null && !this.isAlikeDead() && !this.isAllSkillsDisabled() && !this.isInDuel() && !this.isCastingNow() && !this.isCastingSimultaneouslyNow() && this.getAI().getIntention() == CtrlIntention.AI_INTENTION_IDLE && !AttackStanceTaskManager.getInstance().hasAttackStanceTask(this) && !this.isInOlympiadMode();
    }

    public void setMultiSocialAction(int id, int targetId) {
        this._multiSociaAction = id;
        this._multiSocialTarget = targetId;
    }

    public int getMultiSociaAction() {
        return this._multiSociaAction;
    }

    public int getMultiSocialTarget() {
        return this._multiSocialTarget;
    }

    public ArrayList<TeleportBookmark> getTeleportBookmarks() {
        return this._tpbookmarks;
    }

    public int getBookmarkslot() {
        return this._bookmarkslot;
    }

    public int getQuestInventoryLimit() {
        return Config.INVENTORY_MAXIMUM_QUEST_ITEMS;
    }

    public boolean canAttackCharacter(L2Character cha) {
        if (cha instanceof L2Attackable) {
            return true;
        }
        if (cha instanceof L2Playable) {
            if (cha.isInsideZone(ZoneId.PVP) && !cha.isInsideZone(ZoneId.SIEGE)) {
                return true;
            }
            L2PcInstance target = cha instanceof L2Summon ? ((L2Summon)cha).getOwner() : (L2PcInstance)cha;
            if (this.isInDuel() && target.isInDuel() && target.getDuelId() == this.getDuelId()) {
                return true;
            }
            if (this.isInParty() && target.isInParty()) {
                if (this.getParty() == target.getParty()) {
                    return false;
                }
                if ((this.getParty().getCommandChannel() != null || target.getParty().getCommandChannel() != null) && this.getParty().getCommandChannel() == target.getParty().getCommandChannel()) {
                    return false;
                }
            } else if (this.getClan() != null && target.getClan() != null) {
                if (this.getClanId() == target.getClanId()) {
                    return false;
                }
                if ((this.getAllyId() > 0 || target.getAllyId() > 0) && this.getAllyId() == target.getAllyId()) {
                    return false;
                }
                if (this.getClan().isAtWarWith(target.getClan().getId()) && target.getClan().isAtWarWith(this.getClan().getId())) {
                    return true;
                }
            } else if ((this.getClan() == null || target.getClan() == null) && target.getPvpFlag() == 0 && target.getKarma() == 0) {
                return false;
            }
        }
        return true;
    }

    public boolean isInventoryUnder90(boolean includeQuestInv) {
        return (double)this.getInventory().getSize(includeQuestInv) <= (double)this.getInventoryLimit() * 0.9;
    }

    public boolean havePetInvItems() {
        return this._petItems;
    }

    public void setPetInvItems(boolean haveit) {
        this._petItems = haveit;
    }

    private void restorePetInventoryItems() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT object_id FROM `items` WHERE `owner_id`=? AND (`loc`='PET' OR `loc`='PET_EQUIP') LIMIT 1;");){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                this.setPetInvItems(rset.next() && rset.getInt("object_id") > 0);
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not check Items in Pet Inventory for playerId: " + this.getObjectId(), e);
        }
    }

    public String getAdminConfirmCmd() {
        return this._adminConfirmCmd;
    }

    public void setAdminConfirmCmd(String adminConfirmCmd) {
        this._adminConfirmCmd = adminConfirmCmd;
    }

    public void setBlockCheckerArena(byte arena) {
        this._handysBlockCheckerEventArena = arena;
    }

    public int getBlockCheckerArena() {
        return this._handysBlockCheckerEventArena;
    }

    private long loadRecommendations() {
        long _time_left = 0L;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT rec_have,rec_left,time_left FROM character_reco_bonus WHERE charId=? LIMIT 1");){
            statement.setInt(1, this.getObjectId());
            try (ResultSet rset = statement.executeQuery();){
                if (rset.next()) {
                    this.setRecomHave(rset.getInt("rec_have"));
                    this.setRecomLeft(rset.getInt("rec_left"));
                    _time_left = rset.getLong("time_left");
                } else {
                    _time_left = 3600000L;
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not restore Recommendations for player: " + this.getObjectId(), e);
        }
        return _time_left;
    }

    public void storeRecommendations() {
        long recoTaskEnd = 0L;
        if (this._recoBonusTask != null) {
            recoTaskEnd = Math.max(0L, this._recoBonusTask.getDelay(TimeUnit.MILLISECONDS));
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("INSERT INTO character_reco_bonus (charId,rec_have,rec_left,time_left) VALUES (?,?,?,?) ON DUPLICATE KEY UPDATE rec_have=?, rec_left=?, time_left=?");){
            statement.setInt(1, this.getObjectId());
            statement.setInt(2, this.getRecomHave());
            statement.setInt(3, this.getRecomLeft());
            statement.setLong(4, recoTaskEnd);
            statement.setInt(5, this.getRecomHave());
            statement.setInt(6, this.getRecomLeft());
            statement.setLong(7, recoTaskEnd);
            statement.execute();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "Could not update Recommendations for player: " + this.getObjectId(), e);
        }
    }

    public void checkRecoBonusTask() {
        long taskTime = this.loadRecommendations();
        if (taskTime > 0L) {
            if (taskTime == 3600000L) {
                this.setRecomLeft(this.getRecomLeft() + 20);
            }
            this._recoBonusTask = ThreadPoolManager.getInstance().scheduleGeneral(new RecoBonusTaskEnd(this), taskTime);
        }
        this._recoGiveTask = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(new RecoGiveTask(this), 0x6DDD00L, 3600000L);
        this.storeRecommendations();
    }

    public void stopRecoBonusTask() {
        if (this._recoBonusTask != null) {
            this._recoBonusTask.cancel(false);
            this._recoBonusTask = null;
        }
    }

    public void stopRecoGiveTask() {
        if (this._recoGiveTask != null) {
            this._recoGiveTask.cancel(false);
            this._recoGiveTask = null;
        }
    }

    public boolean isRecoTwoHoursGiven() {
        return this._recoTwoHoursGiven;
    }

    public void setRecoTwoHoursGiven(boolean val) {
        this._recoTwoHoursGiven = val;
    }

    public int getRecomBonusTime() {
        if (this._recoBonusTask != null) {
            return (int)Math.max(0L, this._recoBonusTask.getDelay(TimeUnit.SECONDS));
        }
        return 0;
    }

    public int getRecomBonusType() {
        return 0;
    }

    public void setLastPetitionGmName(String gmName) {
        this._lastPetitionGmName = gmName;
    }

    public String getLastPetitionGmName() {
        return this._lastPetitionGmName;
    }

    public L2ContactList getContactList() {
        return this._contactList;
    }

    public void setEventStatus() {
        this.eventStatus = new PlayerEventHolder(this);
    }

    public void setEventStatus(PlayerEventHolder pes) {
        this.eventStatus = pes;
    }

    public PlayerEventHolder getEventStatus() {
        return this.eventStatus;
    }

    public long getNotMoveUntil() {
        return this._notMoveUntil;
    }

    public void updateNotMoveUntil() {
        this._notMoveUntil = System.currentTimeMillis() + (long)Config.PLAYER_MOVEMENT_BLOCK_TIME;
    }

    @Override
    public boolean isPlayer() {
        return true;
    }

    @Override
    public boolean isChargedShot(ShotType type) {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        return weapon != null && weapon.isChargedShot(type);
    }

    @Override
    public void setChargedShot(ShotType type, boolean charged) {
        L2ItemInstance weapon = this.getActiveWeaponInstance();
        if (weapon != null) {
            weapon.setChargedShot(type, charged);
        }
    }

    public final Skill getCustomSkill(int skillId) {
        return this._customSkills != null ? this._customSkills.get(skillId) : null;
    }

    private final void addCustomSkill(Skill skill) {
        if (skill != null && skill.getDisplayId() != skill.getId()) {
            if (this._customSkills == null) {
                this._customSkills = new FastMap().shared();
            }
            this._customSkills.put(skill.getDisplayId(), skill);
        }
    }

    private final void removeCustomSkill(Skill skill) {
        if (skill != null && this._customSkills != null && skill.getDisplayId() != skill.getId()) {
            this._customSkills.remove(skill.getDisplayId());
        }
    }

    @Override
    public boolean canRevive() {
        return this._canRevive;
    }

    @Override
    public void setCanRevive(boolean val) {
        this._canRevive = val;
    }

    private boolean fireEquipmentListeners(boolean isEquiped, L2ItemInstance item) {
        if (item != null) {
            EquipmentEvent event = new EquipmentEvent();
            event.setEquipped(!isEquiped);
            event.setItem(item);
            for (EquipmentListener listener : this._equipmentListeners) {
                if (listener.onEquip(event)) continue;
                return false;
            }
            for (EquipmentListener listener : GLOBAL_EQUIPMENT_LISTENERS) {
                if (listener.onEquip(event)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean fireTransformListeners(Transform transformation, boolean isTransforming) {
        if (transformation != null && !this._transformListeners.isEmpty()) {
            TransformEvent event = new TransformEvent();
            event.setTransformation(transformation);
            event.setTransforming(isTransforming);
            for (TransformListener listener : this._transformListeners) {
                if (listener.onTransform(event)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean fireHennaListeners(L2Henna henna, boolean isAdding) {
        if (henna != null && !HENNA_LISTENERS.isEmpty()) {
            HennaEvent event = new HennaEvent();
            event.setAdd(isAdding);
            event.setHenna(henna);
            event.setPlayer(this);
            for (HennaListener listener : HENNA_LISTENERS) {
                if (listener.onRemoveHenna(event)) continue;
                return false;
            }
        }
        return true;
    }

    private void fireProfessionChangeListeners(L2PcTemplate t) {
        if (!this._professionChangeListeners.isEmpty() || !GLOBAL_PROFESSION_CHANGE_LISTENERS.isEmpty()) {
            ProfessionChangeEvent event = null;
            event = new ProfessionChangeEvent();
            event.setPlayer(this);
            event.setSubClass(this.isSubClassActive());
            event.setTemplate(t);
            for (ProfessionChangeListener listener : this._professionChangeListeners) {
                listener.professionChanged(event);
            }
            for (ProfessionChangeListener listener : GLOBAL_PROFESSION_CHANGE_LISTENERS) {
                listener.professionChanged(event);
            }
        }
    }

    @Override
    public boolean isOnEvent() {
        for (EventListener listener : this._eventListeners) {
            if (!listener.isOnEvent()) continue;
            return true;
        }
        return super.isOnEvent();
    }

    public boolean isBlockedFromExit() {
        for (EventListener listener : this._eventListeners) {
            if (!listener.isOnEvent() || !listener.isBlockingExit()) continue;
            return true;
        }
        return false;
    }

    public boolean isBlockedFromDeathPenalty() {
        for (EventListener listener : this._eventListeners) {
            if (!listener.isOnEvent() || !listener.isBlockingDeathPenalty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canOverrideCond(PcCondOverride excs) {
        return (this._exceptions & (long)excs.getMask()) != 0L;
    }

    public void setOverrideCond(long masks) {
        this._exceptions = masks;
    }

    public void addOverrideCond(PcCondOverride exc) {
        this._exceptions |= (long)exc.getMask();
        this.getVariables().set(COND_OVERRIDE_KEY, Long.toString(this._exceptions));
    }

    public void removeOverridedCond(PcCondOverride exc) {
        this._exceptions &= (long)(~exc.getMask());
        this.getVariables().set(COND_OVERRIDE_KEY, Long.toString(this._exceptions));
    }

    public boolean hasVariables() {
        return this.getScript(PlayerVariables.class) != null;
    }

    public PlayerVariables getVariables() {
        PlayerVariables vars = this.getScript(PlayerVariables.class);
        return vars != null ? vars : this.addScript(new PlayerVariables(this.getObjectId()));
    }

    public boolean hasAccountVariables() {
        return this.getScript(AccountVariables.class) != null;
    }

    public AccountVariables getAccountVariables() {
        AccountVariables vars = this.getScript(AccountVariables.class);
        return vars != null ? vars : this.addScript(new AccountVariables(this.getAccountName()));
    }

    public static void addHennaListener(HennaListener listener) {
        if (!HENNA_LISTENERS.contains((Object)listener)) {
            HENNA_LISTENERS.add((Object)listener);
        }
    }

    public static void removeHennaListener(HennaListener listener) {
        HENNA_LISTENERS.remove((Object)listener);
    }

    public void addEquipmentListener(EquipmentListener listener) {
        if (!this._equipmentListeners.contains((Object)listener)) {
            this._equipmentListeners.add((Object)listener);
        }
    }

    public void removeEquipmentListener(EquipmentListener listener) {
        this._equipmentListeners.remove((Object)listener);
    }

    public static void addGlobalEquipmentListener(EquipmentListener listener) {
        if (!GLOBAL_EQUIPMENT_LISTENERS.contains((Object)listener)) {
            GLOBAL_EQUIPMENT_LISTENERS.add((Object)listener);
        }
    }

    public static void removeGlobalEquipmentListener(EquipmentListener listener) {
        GLOBAL_EQUIPMENT_LISTENERS.remove((Object)listener);
    }

    public void addTransformListener(TransformListener listener) {
        if (!this._transformListeners.contains((Object)listener)) {
            this._transformListeners.add((Object)listener);
        }
    }

    public void removeTransformListener(TransformListener listener) {
        this._transformListeners.remove((Object)listener);
    }

    public void addProfessionChangeListener(ProfessionChangeListener listener) {
        if (!this._professionChangeListeners.contains((Object)listener)) {
            this._professionChangeListeners.add((Object)listener);
        }
    }

    public void removeProfessionChangeListener(ProfessionChangeListener listener) {
        this._professionChangeListeners.remove((Object)listener);
    }

    public static void addGlobalProfessionChangeListener(ProfessionChangeListener listener) {
        if (!GLOBAL_PROFESSION_CHANGE_LISTENERS.contains((Object)listener)) {
            GLOBAL_PROFESSION_CHANGE_LISTENERS.add((Object)listener);
        }
    }

    public static void removeGlobalProfessionChangeListener(ProfessionChangeListener listener) {
        GLOBAL_PROFESSION_CHANGE_LISTENERS.remove((Object)listener);
    }

    public void addEventListener(EventListener listener) {
        this._eventListeners.add((Object)listener);
    }

    public void removeEventListener(EventListener listener) {
        this._eventListeners.remove((Object)listener);
    }

    public void removeEventListener(Class<? extends EventListener> clazz) {
        Iterator it = this._eventListeners.iterator();
        while (it.hasNext()) {
            EventListener event = (EventListener)it.next();
            if (event.getClass() != clazz) continue;
            it.remove();
        }
    }

    public Collection<EventListener> getEventListeners() {
        return this._eventListeners;
    }

    @Override
    public boolean isInCategory(CategoryType type) {
        return CategoryData.getInstance().isInCategory(type, this.getClassId().getId());
    }

    @Override
    public int getId() {
        return 0;
    }

    public boolean isPartyBanned() {
        return PunishmentManager.getInstance().hasPunishment(this.getObjectId(), PunishmentAffect.CHARACTER, PunishmentType.PARTY_BAN);
    }

    public boolean addAction(PlayerAction act) {
        if (!this.hasAction(act)) {
            this._actionMask |= act.getMask();
            return true;
        }
        return false;
    }

    public boolean removeAction(PlayerAction act) {
        if (this.hasAction(act)) {
            this._actionMask &= ~act.getMask();
            return true;
        }
        return false;
    }

    public boolean hasAction(PlayerAction act) {
        return (this._actionMask & act.getMask()) == act.getMask();
    }

    public class AIAccessor
    extends L2Character.AIAccessor {
        public L2PcInstance getPlayer() {
            return L2PcInstance.this;
        }

        public void doPickupItem(L2Object object) {
            L2PcInstance.this.doPickupItem(object);
        }

        public void doInteract(L2Character target) {
            L2PcInstance.this.doInteract(target);
        }

        @Override
        public void doAttack(L2Character target) {
            super.doAttack(target);
            this.getPlayer().setRecentFakeDeath(false);
        }

        @Override
        public void doCast(Skill skill) {
            super.doCast(skill);
            this.getPlayer().setRecentFakeDeath(false);
        }
    }
}

