/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.stat;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.PcCondOverride;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Calculator;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.MoveType;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.model.stats.TraitType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import java.util.Arrays;

public class CharStat {
    protected final L2Character _activeChar;
    private long _exp = 0L;
    private int _sp = 0;
    private byte _level = 1;
    private final float[] _attackTraits = new float[TraitType.values().length];
    private final int[] _attackTraitsCount = new int[TraitType.values().length];
    private final float[] _defenceTraits = new float[TraitType.values().length];
    private final int[] _defenceTraitsCount = new int[TraitType.values().length];
    private final int[] _traitsInvul = new int[TraitType.values().length];

    public CharStat(L2Character activeChar) {
        this._activeChar = activeChar;
        Arrays.fill(this._attackTraits, 1.0f);
        Arrays.fill(this._defenceTraits, 1.0f);
    }

    public final double calcStat(Stats stat, double init) {
        return this.calcStat(stat, init, null, null);
    }

    public final double calcStat(Stats stat, double init, L2Character target, Skill skill) {
        double val;
        if (stat == null) {
            return init;
        }
        int id = stat.ordinal();
        Calculator c = this._activeChar.getCalculators()[id];
        if (c == null || c.size() == 0) {
            return init;
        }
        if (this.getActiveChar().isPlayer() && this.getActiveChar().isTransformed() && (val = this.getActiveChar().getTransformation().getStat(this.getActiveChar().getActingPlayer(), stat)) > 0.0) {
            init = val;
        }
        Env env = new Env();
        env.setCharacter(this._activeChar);
        env.setTarget(target);
        env.setSkill(skill);
        env.setValue(init);
        c.calc(env);
        if (env.getValue() <= 0.0) {
            switch (stat) {
                case MAX_HP: 
                case MAX_MP: 
                case MAX_CP: 
                case MAGIC_DEFENCE: 
                case POWER_DEFENCE: 
                case POWER_ATTACK: 
                case MAGIC_ATTACK: 
                case POWER_ATTACK_SPEED: 
                case MAGIC_ATTACK_SPEED: 
                case SHIELD_DEFENCE: 
                case STAT_CON: 
                case STAT_DEX: 
                case STAT_INT: 
                case STAT_MEN: 
                case STAT_STR: 
                case STAT_WIT: {
                    env.setValue(1.0);
                }
            }
        }
        return env.getValue();
    }

    public int getAccuracy() {
        return (int)Math.round(this.calcStat(Stats.ACCURACY_COMBAT, 0.0, null, null));
    }

    public L2Character getActiveChar() {
        return this._activeChar;
    }

    public final float getAttackSpeedMultiplier() {
        return (float)(1.1 * (double)this.getPAtkSpd() / (double)this._activeChar.getTemplate().getBasePAtkSpd());
    }

    public final int getCON() {
        return (int)this.calcStat(Stats.STAT_CON, this._activeChar.getTemplate().getBaseCON());
    }

    public final double getCriticalDmg(L2Character target, double init) {
        return this.calcStat(Stats.CRITICAL_DAMAGE, init, target, null);
    }

    public int getCriticalHit(L2Character target, Skill skill) {
        int val = (int)this.calcStat(Stats.CRITICAL_RATE, this._activeChar.getTemplate().getBaseCritRate(), target, skill);
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, Config.MAX_PCRIT_RATE);
        }
        return val;
    }

    public final int getDEX() {
        return (int)this.calcStat(Stats.STAT_DEX, this._activeChar.getTemplate().getBaseDEX());
    }

    public int getEvasionRate(L2Character target) {
        int val = (int)Math.round(this.calcStat(Stats.EVASION_RATE, 0.0, target, null));
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, Config.MAX_EVASION);
        }
        return val;
    }

    public long getExp() {
        return this._exp;
    }

    public void setExp(long value) {
        this._exp = value;
    }

    public int getINT() {
        return (int)this.calcStat(Stats.STAT_INT, this._activeChar.getTemplate().getBaseINT());
    }

    public byte getLevel() {
        return this._level;
    }

    public void setLevel(byte value) {
        this._level = value;
    }

    public final int getMagicalAttackRange(Skill skill) {
        if (skill != null) {
            return (int)this.calcStat(Stats.MAGIC_ATTACK_RANGE, skill.getCastRange(), null, skill);
        }
        return this._activeChar.getTemplate().getBaseAttackRange();
    }

    public int getMaxCp() {
        return (int)this.calcStat(Stats.MAX_CP, this._activeChar.getTemplate().getBaseCpMax());
    }

    public int getMaxRecoverableCp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_CP, this.getMaxCp());
    }

    public int getMaxHp() {
        return (int)this.calcStat(Stats.MAX_HP, this._activeChar.getTemplate().getBaseHpMax());
    }

    public int getMaxRecoverableHp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_HP, this.getMaxHp());
    }

    public int getMaxMp() {
        return (int)this.calcStat(Stats.MAX_MP, this._activeChar.getTemplate().getBaseMpMax());
    }

    public int getMaxRecoverableMp() {
        return (int)this.calcStat(Stats.MAX_RECOVERABLE_MP, this.getMaxMp());
    }

    public int getMAtk(L2Character target, Skill skill) {
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_ATK;
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Config.RAID_MATTACK_MULTIPLIER);
        }
        return (int)this.calcStat(Stats.MAGIC_ATTACK, (float)this._activeChar.getTemplate().getBaseMAtk() * bonusAtk, target, skill);
    }

    public int getMAtkSpd() {
        float bonusSpdAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusSpdAtk = Config.L2JMOD_CHAMPION_SPD_ATK;
        }
        double val = this.calcStat(Stats.MAGIC_ATTACK_SPEED, (float)this._activeChar.getTemplate().getBaseMAtkSpd() * bonusSpdAtk);
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, (double)Config.MAX_MATK_SPEED);
        }
        if (val > (double)Config.LIMIT_MATK_SPD && this._activeChar instanceof L2PcInstance) {
            val = Config.LIMIT_MATK_SPD;
        }
        return (int)val;
    }

    public final int getMCriticalHit(L2Character target, Skill skill) {
        int val = (int)this.calcStat(Stats.MCRITICAL_RATE, 1.0, target, skill) * 10;
        if (!this._activeChar.canOverrideCond(PcCondOverride.MAX_STATS_VALUE)) {
            val = Math.min(val, Config.MAX_MCRIT_RATE);
        }
        return val;
    }

    public int getMDef(L2Character target, Skill skill) {
        double defence = this._activeChar.getTemplate().getBaseMDef();
        if (this._activeChar.isRaid()) {
            defence *= Config.RAID_MDEFENCE_MULTIPLIER;
        }
        return (int)this.calcStat(Stats.MAGIC_DEFENCE, defence, target, skill);
    }

    public final int getMEN() {
        return (int)this.calcStat(Stats.STAT_MEN, this._activeChar.getTemplate().getBaseMEN());
    }

    public final float getMovementSpeedMultiplier() {
        float baseSpeed = this._activeChar.isInsideZone(ZoneId.WATER) ? this.getBaseMoveSpeed(this._activeChar.isRunning() ? MoveType.FAST_SWIM : MoveType.SLOW_SWIM) : this.getBaseMoveSpeed(this._activeChar.isRunning() ? MoveType.RUN : MoveType.WALK);
        if (baseSpeed == 0.0f) {
            return 1.0f;
        }
        return this.getMoveSpeed() / baseSpeed;
    }

    public float getBaseMoveSpeed(MoveType type) {
        return this._activeChar.getTemplate().getBaseMoveSpeed(type);
    }

    public float getMoveSpeed() {
        if (this._activeChar.isInsideZone(ZoneId.WATER)) {
            return this._activeChar.isRunning() ? (float)this.getSwimRunSpeed() : (float)this.getSwimWalkSpeed();
        }
        return this._activeChar.isRunning() ? (float)this.getRunSpeed() : (float)this.getWalkSpeed();
    }

    public final double getMReuseRate(Skill skill) {
        return this.calcStat(Stats.MAGIC_REUSE_RATE, 1.0, null, skill);
    }

    public int getPAtk(L2Character target) {
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_ATK;
        }
        if (this._activeChar.isRaid()) {
            bonusAtk = (float)((double)bonusAtk * Config.RAID_PATTACK_MULTIPLIER);
        }
        return (int)this.calcStat(Stats.POWER_ATTACK, (float)this._activeChar.getTemplate().getBasePAtk() * bonusAtk, target, null);
    }

    public int getPAtkSpd() {
        int val;
        float bonusAtk = 1.0f;
        if (Config.L2JMOD_CHAMPION_ENABLE && this._activeChar.isChampion()) {
            bonusAtk = Config.L2JMOD_CHAMPION_SPD_ATK;
        }
        if ((val = (int)Math.round(this.calcStat(Stats.POWER_ATTACK_SPEED, (float)this._activeChar.getTemplate().getBasePAtkSpd() * bonusAtk, null, null))) > Config.LIMIT_PATK_SPD && this._activeChar instanceof L2PcInstance) {
            val = Config.LIMIT_PATK_SPD;
        }
        return val;
    }

    public int getPDef(L2Character target) {
        return (int)this.calcStat(Stats.POWER_DEFENCE, this._activeChar.isRaid() ? (double)this._activeChar.getTemplate().getBasePDef() * Config.RAID_PDEFENCE_MULTIPLIER : (double)this._activeChar.getTemplate().getBasePDef(), target, null);
    }

    public final int getPhysicalAttackRange() {
        L2Weapon weapon = this._activeChar.getActiveWeaponItem();
        int baseAttackRange = this._activeChar.isTransformed() && this._activeChar.isPlayer() ? this._activeChar.getTransformation().getBaseAttackRange(this._activeChar.getActingPlayer()) : (weapon != null ? weapon.getBaseAttackRange() : this._activeChar.getTemplate().getBaseAttackRange());
        return (int)this.calcStat(Stats.POWER_ATTACK_RANGE, baseAttackRange, null, null);
    }

    public int getPhysicalAttackAngle() {
        L2Weapon weapon = this._activeChar.getActiveWeaponItem();
        int baseAttackAngle = weapon != null ? weapon.getBaseAttackAngle() : 120;
        return baseAttackAngle;
    }

    public final double getWeaponReuseModifier(L2Character target) {
        return this.calcStat(Stats.ATK_REUSE, 1.0, target, null);
    }

    public int getRunSpeed() {
        float baseRunSpd;
        float f = baseRunSpd = this._activeChar.isInsideZone(ZoneId.WATER) ? (float)this.getSwimRunSpeed() : this.getBaseMoveSpeed(MoveType.RUN);
        if (baseRunSpd == 0.0f) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.MOVE_SPEED, baseRunSpd, null, null));
    }

    public int getSwimRunSpeed() {
        float baseRunSpd = this.getBaseMoveSpeed(MoveType.FAST_SWIM);
        if (baseRunSpd == 0.0f) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.MOVE_SPEED, baseRunSpd, null, null));
    }

    public final int getShldDef() {
        return (int)this.calcStat(Stats.SHIELD_DEFENCE, 0.0);
    }

    public int getSp() {
        return this._sp;
    }

    public void setSp(int value) {
        this._sp = value;
    }

    public final int getSTR() {
        return (int)this.calcStat(Stats.STAT_STR, this._activeChar.getTemplate().getBaseSTR());
    }

    public int getWalkSpeed() {
        float baseWalkSpd;
        float f = baseWalkSpd = this._activeChar.isInsideZone(ZoneId.WATER) ? (float)this.getSwimWalkSpeed() : this.getBaseMoveSpeed(MoveType.WALK);
        if (baseWalkSpd == 0.0f) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.MOVE_SPEED, baseWalkSpd));
    }

    public int getSwimWalkSpeed() {
        float baseWalkSpd = this.getBaseMoveSpeed(MoveType.SLOW_SWIM);
        if (baseWalkSpd == 0.0f) {
            return 0;
        }
        return (int)Math.round(this.calcStat(Stats.MOVE_SPEED, baseWalkSpd));
    }

    public final int getWIT() {
        return (int)this.calcStat(Stats.STAT_WIT, this._activeChar.getTemplate().getBaseWIT());
    }

    public final int getMpConsume(Skill skill) {
        if (skill == null) {
            return 1;
        }
        double mpConsume = skill.getMpConsume();
        double nextDanceMpCost = Math.ceil((double)skill.getMpConsume() / 2.0);
        if (skill.isDance() && Config.DANCE_CONSUME_ADDITIONAL_MP && this._activeChar != null && this._activeChar.getDanceCount() > 0) {
            mpConsume += (double)this._activeChar.getDanceCount() * nextDanceMpCost;
        }
        mpConsume = this.calcStat(Stats.MP_CONSUME, mpConsume, null, skill);
        if (skill.isDance()) {
            return (int)this.calcStat(Stats.DANCE_MP_CONSUME_RATE, mpConsume);
        }
        if (skill.isMagic()) {
            return (int)this.calcStat(Stats.MAGICAL_MP_CONSUME_RATE, mpConsume);
        }
        return (int)this.calcStat(Stats.PHYSICAL_MP_CONSUME_RATE, mpConsume);
    }

    public final int getMpInitialConsume(Skill skill) {
        if (skill == null) {
            return 1;
        }
        double mpConsume = this.calcStat(Stats.MP_CONSUME, skill.getMpInitialConsume(), null, skill);
        if (skill.isDance()) {
            return (int)this.calcStat(Stats.DANCE_MP_CONSUME_RATE, mpConsume);
        }
        if (skill.isMagic()) {
            return (int)this.calcStat(Stats.MAGICAL_MP_CONSUME_RATE, mpConsume);
        }
        return (int)this.calcStat(Stats.PHYSICAL_MP_CONSUME_RATE, mpConsume);
    }

    public byte getAttackElement() {
        L2ItemInstance weaponInstance = this._activeChar.getActiveWeaponInstance();
        if (weaponInstance != null && weaponInstance.getAttackElementType() >= 0) {
            return weaponInstance.getAttackElementType();
        }
        int tempVal = 0;
        int[] stats = new int[]{0, 0, 0, 0, 0, 0};
        int returnVal = -2;
        stats[0] = (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().getBaseFire());
        stats[1] = (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().getBaseWater());
        stats[2] = (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().getBaseWind());
        stats[3] = (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().getBaseEarth());
        stats[4] = (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().getBaseHoly());
        stats[5] = (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().getBaseDark());
        for (int x = 0; x < 6; x = (int)((byte)(x + 1))) {
            if (stats[x] <= tempVal) continue;
            returnVal = x;
            tempVal = stats[x];
        }
        return (byte)returnVal;
    }

    public int getAttackElementValue(byte attackAttribute) {
        switch (attackAttribute) {
            case 0: {
                return (int)this.calcStat(Stats.FIRE_POWER, this._activeChar.getTemplate().getBaseFire());
            }
            case 1: {
                return (int)this.calcStat(Stats.WATER_POWER, this._activeChar.getTemplate().getBaseWater());
            }
            case 2: {
                return (int)this.calcStat(Stats.WIND_POWER, this._activeChar.getTemplate().getBaseWind());
            }
            case 3: {
                return (int)this.calcStat(Stats.EARTH_POWER, this._activeChar.getTemplate().getBaseEarth());
            }
            case 4: {
                return (int)this.calcStat(Stats.HOLY_POWER, this._activeChar.getTemplate().getBaseHoly());
            }
            case 5: {
                return (int)this.calcStat(Stats.DARK_POWER, this._activeChar.getTemplate().getBaseDark());
            }
        }
        return 0;
    }

    public int getDefenseElementValue(byte defenseAttribute) {
        switch (defenseAttribute) {
            case 0: {
                return (int)this.calcStat(Stats.FIRE_RES, this._activeChar.getTemplate().getBaseFireRes());
            }
            case 1: {
                return (int)this.calcStat(Stats.WATER_RES, this._activeChar.getTemplate().getBaseWaterRes());
            }
            case 2: {
                return (int)this.calcStat(Stats.WIND_RES, this._activeChar.getTemplate().getBaseWindRes());
            }
            case 3: {
                return (int)this.calcStat(Stats.EARTH_RES, this._activeChar.getTemplate().getBaseEarthRes());
            }
            case 4: {
                return (int)this.calcStat(Stats.HOLY_RES, this._activeChar.getTemplate().getBaseHolyRes());
            }
            case 5: {
                return (int)this.calcStat(Stats.DARK_RES, this._activeChar.getTemplate().getBaseDarkRes());
            }
        }
        return (int)this._activeChar.getTemplate().getBaseElementRes();
    }

    public float getAttackTrait(TraitType traitType) {
        return this._attackTraits[traitType.getId()];
    }

    public float[] getAttackTraits() {
        return this._attackTraits;
    }

    public boolean hasAttackTrait(TraitType traitType) {
        return this._attackTraitsCount[traitType.getId()] > 0;
    }

    public int[] getAttackTraitsCount() {
        return this._attackTraitsCount;
    }

    public float getDefenceTrait(TraitType traitType) {
        return this._defenceTraits[traitType.getId()];
    }

    public float[] getDefenceTraits() {
        return this._defenceTraits;
    }

    public boolean hasDefenceTrait(TraitType traitType) {
        return this._defenceTraitsCount[traitType.getId()] > 0;
    }

    public int[] getDefenceTraitsCount() {
        return this._defenceTraitsCount;
    }

    public boolean isTraitInvul(TraitType traitType) {
        return this._traitsInvul[traitType.getId()] > 0;
    }

    public int[] getTraitsInvul() {
        return this._traitsInvul;
    }
}

