/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.actor.tasks.npc.trap;

import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.instance.L2TrapInstance;
import com.l2jserver.gameserver.network.serverpackets.SocialAction;
import java.util.logging.Logger;

public class TrapTask
implements Runnable {
    private static final Logger _log = Logger.getLogger(TrapTask.class.getName());
    private static final int TICK = 1000;
    private final L2TrapInstance _trap;

    public TrapTask(L2TrapInstance trap) {
        this._trap = trap;
    }

    @Override
    public void run() {
        try {
            if (!this._trap.isTriggered()) {
                if (this._trap.hasLifeTime()) {
                    this._trap.setRemainingTime(this._trap.getRemainingTime() - 1000);
                    if (this._trap.getRemainingTime() < this._trap.getLifeTime() - 15000) {
                        this._trap.broadcastPacket(new SocialAction(this._trap.getObjectId(), 2));
                    }
                    if (this._trap.getRemainingTime() < 0) {
                        switch (this._trap.getSkill().getTargetType()) {
                            case AURA: 
                            case FRONT_AURA: 
                            case BEHIND_AURA: {
                                this._trap.triggerTrap(this._trap);
                                break;
                            }
                            default: {
                                this._trap.unSummon();
                            }
                        }
                        return;
                    }
                }
                for (L2Character target : this._trap.getKnownList().getKnownCharactersInRadius(this._trap.getSkill().getAffectRange())) {
                    if (!this._trap.checkTarget(target)) continue;
                    this._trap.triggerTrap(target);
                    return;
                }
                ThreadPoolManager.getInstance().scheduleGeneral(new TrapTask(this._trap), 1000L);
            }
        }
        catch (Exception e) {
            _log.severe(L2TrapInstance.class.getSimpleName() + ": " + e.getMessage());
            this._trap.unSummon();
        }
    }
}

