/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.base;

import com.l2jserver.gameserver.enums.PcRace;
import com.l2jserver.gameserver.model.base.ClassInfo;
import com.l2jserver.gameserver.model.interfaces.IIdentifiable;

public enum ClassId implements IIdentifiable
{
    fighter(0, false, PcRace.Human, null),
    warrior(1, false, PcRace.Human, fighter),
    gladiator(2, false, PcRace.Human, warrior),
    warlord(3, false, PcRace.Human, warrior),
    knight(4, false, PcRace.Human, fighter),
    paladin(5, false, PcRace.Human, knight),
    darkAvenger(6, false, PcRace.Human, knight),
    rogue(7, false, PcRace.Human, fighter),
    treasureHunter(8, false, PcRace.Human, rogue),
    hawkeye(9, false, PcRace.Human, rogue),
    mage(10, true, PcRace.Human, null),
    wizard(11, true, PcRace.Human, mage),
    sorceror(12, true, PcRace.Human, wizard),
    necromancer(13, true, PcRace.Human, wizard),
    warlock(14, true, true, PcRace.Human, wizard),
    cleric(15, true, PcRace.Human, mage),
    bishop(16, true, PcRace.Human, cleric),
    prophet(17, true, PcRace.Human, cleric),
    elvenFighter(18, false, PcRace.Elf, null),
    elvenKnight(19, false, PcRace.Elf, elvenFighter),
    templeKnight(20, false, PcRace.Elf, elvenKnight),
    swordSinger(21, false, PcRace.Elf, elvenKnight),
    elvenScout(22, false, PcRace.Elf, elvenFighter),
    plainsWalker(23, false, PcRace.Elf, elvenScout),
    silverRanger(24, false, PcRace.Elf, elvenScout),
    elvenMage(25, true, PcRace.Elf, null),
    elvenWizard(26, true, PcRace.Elf, elvenMage),
    spellsinger(27, true, PcRace.Elf, elvenWizard),
    elementalSummoner(28, true, true, PcRace.Elf, elvenWizard),
    oracle(29, true, PcRace.Elf, elvenMage),
    elder(30, true, PcRace.Elf, oracle),
    darkFighter(31, false, PcRace.DarkElf, null),
    palusKnight(32, false, PcRace.DarkElf, darkFighter),
    shillienKnight(33, false, PcRace.DarkElf, palusKnight),
    bladedancer(34, false, PcRace.DarkElf, palusKnight),
    assassin(35, false, PcRace.DarkElf, darkFighter),
    abyssWalker(36, false, PcRace.DarkElf, assassin),
    phantomRanger(37, false, PcRace.DarkElf, assassin),
    darkMage(38, true, PcRace.DarkElf, null),
    darkWizard(39, true, PcRace.DarkElf, darkMage),
    spellhowler(40, true, PcRace.DarkElf, darkWizard),
    phantomSummoner(41, true, true, PcRace.DarkElf, darkWizard),
    shillienOracle(42, true, PcRace.DarkElf, darkMage),
    shillenElder(43, true, PcRace.DarkElf, shillienOracle),
    orcFighter(44, false, PcRace.Orc, null),
    orcRaider(45, false, PcRace.Orc, orcFighter),
    destroyer(46, false, PcRace.Orc, orcRaider),
    orcMonk(47, false, PcRace.Orc, orcFighter),
    tyrant(48, false, PcRace.Orc, orcMonk),
    orcMage(49, false, PcRace.Orc, null),
    orcShaman(50, true, PcRace.Orc, orcMage),
    overlord(51, true, PcRace.Orc, orcShaman),
    warcryer(52, true, PcRace.Orc, orcShaman),
    dwarvenFighter(53, false, PcRace.Dwarf, null),
    scavenger(54, false, PcRace.Dwarf, dwarvenFighter),
    bountyHunter(55, false, PcRace.Dwarf, scavenger),
    artisan(56, false, PcRace.Dwarf, dwarvenFighter),
    warsmith(57, false, PcRace.Dwarf, artisan),
    dummyEntry1(58, false, null, null),
    dummyEntry2(59, false, null, null),
    dummyEntry3(60, false, null, null),
    dummyEntry4(61, false, null, null),
    dummyEntry5(62, false, null, null),
    dummyEntry6(63, false, null, null),
    dummyEntry7(64, false, null, null),
    dummyEntry8(65, false, null, null),
    dummyEntry9(66, false, null, null),
    dummyEntry10(67, false, null, null),
    dummyEntry11(68, false, null, null),
    dummyEntry12(69, false, null, null),
    dummyEntry13(70, false, null, null),
    dummyEntry14(71, false, null, null),
    dummyEntry15(72, false, null, null),
    dummyEntry16(73, false, null, null),
    dummyEntry17(74, false, null, null),
    dummyEntry18(75, false, null, null),
    dummyEntry19(76, false, null, null),
    dummyEntry20(77, false, null, null),
    dummyEntry21(78, false, null, null),
    dummyEntry22(79, false, null, null),
    dummyEntry23(80, false, null, null),
    dummyEntry24(81, false, null, null),
    dummyEntry25(82, false, null, null),
    dummyEntry26(83, false, null, null),
    dummyEntry27(84, false, null, null),
    dummyEntry28(85, false, null, null),
    dummyEntry29(86, false, null, null),
    dummyEntry30(87, false, null, null),
    duelist(88, false, PcRace.Human, gladiator),
    dreadnought(89, false, PcRace.Human, warlord),
    phoenixKnight(90, false, PcRace.Human, paladin),
    hellKnight(91, false, PcRace.Human, darkAvenger),
    sagittarius(92, false, PcRace.Human, hawkeye),
    adventurer(93, false, PcRace.Human, treasureHunter),
    archmage(94, true, PcRace.Human, sorceror),
    soultaker(95, true, PcRace.Human, necromancer),
    arcanaLord(96, true, true, PcRace.Human, warlock),
    cardinal(97, true, PcRace.Human, bishop),
    hierophant(98, true, PcRace.Human, prophet),
    evaTemplar(99, false, PcRace.Elf, templeKnight),
    swordMuse(100, false, PcRace.Elf, swordSinger),
    windRider(101, false, PcRace.Elf, plainsWalker),
    moonlightSentinel(102, false, PcRace.Elf, silverRanger),
    mysticMuse(103, true, PcRace.Elf, spellsinger),
    elementalMaster(104, true, true, PcRace.Elf, elementalSummoner),
    evaSaint(105, true, PcRace.Elf, elder),
    shillienTemplar(106, false, PcRace.DarkElf, shillienKnight),
    spectralDancer(107, false, PcRace.DarkElf, bladedancer),
    ghostHunter(108, false, PcRace.DarkElf, abyssWalker),
    ghostSentinel(109, false, PcRace.DarkElf, phantomRanger),
    stormScreamer(110, true, PcRace.DarkElf, spellhowler),
    spectralMaster(111, true, true, PcRace.DarkElf, phantomSummoner),
    shillienSaint(112, true, PcRace.DarkElf, shillenElder),
    titan(113, false, PcRace.Orc, destroyer),
    grandKhavatari(114, false, PcRace.Orc, tyrant),
    dominator(115, true, PcRace.Orc, overlord),
    doomcryer(116, true, PcRace.Orc, warcryer),
    fortuneSeeker(117, false, PcRace.Dwarf, bountyHunter),
    maestro(118, false, PcRace.Dwarf, warsmith),
    dummyEntry31(119, false, null, null),
    dummyEntry32(120, false, null, null),
    dummyEntry33(121, false, null, null),
    dummyEntry34(122, false, null, null),
    maleSoldier(123, false, PcRace.Kamael, null),
    femaleSoldier(124, false, PcRace.Kamael, null),
    trooper(125, false, PcRace.Kamael, maleSoldier),
    warder(126, false, PcRace.Kamael, femaleSoldier),
    berserker(127, false, PcRace.Kamael, trooper),
    maleSoulbreaker(128, false, PcRace.Kamael, trooper),
    femaleSoulbreaker(129, false, PcRace.Kamael, warder),
    arbalester(130, false, PcRace.Kamael, warder),
    doombringer(131, false, PcRace.Kamael, berserker),
    maleSoulhound(132, false, PcRace.Kamael, maleSoulbreaker),
    femaleSoulhound(133, false, PcRace.Kamael, femaleSoulbreaker),
    trickster(134, false, PcRace.Kamael, arbalester),
    inspector(135, false, PcRace.Kamael, warder),
    judicator(136, false, PcRace.Kamael, inspector);

    private final int _id;
    private final boolean _isMage;
    private final boolean _isSummoner;
    private final PcRace _race;
    private final ClassId _parent;

    private ClassId(int pId, boolean pIsMage, PcRace pRace, ClassId pParent) {
        this._id = pId;
        this._isMage = pIsMage;
        this._isSummoner = false;
        this._race = pRace;
        this._parent = pParent;
    }

    private ClassId(int pId, boolean pIsMage, boolean pIsSummoner, PcRace pRace, ClassId pParent) {
        this._id = pId;
        this._isMage = pIsMage;
        this._isSummoner = pIsSummoner;
        this._race = pRace;
        this._parent = pParent;
    }

    @Override
    public final int getId() {
        return this._id;
    }

    public final boolean isMage() {
        return this._isMage;
    }

    public final boolean isSummoner() {
        return this._isSummoner;
    }

    public final PcRace getRace() {
        return this._race;
    }

    public final boolean childOf(ClassId cid) {
        if (this._parent == null) {
            return false;
        }
        if (this._parent == cid) {
            return true;
        }
        return this._parent.childOf(cid);
    }

    public final boolean equalsOrChildOf(ClassId cid) {
        return this == cid || this.childOf(cid);
    }

    public final int level() {
        if (this._parent == null) {
            return 0;
        }
        return 1 + this._parent.level();
    }

    public final ClassId getParent() {
        return this._parent;
    }

    public static ClassId getClassId(int cId) {
        try {
            return ClassId.values()[cId];
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getClassName() {
        return ClassInfo.getClassName(this.getId());
    }

    public String toHtm() {
        return ClassInfo.toHtm(this.getId());
    }

    public String toHtmW() {
        return ClassInfo.toHtmW(this.getId());
    }

    public String toHtmN() {
        return ClassInfo.toHtmN(this.getId());
    }
}

