/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.buylist;

import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.util.SortedIntArraySet;
import java.util.Collection;
import jp.sf.l2j.troja.FastIntObjectMap;

public final class L2BuyList {
    private final int _listId;
    private final FastIntObjectMap<Product> _products = new FastIntObjectMap();
    protected int[] _allowedNpcs = null;

    public L2BuyList(int listId) {
        this._listId = listId;
    }

    public int getListId() {
        return this._listId;
    }

    public Collection<Product> getProducts() {
        return this._products.values();
    }

    public Product getProductByItemId(int itemId) {
        return (Product)this._products.get(itemId);
    }

    public void addProduct(Product product) {
        this._products.put(product.getItemId(), (Object)product);
    }

    public void addAllowedNpc(int npcId) {
        this._allowedNpcs = SortedIntArraySet.add(this._allowedNpcs, npcId);
    }

    public boolean isNpcAllowed(int npcId) {
        return SortedIntArraySet.contains(this._allowedNpcs, npcId);
    }

    public int[] getAllowedNpcs() {
        return this._allowedNpcs;
    }
}

