/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.conditions;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.conditions.Condition;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.network.SystemMessageId;

public class ConditionPlayerCanSweep
extends Condition {
    private final boolean _val;

    public ConditionPlayerCanSweep(boolean val) {
        this._val = val;
    }

    @Override
    public boolean testImpl(Env env) {
        L2Object[] targets;
        Skill sweep;
        boolean canSweep = false;
        L2PcInstance sweeper = env.getPlayer();
        if (sweeper != null && (sweep = env.getSkill()) != null && (targets = sweep.getTargetList(sweeper)) != null) {
            for (L2Object objTarget : targets) {
                L2Attackable target;
                if (!(objTarget instanceof L2Attackable) || !(target = (L2Attackable)objTarget).isDead()) continue;
                if (target.isSpoil()) {
                    canSweep = target.checkSpoilOwner(sweeper, true);
                    canSweep &= !target.isOldCorpse(sweeper, Config.CORPSE_CONSUME_SKILL_ALLOWED_TIME_BEFORE_DECAY, true);
                    canSweep &= sweeper.getInventory().checkInventorySlotsAndWeight(target.getSpoilLootItems(), true, true);
                    continue;
                }
                sweeper.sendPacket(SystemMessageId.SWEEPER_FAILED_TARGET_NOT_SPOILED);
            }
        }
        return this._val == canSweep;
    }
}

