/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemauction;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.CharNameTable;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.ItemAuctionManager;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemauction.AuctionDateGenerator;
import com.l2jserver.gameserver.model.itemauction.AuctionItem;
import com.l2jserver.gameserver.model.itemauction.ItemAuction;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionBid;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionExtendState;
import com.l2jserver.gameserver.model.itemauction.ItemAuctionState;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.util.Rnd;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class ItemAuctionInstance {
    protected static final Logger _log = Logger.getLogger(ItemAuctionInstance.class.getName());
    private static final String DATE_FORMAT = "yyyy\u5e74MM\u6708dd\u65e5(E) HH\u6642";
    private static final long START_TIME_SPACE = TimeUnit.MILLISECONDS.convert(1L, TimeUnit.MINUTES);
    private static final long FINISH_TIME_SPACE = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);
    private static final String SELECT_AUCTION_ID_BY_INSTANCE_ID = "SELECT auctionId FROM item_auction WHERE instanceId = ?";
    private static final String SELECT_AUCTION_INFO = "SELECT auctionItemId, startingTime, endingTime, auctionStateId FROM item_auction WHERE auctionId = ? ";
    private static final String DELETE_AUCTION_INFO_BY_AUCTION_ID = "DELETE FROM item_auction WHERE auctionId = ?";
    private static final String DELETE_AUCTION_BID_INFO_BY_AUCTION_ID = "DELETE FROM item_auction_bid WHERE auctionId = ?";
    private static final String SELECT_PLAYERS_ID_BY_AUCTION_ID = "SELECT playerObjId, playerBid FROM item_auction_bid WHERE auctionId = ?";
    private static final Comparator<ItemAuction> itemAuctionComparator = new Comparator<ItemAuction>(){

        @Override
        public final int compare(ItemAuction o1, ItemAuction o2) {
            return Long.valueOf(o2.getStartingTime()).compareTo(o1.getStartingTime());
        }
    };
    private final int _instanceId;
    private final AtomicInteger _auctionIds;
    private final FastIntObjectMap<ItemAuction> _auctions;
    private final ArrayList<AuctionItem> _items;
    private final AuctionDateGenerator _dateGenerator;
    private ItemAuction _currentAuction;
    private ItemAuction _nextAuction;
    private ScheduledFuture<?> _stateTask;

    public ItemAuctionInstance(int instanceId, AtomicInteger auctionIds, Node node) throws Exception {
        block53: {
            this._instanceId = instanceId;
            this._auctionIds = auctionIds;
            this._auctions = new FastIntObjectMap();
            this._items = new ArrayList();
            NamedNodeMap nanode = node.getAttributes();
            StatsSet generatorConfig = new StatsSet();
            int i = nanode.getLength();
            while (i-- > 0) {
                Node n = nanode.item(i);
                if (n == null) continue;
                generatorConfig.set(n.getNodeName(), n.getNodeValue());
            }
            this._dateGenerator = new AuctionDateGenerator(generatorConfig);
            for (Node na = node.getFirstChild(); na != null; na = na.getNextSibling()) {
                try {
                    if (!"item".equalsIgnoreCase(na.getNodeName())) continue;
                    NamedNodeMap naa = na.getAttributes();
                    int auctionItemId = Integer.parseInt(naa.getNamedItem("auctionItemId").getNodeValue());
                    int auctionLenght = Integer.parseInt(naa.getNamedItem("auctionLenght").getNodeValue());
                    long auctionInitBid = Integer.parseInt(naa.getNamedItem("auctionInitBid").getNodeValue());
                    int itemId = Integer.parseInt(naa.getNamedItem("itemId").getNodeValue());
                    int itemCount = Integer.parseInt(naa.getNamedItem("itemCount").getNodeValue());
                    if (auctionLenght < 1) {
                        throw new IllegalArgumentException("auctionLenght < 1 for instanceId: " + this._instanceId + ", itemId " + itemId);
                    }
                    StatsSet itemExtra = new StatsSet();
                    AuctionItem item = new AuctionItem(auctionItemId, auctionLenght, auctionInitBid, itemId, itemCount, itemExtra);
                    if (!item.checkItemExists()) {
                        throw new IllegalArgumentException("Item with id " + itemId + " not found");
                    }
                    for (AuctionItem tmp : this._items) {
                        if (tmp.getAuctionItemId() != auctionItemId) continue;
                        throw new IllegalArgumentException("Dublicated auction item id " + auctionItemId);
                    }
                    this._items.add(item);
                    for (Node nb = na.getFirstChild(); nb != null; nb = nb.getNextSibling()) {
                        if (!"extra".equalsIgnoreCase(nb.getNodeName())) continue;
                        NamedNodeMap nab = nb.getAttributes();
                        int i2 = nab.getLength();
                        while (i2-- > 0) {
                            Node n = nab.item(i2);
                            if (n == null) continue;
                            itemExtra.set(n.getNodeName(), n.getNodeValue());
                        }
                    }
                    continue;
                }
                catch (IllegalArgumentException e) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Failed loading auction item", e);
                }
            }
            if (this._items.isEmpty()) {
                throw new IllegalArgumentException("No items defined");
            }
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement(SELECT_AUCTION_ID_BY_INSTANCE_ID);){
                ps.setInt(1, this._instanceId);
                ResultSet rset = ps.executeQuery();
                Throwable throwable = null;
                block38: while (true) {
                    try {
                        while (rset.next()) {
                            int auctionId = rset.getInt(1);
                            try {
                                ItemAuction auction = this.loadAuction(auctionId);
                                if (auction != null) {
                                    this._auctions.put(auctionId, (Object)auction);
                                    continue block38;
                                }
                                ItemAuctionManager.deleteAuction(auctionId);
                                continue block38;
                            }
                            catch (SQLException e) {
                                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Failed loading auction: " + auctionId, e);
                            }
                        }
                        break block53;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (rset != null) {
                        if (throwable != null) {
                            try {
                                rset.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rset.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed loading auctions.", e);
                return;
            }
        }
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + this._items.size() + " item(s) and registered " + this._auctions.size() + " auction(s) for instance " + this._instanceId + ".");
        this.checkAndSetCurrentAndNextAuction();
    }

    public final ItemAuction getCurrentAuction() {
        return this._currentAuction;
    }

    public final ItemAuction getNextAuction() {
        return this._nextAuction;
    }

    public final void shutdown() {
        ScheduledFuture<?> stateTask = this._stateTask;
        if (stateTask != null) {
            stateTask.cancel(false);
        }
    }

    private final AuctionItem getAuctionItem(int auctionItemId) {
        int i = this._items.size();
        while (i-- > 0) {
            AuctionItem item = this._items.get(i);
            if (item.getAuctionItemId() != auctionItemId) continue;
            return item;
        }
        return null;
    }

    final void checkAndSetCurrentAndNextAuction() {
        ItemAuction[] auctions = this._auctions.values().toArray(new ItemAuction[this._auctions.size()]);
        ItemAuction currentAuction = null;
        ItemAuction nextAuction = null;
        block0 : switch (auctions.length) {
            case 0: {
                nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                break;
            }
            case 1: {
                switch (auctions[0].getAuctionState()) {
                    case CREATED: {
                        if (auctions[0].getStartingTime() < System.currentTimeMillis() + START_TIME_SPACE) {
                            currentAuction = auctions[0];
                            nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                            break block0;
                        }
                        nextAuction = auctions[0];
                        break block0;
                    }
                    case STARTED: {
                        currentAuction = auctions[0];
                        nextAuction = this.createAuction(Math.max(currentAuction.getEndingTime() + FINISH_TIME_SPACE, System.currentTimeMillis() + START_TIME_SPACE));
                        break block0;
                    }
                    case FINISHED: {
                        currentAuction = auctions[0];
                        nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                        break block0;
                    }
                }
                throw new IllegalArgumentException();
            }
            default: {
                Arrays.sort(auctions, itemAuctionComparator);
                long currentTime = System.currentTimeMillis();
                for (ItemAuction auction : auctions) {
                    if (auction.getAuctionState() == ItemAuctionState.STARTED) {
                        currentAuction = auction;
                        break;
                    }
                    if (auction.getStartingTime() > currentTime) continue;
                    currentAuction = auction;
                    break;
                }
                for (ItemAuction auction : auctions) {
                    if (auction.getStartingTime() <= currentTime || currentAuction == auction) continue;
                    nextAuction = auction;
                    break;
                }
                if (nextAuction != null) break;
                nextAuction = this.createAuction(System.currentTimeMillis() + START_TIME_SPACE);
                break;
            }
        }
        this._auctions.put(nextAuction.getAuctionId(), (Object)nextAuction);
        this._currentAuction = currentAuction;
        this._nextAuction = nextAuction;
        if (currentAuction != null && currentAuction.getAuctionState() != ItemAuctionState.FINISHED) {
            if (currentAuction.getAuctionState() == ItemAuctionState.STARTED) {
                this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(currentAuction), Math.max(currentAuction.getEndingTime() - System.currentTimeMillis(), 0L)));
            } else {
                this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(currentAuction), Math.max(currentAuction.getStartingTime() - System.currentTimeMillis(), 0L)));
            }
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Schedule current auction " + currentAuction.getAuctionId() + " for instance " + this._instanceId);
        } else {
            this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(new ScheduleAuctionTask(nextAuction), Math.max(nextAuction.getStartingTime() - System.currentTimeMillis(), 0L)));
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Schedule next auction " + nextAuction.getAuctionId() + " on " + new SimpleDateFormat(DATE_FORMAT).format(new Date(nextAuction.getStartingTime())) + " for instance " + this._instanceId);
        }
    }

    public final ItemAuction getAuction(int auctionId) {
        return (ItemAuction)this._auctions.get(auctionId);
    }

    public final ItemAuction[] getAuctionsByBidder(int bidderObjId) {
        Collection<ItemAuction> auctions = this.getAuctions();
        ArrayList<ItemAuction> stack = new ArrayList<ItemAuction>(auctions.size());
        for (ItemAuction auction : this.getAuctions()) {
            ItemAuctionBid bid;
            if (auction.getAuctionState() == ItemAuctionState.CREATED || (bid = auction.getBidFor(bidderObjId)) == null) continue;
            stack.add(auction);
        }
        return stack.toArray(new ItemAuction[stack.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Collection<ItemAuction> getAuctions() {
        Collection auctions;
        FastIntObjectMap<ItemAuction> fastIntObjectMap = this._auctions;
        synchronized (fastIntObjectMap) {
            auctions = this._auctions.values();
        }
        return auctions;
    }

    final void onAuctionFinished(ItemAuction auction) {
        auction.broadcastToAllBiddersInternal(SystemMessage.getSystemMessage(SystemMessageId.S1_AUCTION_ENDED).addItemName(auction.getItemInfo().getItem()));
        ItemAuctionBid bid = auction.getHighestBid();
        if (bid != null) {
            L2ItemInstance item = auction.createNewItemInstance();
            L2PcInstance player = bid.getPlayer();
            if (player != null) {
                player.getWarehouse().addItem("ItemAuction", item, null, null);
                player.sendPacket(SystemMessageId.WON_BID_ITEM_CAN_BE_FOUND_IN_WAREHOUSE);
                _log.log(Level.INFO, this.getClass().getSimpleName() + ": Auction " + auction.getAuctionId() + " has finished. Highest bid by " + player.getName() + " for instance " + this._instanceId);
            } else {
                item.setOwnerId(bid.getPlayerObjId());
                item.setItemLocation(ItemLocation.WAREHOUSE);
                item.updateDatabase();
                L2World.getInstance().removeObject(item);
                _log.log(Level.INFO, this.getClass().getSimpleName() + ": Auction " + auction.getAuctionId() + " has finished. Highest bid by " + CharNameTable.getInstance().getNameById(bid.getPlayerObjId()) + " for instance " + this._instanceId);
            }
            auction.clearCanceledBids();
        } else {
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Auction " + auction.getAuctionId() + " has finished. There have not been any bid for instance " + this._instanceId);
        }
    }

    final void setStateTask(ScheduledFuture<?> future) {
        ScheduledFuture<?> stateTask = this._stateTask;
        if (stateTask != null) {
            stateTask.cancel(false);
        }
        this._stateTask = future;
    }

    private final ItemAuction createAuction(long after) {
        AuctionItem auctionItem = this._items.get(Rnd.get(this._items.size()));
        long startingTime = this._dateGenerator.nextDate(after);
        long endingTime = startingTime + TimeUnit.MILLISECONDS.convert(auctionItem.getAuctionLength(), TimeUnit.MINUTES);
        ItemAuction auction = new ItemAuction(this._auctionIds.getAndIncrement(), this._instanceId, startingTime, endingTime, auctionItem);
        auction.storeMe();
        return auction;
    }

    private final ItemAuction loadAuction(int auctionId) throws SQLException {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            Object object;
            int auctionItemId = 0;
            long startingTime = 0L;
            long endingTime = 0L;
            byte auctionStateId = 0;
            try (PreparedStatement ps = con.prepareStatement(SELECT_AUCTION_INFO);){
                ps.setInt(1, auctionId);
                ResultSet rset = ps.executeQuery();
                object = null;
                try {
                    if (!rset.next()) {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Auction data not found for auction: " + auctionId);
                        ItemAuction itemAuction = null;
                        return itemAuction;
                    }
                    auctionItemId = rset.getInt(1);
                    startingTime = rset.getLong(2);
                    endingTime = rset.getLong(3);
                    auctionStateId = rset.getByte(4);
                }
                catch (Throwable x2) {
                    object = x2;
                    throw x2;
                }
                finally {
                    if (rset != null) {
                        if (object != null) {
                            try {
                                rset.close();
                            }
                            catch (Throwable x2) {
                                ((Throwable)object).addSuppressed(x2);
                            }
                        } else {
                            rset.close();
                        }
                    }
                }
            }
            if (startingTime >= endingTime) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Invalid starting/ending paramaters for auction: " + auctionId);
                ps = null;
                return ps;
            }
            AuctionItem auctionItem = this.getAuctionItem(auctionItemId);
            if (auctionItem == null) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": AuctionItem: " + auctionItemId + ", not found for auction: " + auctionId);
                ItemAuction x2 = null;
                return x2;
            }
            ItemAuctionState auctionState = ItemAuctionState.stateForStateId(auctionStateId);
            if (auctionState == null) {
                _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Invalid auctionStateId: " + auctionStateId + ", for auction: " + auctionId);
                ItemAuction x2 = null;
                return x2;
            }
            if (auctionState == ItemAuctionState.FINISHED && startingTime < System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(Config.ALT_ITEM_AUCTION_EXPIRED_AFTER, TimeUnit.DAYS)) {
                _log.log(Level.INFO, this.getClass().getSimpleName() + ": Clearing expired auction: " + auctionId);
                try (PreparedStatement ps = con.prepareStatement(DELETE_AUCTION_INFO_BY_AUCTION_ID);){
                    ps.setInt(1, auctionId);
                    ps.execute();
                }
                ps = con.prepareStatement(DELETE_AUCTION_BID_INFO_BY_AUCTION_ID);
                x2 = null;
                try {
                    ps.setInt(1, auctionId);
                    ps.execute();
                }
                catch (Throwable x2) {
                    x2 = x2;
                    throw x2;
                }
                finally {
                    if (ps != null) {
                        if (x2 != null) {
                            try {
                                ps.close();
                            }
                            catch (Throwable x2) {
                                x2.addSuppressed(x2);
                            }
                        } else {
                            ps.close();
                        }
                    }
                }
                ps = null;
                return ps;
            }
            ArrayList<ItemAuctionBid> auctionBids = new ArrayList<ItemAuctionBid>();
            try (PreparedStatement ps = con.prepareStatement(SELECT_PLAYERS_ID_BY_AUCTION_ID);){
                ps.setInt(1, auctionId);
                try (ResultSet rs = ps.executeQuery();){
                    while (rs.next()) {
                        int playerObjId = rs.getInt(1);
                        long playerBid = rs.getLong(2);
                        ItemAuctionBid bid = new ItemAuctionBid(playerObjId, playerBid);
                        auctionBids.add(bid);
                    }
                }
            }
            object = new ItemAuction(auctionId, this._instanceId, startingTime, endingTime, auctionItem, auctionBids, auctionState);
            return object;
        }
    }

    private final class ScheduleAuctionTask
    implements Runnable {
        private final ItemAuction _auction;

        public ScheduleAuctionTask(ItemAuction auction) {
            this._auction = auction;
        }

        @Override
        public final void run() {
            try {
                this.runImpl();
            }
            catch (Exception e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Failed scheduling auction " + this._auction.getAuctionId(), e);
            }
        }

        private final void runImpl() throws Exception {
            ItemAuctionState state = this._auction.getAuctionState();
            switch (state) {
                case CREATED: {
                    if (!this._auction.setAuctionState(state, ItemAuctionState.STARTED)) {
                        throw new IllegalStateException("Could not set auction state: " + ItemAuctionState.STARTED.toString() + ", expected: " + state.toString());
                    }
                    _log.log(Level.INFO, this.getClass().getSimpleName() + ": Auction " + this._auction.getAuctionId() + " has started for instance " + this._auction.getInstanceId());
                    ItemAuctionInstance.this.checkAndSetCurrentAndNextAuction();
                    break;
                }
                case STARTED: {
                    switch (this._auction.getAuctionEndingExtendState()) {
                        case EXTEND_BY_5_MIN: {
                            if (this._auction.getScheduledAuctionEndingExtendState() != ItemAuctionExtendState.INITIAL) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_5_MIN);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_3_MIN: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_3_MIN) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_3_MIN);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_CONFIG_PHASE_A: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_B);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                        case EXTEND_BY_CONFIG_PHASE_B: {
                            if (this._auction.getScheduledAuctionEndingExtendState() == ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A) break;
                            this._auction.setScheduledAuctionEndingExtendState(ItemAuctionExtendState.EXTEND_BY_CONFIG_PHASE_A);
                            ItemAuctionInstance.this.setStateTask(ThreadPoolManager.getInstance().scheduleGeneral(this, Math.max(this._auction.getEndingTime() - System.currentTimeMillis(), 0L)));
                            return;
                        }
                    }
                    if (!this._auction.setAuctionState(state, ItemAuctionState.FINISHED)) {
                        throw new IllegalStateException("Could not set auction state: " + ItemAuctionState.FINISHED.toString() + ", expected: " + state.toString());
                    }
                    ItemAuctionInstance.this.onAuctionFinished(this._auction);
                    ItemAuctionInstance.this.checkAndSetCurrentAndNextAuction();
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid state: " + (Object)((Object)state));
                }
            }
        }
    }
}

