/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.itemcontainer;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.model.L2Clan;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.Warehouse;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseAddItemEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseDeleteItemEvent;
import com.l2jserver.gameserver.scripting.scriptengine.events.ClanWarehouseTransferEvent;
import com.l2jserver.gameserver.scripting.scriptengine.listeners.clan.ClanWarehouseListener;
import javolution.util.FastList;

public final class ClanWarehouse
extends Warehouse {
    private final L2Clan _clan;
    private final FastList<ClanWarehouseListener> clanWarehouseListeners = new FastList().shared();

    public ClanWarehouse(L2Clan clan) {
        this._clan = clan;
    }

    @Override
    public String getName() {
        return "ClanWarehouse";
    }

    @Override
    public int getOwnerId() {
        return this._clan.getId();
    }

    @Override
    public L2PcInstance getOwner() {
        return this._clan.getLeader().getPlayerInstance();
    }

    @Override
    public ItemLocation getBaseLocation() {
        return ItemLocation.CLANWH;
    }

    public String getLocationId() {
        return "0";
    }

    public int getLocationId(boolean dummy) {
        return 0;
    }

    public void setLocationId(L2PcInstance dummy) {
    }

    @Override
    public boolean validateCapacity(long slots) {
        return (long)this._items.size() + slots <= (long)Config.WAREHOUSE_SLOTS_CLAN;
    }

    @Override
    public L2ItemInstance addItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = this.getItemByItemId(itemId);
        if (!this.fireClanWarehouseAddItemListeners(process, item, actor, count)) {
            return null;
        }
        return super.addItem(process, itemId, count, actor, reference);
    }

    @Override
    public L2ItemInstance addItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        if (!this.fireClanWarehouseAddItemListeners(process, item, actor, item.getCount())) {
            return null;
        }
        return super.addItem(process, item, actor, reference);
    }

    @Override
    public L2ItemInstance destroyItem(String process, L2ItemInstance item, long count, L2PcInstance actor, Object reference) {
        if (!this.fireClanWarehouseDeleteItemListeners(process, item, actor, count)) {
            return null;
        }
        return super.destroyItem(process, item, count, actor, reference);
    }

    @Override
    public L2ItemInstance transferItem(String process, int objectId, long count, ItemContainer target, L2PcInstance actor, Object reference) {
        L2ItemInstance sourceitem = this.getItemByObjectId(objectId);
        if (!this.fireClanWarehouseTransferListeners(process, sourceitem, count, target, actor)) {
            return null;
        }
        return super.transferItem(process, objectId, count, target, actor, reference);
    }

    private boolean fireClanWarehouseAddItemListeners(String process, L2ItemInstance item, L2PcInstance actor, long count) {
        if (!this.clanWarehouseListeners.isEmpty() && actor != null && item != null) {
            ClanWarehouseAddItemEvent event = new ClanWarehouseAddItemEvent();
            event.setActor(actor);
            event.setItem(item);
            event.setCount(count);
            event.setProcess(process);
            for (ClanWarehouseListener listener : this.clanWarehouseListeners) {
                if (listener.onAddItem(event)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean fireClanWarehouseDeleteItemListeners(String process, L2ItemInstance item, L2PcInstance actor, long count) {
        if (!this.clanWarehouseListeners.isEmpty() && actor != null && item != null) {
            ClanWarehouseDeleteItemEvent event = new ClanWarehouseDeleteItemEvent();
            event.setActor(actor);
            event.setCount(count);
            event.setItem(item);
            event.setProcess(process);
            for (ClanWarehouseListener listener : this.clanWarehouseListeners) {
                if (listener.onDeleteItem(event)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean fireClanWarehouseTransferListeners(String process, L2ItemInstance item, long count, ItemContainer target, L2PcInstance actor) {
        if (!this.clanWarehouseListeners.isEmpty() && actor != null && item != null && target != null) {
            ClanWarehouseTransferEvent event = new ClanWarehouseTransferEvent();
            event.setActor(actor);
            event.setCount(count);
            event.setItem(item);
            event.setProcess(process);
            event.setTarget(target);
            for (ClanWarehouseListener listener : this.clanWarehouseListeners) {
                if (listener.onTransferItem(event)) continue;
                return false;
            }
        }
        return true;
    }

    public void addWarehouseListener(ClanWarehouseListener listener) {
        if (!this.clanWarehouseListeners.contains((Object)listener)) {
            this.clanWarehouseListeners.add((Object)listener);
        }
    }

    public void removeWarehouseListener(ClanWarehouseListener listener) {
        this.clanWarehouseListeners.remove((Object)listener);
    }
}

