/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.olympiad;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.olympiad.AbstractOlympiadGame;
import com.l2jserver.gameserver.model.olympiad.OlympiadGameManager;
import com.l2jserver.gameserver.model.zone.type.L2OlympiadStadiumZone;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OlympiadGameTask
implements Runnable {
    protected static final Logger _log = Logger.getLogger(OlympiadGameTask.class.getName());
    protected static final long BATTLE_PERIOD = Config.ALT_OLY_BATTLE;
    public static final int[] TELEPORT_TO_ARENA = new int[]{120, 60, 30, 15, 10, 5, 4, 3, 2, 1, 0};
    public static final int[] BATTLE_START_TIME_FIRST = new int[]{60, 50, 40, 30, 20, 10, 0};
    public static final int[] BATTLE_START_TIME_SECOND = new int[]{10, 5, 4, 3, 2, 1, 0};
    public static final int[] TELEPORT_TO_TOWN = new int[]{40, 30, 20, 10, 5, 4, 3, 2, 1, 0};
    private final L2OlympiadStadiumZone _zone;
    private AbstractOlympiadGame _game;
    private GameState _state = GameState.IDLE;
    private boolean _needAnnounce = false;
    private int _countDown = 0;

    public OlympiadGameTask(L2OlympiadStadiumZone zone) {
        this._zone = zone;
        zone.registerTask(this);
    }

    public final boolean isRunning() {
        return this._state != GameState.IDLE;
    }

    public final boolean isGameStarted() {
        return this._state.ordinal() >= GameState.GAME_STARTED.ordinal() && this._state.ordinal() <= GameState.CLEANUP.ordinal();
    }

    public final boolean isBattleStarted() {
        return this._state == GameState.BATTLE_IN_PROGRESS;
    }

    public final boolean isBattleFinished() {
        return this._state == GameState.TELEPORT_TO_TOWN;
    }

    public final boolean needAnnounce() {
        if (this._needAnnounce) {
            this._needAnnounce = false;
            return true;
        }
        return false;
    }

    public final L2OlympiadStadiumZone getZone() {
        return this._zone;
    }

    public final AbstractOlympiadGame getGame() {
        return this._game;
    }

    public final void attachGame(AbstractOlympiadGame game) {
        if (game != null && this._state != GameState.IDLE) {
            _log.log(Level.WARNING, "Attempt to overwrite non-finished game in state " + (Object)((Object)this._state));
            return;
        }
        this._game = game;
        this._state = GameState.BEGIN;
        this._needAnnounce = false;
        ThreadPoolManager.getInstance().executeTask(this);
    }

    @Override
    public final void run() {
        try {
            int delay = 1;
            switch (this._state) {
                case BEGIN: {
                    this._state = GameState.TELEPORT_TO_ARENA;
                    this._countDown = Config.ALT_OLY_WAIT_TIME;
                    break;
                }
                case TELEPORT_TO_ARENA: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_ENTER_THE_OLYMPIAD_STADIUM_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._game.broadcastPacket(sm);
                    }
                    delay = this.getDelay(TELEPORT_TO_ARENA);
                    if (this._countDown > 0) break;
                    this._state = GameState.GAME_STARTED;
                    break;
                }
                case GAME_STARTED: {
                    if (!this.startGame()) {
                        this._state = GameState.GAME_STOPPED;
                        break;
                    }
                    this._state = GameState.BATTLE_COUNTDOWN_FIRST;
                    this._countDown = BATTLE_START_TIME_FIRST[0];
                    delay = 5;
                    break;
                }
                case BATTLE_COUNTDOWN_FIRST: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_WILL_START_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._zone.broadcastPacket(sm);
                    }
                    delay = this.getDelay(BATTLE_START_TIME_FIRST);
                    if (this._countDown > 0) break;
                    this.openDoors();
                    this._state = GameState.BATTLE_COUNTDOWN_SECOND;
                    this._countDown = BATTLE_START_TIME_SECOND[0];
                    delay = this.getDelay(BATTLE_START_TIME_SECOND);
                    break;
                }
                case BATTLE_COUNTDOWN_SECOND: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.THE_GAME_WILL_START_IN_S1_SECOND_S);
                        sm.addInt(this._countDown);
                        this._zone.broadcastPacket(sm);
                    }
                    delay = this.getDelay(BATTLE_START_TIME_SECOND);
                    if (this._countDown > 0) break;
                    this._state = GameState.BATTLE_STARTED;
                    break;
                }
                case BATTLE_STARTED: {
                    this._countDown = 0;
                    this._state = GameState.BATTLE_IN_PROGRESS;
                    if (this.startBattle()) break;
                    this._state = GameState.GAME_STOPPED;
                    break;
                }
                case BATTLE_IN_PROGRESS: {
                    this._countDown += 1000;
                    if (!this.checkBattle() && (long)this._countDown <= Config.ALT_OLY_BATTLE) break;
                    this._state = GameState.GAME_STOPPED;
                    break;
                }
                case GAME_STOPPED: {
                    this._state = GameState.TELEPORT_TO_TOWN;
                    this._countDown = TELEPORT_TO_TOWN[0];
                    this.stopGame();
                    delay = this.getDelay(TELEPORT_TO_TOWN);
                    break;
                }
                case TELEPORT_TO_TOWN: {
                    if (this._countDown > 0) {
                        SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.YOU_WILL_BE_MOVED_TO_TOWN_IN_S1_SECONDS);
                        sm.addInt(this._countDown);
                        this._game.broadcastPacket(sm);
                    }
                    delay = this.getDelay(TELEPORT_TO_TOWN);
                    if (this._countDown > 0) break;
                    this._state = GameState.CLEANUP;
                    break;
                }
                case CLEANUP: {
                    this.cleanupGame();
                    this._state = GameState.IDLE;
                    this._game = null;
                    return;
                }
            }
            ThreadPoolManager.getInstance().scheduleGeneral(this, delay * 1000);
        }
        catch (Exception e) {
            switch (this._state) {
                case GAME_STOPPED: 
                case TELEPORT_TO_TOWN: 
                case CLEANUP: 
                case IDLE: {
                    _log.log(Level.WARNING, "Unable to return players back in town, exception: " + e.getMessage());
                    this._state = GameState.IDLE;
                    this._game = null;
                    return;
                }
            }
            _log.log(Level.WARNING, "Exception in " + (Object)((Object)this._state) + ", trying to port players back: " + e.getMessage(), e);
            this._state = GameState.GAME_STOPPED;
            ThreadPoolManager.getInstance().scheduleGeneral(this, 1000L);
        }
    }

    private final int getDelay(int[] times) {
        for (int i = 0; i < times.length - 1; ++i) {
            int time = times[i];
            if (time >= this._countDown) continue;
            int delay = this._countDown - time;
            this._countDown = time;
            return delay;
        }
        this._countDown = -1;
        return 1;
    }

    private final boolean startGame() {
        try {
            if (this._game.checkDefaulted()) {
                return false;
            }
            this._zone.closeDoors();
            if (this._game.needBuffers()) {
                this._zone.spawnBuffers();
            }
            if (!this._game.portPlayersToArena(this._zone.getSpawns())) {
                return false;
            }
            this._game.removals();
            this._needAnnounce = true;
            OlympiadGameManager.getInstance().startBattle();
            return true;
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            return false;
        }
    }

    private final void openDoors() {
        try {
            this._game.resetDamage();
            this._zone.openDoors();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private final boolean startBattle() {
        try {
            if (this._game.needBuffers()) {
                this._zone.deleteBuffers();
            }
            if (this._game.checkBattleStatus() && this._game.makeCompetitionStart()) {
                this._game.broadcastOlympiadInfo(this._zone);
                this._zone.broadcastPacket(SystemMessage.getSystemMessage(SystemMessageId.STARTS_THE_GAME));
                this._zone.updateZoneStatusForCharactersInside();
                return true;
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return false;
    }

    private final boolean checkBattle() {
        try {
            return this._game.haveWinner();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
            return true;
        }
    }

    private final void stopGame() {
        try {
            this._game.validateWinner(this._zone);
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this._zone.updateZoneStatusForCharactersInside();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this._game.cleanEffects();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private final void cleanupGame() {
        try {
            this._game.playersStatusBack();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this._game.portPlayersBack();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this._game.clearPlayers();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        try {
            this._zone.closeDoors();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    private static enum GameState {
        BEGIN,
        TELEPORT_TO_ARENA,
        GAME_STARTED,
        BATTLE_COUNTDOWN_FIRST,
        BATTLE_COUNTDOWN_SECOND,
        BATTLE_STARTED,
        BATTLE_IN_PROGRESS,
        GAME_STOPPED,
        TELEPORT_TO_TOWN,
        CLEANUP,
        IDLE;

    }
}

