/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills;

import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.SkillData;
import com.l2jserver.gameserver.enums.ShotType;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.skills.BuffInfo;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillLaunched;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SkillChannelizer
implements Runnable {
    private static final Logger _log = Logger.getLogger(SkillChannelizer.class.getName());
    private final L2Character _channelizer;
    private L2Character _channelized;
    private Skill _skill;
    private volatile ScheduledFuture<?> _task = null;

    public SkillChannelizer(L2Character channelizer) {
        this._channelizer = channelizer;
    }

    public L2Character getChannelizer() {
        return this._channelizer;
    }

    public L2Character getChannelized() {
        return this._channelized;
    }

    public boolean hasChannelized() {
        return this._channelized != null;
    }

    public void startChanneling(Skill skill) {
        if (this.isChanneling()) {
            _log.log(Level.WARNING, "Character: " + this.toString() + " is attempting to channel skill but he already does!");
            return;
        }
        this._skill = skill;
        this._task = ThreadPoolManager.getInstance().scheduleGeneralAtFixedRate(this, skill.getChannelingTickInitialDelay(), skill.getChannelingTickInterval());
    }

    public void stopChanneling() {
        if (!this.isChanneling()) {
            _log.log(Level.WARNING, "Character: " + this.toString() + " is attempting to stop channel skill but he does not!");
            return;
        }
        this._task.cancel(false);
        this._task = null;
        if (this._channelized != null) {
            this._channelized.getSkillChannelized().removeChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
            this._channelized = null;
        }
        this._skill = null;
    }

    public Skill getSkill() {
        return this._skill;
    }

    public boolean isChanneling() {
        return this._task != null;
    }

    @Override
    public void run() {
        if (!this.isChanneling()) {
            return;
        }
        try {
            if (this._skill.getMpPerChanneling() > 0) {
                if (this._channelizer.getCurrentMp() < (double)this._skill.getMpPerChanneling()) {
                    if (this._channelizer.isPlayer()) {
                        this._channelizer.sendPacket(SystemMessageId.SKILL_REMOVED_DUE_LACK_MP);
                    }
                    this._channelizer.abortCast();
                    return;
                }
                this._channelizer.reduceCurrentMp(this._skill.getMpPerChanneling());
            }
            if (this._skill.getChannelingSkillId() > 0) {
                Skill baseSkill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), 1);
                if (baseSkill == null) {
                    _log.log(Level.WARNING, this.getClass().getSimpleName() + ": skill " + this._skill + " couldn't find effect id skill: " + this._skill.getChannelingSkillId() + " !");
                    this._channelizer.abortCast();
                    return;
                }
                if (this._channelized == null) {
                    List<L2Character> targets = this.getTargetList();
                    if (targets.isEmpty()) {
                        _log.log(Level.WARNING, this.getClass().getSimpleName() + ": skill " + this._skill + " couldn't find proper target!");
                        this._channelizer.abortCast();
                        return;
                    }
                    this._channelized = targets.get(0);
                    this._channelized.getSkillChannelized().addChannelizer(this._skill.getChannelingSkillId(), this.getChannelizer());
                }
                if (!Util.checkIfInRange(this._skill.getEffectRange(), this._channelizer, this._channelized, true)) {
                    this._channelizer.abortCast();
                    this._channelizer.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                } else if (!GeoData.getInstance().canSeeTarget((L2Object)this._channelizer, this._channelized)) {
                    this._channelizer.abortCast();
                    this._channelizer.sendPacket(SystemMessageId.CANT_SEE_TARGET);
                } else {
                    int maxSkillLevel = SkillData.getInstance().getMaxLevel(this._skill.getChannelingSkillId());
                    int skillLevel = Math.min(this._channelized.getSkillChannelized().getChannerlizersSize(this._skill.getChannelingSkillId()), maxSkillLevel);
                    BuffInfo info = this._channelized.getEffectList().getBuffInfoBySkillId(this._skill.getChannelingSkillId());
                    if (info == null || info.getSkill().getLevel() < skillLevel) {
                        Skill skill = SkillData.getInstance().getSkill(this._skill.getChannelingSkillId(), skillLevel);
                        skill.applyEffects(this.getChannelizer(), this._channelized);
                    }
                    this._channelizer.broadcastPacket(new MagicSkillLaunched(this._channelizer, this._skill.getId(), this._skill.getLevel(), this._channelized));
                }
            } else {
                List<L2Character> targets = this.getTargetList();
                Iterator<L2Character> it = targets.iterator();
                while (it.hasNext()) {
                    L2Character target = it.next();
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._channelizer, target)) {
                        it.remove();
                        continue;
                    }
                    if (this._channelizer.isPlayable() && target.isPlayable() && this._skill.isBad()) {
                        if (this._channelizer.isPlayable() && this._channelizer.getActingPlayer().canAttackCharacter(target)) {
                            this._skill.applyEffects(this._channelizer, target);
                            this._channelizer.getActingPlayer().updatePvPStatus(target);
                            continue;
                        }
                        it.remove();
                        continue;
                    }
                    this._skill.applyEffects(this._channelizer, target);
                }
                this._channelizer.broadcastPacket(new MagicSkillLaunched(this._channelizer, this._skill.getId(), this._skill.getLevel(), targets.toArray(new L2Character[0])));
                if (this._skill.useSpiritShot()) {
                    this._channelizer.setChargedShot(this._channelizer.isChargedShot(ShotType.BLESSED_SPIRITSHOTS) ? ShotType.BLESSED_SPIRITSHOTS : ShotType.SPIRITSHOTS, false);
                } else {
                    this._channelizer.setChargedShot(ShotType.SOULSHOTS, false);
                }
                this._channelizer.rechargeShots(this._skill.useSoulShot(), this._skill.useSpiritShot());
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while channelizing skill: " + this._skill + " channelizer: " + this._channelizer + " channelized: " + this._channelized, e);
        }
    }

    public List<L2Character> getTargetList() {
        ArrayList<L2Character> targets = new ArrayList<L2Character>();
        switch (this._skill.getTargetType()) {
            case GROUND: {
                Location wordPosition;
                int x = this._channelizer.getX();
                int y = this._channelizer.getY();
                int z = this._channelizer.getZ();
                if (this._channelizer.isPlayer() && (wordPosition = this._channelizer.getActingPlayer().getCurrentSkillWorldPosition()) != null) {
                    x = wordPosition.getX();
                    y = wordPosition.getY();
                    z = wordPosition.getZ();
                }
                for (L2Character cha : this._channelizer.getKnownList().getKnownCharacters()) {
                    if (cha == null || cha == this._channelizer || cha.calculateDistance(x, y, z, true, false) > (double)this._skill.getAffectRange() || !cha.isAttackable() && !cha.isPlayable() || cha.isAlikeDead()) continue;
                    targets.add(cha);
                }
                break;
            }
            default: {
                if (this._channelizer.getTarget() == null || !this._channelizer.getTarget().isCharacter() || this._channelizer.getTarget() == this._channelizer) break;
                targets.add((L2Character)this._channelizer.getTarget());
            }
        }
        return targets;
    }
}

