/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.model.skills.funcs;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.L2WeaponType;
import com.l2jserver.gameserver.model.skills.funcs.Func;
import com.l2jserver.gameserver.model.skills.funcs.Lambda;
import com.l2jserver.gameserver.model.stats.Env;
import com.l2jserver.gameserver.model.stats.Stats;

public class FuncEnchant
extends Func {
    public FuncEnchant(Stats pStat, int pOrder, Object owner, Lambda lambda) {
        super(pStat, pOrder, owner, lambda);
    }

    @Override
    public void calc(Env env) {
        L2PcInstance player;
        if (this.cond != null && !this.cond.test(env)) {
            return;
        }
        L2ItemInstance item = (L2ItemInstance)this.funcOwner;
        int enchant = item.getEnchantLevel();
        if (enchant <= 0) {
            return;
        }
        int overenchant = 0;
        if (enchant > 3) {
            overenchant = enchant - 3;
            enchant = 3;
        }
        if (env.getPlayer() != null && (player = env.getPlayer()).isInOlympiadMode() && Config.ALT_OLY_ENCHANT_LIMIT >= 0 && enchant + overenchant > Config.ALT_OLY_ENCHANT_LIMIT) {
            if (Config.ALT_OLY_ENCHANT_LIMIT > 3) {
                overenchant = Config.ALT_OLY_ENCHANT_LIMIT - 3;
            } else {
                overenchant = 0;
                enchant = Config.ALT_OLY_ENCHANT_LIMIT;
            }
        }
        if (this.stat == Stats.MAGIC_DEFENCE || this.stat == Stats.POWER_DEFENCE) {
            env.addValue(enchant + 3 * overenchant);
            return;
        }
        if (this.stat == Stats.MAGIC_ATTACK) {
            switch (item.getItem().getItemGradeSPlus()) {
                case 5: {
                    env.addValue(4 * enchant + 8 * overenchant);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    env.addValue(3 * enchant + 6 * overenchant);
                    break;
                }
                case 0: 
                case 1: {
                    env.addValue(2 * enchant + 4 * overenchant);
                }
            }
            return;
        }
        if (item.isWeapon()) {
            L2WeaponType type = (L2WeaponType)item.getItemType();
            block5 : switch (item.getItem().getItemGradeSPlus()) {
                case 5: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.addValue(10 * enchant + 20 * overenchant);
                            break block5;
                        }
                        case BIGSWORD: 
                        case BIGBLUNT: 
                        case DUAL: 
                        case DUALFIST: 
                        case ANCIENTSWORD: 
                        case DUALDAGGER: {
                            env.addValue(6 * enchant + 12 * overenchant);
                            break block5;
                        }
                    }
                    env.addValue(5 * enchant + 10 * overenchant);
                    break;
                }
                case 4: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.addValue(8 * enchant + 16 * overenchant);
                            break block5;
                        }
                        case BIGSWORD: 
                        case BIGBLUNT: 
                        case DUAL: 
                        case DUALFIST: 
                        case ANCIENTSWORD: 
                        case DUALDAGGER: {
                            env.addValue(5 * enchant + 10 * overenchant);
                            break block5;
                        }
                    }
                    env.addValue(4 * enchant + 8 * overenchant);
                    break;
                }
                case 2: 
                case 3: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.addValue(6 * enchant + 12 * overenchant);
                            break block5;
                        }
                        case BIGSWORD: 
                        case BIGBLUNT: 
                        case DUAL: 
                        case DUALFIST: 
                        case ANCIENTSWORD: 
                        case DUALDAGGER: {
                            env.addValue(4 * enchant + 8 * overenchant);
                            break block5;
                        }
                    }
                    env.addValue(3 * enchant + 6 * overenchant);
                    break;
                }
                case 0: 
                case 1: {
                    switch (type) {
                        case BOW: 
                        case CROSSBOW: {
                            env.addValue(4 * enchant + 8 * overenchant);
                            break block5;
                        }
                    }
                    env.addValue(2 * enchant + 4 * overenchant);
                }
            }
        }
    }
}

