/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.TaskPriority;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.StopMove;
import com.l2jserver.gameserver.util.Util;
import java.nio.BufferUnderflowException;

public class MoveBackwardToLocation
extends L2GameClientPacket {
    private static final String _C__0F_MOVEBACKWARDTOLOC = "[C] 0F MoveBackwardToLoc";
    private int _targetX;
    private int _targetY;
    private int _targetZ;
    private int _originX;
    private int _originY;
    private int _originZ;
    private int _moveMovement;
    private int _curX;
    private int _curY;
    private int _curZ;

    public TaskPriority getPriority() {
        return TaskPriority.PR_HIGH;
    }

    @Override
    protected void readImpl() {
        block2: {
            this._targetX = this.readD();
            this._targetY = this.readD();
            this._targetZ = this.readD();
            this._originX = this.readD();
            this._originY = this.readD();
            this._originZ = this.readD();
            try {
                this._moveMovement = this.readD();
            }
            catch (BufferUnderflowException e) {
                if (!Config.L2WALKER_PROTECTION) break block2;
                L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
                Util.handleIllegalPlayerAction(activeChar, "Player " + activeChar.getName() + " is trying to use L2Walker and got kicked.", Config.DEFAULT_PUNISH);
            }
        }
    }

    @Override
    protected void runImpl() {
        L2PcInstance activeChar = ((L2GameClient)this.getClient()).getActiveChar();
        if (activeChar == null) {
            return;
        }
        if (Config.PLAYER_MOVEMENT_BLOCK_TIME > 0 && !activeChar.isGM() && activeChar.getNotMoveUntil() > System.currentTimeMillis()) {
            activeChar.sendPacket(SystemMessageId.CANNOT_MOVE_WHILE_SPEAKING_TO_AN_NPC);
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            return;
        }
        if (this._targetX == this._originX && this._targetY == this._originY && this._targetZ == this._originZ) {
            activeChar.sendPacket(new StopMove(activeChar));
            return;
        }
        this._targetZ += activeChar.getTemplate().getCollisionHeight();
        this._curX = activeChar.getX();
        this._curY = activeChar.getY();
        this._curZ = activeChar.getZ();
        if (activeChar.getTeleMode() > 0) {
            if (activeChar.getTeleMode() == 1) {
                activeChar.setTeleMode(0);
            }
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
            activeChar.teleToLocation(this._targetX, this._targetY, this._targetZ);
            return;
        }
        if (this._moveMovement == 0 && Config.GEODATA < 1 && !activeChar.isFlying()) {
            activeChar.sendPacket(ActionFailed.STATIC_PACKET);
        } else {
            double dx = this._targetX - this._curX;
            double dy = this._targetY - this._curY;
            if (activeChar.isOutOfControl() || dx * dx + dy * dy > 9.801E7) {
                activeChar.sendPacket(ActionFailed.STATIC_PACKET);
                return;
            }
            activeChar.getAI().setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(this._targetX, this._targetY, this._targetZ));
        }
    }

    @Override
    public String getType() {
        return _C__0F_MOVEBACKWARDTOLOC;
    }
}

