/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.clientpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.instancemanager.CastleManorManager;
import com.l2jserver.gameserver.model.ClanPrivilege;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.network.L2GameClient;
import com.l2jserver.gameserver.network.clientpackets.L2GameClientPacket;
import com.l2jserver.gameserver.util.Util;
import java.util.ArrayList;

public class RequestSetCrop
extends L2GameClientPacket {
    private static final String _C__D0_04_REQUESTSETCROP = "[C] D0:04 RequestSetCrop";
    private static final int BATCH_LENGTH = 21;
    private int _manorId;
    private Crop[] _items = null;

    @Override
    protected void readImpl() {
        this._manorId = this.readD();
        int count = this.readD();
        if (count <= 0 || count > Config.MAX_ITEM_IN_PACKET || count * 21 != this._buf.remaining()) {
            return;
        }
        this._items = new Crop[count];
        for (int i = 0; i < count; ++i) {
            int itemId = this.readD();
            long sales = this.readQ();
            long price = this.readQ();
            int type = this.readC();
            if (itemId < 1 || sales < 0L || price < 0L) {
                this._items = null;
                return;
            }
            this._items[i] = new Crop(itemId, sales, price, type);
        }
    }

    @Override
    protected void runImpl() {
        if (this._items == null) {
            return;
        }
        L2PcInstance player = ((L2GameClient)this.getClient()).getActiveChar();
        if (player == null || player.getClan() == null || !player.hasClanPrivilege(ClanPrivilege.CS_MANOR_ADMIN)) {
            return;
        }
        Castle currentCastle = CastleManager.getInstance().getCastleById(this._manorId);
        if (currentCastle.getOwnerId() != player.getClanId()) {
            return;
        }
        if (!player.isInsideRadius(player.getLastFolkNPC(), 150, true, false)) {
            return;
        }
        ArrayList<CropProcure> crops = new ArrayList<CropProcure>(this._items.length);
        for (Crop i : this._items) {
            CropProcure s = i.getCrop();
            if (s == null) {
                Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " tried to overflow while setting manor.", Config.DEFAULT_PUNISH);
                return;
            }
            crops.add(s);
        }
        currentCastle.setCropProcure(crops, 1);
        if (Config.ALT_MANOR_SAVE_ALL_ACTIONS) {
            currentCastle.saveCropData(1);
        }
    }

    @Override
    public String getType() {
        return _C__D0_04_REQUESTSETCROP;
    }

    private static class Crop {
        private final int _itemId;
        private final long _sales;
        private final long _price;
        private final int _type;

        public Crop(int id, long s, long p, int t) {
            this._itemId = id;
            this._sales = s;
            this._price = p;
            this._type = t;
        }

        public CropProcure getCrop() {
            if (this._sales != 0L && Inventory.MAX_ADENA / this._sales < this._price) {
                return null;
            }
            return CastleManorManager.getInstance().getNewCropProcure(this._itemId, this._sales, this._type, this._price, this._sales);
        }
    }
}

