/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.Config;
import com.l2jserver.gameserver.model.buylist.L2BuyList;
import com.l2jserver.gameserver.model.buylist.Product;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.Collection;

public final class BuyList
extends L2GameServerPacket {
    private final int _listId;
    private final Collection<Product> _list;
    private final long _money;
    private double _taxRate = 0.0;

    public BuyList(L2BuyList list, long currentMoney, double taxRate) {
        this._listId = list.getListId();
        this._list = list.getProducts();
        this._money = currentMoney;
        this._taxRate = taxRate;
    }

    @Override
    protected final void writeImpl() {
        this.writeC(254);
        this.writeH(183);
        this.writeD(0);
        this.writeQ(this._money);
        this.writeD(this._listId);
        this.writeH(this._list.size());
        for (Product product : this._list) {
            long item_getCurrentCount = product.getCount();
            if (item_getCurrentCount <= 0L && product.hasLimitedStock()) continue;
            this.writeD(product.getItemId());
            this.writeD(product.getItemId());
            this.writeD(0);
            this.writeQ(item_getCurrentCount < 0L ? 0L : item_getCurrentCount);
            this.writeH(product.getItem().getType2());
            this.writeH(product.getItem().getType1());
            this.writeH(0);
            this.writeD(product.getItem().getBodyPart());
            this.writeH(0);
            this.writeH(0);
            this.writeD(0);
            this.writeD(-1);
            this.writeD(-9999);
            this.writeH(0);
            this.writeH(0);
            for (int i = 0; i < 6; i = (int)((byte)(i + 1))) {
                this.writeH(0);
            }
            this.writeH(0);
            this.writeH(0);
            this.writeH(0);
            int item_getItemId = product.getItemId();
            if (item_getItemId >= 3960 && item_getItemId <= 4026 || item_getItemId >= 5205 && item_getItemId <= 5219 || item_getItemId >= 6038 && item_getItemId <= 6306 || item_getItemId >= 6779 && item_getItemId <= 6833 || item_getItemId >= 7918 && item_getItemId <= 8029) {
                this.writeQ((long)((double)((float)product.getPrice() * Config.RATE_SIEGE_GUARDS_PRICE) * (1.0 + this._taxRate)));
                continue;
            }
            this.writeQ((long)((double)product.getPrice() * (1.0 + this._taxRate)));
        }
    }
}

