/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.network.serverpackets;

import com.l2jserver.gameserver.datatables.ManorData;
import com.l2jserver.gameserver.model.CropProcure;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import java.util.List;
import jp.sf.l2j.troja.FastIntObjectMap;

public class ExShowSellCropList
extends L2GameServerPacket {
    private int _manorId = 1;
    private final FastIntObjectMap<L2ItemInstance> _cropsItems;
    private final FastIntObjectMap<CropProcure> _castleCrops;

    public ExShowSellCropList(L2PcInstance player, int manorId, List<CropProcure> crops) {
        int[] allCrops;
        this._manorId = manorId;
        this._castleCrops = new FastIntObjectMap();
        this._cropsItems = new FastIntObjectMap();
        for (int cropId : allCrops = ManorData.getInstance().getAllCrops()) {
            L2ItemInstance item = player.getInventory().getItemByItemId(cropId);
            if (item == null) continue;
            this._cropsItems.put(cropId, (Object)item);
        }
        for (CropProcure crop : crops) {
            if (!this._cropsItems.containsKey(crop.getId()) || crop.getAmount() <= 0L) continue;
            this._castleCrops.put(crop.getId(), (Object)crop);
        }
    }

    @Override
    public void writeImpl() {
        this.writeC(254);
        this.writeH(44);
        this.writeD(this._manorId);
        this.writeD(this._cropsItems.size());
        for (L2ItemInstance item : this._cropsItems.values()) {
            this.writeD(item.getObjectId());
            this.writeD(item.getDisplayId());
            this.writeD(ManorData.getInstance().getSeedLevelByCrop(item.getId()));
            this.writeC(1);
            this.writeD(ManorData.getInstance().getRewardItem(item.getId(), 1));
            this.writeC(1);
            this.writeD(ManorData.getInstance().getRewardItem(item.getId(), 2));
            CropProcure crop = (CropProcure)this._castleCrops.get(item.getId());
            if (crop != null) {
                this.writeD(this._manorId);
                this.writeQ(crop.getAmount());
                this.writeQ(crop.getPrice());
                this.writeC(crop.getReward());
            } else {
                this.writeD(-1);
                this.writeQ(0L);
                this.writeQ(0L);
                this.writeC(0);
            }
            this.writeQ(item.getCount());
        }
    }
}

