/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

import com.l2jserver.Config;
import com.l2jserver.gameserver.Announcements;
import com.l2jserver.gameserver.Shutdown;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeadLockDetector
extends Thread {
    private static Logger _log = Logger.getLogger(DeadLockDetector.class.getName());
    private static final int _sleepTime = Config.DEADLOCK_CHECK_INTERVAL * 1000;
    private final ThreadMXBean tmx = ManagementFactory.getThreadMXBean();

    public DeadLockDetector() {
        super("DeadLockDetector");
    }

    @Override
    public final void run() {
        boolean deadlock = false;
        while (!deadlock) {
            try {
                long[] ids = this.tmx.findDeadlockedThreads();
                if (ids != null) {
                    deadlock = true;
                    ThreadInfo[] tis = this.tmx.getThreadInfo(ids, true, true);
                    StringBuilder info = new StringBuilder(256).append("DeadLock Found!").append(Config.EOL);
                    for (ThreadInfo ti : tis) {
                        this.appendThreadInfo(info, ti);
                    }
                    for (ThreadInfo ti : tis) {
                        LockInfo[] locks = ti.getLockedSynchronizers();
                        MonitorInfo[] monitors = ti.getLockedMonitors();
                        if (locks.length == 0 && monitors.length == 0) continue;
                        ThreadInfo dl = ti;
                        info.append("Java-level deadlock:").append(Config.EOL).append('\t').append(dl.getThreadName()).append(" is waiting to lock ").append(dl.getLockInfo().toString()).append(" which is held by ").append(dl.getLockOwnerName()).append(Config.EOL);
                        while ((dl = this.tmx.getThreadInfo(new long[]{dl.getLockOwnerId()}, true, true)[0]).getThreadId() != ti.getThreadId()) {
                            info.append('\t').append(dl.getThreadName()).append(" is waiting to lock ").append(dl.getLockInfo().toString()).append(" which is held by ").append(dl.getLockOwnerName()).append(Config.EOL);
                        }
                    }
                    _log.warning(info.toString());
                    if (Config.RESTART_ON_DEADLOCK) {
                        Announcements an = Announcements.getInstance();
                        an.announceToAll("Server has stability issues - restarting now.");
                        Shutdown.getInstance().startTelnetShutdown("DeadLockDetector - Auto Restart", 60, true);
                    }
                }
                Thread.sleep(_sleepTime);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "DeadLockDetector: ", e);
            }
        }
    }

    void appendThreadInfo(StringBuilder sb, ThreadInfo ti) {
        LockInfo[] locks;
        int i;
        MonitorInfo[] lockedMonitors = ti.getLockedMonitors();
        StackTraceElement[] stackTrace = ti.getStackTrace();
        sb.append('\"').append(ti.getThreadName()).append("\" Id=").append(ti.getThreadId()).append(' ').append((Object)ti.getThreadState());
        if (ti.getLockName() != null) {
            sb.append(" on ").append(ti.getLockName());
        }
        if (ti.getLockOwnerName() != null) {
            sb.append(" owned by \"").append(ti.getLockOwnerName()).append("\" Id=").append(ti.getLockOwnerId());
        }
        if (ti.isSuspended()) {
            sb.append(" (suspended)");
        }
        if (ti.isInNative()) {
            sb.append(" (in native)");
        }
        sb.append(Config.EOL);
        for (i = 0; i < stackTrace.length; ++i) {
            StackTraceElement ste = stackTrace[i];
            sb.append("\tat ").append(ste.toString()).append(Config.EOL);
            if (i == 0 && ti.getLockInfo() != null) {
                Thread.State ts = ti.getThreadState();
                switch (ts) {
                    case BLOCKED: {
                        sb.append("\t-  blocked on ").append(ti.getLockInfo()).append(Config.EOL);
                        break;
                    }
                    case WAITING: {
                        sb.append("\t-  waiting on ").append(ti.getLockInfo()).append(Config.EOL);
                        break;
                    }
                    case TIMED_WAITING: {
                        sb.append("\t-  waiting on ").append(ti.getLockInfo()).append(Config.EOL);
                        break;
                    }
                }
            }
            for (LockInfo lockInfo : lockedMonitors) {
                if (((MonitorInfo)lockInfo).getLockedStackDepth() != i) continue;
                sb.append("\t-  locked ").append(lockInfo).append(Config.EOL);
            }
        }
        if (i < stackTrace.length) {
            sb.append("\t...").append(Config.EOL);
        }
        if ((locks = ti.getLockedSynchronizers()).length > 0) {
            sb.append(Config.EOL).append("\tNumber of locked synchronizers = ").append(locks.length).append(Config.EOL);
            for (LockInfo lockInfo : locks) {
                sb.append("\t- ").append(lockInfo).append(Config.EOL);
            }
        }
        sb.append(Config.EOL);
    }
}

