/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.util;

public class HexUtils {
    private static final char[] NIBBLE_CHAR_LOOKUP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static char[] b2HexChars(byte data) {
        return HexUtils.b2HexChars(data, null, 0);
    }

    public static char[] b2HexChars(byte data, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[2];
            dstOffset = 0;
        }
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 4 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data & 0xF];
        return dstHexChars;
    }

    public static char[] int2HexChars(int data) {
        return HexUtils.int2HexChars(data, new char[8], 0);
    }

    public static char[] int2HexChars(int data, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[8];
            dstOffset = 0;
        }
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 28 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 24 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 20 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 16 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 12 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 8 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data >> 4 & 0xF];
        dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data & 0xF];
        return dstHexChars;
    }

    public static char[] bArr2HexChars(byte[] data, int offset, int len) {
        return HexUtils.bArr2HexChars(data, offset, len, null, 0);
    }

    public static char[] bArr2HexChars(byte[] data, int offset, int len, char[] dstHexChars, int dstOffset) {
        if (dstHexChars == null) {
            dstHexChars = new char[len * 2];
            dstOffset = 0;
        }
        int end = len + offset;
        for (int dataIdx = offset; dataIdx < end; ++dataIdx) {
            dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data[dataIdx] >> 4 & 0xF];
            dstHexChars[dstOffset++] = NIBBLE_CHAR_LOOKUP[data[dataIdx] & 0xF];
        }
        return dstHexChars;
    }

    public static char[] bArr2AsciiChars(byte[] data, int offset, int len) {
        return HexUtils.bArr2AsciiChars(data, offset, len, new char[len], 0);
    }

    public static char[] bArr2AsciiChars(byte[] data, int offset, int len, char[] dstAsciiChars, int dstOffset) {
        if (dstAsciiChars == null) {
            dstAsciiChars = new char[len];
            dstOffset = 0;
        }
        int end = len + offset;
        for (int dataIdx = offset; dataIdx < end; ++dataIdx) {
            int b = data[dataIdx] & 0xFF;
            dstAsciiChars[dstOffset++] = b > 31 && b < 128 ? (int)b : 46;
        }
        return dstAsciiChars;
    }

    public static CharSequence bArr2HexEdChars(byte[] data, int len) {
        StringBuilder sb = new StringBuilder(len * 4);
        int ix = 0;
        while (ix < len) {
            sb.append(NIBBLE_CHAR_LOOKUP[ix >> 20 & 0xF]).append(NIBBLE_CHAR_LOOKUP[ix >> 16 & 0xF]).append(NIBBLE_CHAR_LOOKUP[ix >> 12 & 0xF]).append(NIBBLE_CHAR_LOOKUP[ix >> 8 & 0xF]).append(NIBBLE_CHAR_LOOKUP[ix >> 4 & 0xF]).append(NIBBLE_CHAR_LOOKUP[ix & 0xF]).append(' ');
            int end = ix + 16;
            int col = 0;
            while (ix < end) {
                if (ix < len) {
                    byte b = data[ix];
                    sb.append(col == 8 ? (char)'-' : ' ').append(NIBBLE_CHAR_LOOKUP[b >> 4 & 0xF]).append(NIBBLE_CHAR_LOOKUP[b & 0xF]);
                } else {
                    sb.append(' ').append(' ').append(' ');
                }
                ++ix;
                ++col;
            }
            ix -= 16;
            sb.append(' ').append(' ');
            while (ix < end && ix < len) {
                byte b = data[ix];
                sb.append(b < 32 ? (char)'\uff65' : (char)(b & 0xFF));
                ++ix;
            }
            sb.append('\n');
        }
        return sb;
    }
}

