/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package ai.npc.ArenaManager;

import static com.l2jserver.gameserver.datatables.SkillData.*;
import ai.npc.AbstractNpcAI;

import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.Inventory;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.SystemMessageId;

/**
 * Arena Manager AI.
 * @author St3eT
 */
public class ArenaManager extends AbstractNpcAI
{
	// NPCs
	private static final int[] ARENA_MANAGER =
	{
		31226, // Arena Director (MDT)
		31225, // Arena Manager (Coliseum)
	};
	// Skill
	private static final int[] BUFFS =
	{
		getSkillHashCode(6805, 1), // Arena Empower
		getSkillHashCode(6806, 1), // Arena Acumen
		getSkillHashCode(6807, 1), // Arena Concentration
		getSkillHashCode(6808, 1), // Arena Might
		getSkillHashCode(6804, 1), // Arena Wind Walk
		getSkillHashCode(6812, 1), // Arena Berserker Spirit
	};
	private static final int CP_RECOVERY = getSkillHashCode(4380, 1); // Arena: CP Recovery
	private static final int HP_RECOVERY = getSkillHashCode(6817, 1); // Arena HP Recovery
	// Misc
	private static final int CP_COST = 1000;
	private static final int HP_COST = 1000;
	private static final int BUFF_COST = 2000;
	
	private static final String YOU_CAN_NOT_GET_RECOVER_INSIDE_FENCE = "̍̒ɂ͉񕜖@܂B";	//[JOJO]
	
	private ArenaManager()
	{
		super(ArenaManager.class.getSimpleName(), "ai/npc");
		addStartNpc(ARENA_MANAGER);
		addTalkId(ARENA_MANAGER);
		addFirstTalkId(ARENA_MANAGER);
	}
	
	@Override
	public String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		switch (event)
		{
			case "CPrecovery":
			{
				if (player.isInsideZone(ZoneId.PVP))
				{
					player.sendMessage(YOU_CAN_NOT_GET_RECOVER_INSIDE_FENCE);	//[JOJO]
				}
				else if (!takeItems(player, Inventory.ADENA_ID, CP_COST))
				{
					player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
				}
				else
				{
					startQuestTimer("CPrecovery_delay", 2000, npc, player);
				}
				break;
			}
			case "CPrecovery_delay":
			{
				if (player.isInsideZone(ZoneId.PVP))
				{
					player.sendMessage(YOU_CAN_NOT_GET_RECOVER_INSIDE_FENCE);	//[JOJO]
				}
				else 
				{
					npc.setTarget(player);
					npc.doCast(getSkill(CP_RECOVERY));
				}
				break;
			}
			case "HPrecovery":
			{
				if (player.isInsideZone(ZoneId.PVP))
				{
					player.sendMessage(YOU_CAN_NOT_GET_RECOVER_INSIDE_FENCE);	//[JOJO]
				}
				else if (!takeItems(player, Inventory.ADENA_ID, HP_COST))
				{
					player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
				}
				else
				{
					startQuestTimer("HPrecovery_delay", 2000, npc, player);
				}
				break;
			}
			case "HPrecovery_delay":
			{
				if (player.isInsideZone(ZoneId.PVP))
				{
					player.sendMessage(YOU_CAN_NOT_GET_RECOVER_INSIDE_FENCE);	//[JOJO]
				}
				else 
				{
					npc.setTarget(player);
					npc.doCast(getSkill(HP_RECOVERY));
				}
				break;
			}
			case "Buff":
			{
				if (!takeItems(player, Inventory.ADENA_ID, BUFF_COST))
				{
					player.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
				}
				else
				{
					npc.setTarget(player);
					for (int skill : BUFFS)
					{
						npc.doCast(getSkill(skill));
					}
				}
				break;
			}
		}
		return null;
	}
	
	public static void main(String[] args)
	{
		new ArenaManager();
	}
}