/*
 * Copyright (C) 2004-2014 L2J DataPack
 * 
 * This file is part of L2J DataPack.
 * 
 * L2J DataPack is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * L2J DataPack is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package quests.Q00692_HowtoOpposeEvil;

import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;

import com.l2jserver.Config;
import com.l2jserver.gameserver.enums.QuestSound;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.quest.Quest;
import com.l2jserver.gameserver.model.quest.QuestState;

/**
 * How to Oppose Evil (692)
 * @author Gigiikun
 */
public final class Q00692_HowtoOpposeEvil extends Quest
{
	private static final int DILIOS = 32549;
	private static final int KIRKLAN = 32550;
	private static final int LEKONS_CERTIFICATE = 13857;
	private static final int[] QUEST_ITEMS =
	{
		13863,
		13864,
		13865,
		13866,
		13867,
		15535,
		15536
	};
	
	private static final ItemHolder ITEM_SEED_OF_INFINITY = new ItemHolder(13863, 500);		// (itemId, chance)
	private static final ItemHolder ITEM_SEED_OF_DESTRUCTION = new ItemHolder(13865, 250);
	private static final ItemHolder ITEM_SEED_OF_ANNIHILATION = new ItemHolder(15536, 125);
	
	private static final SortedIntObjectArrayMap<ItemHolder> QUEST_MOBS = new SortedIntObjectArrayMap<ItemHolder>()
		// Seed of Infinity
		.append(22509, ITEM_SEED_OF_INFINITY)
		.append(22510, ITEM_SEED_OF_INFINITY)
		.append(22511, ITEM_SEED_OF_INFINITY)
		.append(22512, ITEM_SEED_OF_INFINITY)
		.append(22513, ITEM_SEED_OF_INFINITY)
		.append(22514, ITEM_SEED_OF_INFINITY)
		.append(22515, ITEM_SEED_OF_INFINITY)
		// Seed of Destruction
		.append(22537, ITEM_SEED_OF_DESTRUCTION)
		.append(22538, ITEM_SEED_OF_DESTRUCTION)
		.append(22539, ITEM_SEED_OF_DESTRUCTION)
		.append(22540, ITEM_SEED_OF_DESTRUCTION)
		.append(22541, ITEM_SEED_OF_DESTRUCTION)
		.append(22542, ITEM_SEED_OF_DESTRUCTION)
		.append(22543, ITEM_SEED_OF_DESTRUCTION)
		.append(22544, ITEM_SEED_OF_DESTRUCTION)
		.append(22546, ITEM_SEED_OF_DESTRUCTION)
		.append(22547, ITEM_SEED_OF_DESTRUCTION)
		.append(22548, ITEM_SEED_OF_DESTRUCTION)
		.append(22549, ITEM_SEED_OF_DESTRUCTION)
		.append(22550, ITEM_SEED_OF_DESTRUCTION)
		.append(22551, ITEM_SEED_OF_DESTRUCTION)
		.append(22552, ITEM_SEED_OF_DESTRUCTION)
		.append(22593, ITEM_SEED_OF_DESTRUCTION)
		.append(22596, ITEM_SEED_OF_DESTRUCTION)
		.append(22597, ITEM_SEED_OF_DESTRUCTION)
		// Seed of Annihilation
		.append(22746, ITEM_SEED_OF_ANNIHILATION)
		.append(22747, ITEM_SEED_OF_ANNIHILATION)
		.append(22748, ITEM_SEED_OF_ANNIHILATION)
		.append(22749, ITEM_SEED_OF_ANNIHILATION)
		.append(22750, ITEM_SEED_OF_ANNIHILATION)
		.append(22751, ITEM_SEED_OF_ANNIHILATION)
		.append(22752, ITEM_SEED_OF_ANNIHILATION)
		.append(22753, ITEM_SEED_OF_ANNIHILATION)
		.append(22754, ITEM_SEED_OF_ANNIHILATION)
		.append(22755, ITEM_SEED_OF_ANNIHILATION)
		.append(22756, ITEM_SEED_OF_ANNIHILATION)
		.append(22757, ITEM_SEED_OF_ANNIHILATION)
		.append(22758, ITEM_SEED_OF_ANNIHILATION)
		.append(22759, ITEM_SEED_OF_ANNIHILATION)
		.append(22760, ITEM_SEED_OF_ANNIHILATION)
		.append(22761, ITEM_SEED_OF_ANNIHILATION)
		.append(22762, ITEM_SEED_OF_ANNIHILATION)
		.append(22763, ITEM_SEED_OF_ANNIHILATION)
		.append(22764, ITEM_SEED_OF_ANNIHILATION)
		.append(22765, ITEM_SEED_OF_ANNIHILATION)
	;
	
	public Q00692_HowtoOpposeEvil(int questId, String name, String descr)
	{
		super(questId, name, descr);
		addStartNpc(DILIOS);
		addTalkId(DILIOS, KIRKLAN);
		addKillId(QUEST_MOBS.keySet());
	}
	
	@Override
	public final String onAdvEvent(String event, L2Npc npc, L2PcInstance player)
	{
		QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return getNoQuestMsg(player);
		}
		if (event.equalsIgnoreCase("32549-03.htm"))
		{
			st.startQuest();
		}
		else if (event.equalsIgnoreCase("32550-04.htm"))
		{
			st.setCond(3);
		}
		else if (event.equalsIgnoreCase("32550-07.htm"))
		{
			if (!giveReward(st, 13863, 5, 13796, 1))
			{
				return "32550-08.htm";
			}
		}
		else if (event.equalsIgnoreCase("32550-09.htm"))
		{
			if (!giveReward(st, 13798, 1, 57, 5000))
			{
				return "32550-10.htm";
			}
		}
		else if (event.equalsIgnoreCase("32550-12.htm"))
		{
			if (!giveReward(st, 13865, 5, 13841, 1))
			{
				return "32550-13.htm";
			}
		}
		else if (event.equalsIgnoreCase("32550-14.htm"))
		{
			if (!giveReward(st, 13867, 1, 57, 5000))
			{
				return "32550-15.htm";
			}
		}
		else if (event.equalsIgnoreCase("32550-17.htm"))
		{
			if (!giveReward(st, 15536, 5, 15486, 1))
			{
				return "32550-18.htm";
			}
		}
		else if (event.equalsIgnoreCase("32550-19.htm"))
		{
			if (!giveReward(st, 15535, 1, 57, 5000))
			{
				return "32550-20.htm";
			}
		}
		return event;
	}
	
	@Override
	public final String onKill(L2Npc npc, L2PcInstance player, boolean isSummon)
	{
		final L2PcInstance partyMember = getRandomPartyMember(player, 3);
		if (partyMember == null)
		{
			return null;
		}
		final QuestState st = partyMember.getQuestState(getName());
		final ItemHolder item;
		if (st != null && (item = QUEST_MOBS.get(npc.getId())) != null)
		{
			int chance = (int) (item.getCount() * Config.RATE_QUEST_DROP);
			int numItems = chance / 1000;
			chance = chance % 1000;
			if (getRandom(1000) < chance)
			{
				numItems++;
			}
			if (numItems > 0)
			{
				st.giveItems(item.getId(), numItems);
				st.playSound(QuestSound.ITEMSOUND_QUEST_ITEMGET);
			}
		}
		return null;
	}
	
	@Override
	public final String onTalk(L2Npc npc, L2PcInstance player)
	{
		String htmltext = getNoQuestMsg(player);
		final QuestState st = player.getQuestState(getName());
		if (st == null)
		{
			return htmltext;
		}
		
		if (st.isCreated())
		{
			htmltext = (player.getLevel() >= 75) ? "32549-01.htm" : "32549-00.htm";
		}
		else
		{
			if (npc.getId() == DILIOS)
			{
				if (st.isCond(1) && st.hasQuestItems(LEKONS_CERTIFICATE))
				{
					htmltext = "32549-04.htm";
					st.takeItems(LEKONS_CERTIFICATE, -1);
					st.setCond(2);
				}
				else if (st.isCond(2))
				{
					htmltext = "32549-05.htm";
				}
			}
			else
			{
				if (st.isCond(2))
				{
					htmltext = "32550-01.htm";
				}
				else if (st.isCond(3))
				{
					for (int i : QUEST_ITEMS)
					{
						if (st.getQuestItemsCount(i) > 0)
						{
							return "32550-05.htm";
						}
					}
					htmltext = "32550-04.htm";
				}
			}
		}
		return htmltext;
	}
	
	private static final boolean giveReward(QuestState st, int itemId, int minCount, int rewardItemId, long rewardCount)
	{
		long count = st.getQuestItemsCount(itemId);
		if (count < minCount)
		{
			return false;
		}
		
		count = count / minCount;
		st.takeItems(itemId, count * minCount);
		st.rewardItems(rewardItemId, rewardCount * count);
		return true;
	}
	
	public static void main(String[] args)
	{
		new Q00692_HowtoOpposeEvil(692, Q00692_HowtoOpposeEvil.class.getSimpleName(), "ɗ@");
	}
}