/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.DoorTable;
import com.l2jserver.gameserver.geoengine.Direction;
import com.l2jserver.gameserver.geoengine.NullDriver;
import com.l2jserver.gameserver.geoengine.abstraction.IGeoDriver;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.util.GeoUtils;
import com.l2jserver.gameserver.util.LinePointIterator;
import com.l2jserver.gameserver.util.LinePointIterator3D;
import java.io.FileInputStream;
import java.lang.reflect.Constructor;
import java.nio.file.Paths;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GeoData
implements IGeoDriver {
    private static final Logger LOGGER = Logger.getLogger(GeoData.class.getName());
    private static final int ELEVATED_SEE_OVER_DISTANCE = 2;
    private static final int MAX_SEE_OVER_HEIGHT = 48;
    private final IGeoDriver _driver;

    public static GeoData getInstance() {
        return SingletonHolder._instance;
    }

    protected GeoData() {
        if (Config.GEODATA > 0) {
            IGeoDriver driver = null;
            try {
                Class<?> cls = Class.forName(Config.GEODATA_DRIVER);
                if (!IGeoDriver.class.isAssignableFrom(cls)) {
                    throw new ClassCastException("Geodata driver class needs to implement IGeoDriver!");
                }
                Constructor<?> ctor = cls.getConstructor(Properties.class);
                Properties props = new Properties();
                try (FileInputStream fis = new FileInputStream(Paths.get("config", "GeoDriver.properties").toString());){
                    props.load(fis);
                }
                driver = (IGeoDriver)ctor.newInstance(props);
            }
            catch (Exception ex) {
                LOGGER.log(Level.SEVERE, "Failed to load geodata driver!", ex);
                System.exit(1);
            }
            this._driver = driver;
        } else {
            this._driver = new NullDriver(null);
        }
    }

    public int getGeoX(int worldX) {
        return this._driver.getGeoX(worldX);
    }

    public int getGeoY(int worldY) {
        return this._driver.getGeoY(worldY);
    }

    public int getWorldX(int geoX) {
        return this._driver.getWorldX(geoX);
    }

    public int getWorldY(int geoY) {
        return this._driver.getWorldY(geoY);
    }

    public boolean hasGeoPos(int geoX, int geoY) {
        return this._driver.hasGeoPos(geoX, geoY);
    }

    public int getNearestZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNearestZ(geoX, geoY, worldZ);
    }

    public int getNextLowerZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNextLowerZ(geoX, geoY, worldZ);
    }

    public int getNextHigherZ(int geoX, int geoY, int worldZ) {
        return this._driver.getNextHigherZ(geoX, geoY, worldZ);
    }

    public boolean canEnterNeighbors(int geoX, int geoY, int worldZ, Direction first, Direction ... more) {
        return this._driver.canEnterNeighbors(geoX, geoY, worldZ, first, more);
    }

    public boolean canEnterAllNeighbors(int geoX, int geoY, int worldZ) {
        return this._driver.canEnterAllNeighbors(geoX, geoY, worldZ);
    }

    public boolean isNullDriver() {
        return this._driver instanceof NullDriver;
    }

    public int getHeight(int x, int y, int z) {
        return this.getNearestZ(this.getGeoX(x), this.getGeoY(y), z);
    }

    public int getSpawnHeight(int x, int y, int z) {
        return this.getNextLowerZ(this.getGeoX(x), this.getGeoY(y), z + 30);
    }

    public int getSpawnHeight(Location location) {
        return this.getSpawnHeight(location.getX(), location.getY(), location.getZ());
    }

    public boolean canSeeTarget(L2Object cha, L2Object target) {
        if (target.isDoor()) {
            return true;
        }
        return this.canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), cha.getInstanceId(), target.getX(), target.getY(), target.getZ(), target.getInstanceId());
    }

    public boolean canSeeTarget(L2Object cha, ILocational worldPosition) {
        return this.canSeeTarget(cha.getX(), cha.getY(), cha.getZ(), cha.getInstanceId(), worldPosition.getX(), worldPosition.getY(), worldPosition.getZ());
    }

    public boolean canSeeTarget(int x, int y, int z, int instanceId, int tx, int ty, int tz, int tInstanceId) {
        if (instanceId != tInstanceId) {
            return false;
        }
        return this.canSeeTarget(x, y, z, instanceId, tx, ty, tz);
    }

    public boolean canSeeTarget(int x, int y, int z, int instanceId, int tx, int ty, int tz) {
        if (DoorTable.getInstance().checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, true)) {
            return false;
        }
        return this.canSeeTarget(x, y, z, tx, ty, tz);
    }

    private int getLosGeoZ(int prevX, int prevY, int prevGeoZ, int curX, int curY, Direction dir) {
        boolean can = true;
        switch (dir) {
            case NORTH_EAST: {
                can = this.canEnterNeighbors(prevX, prevY - 1, prevGeoZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevGeoZ, Direction.NORTH, new Direction[0]);
                break;
            }
            case NORTH_WEST: {
                can = this.canEnterNeighbors(prevX, prevY - 1, prevGeoZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevGeoZ, Direction.NORTH, new Direction[0]);
                break;
            }
            case SOUTH_EAST: {
                can = this.canEnterNeighbors(prevX, prevY + 1, prevGeoZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevGeoZ, Direction.SOUTH, new Direction[0]);
                break;
            }
            case SOUTH_WEST: {
                boolean bl = can = this.canEnterNeighbors(prevX, prevY + 1, prevGeoZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevGeoZ, Direction.SOUTH, new Direction[0]);
            }
        }
        if (can && this.canEnterNeighbors(prevX, prevY, prevGeoZ, dir, new Direction[0])) {
            return this.getNearestZ(curX, curY, prevGeoZ);
        }
        return this.getNextHigherZ(curX, curY, prevGeoZ);
    }

    public boolean canSeeTarget(int x, int y, int z, int tx, int ty, int tz) {
        int prevZ;
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        z = this.getNearestZ(geoX, geoY, z);
        tz = this.getNearestZ(tGeoX, tGeoY, tz);
        if (geoX == tGeoX && geoY == tGeoY) {
            if (this.hasGeoPos(tGeoX, tGeoY)) {
                return z == tz;
            }
            return true;
        }
        if (tz > z) {
            int tmp = tx;
            tx = x;
            x = tmp;
            tmp = ty;
            ty = y;
            y = tmp;
            tmp = tz;
            tz = z;
            z = tmp;
            tmp = tGeoX;
            tGeoX = geoX;
            geoX = tmp;
            tmp = tGeoY;
            tGeoY = geoY;
            geoY = tmp;
        }
        LinePointIterator3D pointIter = new LinePointIterator3D(geoX, geoY, z, tGeoX, tGeoY, tz);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevGeoZ = prevZ = pointIter.z();
        int ptIndex = 0;
        while (pointIter.next()) {
            int curX = pointIter.x();
            int curY = pointIter.y();
            if (curX == prevX && curY == prevY) continue;
            int beeCurZ = pointIter.z();
            int curGeoZ = prevGeoZ;
            if (this.hasGeoPos(curX, curY)) {
                int beeCurGeoZ = this.getNearestZ(curX, curY, beeCurZ);
                Direction dir = GeoUtils.computeDirection(prevX, prevY, curX, curY);
                curGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, curX, curY, dir);
                int maxHeight = ptIndex < 2 ? z + 48 : beeCurZ + 48;
                boolean canSeeThrough = false;
                if (curGeoZ <= maxHeight && curGeoZ <= beeCurGeoZ) {
                    switch (dir) {
                        case NORTH_EAST: {
                            int northGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY - 1, Direction.EAST);
                            int eastGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX + 1, prevY, Direction.NORTH);
                            canSeeThrough = northGeoZ <= maxHeight && eastGeoZ <= maxHeight && northGeoZ <= this.getNearestZ(prevX, prevY - 1, beeCurZ) && eastGeoZ <= this.getNearestZ(prevX + 1, prevY, beeCurZ);
                            break;
                        }
                        case NORTH_WEST: {
                            int northGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY - 1, Direction.WEST);
                            int westGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX - 1, prevY, Direction.NORTH);
                            canSeeThrough = northGeoZ <= maxHeight && westGeoZ <= maxHeight && northGeoZ <= this.getNearestZ(prevX, prevY - 1, beeCurZ) && westGeoZ <= this.getNearestZ(prevX - 1, prevY, beeCurZ);
                            break;
                        }
                        case SOUTH_EAST: {
                            int southGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY + 1, Direction.EAST);
                            int eastGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX + 1, prevY, Direction.SOUTH);
                            canSeeThrough = southGeoZ <= maxHeight && eastGeoZ <= maxHeight && southGeoZ <= this.getNearestZ(prevX, prevY + 1, beeCurZ) && eastGeoZ <= this.getNearestZ(prevX + 1, prevY, beeCurZ);
                            break;
                        }
                        case SOUTH_WEST: {
                            int southGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX, prevY + 1, Direction.WEST);
                            int westGeoZ = this.getLosGeoZ(prevX, prevY, prevGeoZ, prevX - 1, prevY, Direction.SOUTH);
                            canSeeThrough = southGeoZ <= maxHeight && westGeoZ <= maxHeight && southGeoZ <= this.getNearestZ(prevX, prevY + 1, beeCurZ) && westGeoZ <= this.getNearestZ(prevX - 1, prevY, beeCurZ);
                            break;
                        }
                        default: {
                            canSeeThrough = true;
                        }
                    }
                }
                if (!canSeeThrough) {
                    return false;
                }
            }
            prevX = curX;
            prevY = curY;
            prevGeoZ = curGeoZ;
            ++ptIndex;
        }
        return true;
    }

    public Location moveCheck(int x, int y, int z, int tx, int ty, int tz, int instanceId) {
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        z = this.getNearestZ(geoX, geoY, z);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        tz = this.getNearestZ(tGeoX, tGeoY, tz);
        if (DoorTable.getInstance().checkIfDoorsBetween(x, y, z, tx, ty, tz, instanceId, false)) {
            return new Location(x, y, this.getHeight(x, y, z));
        }
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevZ = z;
        while (pointIter.next()) {
            int curX = pointIter.x();
            int curY = pointIter.y();
            int curZ = this.getNearestZ(curX, curY, prevZ);
            if (this.hasGeoPos(prevX, prevY)) {
                Direction dir = GeoUtils.computeDirection(prevX, prevY, curX, curY);
                boolean canEnter = false;
                if (this.canEnterNeighbors(prevX, prevY, prevZ, dir, new Direction[0])) {
                    switch (dir) {
                        case NORTH_EAST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY - 1, prevZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevZ, Direction.NORTH, new Direction[0]);
                            break;
                        }
                        case NORTH_WEST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY - 1, prevZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevZ, Direction.NORTH, new Direction[0]);
                            break;
                        }
                        case SOUTH_EAST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY + 1, prevZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevZ, Direction.SOUTH, new Direction[0]);
                            break;
                        }
                        case SOUTH_WEST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY + 1, prevZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevZ, Direction.SOUTH, new Direction[0]);
                            break;
                        }
                        default: {
                            canEnter = true;
                        }
                    }
                }
                if (!canEnter) {
                    return new Location(this.getWorldX(prevX), this.getWorldY(prevY), prevZ);
                }
            }
            prevX = curX;
            prevY = curY;
            prevZ = curZ;
        }
        if (this.hasGeoPos(prevX, prevY) && prevZ != tz) {
            return new Location(x, y, z);
        }
        return new Location(tx, ty, tz);
    }

    public boolean canMove(int fromX, int fromY, int fromZ, int toX, int toY, int toZ, int instanceId) {
        int geoX = this.getGeoX(fromX);
        int geoY = this.getGeoY(fromY);
        fromZ = this.getNearestZ(geoX, geoY, fromZ);
        int tGeoX = this.getGeoX(toX);
        int tGeoY = this.getGeoY(toY);
        toZ = this.getNearestZ(tGeoX, tGeoY, toZ);
        if (DoorTable.getInstance().checkIfDoorsBetween(fromX, fromY, fromZ, toX, toY, toZ, instanceId, false)) {
            return false;
        }
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevX = pointIter.x();
        int prevY = pointIter.y();
        int prevZ = fromZ;
        while (pointIter.next()) {
            int curX = pointIter.x();
            int curY = pointIter.y();
            int curZ = this.getNearestZ(curX, curY, prevZ);
            if (this.hasGeoPos(prevX, prevY)) {
                Direction dir = GeoUtils.computeDirection(prevX, prevY, curX, curY);
                boolean canEnter = false;
                if (this.canEnterNeighbors(prevX, prevY, prevZ, dir, new Direction[0])) {
                    switch (dir) {
                        case NORTH_EAST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY - 1, prevZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevZ, Direction.NORTH, new Direction[0]);
                            break;
                        }
                        case NORTH_WEST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY - 1, prevZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevZ, Direction.NORTH, new Direction[0]);
                            break;
                        }
                        case SOUTH_EAST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY + 1, prevZ, Direction.EAST, new Direction[0]) && this.canEnterNeighbors(prevX + 1, prevY, prevZ, Direction.SOUTH, new Direction[0]);
                            break;
                        }
                        case SOUTH_WEST: {
                            canEnter = this.canEnterNeighbors(prevX, prevY + 1, prevZ, Direction.WEST, new Direction[0]) && this.canEnterNeighbors(prevX - 1, prevY, prevZ, Direction.SOUTH, new Direction[0]);
                            break;
                        }
                        default: {
                            canEnter = true;
                        }
                    }
                }
                if (!canEnter) {
                    return false;
                }
            }
            prevX = curX;
            prevY = curY;
            prevZ = curZ;
        }
        return !this.hasGeoPos(prevX, prevY) || prevZ == toZ;
    }

    public int traceTerrainZ(int x, int y, int z, int tx, int ty) {
        int geoX = this.getGeoX(x);
        int geoY = this.getGeoY(y);
        z = this.getNearestZ(geoX, geoY, z);
        int tGeoX = this.getGeoX(tx);
        int tGeoY = this.getGeoY(ty);
        LinePointIterator pointIter = new LinePointIterator(geoX, geoY, tGeoX, tGeoY);
        pointIter.next();
        int prevZ = z;
        while (pointIter.next()) {
            int curZ;
            int curX = pointIter.x();
            int curY = pointIter.y();
            prevZ = curZ = this.getNearestZ(curX, curY, prevZ);
        }
        return prevZ;
    }

    public boolean canMove(ILocational from, int toX, int toY, int toZ) {
        return this.canMove(from.getX(), from.getY(), from.getZ(), toX, toY, toZ, from.getInstanceId());
    }

    public boolean canMove(ILocational from, ILocational to) {
        return this.canMove(from, to.getX(), to.getY(), to.getZ());
    }

    public boolean hasGeo(int x, int y) {
        return this.hasGeoPos(this.getGeoX(x), this.getGeoY(y));
    }

    private static class SingletonHolder {
        protected static final GeoData _instance = new GeoData();

        private SingletonHolder() {
        }
    }
}

