/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.ItemTable;
import com.l2jserver.gameserver.datatables.RecipeData;
import com.l2jserver.gameserver.enums.StatType;
import com.l2jserver.gameserver.model.L2ManufactureItem;
import com.l2jserver.gameserver.model.L2RecipeInstance;
import com.l2jserver.gameserver.model.L2RecipeList;
import com.l2jserver.gameserver.model.L2RecipeStatInstance;
import com.l2jserver.gameserver.model.TempItem;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.itemcontainer.ItemContainer;
import com.l2jserver.gameserver.model.itemcontainer.PcInventory;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.stats.Stats;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.ItemList;
import com.l2jserver.gameserver.network.serverpackets.L2GameServerPacket;
import com.l2jserver.gameserver.network.serverpackets.MagicSkillUse;
import com.l2jserver.gameserver.network.serverpackets.RecipeBookItemList;
import com.l2jserver.gameserver.network.serverpackets.RecipeItemMakeInfo;
import com.l2jserver.gameserver.network.serverpackets.RecipeShopItemInfo;
import com.l2jserver.gameserver.network.serverpackets.SetupGauge;
import com.l2jserver.gameserver.network.serverpackets.StatusUpdate;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class RecipeController {
    protected static final FastIntObjectMap<RecipeItemMaker> _activeMakers = new FastIntObjectMap();

    protected RecipeController() {
        _activeMakers.shared();
    }

    public void requestBookOpen(L2PcInstance player, boolean isDwarvenCraft) {
        if (!_activeMakers.containsKey(player.getObjectId())) {
            RecipeBookItemList response = new RecipeBookItemList(isDwarvenCraft, player.getMaxMp());
            response.addRecipes(isDwarvenCraft ? player.getDwarvenRecipeBook() : player.getCommonRecipeBook());
            player.sendPacket(response);
            return;
        }
        player.sendPacket(SystemMessageId.CANT_ALTER_RECIPEBOOK_WHILE_CRAFTING);
    }

    public void requestMakeItemAbort(L2PcInstance player) {
        _activeMakers.remove(player.getObjectId());
    }

    public void requestManufactureItem(L2PcInstance manufacturer, int recipeListId, L2PcInstance player) {
        block7: {
            for (L2ManufactureItem temp : manufacturer.getManufactureItems().values()) {
                if (temp.getRecipeId() != recipeListId) continue;
                break block7;
            }
            player.sendPacket(SystemMessageId.MANUFACTURE_PRICE_HAS_CHANGED);
            return;
        }
        L2RecipeList recipeList = RecipeData.getInstance().getValidRecipeList(player, recipeListId);
        if (recipeList == null) {
            return;
        }
        if (!manufacturer.hasRecipeList(recipeListId)) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false recipe id.", Config.DEFAULT_PUNISH);
            return;
        }
        if (Config.ALT_GAME_CREATION && _activeMakers.containsKey(manufacturer.getObjectId())) {
            player.sendPacket(SystemMessageId.CLOSE_STORE_WINDOW_AND_TRY_AGAIN);
            return;
        }
        RecipeItemMaker maker = new RecipeItemMaker(manufacturer, recipeList, player);
        if (maker._isValid) {
            if (Config.ALT_GAME_CREATION) {
                _activeMakers.put(manufacturer.getObjectId(), (Object)maker);
                ThreadPoolManager.getInstance().scheduleGeneral(maker, 100L);
            } else {
                maker.run();
            }
        }
    }

    public void requestMakeItem(L2PcInstance player, int recipeListId) {
        if (player.isInCombat() || player.isInDuel()) {
            player.sendPacket(SystemMessageId.CANT_OPERATE_PRIVATE_STORE_DURING_COMBAT);
            return;
        }
        L2RecipeList recipeList = RecipeData.getInstance().getValidRecipeList(player, recipeListId);
        if (recipeList == null) {
            return;
        }
        if (!player.hasRecipeList(recipeListId)) {
            Util.handleIllegalPlayerAction(player, "Warning!! Character " + player.getName() + " of account " + player.getAccountName() + " sent a false recipe id.", Config.DEFAULT_PUNISH);
            return;
        }
        if (Config.ALT_GAME_CREATION && _activeMakers.containsKey(player.getObjectId())) {
            SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1);
            sm.addItemName(recipeList.getItemId());
            sm.addString("You are busy creating.");
            player.sendPacket(sm);
            return;
        }
        RecipeItemMaker maker = new RecipeItemMaker(player, recipeList, player);
        if (maker._isValid) {
            if (Config.ALT_GAME_CREATION) {
                _activeMakers.put(player.getObjectId(), (Object)maker);
                ThreadPoolManager.getInstance().scheduleGeneral(maker, 100L);
            } else {
                maker.run();
            }
        }
    }

    public static RecipeController getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final RecipeController _instance = new RecipeController();

        private SingletonHolder() {
        }
    }

    private static class RecipeItemMaker
    implements Runnable {
        private static final Logger _log = Logger.getLogger(RecipeItemMaker.class.getName());
        protected boolean _isValid;
        protected List<TempItem> _items = null;
        protected final L2RecipeList _recipeList;
        protected final L2PcInstance _player;
        protected final L2PcInstance _target;
        protected final Skill _skill;
        protected final int _skillId;
        protected final int _skillLevel;
        protected int _creationPasses = 1;
        protected int _itemGrab;
        protected int _exp = -1;
        protected int _sp = -1;
        protected long _price;
        protected int _totalItems;
        protected int _delay;

        public RecipeItemMaker(L2PcInstance pPlayer, L2RecipeList pRecipeList, L2PcInstance pTarget) {
            L2ManufactureItem item;
            this._player = pPlayer;
            this._target = pTarget;
            this._recipeList = pRecipeList;
            this._isValid = false;
            this._skillId = this._recipeList.isDwarvenRecipe() ? CommonSkill.CREATE_DWARVEN.getId() : CommonSkill.CREATE_COMMON.getId();
            this._skillLevel = this._player.getSkillLevel(this._skillId);
            this._skill = this._player.getKnownSkill(this._skillId);
            this._player.isInCraftMode(true);
            if (this._player.isAlikeDead()) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._target.isAlikeDead()) {
                this._target.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._target.isProcessingTransaction()) {
                this._target.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._player.isProcessingTransaction()) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._recipeList.getRecipes().length == 0) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._recipeList.getLevel() > this._skillLevel) {
                this._player.sendPacket(ActionFailed.STATIC_PACKET);
                this.abort();
                return;
            }
            if (this._player != this._target && (item = this._player.getManufactureItems().get(this._recipeList.getId())) != null) {
                this._price = item.getCost();
                if (this._target.getAdena() < this._price) {
                    this._target.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
                    this.abort();
                    return;
                }
            }
            if ((this._items = this.listItems(false)) == null) {
                this.abort();
                return;
            }
            for (TempItem i : this._items) {
                this._totalItems += i.getQuantity();
            }
            if (!this.calculateStatUse(false, false)) {
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION) {
                this.calculateAltStatChange();
            }
            this.updateMakeInfo(true);
            this.updateCurMp();
            this.updateCurLoad();
            this._player.isInCraftMode(false);
            this._isValid = true;
        }

        @Override
        public void run() {
            if (!Config.IS_CRAFTING_ENABLED) {
                this._target.sendMessage("Item creation is currently disabled.");
                this.abort();
                return;
            }
            if (this._player == null || this._target == null) {
                _log.warning("player or target == null (disconnected?), aborting" + this._target + this._player);
                this.abort();
                return;
            }
            if (!this._player.isOnline() || !this._target.isOnline()) {
                _log.warning("player or target is not online, aborting " + this._target + this._player);
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION && !_activeMakers.containsKey(this._player.getObjectId())) {
                if (this._target != this._player) {
                    this._target.sendMessage("Manufacture aborted");
                    this._player.sendMessage("Manufacture aborted");
                } else {
                    this._player.sendMessage("Item creation aborted");
                }
                this.abort();
                return;
            }
            if (Config.ALT_GAME_CREATION && !this._items.isEmpty()) {
                if (!this.calculateStatUse(true, true)) {
                    return;
                }
                this.updateCurMp();
                this.grabSomeItems();
                if (!this._items.isEmpty()) {
                    this._delay = (int)(Config.ALT_GAME_CREATION_SPEED * this._player.getMReuseRate(this._skill) * 10.0 * 100.0);
                    MagicSkillUse msk = new MagicSkillUse(this._player, this._skillId, this._skillLevel, this._delay, 0);
                    this._player.broadcastPacket(msk);
                    this._player.sendPacket(new SetupGauge(0, this._delay));
                    ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                } else {
                    this._player.sendPacket(new SetupGauge(0, this._delay));
                    try {
                        Thread.sleep(this._delay);
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    finally {
                        this.finishCrafting();
                    }
                }
            } else {
                this.finishCrafting();
            }
        }

        private void finishCrafting() {
            L2ItemInstance adenatransfer;
            if (!Config.ALT_GAME_CREATION) {
                this.calculateStatUse(false, true);
            }
            if (this._target != this._player && this._price > 0L && (adenatransfer = this._target.transferItem("PayManufacture", this._target.getInventory().getAdenaInstance().getObjectId(), this._price, this._player.getInventory(), this._player)) == null) {
                this._target.sendPacket(SystemMessageId.YOU_NOT_ENOUGH_ADENA);
                this.abort();
                return;
            }
            this._items = this.listItems(true);
            if (this._items != null) {
                if (Rnd.get(100) < this._recipeList.getSuccessRate()) {
                    this.rewardPlayer();
                    this.updateMakeInfo(true);
                } else {
                    if (this._target != this._player) {
                        SystemMessage msg = SystemMessage.getSystemMessage(SystemMessageId.CREATION_OF_S2_FOR_C1_AT_S3_ADENA_FAILED);
                        msg.addString(this._target.getName());
                        msg.addItemName(this._recipeList.getItemId());
                        msg.addItemNumber(this._price);
                        this._player.sendPacket(msg);
                        msg = SystemMessage.getSystemMessage(SystemMessageId.C1_FAILED_TO_CREATE_S2_FOR_S3_ADENA);
                        msg.addString(this._player.getName());
                        msg.addItemName(this._recipeList.getItemId());
                        msg.addItemNumber(this._price);
                        this._target.sendPacket(msg);
                    } else {
                        this._player.sendPacket((L2GameServerPacket)((Object)SystemMessage.getSystemMessage(SystemMessageId.S1_MANUFACTURE_FAILURE).addItemName(this._recipeList.getItemId())));
                    }
                    this.updateMakeInfo(false);
                }
            }
            this.updateCurMp();
            this.updateCurLoad();
            _activeMakers.remove(this._player.getObjectId());
            this._player.isInCraftMode(false);
            this._target.sendPacket(new ItemList(this._target, false));
        }

        private void updateMakeInfo(boolean success) {
            if (this._target == this._player) {
                this._target.sendPacket(new RecipeItemMakeInfo(this._recipeList.getId(), this._target, success));
            } else {
                this._target.sendPacket(new RecipeShopItemInfo(this._player, this._recipeList.getId()));
            }
        }

        private void updateCurLoad() {
            StatusUpdate su = new StatusUpdate(this._target);
            su.addAttribute(14, this._target.getCurrentLoad());
            this._target.sendPacket(su);
        }

        private void updateCurMp() {
            StatusUpdate su = new StatusUpdate(this._target);
            su.addAttribute(11, (int)this._target.getCurrentMp());
            this._target.sendPacket(su);
        }

        private void grabSomeItems() {
            int count;
            for (int grabItems = this._itemGrab; grabItems > 0 && !this._items.isEmpty(); grabItems -= count) {
                TempItem item = this._items.get(0);
                count = item.getQuantity();
                if (count >= grabItems) {
                    count = grabItems;
                }
                item.setQuantity(item.getQuantity() - count);
                if (item.getQuantity() <= 0) {
                    this._items.remove(0);
                } else {
                    this._items.set(0, item);
                }
                if (this._target == this._player) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.S1_S2_EQUIPPED);
                    sm.addItemNumber(count);
                    sm.addItemName(item.getItemId());
                    this._player.sendPacket(sm);
                    continue;
                }
                this._target.sendMessage("Manufacturer " + this._player.getName() + " used " + count + " " + item.getItemName());
            }
        }

        private void calculateAltStatChange() {
            this._itemGrab = this._skillLevel;
            for (L2RecipeStatInstance altStatChange : this._recipeList.getAltStatChange()) {
                if (altStatChange.getType() == StatType.XP) {
                    this._exp = altStatChange.getValue();
                    continue;
                }
                if (altStatChange.getType() == StatType.SP) {
                    this._sp = altStatChange.getValue();
                    continue;
                }
                if (altStatChange.getType() != StatType.GIM) continue;
                this._itemGrab *= altStatChange.getValue();
            }
            this._creationPasses = this._totalItems / this._itemGrab + (this._totalItems % this._itemGrab != 0 ? 1 : 0);
            if (this._creationPasses < 1) {
                this._creationPasses = 1;
            }
        }

        private boolean calculateStatUse(boolean isWait, boolean isReduce) {
            boolean ret = true;
            for (L2RecipeStatInstance statUse : this._recipeList.getStatUse()) {
                double modifiedValue = statUse.getValue() / this._creationPasses;
                if (statUse.getType() == StatType.HP) {
                    if (this._player.getCurrentHp() <= modifiedValue) {
                        if (Config.ALT_GAME_CREATION && isWait) {
                            this._player.sendPacket(new SetupGauge(0, this._delay));
                            ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                        } else {
                            this._target.sendPacket(SystemMessageId.NOT_ENOUGH_HP);
                            this.abort();
                        }
                        ret = false;
                        continue;
                    }
                    if (!isReduce) continue;
                    this._player.reduceCurrentHp(modifiedValue, this._player, this._skill);
                    continue;
                }
                if (statUse.getType() == StatType.MP) {
                    if (this._player.getCurrentMp() < modifiedValue) {
                        if (Config.ALT_GAME_CREATION && isWait) {
                            this._player.sendPacket(new SetupGauge(0, this._delay));
                            ThreadPoolManager.getInstance().scheduleGeneral(this, 100 + this._delay);
                        } else {
                            this._target.sendPacket(SystemMessageId.NOT_ENOUGH_MP);
                            this.abort();
                        }
                        ret = false;
                        continue;
                    }
                    if (!isReduce) continue;
                    this._player.reduceCurrentMp(modifiedValue);
                    continue;
                }
                this._target.sendMessage("Recipe error!!!, please tell this to your GM.");
                ret = false;
                this.abort();
            }
            return ret;
        }

        private List<TempItem> listItems(boolean remove) {
            L2RecipeInstance[] recipes = this._recipeList.getRecipes();
            PcInventory inv = this._target.getInventory();
            ArrayList<TempItem> materials = new ArrayList<TempItem>();
            for (L2RecipeInstance recipe : recipes) {
                long itemQuantityAmount;
                if (recipe.getQuantity() <= 0) continue;
                L2ItemInstance item = inv.getItemByItemId(recipe.getItemId());
                long l = itemQuantityAmount = item == null ? 0L : item.getCount();
                if (itemQuantityAmount < (long)recipe.getQuantity()) {
                    SystemMessage sm = SystemMessage.getSystemMessage(SystemMessageId.MISSING_S2_S1_TO_CREATE);
                    sm.addItemName(recipe.getItemId());
                    sm.addItemNumber((long)recipe.getQuantity() - itemQuantityAmount);
                    this._target.sendPacket(sm);
                    this.abort();
                    return null;
                }
                materials.add(new TempItem(item, recipe.getQuantity()));
            }
            if (remove) {
                for (TempItem tmp : materials) {
                    SystemMessage sm;
                    ((ItemContainer)inv).destroyItemByItemId("Manufacture", tmp.getItemId(), tmp.getQuantity(), this._target, this._player);
                    if (tmp.getQuantity() > 1) {
                        sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S1_DISAPPEARED);
                        sm.addItemName(tmp.getItemId());
                        sm.addItemNumber(tmp.getQuantity());
                        this._target.sendPacket(sm);
                        continue;
                    }
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S1_DISAPPEARED);
                    sm.addItemName(tmp.getItemId());
                    this._target.sendPacket(sm);
                }
            }
            return materials;
        }

        private void abort() {
            this.updateMakeInfo(false);
            this._player.isInCraftMode(false);
            _activeMakers.remove(this._player.getObjectId());
        }

        private void rewardPlayer() {
            int rareProdId = this._recipeList.getRareItemId();
            int itemId = this._recipeList.getItemId();
            int itemCount = this._recipeList.getCount();
            L2Item template = ItemTable.getInstance().getTemplate(itemId);
            if (rareProdId != -1 && (rareProdId == itemId || Config.CRAFT_MASTERWORK) && Rnd.get(100) < this._recipeList.getRarity()) {
                itemId = rareProdId;
                itemCount = this._recipeList.getRareCount();
            }
            this._target.getInventory().addItem("Manufacture", itemId, itemCount, this._target, this._player);
            SystemMessage sm = null;
            if (this._target != this._player) {
                if (itemCount == 1) {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_CREATED_FOR_C1_FOR_S3_ADENA);
                    sm.addString(this._target.getName());
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._player.sendPacket(sm);
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CREATED_S2_FOR_S3_ADENA);
                    sm.addString(this._player.getName());
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._target.sendPacket(sm);
                } else {
                    sm = SystemMessage.getSystemMessage(SystemMessageId.S2_S3_S_CREATED_FOR_C1_FOR_S4_ADENA);
                    sm.addString(this._target.getName());
                    sm.addItemNumber(itemCount);
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._player.sendPacket(sm);
                    sm = SystemMessage.getSystemMessage(SystemMessageId.C1_CREATED_S2_S3_S_FOR_S4_ADENA);
                    sm.addString(this._player.getName());
                    sm.addItemNumber(itemCount);
                    sm.addItemName(itemId);
                    sm.addItemNumber(this._price);
                    this._target.sendPacket(sm);
                }
            }
            if (itemCount > 1) {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_S2_S1_S);
                sm.addItemName(itemId);
                sm.addItemNumber(itemCount);
                this._target.sendPacket(sm);
            } else {
                sm = SystemMessage.getSystemMessage(SystemMessageId.EARNED_ITEM_S1);
                sm.addItemName(itemId);
                this._target.sendPacket(sm);
            }
            if (Config.ALT_GAME_CREATION) {
                int recipeLevel = this._recipeList.getLevel();
                if (this._exp < 0) {
                    this._exp = template.getReferencePrice() * itemCount;
                    this._exp /= recipeLevel;
                }
                if (this._sp < 0) {
                    this._sp = this._exp / 10;
                }
                if (itemId == rareProdId) {
                    this._exp = (int)((double)this._exp * Config.ALT_GAME_CREATION_RARE_XPSP_RATE);
                    this._sp = (int)((double)this._sp * Config.ALT_GAME_CREATION_RARE_XPSP_RATE);
                }
                if (this._exp < 0) {
                    this._exp = 0;
                }
                if (this._sp < 0) {
                    this._sp = 0;
                }
                for (int i = this._skillLevel; i > recipeLevel; --i) {
                    this._exp /= 4;
                    this._sp /= 4;
                }
                this._player.addExpAndSp((int)this._player.calcStat(Stats.EXPSP_RATE, (double)this._exp * Config.ALT_GAME_CREATION_XP_RATE * Config.ALT_GAME_CREATION_SPEED, null, null), (int)this._player.calcStat(Stats.EXPSP_RATE, (double)this._sp * Config.ALT_GAME_CREATION_SP_RATE * Config.ALT_GAME_CREATION_SPEED, null, null));
            }
            this.updateMakeInfo(true);
        }
    }
}

