/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.SevenSignsFestival;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.instancemanager.CastleManager;
import com.l2jserver.gameserver.model.AutoSpawnHandler;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.TeleportWhereType;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.entity.Castle;
import com.l2jserver.gameserver.model.skills.CommonSkill;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.SSQInfo;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.util.Broadcast;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastMap;

public class SevenSigns {
    protected static final Logger _log = Logger.getLogger(SevenSigns.class.getName());
    public static final String SEVEN_SIGNS_HTML_PATH = "data/html/seven_signs/";
    public static final int CABAL_NULL = 0;
    public static final int CABAL_DUSK = 1;
    public static final int CABAL_DAWN = 2;
    public static final int SEAL_NULL = 0;
    public static final int SEAL_AVARICE = 1;
    public static final int SEAL_GNOSIS = 2;
    public static final int SEAL_STRIFE = 3;
    public static final int PERIOD_COMP_RECRUITING = 0;
    public static final int PERIOD_COMPETITION = 1;
    public static final int PERIOD_COMP_RESULTS = 2;
    public static final int PERIOD_SEAL_VALIDATION = 3;
    public static final int PERIOD_START_HOUR = 18;
    public static final int PERIOD_START_MINS = 0;
    public static final int PERIOD_START_DAY = 2;
    public static final int PERIOD_MINOR_LENGTH = 900000;
    public static final int PERIOD_MAJOR_LENGTH = 603900000;
    public static final int RECORD_SEVEN_SIGNS_ID = 5707;
    public static final int RECORD_SEVEN_SIGNS_COST = 500;
    public static final int ORATOR_NPC_ID = 31094;
    public static final int PREACHER_NPC_ID = 31093;
    public static final int MAMMON_MERCHANT_ID = 31113;
    public static final int MAMMON_BLACKSMITH_ID = 31126;
    public static final int MAMMON_MARKETEER_ID = 31092;
    public static final int LILITH_NPC_ID = 25283;
    public static final int ANAKIM_NPC_ID = 25286;
    public static final int CREST_OF_DAWN_ID = 31170;
    public static final int CREST_OF_DUSK_ID = 31171;
    public static final int SEAL_STONE_BLUE_ID = 6360;
    public static final int SEAL_STONE_GREEN_ID = 6361;
    public static final int SEAL_STONE_RED_ID = 6362;
    public static final int[] SEAL_STONE_IDS = new int[]{6360, 6361, 6362};
    public static final int SEAL_STONE_BLUE_VALUE = 3;
    public static final int SEAL_STONE_GREEN_VALUE = 5;
    public static final int SEAL_STONE_RED_VALUE = 10;
    public static final int BLUE_CONTRIB_POINTS = 3;
    public static final int GREEN_CONTRIB_POINTS = 5;
    public static final int RED_CONTRIB_POINTS = 10;
    private final Calendar _nextPeriodChange = Calendar.getInstance();
    protected int _activePeriod;
    protected int _currentCycle;
    protected double _dawnStoneScore;
    protected double _duskStoneScore;
    protected int _dawnFestivalScore;
    protected int _duskFestivalScore;
    protected int _compWinner;
    protected int _previousWinner;
    protected Calendar _lastSave = Calendar.getInstance();
    protected Map<Integer, StatsSet> _signsPlayerData = new FastMap();
    private final Map<Integer, Integer> _signsSealOwners = new FastMap();
    private final Map<Integer, Integer> _signsDuskSealTotals = new FastMap();
    private final Map<Integer, Integer> _signsDawnSealTotals = new FastMap();
    private AutoSpawnHandler.AutoSpawnInstance _merchantSpawn;
    private AutoSpawnHandler.AutoSpawnInstance _blacksmithSpawn;
    private AutoSpawnHandler.AutoSpawnInstance _lilithSpawn;
    private AutoSpawnHandler.AutoSpawnInstance _anakimSpawn;
    private Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _crestofdawnspawns;
    private Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _crestofduskspawns;
    private Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _oratorSpawns;
    private Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _preacherSpawns;
    private Map<Integer, AutoSpawnHandler.AutoSpawnInstance> _marketeerSpawns;
    private static final String LOAD_DATA = "SELECT charId, cabal, seal, red_stones, green_stones, blue_stones, ancient_adena_amount, contribution_score FROM seven_signs";
    private static final String LOAD_STATUS = "SELECT * FROM seven_signs_status WHERE id=0";
    private static final String INSERT_PLAYER = "INSERT INTO seven_signs (charId, cabal, seal) VALUES (?,?,?)";
    private static final String UPDATE_PLAYER = "UPDATE seven_signs SET cabal=?, seal=?, red_stones=?, green_stones=?, blue_stones=?, ancient_adena_amount=?, contribution_score=? WHERE charId=?";
    private static final String UPDATE_STATUS = "UPDATE seven_signs_status SET current_cycle=?, active_period=?, previous_winner=?, dawn_stone_score=?, dawn_festival_score=?, dusk_stone_score=?, dusk_festival_score=?, avarice_owner=?, gnosis_owner=?, strife_owner=?, avarice_dawn_score=?, gnosis_dawn_score=?, strife_dawn_score=?, avarice_dusk_score=?, gnosis_dusk_score=?, strife_dusk_score=?, festival_cycle=?, accumulated_bonus0=?, accumulated_bonus1=?, accumulated_bonus2=?,accumulated_bonus3=?, accumulated_bonus4=?, date=? WHERE id=0";

    protected SevenSigns() {
        try {
            this.restoreSevenSignsData();
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "SevenSigns: Failed to load configuration: " + e.getMessage(), e);
        }
        _log.info("SevenSigns: Currently in the " + this.getCurrentPeriodName() + " period!");
        this.initializeSeals();
        if (this.isSealValidationPeriod()) {
            if (this.getCabalHighestScore() == 0) {
                _log.info("SevenSigns: The competition ended with a tie last week.");
            } else {
                _log.info("SevenSigns: The " + SevenSigns.getCabalName(this.getCabalHighestScore()) + " were victorious last week.");
            }
        } else if (this.getCabalHighestScore() == 0) {
            _log.info("SevenSigns: The competition, if the current trend continues, will end in a tie this week.");
        } else {
            _log.info("SevenSigns: The " + SevenSigns.getCabalName(this.getCabalHighestScore()) + " are in the lead this week.");
        }
        long milliToChange = 0L;
        if (this.isNextPeriodChangeInPast()) {
            _log.info("SevenSigns: Next period change was in the past (server was offline), changing periods now!");
        } else {
            this.setCalendarForNextPeriodChange();
            milliToChange = this.getMilliToPeriodChange();
        }
        SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
        ThreadPoolManager.getInstance().scheduleGeneral(sspc, milliToChange);
        _log.info("SevenSigns: Next period begins in " + Util.strMillTime(milliToChange));
    }

    private boolean isNextPeriodChangeInPast() {
        Calendar lastPeriodChange = Calendar.getInstance();
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                lastPeriodChange.set(7, 2);
                lastPeriodChange.set(11, 18);
                lastPeriodChange.set(12, 0);
                lastPeriodChange.set(13, 0);
                lastPeriodChange.set(14, 0);
                if (!Calendar.getInstance().before(lastPeriodChange)) break;
                lastPeriodChange.add(10, -168);
                break;
            }
            case 0: 
            case 2: {
                lastPeriodChange.setTimeInMillis(this._lastSave.getTimeInMillis() + 900000L);
            }
        }
        return this._lastSave.getTimeInMillis() > 7L && this._lastSave.before(lastPeriodChange);
    }

    public void spawnSevenSignsNPC() {
        block30: {
            block28: {
                block29: {
                    this._merchantSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31113, false);
                    this._blacksmithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(31126, false);
                    this._marketeerSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31092);
                    this._lilithSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25283, false);
                    this._anakimSpawn = AutoSpawnHandler.getInstance().getAutoSpawnInstance(25286, false);
                    this._crestofdawnspawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31170);
                    this._crestofduskspawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31171);
                    this._oratorSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31094);
                    this._preacherSpawns = AutoSpawnHandler.getInstance().getAutoSpawnInstances(31093);
                    if (!this.isSealValidationPeriod() && !this.isCompResultsPeriod()) break block28;
                    for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._marketeerSpawns.values()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                    }
                    if (this.getSealOwner(2) == this.getCabalHighestScore() && this.getSealOwner(2) != 0) {
                        if (!Config.ANNOUNCE_MAMMON_SPAWN) {
                            this._blacksmithSpawn.setBroadcast(false);
                        }
                        if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(this._blacksmithSpawn.getObjectId(), true).isSpawnActive()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(this._blacksmithSpawn, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._oratorSpawns.values()) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._preacherSpawns.values()) {
                            if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(spawnInst.getObjectId(), true).isSpawnActive()) continue;
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, true);
                        }
                    } else {
                        AutoSpawnHandler.getInstance().setSpawnActive(this._blacksmithSpawn, false);
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._oratorSpawns.values()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                        for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._preacherSpawns.values()) {
                            AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
                        }
                    }
                    if (this.getSealOwner(1) != this.getCabalHighestScore() || this.getSealOwner(1) == 0) break block29;
                    if (!Config.ANNOUNCE_MAMMON_SPAWN) {
                        this._merchantSpawn.setBroadcast(false);
                    }
                    if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(this._merchantSpawn.getObjectId(), true).isSpawnActive()) {
                        AutoSpawnHandler.getInstance().setSpawnActive(this._merchantSpawn, true);
                    }
                    switch (this.getCabalHighestScore()) {
                        case 2: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(this._lilithSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(this._lilithSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(this._anakimSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : this._crestofdawnspawns.values()) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(dawnCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : this._crestofduskspawns.values()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                            }
                            break block30;
                        }
                        case 1: {
                            if (!AutoSpawnHandler.getInstance().getAutoSpawnInstance(this._anakimSpawn.getObjectId(), true).isSpawnActive()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(this._anakimSpawn, true);
                            }
                            AutoSpawnHandler.getInstance().setSpawnActive(this._lilithSpawn, false);
                            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : this._crestofduskspawns.values()) {
                                if (AutoSpawnHandler.getInstance().getAutoSpawnInstance(duskCrest.getObjectId(), true).isSpawnActive()) continue;
                                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, true);
                            }
                            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : this._crestofdawnspawns.values()) {
                                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                            }
                            break;
                        }
                    }
                    break block30;
                }
                AutoSpawnHandler.getInstance().setSpawnActive(this._merchantSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(this._lilithSpawn, false);
                AutoSpawnHandler.getInstance().setSpawnActive(this._anakimSpawn, false);
                for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : this._crestofdawnspawns.values()) {
                    AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
                }
                for (AutoSpawnHandler.AutoSpawnInstance duskCrest : this._crestofduskspawns.values()) {
                    AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
                }
                break block30;
            }
            AutoSpawnHandler.getInstance().setSpawnActive(this._merchantSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(this._blacksmithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(this._lilithSpawn, false);
            AutoSpawnHandler.getInstance().setSpawnActive(this._anakimSpawn, false);
            for (AutoSpawnHandler.AutoSpawnInstance dawnCrest : this._crestofdawnspawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(dawnCrest, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance duskCrest : this._crestofduskspawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(duskCrest, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._oratorSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._preacherSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
            for (AutoSpawnHandler.AutoSpawnInstance spawnInst : this._marketeerSpawns.values()) {
                AutoSpawnHandler.getInstance().setSpawnActive(spawnInst, false);
            }
        }
    }

    public static SevenSigns getInstance() {
        return SingletonHolder._instance;
    }

    public static long calcContributionScore(long blueCount, long greenCount, long redCount) {
        long contrib = blueCount * 3L;
        contrib += greenCount * 5L;
        return contrib += redCount * 10L;
    }

    public static long calcAncientAdenaReward(long blueCount, long greenCount, long redCount) {
        long reward = blueCount * 3L;
        reward += greenCount * 5L;
        return reward += redCount * 10L;
    }

    public static final String getCabalShortName(int cabal) {
        switch (cabal) {
            case 2: {
                return "dawn";
            }
            case 1: {
                return "dusk";
            }
        }
        return "No Cabal";
    }

    public static final String getCabalName(int cabal) {
        switch (cabal) {
            case 2: {
                return "Lords of Dawn";
            }
            case 1: {
                return "Revolutionaries of Dusk";
            }
        }
        return "No Cabal";
    }

    public static final String getCabalNameJA(int cabal) {
        switch (cabal) {
            case 2: {
                return "\u9ece\u660e\u306e\u541b\u4e3b\u305f\u3061";
            }
            case 1: {
                return "\u9ec4\u660f\u306e\u9769\u547d\u8ecd";
            }
        }
        return "\u306a\u3057";
    }

    public static final String getSealName(int seal, boolean shortName) {
        String sealName = !shortName ? "Seal of " : "";
        switch (seal) {
            case 1: {
                sealName = sealName + "Avarice";
                break;
            }
            case 2: {
                sealName = sealName + "Gnosis";
                break;
            }
            case 3: {
                sealName = sealName + "Strife";
            }
        }
        return sealName;
    }

    public static final String getSealNameJA(int seal, boolean shortName) {
        switch (seal) {
            case 1: {
                return "\u8caa\u6b32\u306e\u5c01\u5370";
            }
            case 2: {
                return "\u5553\u793a\u306e\u5c01\u5370";
            }
            case 3: {
                return "\u6226\u4e71\u306e\u5c01\u5370";
            }
        }
        throw new AssertionError();
    }

    public final int getCurrentCycle() {
        return this._currentCycle;
    }

    public final int getCurrentPeriod() {
        return this._activePeriod;
    }

    private final int getDaysToPeriodChange() {
        int numDays = this._nextPeriodChange.get(7) - 2;
        if (numDays < 0) {
            return 0 - numDays;
        }
        return 7 - numDays;
    }

    public final long getMilliToPeriodChange() {
        return this._nextPeriodChange.getTimeInMillis() - System.currentTimeMillis();
    }

    protected void setCalendarForNextPeriodChange() {
        switch (this.getCurrentPeriod()) {
            case 1: 
            case 3: {
                int daysToChange = this.getDaysToPeriodChange();
                if (daysToChange == 7) {
                    if (this._nextPeriodChange.get(11) < 18) {
                        daysToChange = 0;
                    } else if (this._nextPeriodChange.get(11) == 18 && this._nextPeriodChange.get(12) < 0) {
                        daysToChange = 0;
                    }
                }
                if (daysToChange > 0) {
                    this._nextPeriodChange.add(5, daysToChange);
                }
                this._nextPeriodChange.set(11, 18);
                this._nextPeriodChange.set(12, 0);
                break;
            }
            case 0: 
            case 2: {
                this._nextPeriodChange.add(14, 900000);
            }
        }
        _log.info("SevenSigns: Next period change set to " + Util.dateFormat(this._nextPeriodChange.getTime()));
    }

    public final String getCurrentPeriodName() {
        String periodName = null;
        switch (this._activePeriod) {
            case 0: {
                periodName = "\u6e96\u5099\u671f\u9593";
                break;
            }
            case 1: {
                periodName = "\u7af6\u4e89\u671f\u9593";
                break;
            }
            case 2: {
                periodName = "\u96c6\u8a08\u671f\u9593";
                break;
            }
            case 3: {
                periodName = "\u5c01\u5370\u6709\u52b9\u671f\u9593";
            }
        }
        return periodName;
    }

    public final boolean isCompetitionPeriod() {
        return this._activePeriod == 1;
    }

    public final boolean isSealValidationPeriod() {
        return this._activePeriod == 3;
    }

    public final boolean isCompResultsPeriod() {
        return this._activePeriod == 2;
    }

    public boolean isDateInSealValidPeriod(Calendar date) {
        long tillDate;
        long nextPeriodChange = this.getMilliToPeriodChange();
        long nextQuestStart = 0L;
        long nextValidStart = 0L;
        for (tillDate = date.getTimeInMillis() - System.currentTimeMillis(); 1209600000L < tillDate; tillDate -= 1209600000L) {
        }
        while (tillDate < 0L) {
            tillDate += 1209600000L;
        }
        switch (this.getCurrentPeriod()) {
            case 0: {
                nextValidStart = nextPeriodChange + 603900000L;
                nextQuestStart = nextValidStart + 603900000L + 900000L;
                break;
            }
            case 1: {
                nextValidStart = nextPeriodChange;
                nextQuestStart = nextPeriodChange + 603900000L + 900000L;
                break;
            }
            case 2: {
                nextQuestStart = nextPeriodChange + 603900000L;
                nextValidStart = nextQuestStart + 603900000L + 900000L;
                break;
            }
            case 3: {
                nextQuestStart = nextPeriodChange;
                nextValidStart = nextPeriodChange + 603900000L + 900000L;
            }
        }
        return (nextQuestStart >= tillDate || tillDate >= nextValidStart) && (nextValidStart >= nextQuestStart || tillDate >= nextValidStart && nextQuestStart >= tillDate);
    }

    public final int getCurrentScore(int cabal) {
        double totalStoneScore = this._dawnStoneScore + this._duskStoneScore;
        switch (cabal) {
            case 0: {
                return 0;
            }
            case 2: {
                return Math.round((float)(this._dawnStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._dawnFestivalScore;
            }
            case 1: {
                return Math.round((float)(this._duskStoneScore / ((float)totalStoneScore == 0.0f ? 1.0 : totalStoneScore)) * 500.0f) + this._duskFestivalScore;
            }
        }
        return 0;
    }

    public final double getCurrentStoneScore(int cabal) {
        switch (cabal) {
            case 0: {
                return 0.0;
            }
            case 2: {
                return this._dawnStoneScore;
            }
            case 1: {
                return this._duskStoneScore;
            }
        }
        return 0.0;
    }

    public final int getCurrentFestivalScore(int cabal) {
        switch (cabal) {
            case 0: {
                return 0;
            }
            case 2: {
                return this._dawnFestivalScore;
            }
            case 1: {
                return this._duskFestivalScore;
            }
        }
        return 0;
    }

    public final int getCabalHighestScore() {
        if (this.getCurrentScore(1) == this.getCurrentScore(2)) {
            return 0;
        }
        if (this.getCurrentScore(1) > this.getCurrentScore(2)) {
            return 1;
        }
        return 2;
    }

    public final int getSealOwner(int seal) {
        return this._signsSealOwners.get(seal);
    }

    public final int getSealProportion(int seal, int cabal) {
        if (cabal == 0) {
            return 0;
        }
        if (cabal == 1) {
            return this._signsDuskSealTotals.get(seal);
        }
        return this._signsDawnSealTotals.get(seal);
    }

    public final int getTotalMembers(int cabal) {
        int cabalMembers = 0;
        String cabalName = SevenSigns.getCabalShortName(cabal);
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            if (!sevenDat.getString("cabal").equals(cabalName)) continue;
            ++cabalMembers;
        }
        return cabalMembers;
    }

    public int getPlayerStoneContrib(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        int stoneCount = 0;
        stoneCount += currPlayer.getInt("red_stones");
        stoneCount += currPlayer.getInt("green_stones");
        return stoneCount += currPlayer.getInt("blue_stones");
    }

    public int getPlayerContribScore(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("contribution_score");
    }

    public int getPlayerAdenaCollect(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("ancient_adena_amount");
    }

    public int getPlayerSeal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        return currPlayer.getInt("seal");
    }

    public int getPlayerCabal(int objectId) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        if (currPlayer == null) {
            return 0;
        }
        String playerCabal = currPlayer.getString("cabal");
        if (playerCabal.equalsIgnoreCase("dawn")) {
            return 2;
        }
        if (playerCabal.equalsIgnoreCase("dusk")) {
            return 1;
        }
        return 0;
    }

    protected void restoreSevenSignsData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            Throwable throwable;
            ResultSet rs;
            try (Statement s = con.createStatement();){
                rs = s.executeQuery(LOAD_DATA);
                throwable = null;
                try {
                    StatsSet sevenDat = null;
                    while (rs.next()) {
                        int charObjId = rs.getInt("charId");
                        sevenDat = new StatsSet();
                        sevenDat.set("charId", charObjId);
                        sevenDat.set("cabal", rs.getString("cabal"));
                        sevenDat.set("seal", rs.getInt("seal"));
                        sevenDat.set("red_stones", rs.getInt("red_stones"));
                        sevenDat.set("green_stones", rs.getInt("green_stones"));
                        sevenDat.set("blue_stones", rs.getInt("blue_stones"));
                        sevenDat.set("ancient_adena_amount", rs.getDouble("ancient_adena_amount"));
                        sevenDat.set("contribution_score", rs.getDouble("contribution_score"));
                        this._signsPlayerData.put(charObjId, sevenDat);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            s = con.createStatement();
            var4_7 = null;
            try {
                rs = s.executeQuery(LOAD_STATUS);
                throwable = null;
                try {
                    while (rs.next()) {
                        this._currentCycle = rs.getInt("current_cycle");
                        this._activePeriod = rs.getInt("active_period");
                        this._previousWinner = rs.getInt("previous_winner");
                        this._dawnStoneScore = rs.getDouble("dawn_stone_score");
                        this._dawnFestivalScore = rs.getInt("dawn_festival_score");
                        this._duskStoneScore = rs.getDouble("dusk_stone_score");
                        this._duskFestivalScore = rs.getInt("dusk_festival_score");
                        this._signsSealOwners.put(1, rs.getInt("avarice_owner"));
                        this._signsSealOwners.put(2, rs.getInt("gnosis_owner"));
                        this._signsSealOwners.put(3, rs.getInt("strife_owner"));
                        this._signsDawnSealTotals.put(1, rs.getInt("avarice_dawn_score"));
                        this._signsDawnSealTotals.put(2, rs.getInt("gnosis_dawn_score"));
                        this._signsDawnSealTotals.put(3, rs.getInt("strife_dawn_score"));
                        this._signsDuskSealTotals.put(1, rs.getInt("avarice_dusk_score"));
                        this._signsDuskSealTotals.put(2, rs.getInt("gnosis_dusk_score"));
                        this._signsDuskSealTotals.put(3, rs.getInt("strife_dusk_score"));
                        this._lastSave.setTimeInMillis(rs.getLong("date"));
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable6) {
                var4_7 = throwable6;
                throw throwable6;
            }
            finally {
                if (s != null) {
                    if (var4_7 != null) {
                        try {
                            s.close();
                        }
                        catch (Throwable throwable7) {
                            var4_7.addSuppressed(throwable7);
                        }
                    } else {
                        s.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to load Seven Signs data from database: " + e.getMessage(), e);
        }
    }

    public void saveSevenSignsData() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(UPDATE_PLAYER);){
            for (StatsSet sevenDat : this._signsPlayerData.values()) {
                ps.setString(1, sevenDat.getString("cabal"));
                ps.setInt(2, sevenDat.getInt("seal"));
                ps.setInt(3, sevenDat.getInt("red_stones"));
                ps.setInt(4, sevenDat.getInt("green_stones"));
                ps.setInt(5, sevenDat.getInt("blue_stones"));
                ps.setDouble(6, sevenDat.getDouble("ancient_adena_amount"));
                ps.setDouble(7, sevenDat.getDouble("contribution_score"));
                ps.setInt(8, sevenDat.getInt("charId"));
                ps.execute();
                ps.clearParameters();
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
    }

    public final void saveSevenSignsData(int objectId) {
        StatsSet sevenDat = this._signsPlayerData.get(objectId);
        if (sevenDat == null) {
            return;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(UPDATE_PLAYER);){
            ps.setString(1, sevenDat.getString("cabal"));
            ps.setInt(2, sevenDat.getInt("seal"));
            ps.setInt(3, sevenDat.getInt("red_stones"));
            ps.setInt(4, sevenDat.getInt("green_stones"));
            ps.setInt(5, sevenDat.getInt("blue_stones"));
            ps.setDouble(6, sevenDat.getDouble("ancient_adena_amount"));
            ps.setDouble(7, sevenDat.getDouble("contribution_score"));
            ps.setInt(8, sevenDat.getInt("charId"));
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
    }

    public final void saveSevenSignsStatus() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement(UPDATE_STATUS);){
            ps.setInt(1, this._currentCycle);
            ps.setInt(2, this._activePeriod);
            ps.setInt(3, this._previousWinner);
            ps.setDouble(4, this._dawnStoneScore);
            ps.setInt(5, this._dawnFestivalScore);
            ps.setDouble(6, this._duskStoneScore);
            ps.setInt(7, this._duskFestivalScore);
            ps.setInt(8, this._signsSealOwners.get(1));
            ps.setInt(9, this._signsSealOwners.get(2));
            ps.setInt(10, this._signsSealOwners.get(3));
            ps.setInt(11, this._signsDawnSealTotals.get(1));
            ps.setInt(12, this._signsDawnSealTotals.get(2));
            ps.setInt(13, this._signsDawnSealTotals.get(3));
            ps.setInt(14, this._signsDuskSealTotals.get(1));
            ps.setInt(15, this._signsDuskSealTotals.get(2));
            ps.setInt(16, this._signsDuskSealTotals.get(3));
            ps.setInt(17, SevenSignsFestival.getInstance().getCurrentFestivalCycle());
            for (int i = 0; i < 5; ++i) {
                ps.setInt(18 + i, SevenSignsFestival.getInstance().getAccumulatedBonus(i));
            }
            this._lastSave = Calendar.getInstance();
            ps.setLong(23, this._lastSave.getTimeInMillis());
            ps.execute();
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, "SevenSigns: Unable to save data to database: " + e.getMessage(), e);
        }
    }

    protected void resetPlayerData() {
        for (StatsSet sevenDat : this._signsPlayerData.values()) {
            int charObjId = sevenDat.getInt("charId");
            sevenDat.set("cabal", "");
            sevenDat.set("seal", 0);
            sevenDat.set("contribution_score", 0);
            this._signsPlayerData.put(charObjId, sevenDat);
        }
    }

    public int setPlayerInfo(int objectId, int chosenCabal, int chosenSeal) {
        StatsSet currPlayerData = this._signsPlayerData.get(objectId);
        if (currPlayerData != null) {
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            this._signsPlayerData.put(objectId, currPlayerData);
        } else {
            currPlayerData = new StatsSet();
            currPlayerData.set("charId", objectId);
            currPlayerData.set("cabal", SevenSigns.getCabalShortName(chosenCabal));
            currPlayerData.set("seal", chosenSeal);
            currPlayerData.set("red_stones", 0);
            currPlayerData.set("green_stones", 0);
            currPlayerData.set("blue_stones", 0);
            currPlayerData.set("ancient_adena_amount", 0);
            currPlayerData.set("contribution_score", 0);
            this._signsPlayerData.put(objectId, currPlayerData);
            try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                 PreparedStatement ps = con.prepareStatement(INSERT_PLAYER);){
                ps.setInt(1, objectId);
                ps.setString(2, SevenSigns.getCabalShortName(chosenCabal));
                ps.setInt(3, chosenSeal);
                ps.execute();
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, "SevenSigns: Failed to save data: " + e.getMessage(), e);
            }
        }
        if ("dawn".equals(currPlayerData.getString("cabal"))) {
            this._signsDawnSealTotals.put(chosenSeal, this._signsDawnSealTotals.get(chosenSeal) + 1);
        } else {
            this._signsDuskSealTotals.put(chosenSeal, this._signsDuskSealTotals.get(chosenSeal) + 1);
        }
        if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
            this.saveSevenSignsStatus();
        }
        return chosenCabal;
    }

    public int getAncientAdenaReward(int objectId, boolean removeReward) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        int rewardAmount = currPlayer.getInt("ancient_adena_amount");
        currPlayer.set("red_stones", 0);
        currPlayer.set("green_stones", 0);
        currPlayer.set("blue_stones", 0);
        currPlayer.set("ancient_adena_amount", 0);
        if (removeReward) {
            this._signsPlayerData.put(objectId, currPlayer);
            if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
                this.saveSevenSignsData(objectId);
                this.saveSevenSignsStatus();
            }
        }
        return rewardAmount;
    }

    public long addPlayerStoneContrib(int objectId, long blueCount, long greenCount, long redCount) {
        StatsSet currPlayer = this._signsPlayerData.get(objectId);
        long contribScore = SevenSigns.calcContributionScore(blueCount, greenCount, redCount);
        long totalAncientAdena = currPlayer.getLong("ancient_adena_amount") + SevenSigns.calcAncientAdenaReward(blueCount, greenCount, redCount);
        long totalContribScore = currPlayer.getLong("contribution_score") + contribScore;
        if (totalContribScore > (long)Config.ALT_MAXIMUM_PLAYER_CONTRIB) {
            return -1L;
        }
        currPlayer.set("red_stones", (long)currPlayer.getInt("red_stones") + redCount);
        currPlayer.set("green_stones", (long)currPlayer.getInt("green_stones") + greenCount);
        currPlayer.set("blue_stones", (long)currPlayer.getInt("blue_stones") + blueCount);
        currPlayer.set("ancient_adena_amount", totalAncientAdena);
        currPlayer.set("contribution_score", totalContribScore);
        this._signsPlayerData.put(objectId, currPlayer);
        switch (this.getPlayerCabal(objectId)) {
            case 2: {
                this._dawnStoneScore += (double)contribScore;
                break;
            }
            case 1: {
                this._duskStoneScore += (double)contribScore;
            }
        }
        if (!Config.ALT_SEVENSIGNS_LAZY_UPDATE) {
            this.saveSevenSignsData(objectId);
            this.saveSevenSignsStatus();
        }
        return contribScore;
    }

    public void addFestivalScore(int cabal, int amount) {
        if (cabal == 1) {
            this._duskFestivalScore += amount;
            if (this._dawnFestivalScore >= amount) {
                this._dawnFestivalScore -= amount;
            }
        } else {
            this._dawnFestivalScore += amount;
            if (this._duskFestivalScore >= amount) {
                this._duskFestivalScore -= amount;
            }
        }
    }

    public void sendCurrentPeriodMsg(L2PcInstance player) {
        SystemMessage sm = null;
        switch (this.getCurrentPeriod()) {
            case 0: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.PREPARATIONS_PERIOD_BEGUN);
                break;
            }
            case 1: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.COMPETITION_PERIOD_BEGUN);
                break;
            }
            case 2: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.RESULTS_PERIOD_BEGUN);
                break;
            }
            case 3: {
                sm = SystemMessage.getSystemMessage(SystemMessageId.VALIDATION_PERIOD_BEGUN);
            }
        }
        player.sendPacket(sm);
    }

    public void sendMessageToAll(SystemMessageId sysMsgId) {
        Broadcast.toAllOnlinePlayers(SystemMessage.getSystemMessage(sysMsgId));
    }

    protected void initializeSeals() {
        for (Map.Entry<Integer, Integer> e : this._signsSealOwners.entrySet()) {
            if (e.getValue() != 0) {
                if (this.isSealValidationPeriod()) {
                    _log.info("SevenSigns: The " + SevenSigns.getCabalName(e.getValue()) + " have won the " + SevenSigns.getSealName(e.getKey(), false) + ".");
                    continue;
                }
                _log.info("SevenSigns: The " + SevenSigns.getSealName(e.getKey(), false) + " is currently owned by " + SevenSigns.getCabalName(e.getValue()) + ".");
                continue;
            }
            _log.info("SevenSigns: The " + SevenSigns.getSealName(e.getKey(), false) + " remains unclaimed.");
        }
    }

    protected void resetSeals() {
        this._signsDawnSealTotals.put(1, 0);
        this._signsDawnSealTotals.put(2, 0);
        this._signsDawnSealTotals.put(3, 0);
        this._signsDuskSealTotals.put(1, 0);
        this._signsDuskSealTotals.put(2, 0);
        this._signsDuskSealTotals.put(3, 0);
    }

    protected void calcNewSealOwners() {
        for (Integer currSeal : this._signsDawnSealTotals.keySet()) {
            int prevSealOwner = this._signsSealOwners.get(currSeal);
            int newSealOwner = 0;
            int dawnProportion = this.getSealProportion(currSeal, 2);
            int totalDawnMembers = this.getTotalMembers(2) == 0 ? 1 : this.getTotalMembers(2);
            int dawnPercent = Math.round((float)dawnProportion / (float)totalDawnMembers * 100.0f);
            int duskProportion = this.getSealProportion(currSeal, 1);
            int totalDuskMembers = this.getTotalMembers(1) == 0 ? 1 : this.getTotalMembers(1);
            int duskPercent = Math.round((float)duskProportion / (float)totalDuskMembers * 100.0f);
            block0 : switch (prevSealOwner) {
                case 0: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : 0;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 2: {
                            if (dawnPercent >= 10) {
                                newSealOwner = 2;
                                break;
                            }
                            newSealOwner = 0;
                            break;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 35 ? 1 : (dawnPercent >= 10 ? 2 : 0);
                        }
                    }
                    break;
                }
                case 1: {
                    switch (this.getCabalHighestScore()) {
                        case 0: {
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 2: {
                            if (dawnPercent >= 35) {
                                newSealOwner = 2;
                                break block0;
                            }
                            if (duskPercent >= 10) {
                                newSealOwner = 1;
                                break block0;
                            }
                            newSealOwner = 0;
                            break block0;
                        }
                        case 1: {
                            newSealOwner = duskPercent >= 10 ? 1 : 0;
                        }
                    }
                }
            }
            this._signsSealOwners.put(currSeal, newSealOwner);
            switch (currSeal) {
                case 1: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_AVARICE);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_AVARICE);
                    break;
                }
                case 2: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_GNOSIS);
                        break;
                    }
                    if (newSealOwner != 1) break;
                    this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_GNOSIS);
                    break;
                }
                case 3: {
                    if (newSealOwner == 2) {
                        this.sendMessageToAll(SystemMessageId.DAWN_OBTAINED_STRIFE);
                    } else if (newSealOwner == 1) {
                        this.sendMessageToAll(SystemMessageId.DUSK_OBTAINED_STRIFE);
                    }
                    CastleManager.getInstance().validateTaxes(newSealOwner);
                }
            }
        }
    }

    protected void teleLosingCabalFromDungeons(String compWinner) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            StatsSet currPlayer = this._signsPlayerData.get(player.getObjectId());
            if (this.isSealValidationPeriod() || this.isCompResultsPeriod()) {
                if (player.isGM() || !player.isIn7sDungeon() || currPlayer != null && currPlayer.getString("cabal").equals(compWinner)) continue;
                player.teleToLocation(TeleportWhereType.TOWN);
                player.setIsIn7sDungeon(false);
                player.sendMessage("You have been teleported to the nearest town due to the beginning of the Seal Validation period.");
                continue;
            }
            if (player.isGM() || !player.isIn7sDungeon() || currPlayer != null && currPlayer.getString("cabal").isEmpty()) continue;
            player.teleToLocation(TeleportWhereType.TOWN);
            player.setIsIn7sDungeon(false);
            player.sendMessage("You have been teleported to the nearest town because you have not signed for any cabal.");
        }
    }

    public boolean checkIsDawnPostingTicket(int itemId) {
        if (itemId > 6114 && itemId < 6175) {
            return true;
        }
        if (itemId > 6801 && itemId < 6812) {
            return true;
        }
        if (itemId > 7997 && itemId < 8008) {
            return true;
        }
        if (itemId > 7940 && itemId < 7951) {
            return true;
        }
        if (itemId > 6294 && itemId < 6307) {
            return true;
        }
        if (itemId > 6831 && itemId < 6834) {
            return true;
        }
        if (itemId > 8027 && itemId < 8030) {
            return true;
        }
        return itemId > 7970 && itemId < 7973;
    }

    public boolean checkIsRookiePostingTicket(int itemId) {
        if (itemId > 6174 && itemId < 6295) {
            return true;
        }
        if (itemId > 6811 && itemId < 6832) {
            return true;
        }
        if (itemId > 7950 && itemId < 7971) {
            return true;
        }
        return itemId > 8007 && itemId < 8028;
    }

    public void giveCPMult(int strifeOwner) {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            int cabal = this.getPlayerCabal(player.getObjectId());
            if (cabal == 0) continue;
            if (cabal == strifeOwner) {
                player.addSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
                continue;
            }
            player.addSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public void removeCPMult() {
        for (L2PcInstance player : L2World.getInstance().getPlayers()) {
            player.removeSkill(CommonSkill.THE_VICTOR_OF_WAR.getSkill());
            player.removeSkill(CommonSkill.THE_VANQUISHED_OF_WAR.getSkill());
        }
    }

    public boolean checkSummonConditions(L2PcInstance activeChar) {
        if (activeChar == null) {
            return true;
        }
        if (this.isSealValidationPeriod() && this.getSealOwner(3) == 2 && this.getPlayerCabal(activeChar.getObjectId()) == 1) {
            activeChar.sendPacket(SystemMessageId.SEAL_OF_STRIFE_FORBIDS_SUMMONING);
            return true;
        }
        return false;
    }

    private static class SingletonHolder {
        protected static final SevenSigns _instance = new SevenSigns();

        private SingletonHolder() {
        }
    }

    protected class SevenSignsPeriodChange
    implements Runnable {
        protected SevenSignsPeriodChange() {
        }

        @Override
        public void run() {
            int periodEnded = SevenSigns.this.getCurrentPeriod();
            ++SevenSigns.this._activePeriod;
            switch (periodEnded) {
                case 0: {
                    SevenSignsFestival.getInstance().startFestivalManager();
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_BEGUN);
                    break;
                }
                case 1: {
                    SevenSigns.this.sendMessageToAll(SystemMessageId.QUEST_EVENT_PERIOD_ENDED);
                    int compWinner = SevenSigns.this.getCabalHighestScore();
                    SevenSignsFestival.getInstance().getFestivalManagerSchedule().cancel(false);
                    SevenSignsFestival.getInstance().rewardHighestRanked();
                    SevenSigns.this.calcNewSealOwners();
                    switch (compWinner) {
                        case 2: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DAWN_WON);
                            break;
                        }
                        case 1: {
                            SevenSigns.this.sendMessageToAll(SystemMessageId.DUSK_WON);
                        }
                    }
                    SevenSigns.this._previousWinner = compWinner;
                    ArrayList<Castle> castles = CastleManager.getInstance().getCastles();
                    for (Castle castle : castles) {
                        castle.setTicketBuyCount(0);
                    }
                    break;
                }
                case 2: {
                    SevenSigns.this.initializeSeals();
                    SevenSigns.this.giveCPMult(SevenSigns.this.getSealOwner(3));
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_BEGUN);
                    _log.info("SevenSigns: The " + SevenSigns.getCabalName(SevenSigns.this._previousWinner) + " have won the competition with " + SevenSigns.this.getCurrentScore(SevenSigns.this._previousWinner) + " points!");
                    break;
                }
                case 3: {
                    SevenSigns.this._activePeriod = 0;
                    SevenSigns.this.sendMessageToAll(SystemMessageId.SEAL_VALIDATION_PERIOD_ENDED);
                    SevenSigns.this.removeCPMult();
                    SevenSigns.this.resetPlayerData();
                    SevenSigns.this.resetSeals();
                    ++SevenSigns.this._currentCycle;
                    SevenSignsFestival.getInstance().resetFestivalData(false);
                    SevenSigns.this._dawnStoneScore = 0.0;
                    SevenSigns.this._duskStoneScore = 0.0;
                    SevenSigns.this._dawnFestivalScore = 0;
                    SevenSigns.this._duskFestivalScore = 0;
                }
            }
            SevenSigns.this.saveSevenSignsData();
            SevenSigns.this.saveSevenSignsStatus();
            SevenSigns.this.teleLosingCabalFromDungeons(SevenSigns.getCabalShortName(SevenSigns.this.getCabalHighestScore()));
            SSQInfo ss = new SSQInfo();
            Broadcast.toAllOnlinePlayers(ss);
            SevenSigns.this.spawnSevenSignsNPC();
            _log.info("SevenSigns: The " + SevenSigns.this.getCurrentPeriodName() + " period has begun!");
            SevenSigns.this.setCalendarForNextPeriodChange();
            SevenSignsPeriodChange sspc = new SevenSignsPeriodChange();
            ThreadPoolManager.getInstance().scheduleGeneral(sspc, SevenSigns.this.getMilliToPeriodChange());
        }
    }
}

