/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.datatables.TerritoryTable;
import com.l2jserver.gameserver.enums.AISkillScope;
import com.l2jserver.gameserver.enums.AIType;
import com.l2jserver.gameserver.instancemanager.DimensionalRiftManager;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FestivalMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FriendlyMobInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GrandBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2GuardInstance;
import com.l2jserver.gameserver.model.actor.instance.L2MonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RaidBossInstance;
import com.l2jserver.gameserver.model.actor.instance.L2RiftInvaderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2StaticObjectInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableFactionCall;
import com.l2jserver.gameserver.model.events.impl.character.npc.attackable.OnAttackableHate;
import com.l2jserver.gameserver.model.events.returns.TerminateReturn;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.model.zone.ZoneId;
import com.l2jserver.gameserver.network.serverpackets.ValidateLocation;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class L2AttackableAI
extends L2CharacterAI
implements Runnable {
    private static final int RANDOM_WALK_RATE = 30;
    private static final int MAX_ATTACK_TIMEOUT = 1200;
    private Future<?> _aiTask;
    private int _attackTimeout;
    private int _globalAggro = -10;
    private boolean _thinking;
    private int timepass = 0;
    private int chaostime = 0;
    private final L2NpcTemplate _skillrender = this.getActiveChar().getTemplate();
    int lastBuffTick;

    public L2AttackableAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._attackTimeout = Integer.MAX_VALUE;
    }

    @Override
    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        if (target == null || this.getActiveChar() == null) {
            return false;
        }
        L2Attackable me = this.getActiveChar();
        if (target.isInvul()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isGM()) {
                return false;
            }
            if (target instanceof L2Summon && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target instanceof L2DoorInstance) {
            return false;
        }
        if (target.isAlikeDead() || target instanceof L2Playable && !me.isInsideRadius(target, me.getAggroRange(), true, false)) {
            return false;
        }
        if (target.isPlayable() && !me.isRaid() && !me.canSeeThroughSilentMove() && ((L2Playable)target).isSilentMovingAffected()) {
            return false;
        }
        L2PcInstance player = target.getActingPlayer();
        if (player != null) {
            if (player.isGM() && !player.getAccessLevel().canTakeAggro()) {
                return false;
            }
            if (player.isRecentFakeDeath()) {
                return false;
            }
            if (player.isInParty() && player.getParty().isInDimensionalRift()) {
                byte riftType = player.getParty().getDimensionalRift().getType();
                byte riftRoom = player.getParty().getDimensionalRift().getCurrentRoom();
                if (me instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(me.getX(), me.getY(), me.getZ())) {
                    return false;
                }
            }
        }
        if (me instanceof L2GuardInstance) {
            if (player != null && player.getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, player);
            }
            if (target instanceof L2MonsterInstance && Config.GUARD_ATTACK_AGGRO_MOB) {
                return ((L2MonsterInstance)target).isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (me instanceof L2FriendlyMobInstance) {
            if (target instanceof L2Npc) {
                return false;
            }
            if (target instanceof L2PcInstance && ((L2PcInstance)target).getKarma() > 0) {
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
            return false;
        }
        if (target instanceof L2Attackable) {
            if (!target.isAutoAttackable(me)) {
                return false;
            }
            if (me.isChaos() && me.isInsideRadius(target, me.getAggroRange(), false, false)) {
                if (((L2Attackable)target).isInMyClan(me)) {
                    return false;
                }
                return GeoData.getInstance().canSeeTarget((L2Object)me, target);
            }
        }
        if (target instanceof L2Attackable || target instanceof L2Npc) {
            return false;
        }
        if (!Config.ALT_MOB_AGRO_IN_PEACEZONE && target.isInsideZone(ZoneId.PEACE)) {
            return false;
        }
        if (me.isChampion() && Config.L2JMOD_CHAMPION_PASSIVE) {
            return false;
        }
        return me.isAggressive() && GeoData.getInstance().canSeeTarget((L2Object)me, target);
    }

    public void startAITask() {
        if (this._aiTask == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, 1000L);
        }
    }

    @Override
    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
        super.stopAITask();
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (intention == CtrlIntention.AI_INTENTION_IDLE) {
            L2Attackable npc = this.getActiveChar();
            if (!npc.isAlikeDead()) {
                int range;
                Location loc;
                if (!npc.getKnownList().getKnownPlayers().isEmpty()) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                } else if (npc.getSpawn() != null && !npc.isInsideRadius(loc = npc.getSpawn().getLocation(npc), (range = Config.MAX_DRIFT_RANGE) + range, true, false)) {
                    intention = CtrlIntention.AI_INTENTION_ACTIVE;
                }
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this._aiTask != null) {
                    this._aiTask.cancel(true);
                    this._aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        this.startAITask();
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        this._attackTimeout = 1200 + GameTimeController.getInstance().getGameTicks();
        if (this.lastBuffTick + 30 < GameTimeController.getInstance().getGameTicks()) {
            for (Skill sk : this._skillrender.getAISkills(AISkillScope.BUFF)) {
                if (!this.cast(sk)) continue;
                L2Attackable npc = this.getActiveChar();
                if (npc.isMoving() || !npc.isWalker() || !WalkingManager.getInstance().isOnWalk(npc)) break;
                WalkingManager.getInstance().stopMoving(npc, false, true);
                break;
            }
            this.lastBuffTick = GameTimeController.getInstance().getGameTicks();
        }
        super.onIntentionAttack(target);
    }

    private void thinkCast() {
        if (this.checkTargetLost(this.getCastTarget())) {
            this.setCastTarget(null);
            return;
        }
        if (this.maybeMoveToPawn(this.getCastTarget(), this._actor.getMagicalAttackRange(this._skill))) {
            return;
        }
        this.clientStopMoving(null);
        this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        this._accessor.doCast(this._skill);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void thinkActive() {
        int z1;
        int y1;
        int x1;
        L2Attackable npc;
        block31: {
            npc = this.getActiveChar();
            if (this._globalAggro != 0) {
                this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
            }
            if (this._globalAggro >= 0) {
                Collection objs = npc.getKnownList().getKnownObjects().values();
                for (L2Object obj : objs) {
                    int hating;
                    TerminateReturn term;
                    L2PcInstance targetPlayer;
                    if (!(obj instanceof L2Character) || obj instanceof L2StaticObjectInstance) continue;
                    L2Character target = (L2Character)obj;
                    if (npc instanceof L2FestivalMonsterInstance && obj instanceof L2PcInstance && !(targetPlayer = (L2PcInstance)obj).isFestivalParticipant() || !this.autoAttackCondition(target) || target.isPlayable() && (term = EventDispatcher.getInstance().notifyEvent(new OnAttackableHate(this.getActiveChar(), target.getActingPlayer(), target.isSummon()), this.getActiveChar(), TerminateReturn.class)) != null && term.terminate() || (hating = npc.getHating(target)) != 0) continue;
                    npc.addDamageHate(target, 0, 0);
                }
                L2Character hated = npc.isConfused() ? this.getAttackTarget() : npc.getMostHated();
                if (hated != null && !npc.isCoreAIDisabled()) {
                    int aggro = npc.getHating(hated);
                    if (aggro + this._globalAggro <= 0) return;
                    if (!npc.isRunning()) {
                        npc.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated);
                    return;
                }
            }
            if (npc.getCurrentHp() == (double)npc.getMaxHp() && npc.getCurrentMp() == (double)npc.getMaxMp() && !npc.getAttackByList().isEmpty() && Rnd.nextInt(500) == 0) {
                npc.clearAggroList();
                npc.getAttackByList().clear();
                if (npc instanceof L2MonsterInstance && ((L2MonsterInstance)npc).hasMinions()) {
                    ((L2MonsterInstance)npc).getMinionList().deleteReusedMinions();
                }
            }
            if (!npc.canReturnToSpawnPoint()) {
                return;
            }
            if (this instanceof L2GuardInstance.L2GuardAI && !npc.isWalker()) {
                ((L2GuardInstance.L2GuardAI)this).returnHome();
                return;
            }
            if (npc instanceof L2FestivalMonsterInstance) {
                return;
            }
            L2Attackable leader = npc.getLeader();
            if (leader != null && !leader.isAlikeDead()) {
                int minRadius = 30;
                int offset = npc.isRaidMinion() ? 500 : 200;
                if (leader.isRunning()) {
                    npc.setRunning();
                } else {
                    npc.setWalking();
                }
                if (npc.calculateDistance(leader, false, true) > (double)(offset * offset)) {
                    double distance = Rnd.get(30, offset);
                    double angle = Rnd.nextDouble() * (Math.PI * 2);
                    int x12 = leader.getX() + (int)(distance * Math.cos(angle));
                    int y12 = leader.getY() + (int)(distance * Math.sin(angle));
                    int z12 = leader.getZ();
                    this.moveTo(x12, y12, z12);
                    return;
                }
                if (Rnd.nextInt(30) != 0) return;
                for (Skill sk : this._skillrender.getAISkills(AISkillScope.BUFF)) {
                    if (!this.cast(sk)) continue;
                    return;
                }
                return;
            }
            if (npc.getSpawn() == null || Rnd.nextInt(30) != 0) return;
            x1 = 0;
            y1 = 0;
            z1 = 0;
            int range = Config.MAX_DRIFT_RANGE;
            for (Skill sk : this._skillrender.getAISkills(AISkillScope.BUFF)) {
                if (!this.cast(sk)) continue;
                return;
            }
            if (npc.getSpawn().getX() == 0 && npc.getSpawn().getY() == 0 && npc.getSpawn().getSpawnTerritory() == null) {
                double distance2;
                Location location = TerritoryTable.getInstance().getRandomPoint(npc.getSpawn().getLocationId());
                if (location != null) {
                    x1 = location.getX();
                    y1 = location.getY();
                    z1 = location.getZ();
                }
                if ((distance2 = npc.calculateDistance(x1, y1, 0, false, true)) > (double)((range + range) * (range + range))) {
                    npc.setisReturningToSpawnPoint(true);
                    float delay = (float)Math.sqrt(distance2) / (float)range;
                    x1 = npc.getX() + (int)((float)(x1 - npc.getX()) / delay);
                    y1 = npc.getY() + (int)((float)(y1 - npc.getY()) / delay);
                }
                if (TerritoryTable.getInstance().getProcMax(npc.getSpawn().getLocationId()) > 0 && !npc.isReturningToSpawnPoint()) {
                    return;
                }
            } else {
                ILocational p = npc.getSpawnPoint();
                x1 = p.getX();
                y1 = p.getY();
                z1 = p.getZ();
                if (npc.isNoRndWalk()) {
                    if (npc.getX() != x1 || npc.getY() != y1) {
                        if (npc.isReturningToSpawnPoint() && npc.isMoving() && npc.getXdestination() == x1 && npc.getYdestination() == y1) {
                            return;
                        }
                        npc.setisReturningToSpawnPoint(true);
                        break block31;
                    } else {
                        int h1 = npc.getSpawn().getHeading();
                        if (npc.getHeading() == h1) return;
                        npc.setHeading(h1);
                        npc.broadcastPacket(new ValidateLocation(npc));
                        return;
                    }
                }
                if (!npc.isInsideRadius(x1, y1, 0, range, false, false)) {
                    if (npc.isReturningToSpawnPoint() && npc.isMoving() && npc.getXdestination() == x1 && npc.getYdestination() == y1) {
                        return;
                    }
                    npc.setisReturningToSpawnPoint(true);
                } else {
                    double distance = Rnd.get(range);
                    double angle = Rnd.nextDouble() * (Math.PI * 2);
                    x1 += (int)(distance * Math.cos(angle));
                    y1 += (int)(distance * Math.sin(angle));
                    z1 = npc.getZ();
                }
            }
        }
        Location moveLoc = GeoData.getInstance().moveCheck(npc.getX(), npc.getY(), npc.getZ(), x1, y1, z1, npc.getInstanceId());
        this.moveTo(moveLoc.getX(), moveLoc.getY(), moveLoc.getZ());
    }

    private void thinkAttack() {
        Object skill;
        L2Attackable npc = this.getActiveChar();
        if (npc.isCastingNow()) {
            return;
        }
        L2Character originalAttackTarget = this.getAttackTarget();
        if (originalAttackTarget == null || originalAttackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getInstance().getGameTicks()) {
            if (originalAttackTarget != null) {
                npc.stopHating(originalAttackTarget);
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            npc.setWalking();
            return;
        }
        int collision = npc.getTemplate().getCollisionRadius();
        int[] clans = this.getActiveChar().getTemplate().getClans();
        if (clans != null && clans.length > 0 && npc.getAttackByList().contains(originalAttackTarget)) {
            int factionRange = npc.getTemplate().getClanHelpRange() + collision;
            Collection objs = originalAttackTarget.getKnownList().getKnownObjects().values();
            try {
                for (L2Object obj : objs) {
                    if (!(obj instanceof L2Npc)) continue;
                    L2Npc called = (L2Npc)obj;
                    if (!this.getActiveChar().isInMyClan(called) || !npc.isInsideRadius(called, factionRange, true, false) || !called.hasAI() || Math.abs(originalAttackTarget.getZ() - called.getZ()) >= 600 || called.getAI()._intention != CtrlIntention.AI_INTENTION_IDLE && called.getAI()._intention != CtrlIntention.AI_INTENTION_ACTIVE || called.getInstanceId() != npc.getInstanceId()) continue;
                    if (originalAttackTarget.isPlayable()) {
                        if (originalAttackTarget.isInParty() && originalAttackTarget.getParty().isInDimensionalRift()) {
                            byte riftType = originalAttackTarget.getParty().getDimensionalRift().getType();
                            byte riftRoom = originalAttackTarget.getParty().getDimensionalRift().getCurrentRoom();
                            if (npc instanceof L2RiftInvaderInstance && !DimensionalRiftManager.getInstance().getRoom(riftType, riftRoom).checkIfInZone(npc.getX(), npc.getY(), npc.getZ())) continue;
                        }
                        called.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, originalAttackTarget, 1);
                        EventDispatcher.getInstance().notifyEventAsync(new OnAttackableFactionCall(called, this.getActiveChar(), originalAttackTarget.getActingPlayer(), originalAttackTarget.isSummon()), called);
                        continue;
                    }
                    if (!(called instanceof L2Attackable) || this.getAttackTarget() == null || called.getAI()._intention == CtrlIntention.AI_INTENTION_ATTACK) continue;
                    ((L2Attackable)called).addDamageHate(this.getAttackTarget(), 0, npc.getHating(this.getAttackTarget()));
                    called.getAI().setIntention(CtrlIntention.AI_INTENTION_ATTACK, this.getAttackTarget());
                }
            }
            catch (NullPointerException e) {
                this._log.warning(this.getClass().getSimpleName() + ": thinkAttack() faction call failed: " + e.getMessage());
            }
        }
        if (npc.isCoreAIDisabled()) {
            return;
        }
        L2Character mostHate = npc.getMostHated();
        if (mostHate == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return;
        }
        this.setAttackTarget(mostHate);
        npc.setTarget(mostHate);
        int combinedCollision = collision + mostHate.getTemplate().getCollisionRadius();
        List<Skill> aiSuicideSkills = this._skillrender.getAISkills(AISkillScope.SUICIDE);
        if (!aiSuicideSkills.isEmpty() && (int)(npc.getCurrentHp() / (double)npc.getMaxHp() * 100.0) < 30 && Util.checkIfInRange(((Skill)(skill = aiSuicideSkills.get(Rnd.nextInt(aiSuicideSkills.size())))).getAffectRange(), this.getActiveChar(), mostHate, false) && Rnd.get(100) < Rnd.get(npc.getMinSkillChance(), npc.getMaxSkillChance())) {
            if (this.cast((Skill)skill)) {
                return;
            }
            for (Skill sk : aiSuicideSkills) {
                if (!this.cast(sk)) continue;
                return;
            }
        }
        if (!npc.isMovementDisabled() && Rnd.nextInt(100) <= 3) {
            for (L2Object nearby : npc.getKnownList().getKnownObjects().values()) {
                if (nearby == mostHate || !(nearby instanceof L2Character) || !(Math.hypot(npc.getX() - nearby.getX(), npc.getY() - nearby.getY()) < (double)collision)) continue;
                double distance = Util.calculateDistance(npc, mostHate, false) + (double)Rnd.get(40);
                double F = 2.6179938779914944;
                double angle = Rnd.nextDouble() * 5.235987755982989 - 2.6179938779914944;
                int newX = mostHate.getX() + (int)(distance * Math.cos(angle += Util.convertHeadingToRadian(mostHate.getHeading())));
                int newY = mostHate.getY() + (int)(distance * Math.sin(angle));
                if (!(Math.hypot(newX - nearby.getX(), newY - nearby.getY()) > (double)collision)) continue;
                int newZ = npc.getZ() + 30;
                if (Config.GEODATA != 0 && !GeoData.getInstance().canMove(npc.getX(), npc.getY(), npc.getZ(), newX, newY, newZ, npc.getInstanceId())) continue;
                this.moveTo(newX, newY, newZ);
                return;
            }
        }
        if (!npc.isMovementDisabled() && npc.getDodge() > 0 && Rnd.get(100) <= npc.getDodge() && npc.calculateDistance(mostHate, false, false) <= (double)(60 + combinedCollision)) {
            double distance = 300.0;
            double F = 0.5235987755982988;
            double angle = Rnd.nextDouble() * 1.0471975511965976 - 0.5235987755982988;
            int posX = npc.getX() + (int)(300.0 * Math.cos(angle += Math.atan2(npc.getY() - mostHate.getY(), npc.getX() - mostHate.getX())));
            int n = npc.getY() + (int)(300.0 * Math.sin(angle));
            int posZ = npc.getZ() + 30;
            if (Config.GEODATA == 0 || GeoData.getInstance().canMove(npc.getX(), npc.getY(), npc.getZ(), posX, n, posZ, npc.getInstanceId())) {
                this.setIntention(CtrlIntention.AI_INTENTION_MOVE_TO, new Location(posX, n, posZ, 0));
            }
            return;
        }
        if (npc.isRaid() || npc.isRaidMinion()) {
            ++this.chaostime;
            if (npc instanceof L2RaidBossInstance) {
                if (!((L2MonsterInstance)npc).hasMinions()) {
                    if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 100.0 / (double)npc.getMaxHp()) {
                        this.aggroReconsider();
                        this.chaostime = 0;
                        return;
                    }
                } else if (this.chaostime > Config.RAID_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 200.0 / (double)npc.getMaxHp()) {
                    this.aggroReconsider();
                    this.chaostime = 0;
                    return;
                }
            } else if (npc instanceof L2GrandBossInstance) {
                double chaosRate;
                if (this.chaostime > Config.GRAND_CHAOS_TIME && ((chaosRate = 100.0 - npc.getCurrentHp() * 300.0 / (double)npc.getMaxHp()) <= 10.0 && Rnd.get(100) <= 10 || chaosRate > 10.0 && (double)Rnd.get(100) <= chaosRate)) {
                    this.aggroReconsider();
                    this.chaostime = 0;
                    return;
                }
            } else if (this.chaostime > Config.MINION_CHAOS_TIME && (double)Rnd.get(100) <= 100.0 - npc.getCurrentHp() * 200.0 / (double)npc.getMaxHp()) {
                this.aggroReconsider();
                this.chaostime = 0;
                return;
            }
        }
        if (!this._skillrender.getAISkills(AISkillScope.GENERAL).isEmpty()) {
            List<Skill> aiResSkills;
            List<Skill> aiHealSkills = this._skillrender.getAISkills(AISkillScope.HEAL);
            if (!aiHealSkills.isEmpty()) {
                L2Attackable leader;
                double percentage = npc.getCurrentHp() / (double)npc.getMaxHp() * 100.0;
                if (npc.isMinion() && (leader = npc.getLeader()) != null && !leader.isDead() && (double)Rnd.get(100) > leader.getCurrentHp() / (double)leader.getMaxHp() * 100.0) {
                    for (Skill skill2 : aiHealSkills) {
                        if (skill2.getTargetType() == L2TargetType.SELF || !this.checkSkillCastConditions(skill2)) continue;
                        if (!(Util.checkIfInRange(skill2.getCastRange() + collision + ((L2Character)leader).getTemplate().getCollisionRadius(), npc, leader, false) || this.isParty(skill2) || npc.isMovementDisabled())) {
                            this.moveToPawn(leader, skill2.getCastRange() + collision + ((L2Character)leader).getTemplate().getCollisionRadius());
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)npc, leader)) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(leader);
                        this.clientStopMoving(null);
                        npc.doCast(skill2);
                        return;
                    }
                }
                if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                    for (Skill sk : aiHealSkills) {
                        if (!this.checkSkillCastConditions(sk)) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(npc);
                        npc.doCast(sk);
                        return;
                    }
                }
                for (Skill sk : aiHealSkills) {
                    if (!this.checkSkillCastConditions(sk)) continue;
                    if (sk.getTargetType() == L2TargetType.ONE) {
                        for (L2Character obj : npc.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + collision)) {
                            if (!(obj instanceof L2Attackable) || obj.isDead()) continue;
                            L2Attackable l2Attackable = (L2Attackable)obj;
                            if (!((L2Attackable)obj).isInMyClan(npc)) continue;
                            percentage = l2Attackable.getCurrentHp() / (double)l2Attackable.getMaxHp() * 100.0;
                            if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)npc, l2Attackable)) continue;
                            this.clientStopMoving(null);
                            npc.setTarget(obj);
                            npc.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    npc.doCast(sk);
                    return;
                }
            }
            if (!(aiResSkills = this._skillrender.getAISkills(AISkillScope.RES)).isEmpty()) {
                L2Attackable leader;
                if (npc.isMinion() && (leader = npc.getLeader()) != null && leader.isDead()) {
                    for (Skill sk : aiResSkills) {
                        if (sk.getTargetType() == L2TargetType.SELF || !this.checkSkillCastConditions(sk)) continue;
                        if (!(Util.checkIfInRange(sk.getCastRange() + collision + ((L2Character)leader).getTemplate().getCollisionRadius(), npc, leader, false) || this.isParty(sk) || npc.isMovementDisabled())) {
                            this.moveToPawn(leader, sk.getCastRange() + collision + ((L2Character)leader).getTemplate().getCollisionRadius());
                            return;
                        }
                        if (!GeoData.getInstance().canSeeTarget((L2Object)npc, leader)) continue;
                        this.clientStopMoving(null);
                        npc.setTarget(leader);
                        npc.doCast(sk);
                        return;
                    }
                }
                for (Skill sk : aiResSkills) {
                    if (!this.checkSkillCastConditions(sk)) continue;
                    if (sk.getTargetType() == L2TargetType.ONE) {
                        for (L2Character l2Character : npc.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + collision)) {
                            L2Attackable targets;
                            if (!(l2Character instanceof L2Attackable) || !l2Character.isDead() || !npc.isInMyClan(targets = (L2Attackable)l2Character) || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)npc, targets)) continue;
                            this.clientStopMoving(null);
                            npc.setTarget(l2Character);
                            npc.doCast(sk);
                            return;
                        }
                    }
                    if (!this.isParty(sk)) continue;
                    this.clientStopMoving(null);
                    L2Character target = this.getAttackTarget();
                    npc.setTarget(npc);
                    npc.doCast(sk);
                    npc.setTarget(target);
                    return;
                }
            }
        }
        double dist = npc.calculateDistance(mostHate, false, false);
        int dist2 = (int)dist - collision;
        int range = npc.getPhysicalAttackRange() + combinedCollision;
        if (mostHate.isMoving()) {
            range += 50;
            if (npc.isMoving()) {
                range += 50;
            }
        }
        if (npc.isMovementDisabled() && (dist > (double)range || mostHate.isMoving()) || dist > (double)range && mostHate.isMoving()) {
            this.movementDisable();
            return;
        }
        this.setTimepass(0);
        List<Skill> aiGeneralSkills = this._skillrender.getAISkills(AISkillScope.GENERAL);
        if (!aiGeneralSkills.isEmpty()) {
            if (Rnd.get(100) < Rnd.get(npc.getMinSkillChance(), npc.getMaxSkillChance())) {
                Skill skill3 = aiGeneralSkills.get(Rnd.nextInt(aiGeneralSkills.size()));
                if (this.cast(skill3)) {
                    return;
                }
                for (Skill skill4 : aiGeneralSkills) {
                    if (!this.cast(skill4)) continue;
                    return;
                }
            }
            if (npc.hasLSkill() || npc.hasSSkill()) {
                List<Skill> longRangeSkills;
                List<Skill> list = this.shortRangeSkillRender();
                if (!list.isEmpty() && npc.hasSSkill() && dist2 <= 150 && Rnd.get(100) <= npc.getSSkillChance()) {
                    Skill shortRangeSkill = list.get(Rnd.get(list.size()));
                    if (shortRangeSkill != null && this.cast(shortRangeSkill)) {
                        return;
                    }
                    for (Skill sk : list) {
                        if (sk == null || !this.cast(sk)) continue;
                        return;
                    }
                }
                if (!(longRangeSkills = this.longRangeSkillRender()).isEmpty() && npc.hasLSkill() && dist2 > 150 && Rnd.get(100) <= npc.getLSkillChance()) {
                    Skill skill5 = longRangeSkills.get(Rnd.get(longRangeSkills.size()));
                    if (skill5 != null && this.cast(skill5)) {
                        return;
                    }
                    for (Skill sk : longRangeSkills) {
                        if (sk == null || !this.cast(sk)) continue;
                        return;
                    }
                }
            }
        }
        if (dist2 > range || !GeoData.getInstance().canSeeTarget((L2Object)npc, mostHate)) {
            if (npc.isMovementDisabled()) {
                this.targetReconsider();
            } else if (this.getAttackTarget() != null) {
                if (this.getAttackTarget().isMoving()) {
                    range -= 100;
                }
                if (range < 5) {
                    range = 5;
                }
                this.moveToPawn(this.getAttackTarget(), range);
            }
            return;
        }
        this.melee(npc.getPrimarySkillId());
    }

    private void melee(int type) {
        if (type != 0) {
            switch (type) {
                case -1: {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.GENERAL)) {
                        if (!this.cast(sk)) continue;
                        return;
                    }
                    break;
                }
                case 1: {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.ATTACK)) {
                        if (!this.cast(sk)) continue;
                        return;
                    }
                    break;
                }
                default: {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.GENERAL)) {
                        if (sk.getId() != this.getActiveChar().getPrimarySkillId() || !this.cast(sk)) continue;
                        return;
                    }
                }
            }
        }
        this._accessor.doAttack(this.getAttackTarget());
    }

    private boolean cast(Skill sk) {
        L2Character target;
        L2Character attackTarget;
        if (sk == null) {
            return false;
        }
        L2Attackable caster = this.getActiveChar();
        if (caster.isCastingNow() && !sk.isSimultaneousCast()) {
            return false;
        }
        if (!this.checkSkillCastConditions(sk)) {
            return false;
        }
        if (this.getAttackTarget() == null && caster.getMostHated() != null) {
            this.setAttackTarget(caster.getMostHated());
        }
        if ((attackTarget = this.getAttackTarget()) == null) {
            return false;
        }
        double dist = caster.calculateDistance(attackTarget, false, false);
        double dist2 = dist - (double)attackTarget.getTemplate().getCollisionRadius();
        double range = caster.getPhysicalAttackRange() + caster.getTemplate().getCollisionRadius() + attackTarget.getTemplate().getCollisionRadius();
        double srange = sk.getCastRange() + caster.getTemplate().getCollisionRadius();
        if (attackTarget.isMoving()) {
            dist2 -= 30.0;
        }
        if (sk.isContinuous()) {
            if (!sk.isDebuff()) {
                if (!caster.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
                if (sk.getTargetType() == L2TargetType.SELF) {
                    return false;
                }
                if (sk.getTargetType() == L2TargetType.ONE && (target = this.effectTargetReconsider(sk, true)) != null) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
                if (this.canParty(sk)) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
            } else if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA || sk.getTargetType() == L2TargetType.AURA_CORPSE_MOB) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if ((sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (sk.getTargetType() == L2TargetType.ONE && (target = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) {
            if (sk.getTargetType() == L2TargetType.ONE) {
                if (attackTarget.getEffectList().getFirstEffect(L2EffectType.BUFF) != null && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                target = this.effectTargetReconsider(sk, false);
                if (target != null) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                if ((sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget)) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if ((sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            }
        }
        if (sk.hasEffectType(L2EffectType.HEAL)) {
            L2Npc targets;
            Iterator<L2Character> leader;
            double percentage = caster.getCurrentHp() / (double)caster.getMaxHp() * 100.0;
            if (caster.isMinion() && sk.getTargetType() != L2TargetType.SELF && (leader = caster.getLeader()) != null && !((L2Character)((Object)leader)).isDead() && (double)Rnd.get(100) > ((L2Character)((Object)leader)).getCurrentHp() / (double)((L2Character)((Object)leader)).getMaxHp() * 100.0) {
                if (!(Util.checkIfInRange(sk.getCastRange() + caster.getTemplate().getCollisionRadius() + ((L2Character)((Object)leader)).getTemplate().getCollisionRadius(), caster, leader, false) || this.isParty(sk) || caster.isMovementDisabled())) {
                    this.moveToPawn((L2Object)((Object)leader), sk.getCastRange() + caster.getTemplate().getCollisionRadius() + ((L2Character)((Object)leader)).getTemplate().getCollisionRadius());
                }
                if (GeoData.getInstance().canSeeTarget((L2Object)caster, (L2Object)((Object)leader))) {
                    this.clientStopMoving(null);
                    caster.setTarget((L2Object)((Object)leader));
                    caster.doCast(sk);
                    return true;
                }
            }
            if ((double)Rnd.get(100) < (100.0 - percentage) / 3.0) {
                this.clientStopMoving(null);
                caster.setTarget(caster);
                caster.doCast(sk);
                return true;
            }
            if (sk.getTargetType() == L2TargetType.ONE) {
                for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + caster.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || obj.isDead() || !caster.isInMyClan(targets = (L2Attackable)obj)) continue;
                    percentage = targets.getCurrentHp() / (double)targets.getMaxHp() * 100.0;
                    if (!((double)Rnd.get(100) < (100.0 - percentage) / 10.0) || !GeoData.getInstance().canSeeTarget((L2Object)caster, targets)) continue;
                    this.clientStopMoving(null);
                    caster.setTarget(obj);
                    caster.doCast(sk);
                    return true;
                }
            }
            if (this.isParty(sk)) {
                for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getAffectRange() + caster.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || !(targets = (L2Npc)obj).isInMyClan(caster) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
            }
        }
        if (sk.hasEffectType(L2EffectType.PHYSICAL_ATTACK, L2EffectType.PHYSICAL_ATTACK_HP_LINK, L2EffectType.MAGICAL_ATTACK, L2EffectType.DEATH_LINK, L2EffectType.HP_DRAIN)) {
            if (!this.canAura(sk)) {
                if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                L2Character target2 = this.skillTargetReconsider(sk);
                if (target2 != null) {
                    this.clientStopMoving(null);
                    L2Character targets = attackTarget;
                    caster.setTarget(target2);
                    caster.doCast(sk);
                    caster.setTarget(targets);
                    return true;
                }
            } else {
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.SLEEP)) {
            if (sk.getTargetType() == L2TargetType.ONE) {
                if (!attackTarget.isDead() && dist2 <= srange && (dist2 > range || attackTarget.isMoving()) && !attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                L2Character target3 = this.effectTargetReconsider(sk, false);
                if (target3 != null) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if ((sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            }
        }
        if (sk.hasEffectType(L2EffectType.STUN, L2EffectType.ROOT, L2EffectType.PARALYZE, L2EffectType.MUTE, L2EffectType.FEAR)) {
            L2Character target4;
            if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if ((sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (sk.getTargetType() == L2TargetType.ONE && (target4 = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.DMG_OVER_TIME, L2EffectType.DMG_OVER_TIME_PERCENT)) {
            L2Character target5;
            if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !this.canAOE(sk) && !attackTarget.isDead() && dist2 <= srange) {
                if (!attackTarget.isAffectedBySkill(sk.getId())) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (this.canAOE(sk)) {
                if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA || sk.getTargetType() == L2TargetType.AURA_CORPSE_MOB) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
                if ((sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) && GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                    this.clientStopMoving(null);
                    caster.doCast(sk);
                    return true;
                }
            } else if (sk.getTargetType() == L2TargetType.ONE && (target5 = this.effectTargetReconsider(sk, false)) != null) {
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
        }
        if (sk.hasEffectType(L2EffectType.RESURRECTION)) {
            L2Npc targets;
            if (!this.isParty(sk)) {
                L2Attackable leader;
                if (caster.isMinion() && sk.getTargetType() != L2TargetType.SELF && (leader = caster.getLeader()) != null) {
                    if (leader.isDead() && !Util.checkIfInRange(sk.getCastRange() + caster.getTemplate().getCollisionRadius() + ((L2Character)leader).getTemplate().getCollisionRadius(), caster, leader, false) && !this.isParty(sk) && !caster.isMovementDisabled()) {
                        this.moveToPawn(leader, sk.getCastRange() + caster.getTemplate().getCollisionRadius() + ((L2Character)leader).getTemplate().getCollisionRadius());
                    }
                    if (GeoData.getInstance().canSeeTarget((L2Object)caster, leader)) {
                        this.clientStopMoving(null);
                        caster.setTarget(leader);
                        caster.doCast(sk);
                        return true;
                    }
                }
                for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getCastRange() + caster.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || !obj.isDead() || !caster.isInMyClan(targets = (L2Attackable)obj) || Rnd.get(100) >= 10 || !GeoData.getInstance().canSeeTarget((L2Object)caster, targets)) continue;
                    this.clientStopMoving(null);
                    caster.setTarget(obj);
                    caster.doCast(sk);
                    return true;
                }
            } else if (this.isParty(sk)) {
                for (L2Character obj : caster.getKnownList().getKnownCharactersInRadius(sk.getAffectRange() + caster.getTemplate().getCollisionRadius())) {
                    if (!(obj instanceof L2Attackable) || !caster.isInMyClan(targets = (L2Npc)obj) || !(obj.getCurrentHp() < (double)obj.getMaxHp()) || Rnd.get(100) > 20) continue;
                    this.clientStopMoving(null);
                    caster.setTarget(caster);
                    caster.doCast(sk);
                    return true;
                }
            }
        }
        if (!this.canAura(sk)) {
            if (GeoData.getInstance().canSeeTarget((L2Object)caster, attackTarget) && !attackTarget.isDead() && dist2 <= srange) {
                this.clientStopMoving(null);
                caster.doCast(sk);
                return true;
            }
            L2Character target6 = this.skillTargetReconsider(sk);
            if (target6 != null) {
                this.clientStopMoving(null);
                L2Character targets = attackTarget;
                caster.setTarget(target6);
                caster.doCast(sk);
                caster.setTarget(targets);
                return true;
            }
        } else {
            this.clientStopMoving(null);
            caster.doCast(sk);
            return true;
        }
        return false;
    }

    private void movementDisable() {
        L2Attackable npc = this.getActiveChar();
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        try {
            if (npc.getTarget() == null) {
                npc.setTarget(this.getAttackTarget());
            }
            dist = npc.calculateDistance(this.getAttackTarget(), false, false);
            dist2 = dist - (double)npc.getTemplate().getCollisionRadius();
            range = npc.getPhysicalAttackRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
            if (this.getAttackTarget().isMoving()) {
                dist -= 30.0;
                if (npc.isMoving()) {
                    dist -= 50.0;
                }
            }
            if (!this._skillrender.getAISkills(AISkillScope.GENERAL).isEmpty()) {
                int random = Rnd.get(100);
                if (!this.getAttackTarget().isImmobilized() && random < 2) {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.IMMOBILIZE)) {
                        if (!this.checkSkillCastConditions(sk) || (double)(sk.getCastRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius()) <= dist2 && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (random < 5) {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.COT)) {
                        if (!this.checkSkillCastConditions(sk) || (double)(sk.getCastRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius()) <= dist2 && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (random < 8) {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.DEBUFF)) {
                        if (!this.checkSkillCastConditions(sk) || (double)(sk.getCastRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius()) <= dist2 && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (random < 9) {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.NEGATIVE)) {
                        if (!this.checkSkillCastConditions(sk) || (double)(sk.getCastRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius()) <= dist2 && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget()) || this.getAttackTarget().getEffectList().getFirstEffect(L2EffectType.BUFF) == null) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
                if (npc.isMovementDisabled() || npc.getAiType() == AIType.MAGE || npc.getAiType() == AIType.HEALER) {
                    for (Skill sk : this._skillrender.getAISkills(AISkillScope.ATTACK)) {
                        if (!this.checkSkillCastConditions(sk) || (double)(sk.getCastRange() + npc.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius()) <= dist2 && !this.canAura(sk) || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget())) continue;
                        this.clientStopMoving(null);
                        npc.doCast(sk);
                        return;
                    }
                }
            }
            if (npc.isMovementDisabled()) {
                this.targetReconsider();
                return;
            }
            if (dist > (double)range || !GeoData.getInstance().canSeeTarget((L2Object)npc, this.getAttackTarget())) {
                if (this.getAttackTarget().isMoving()) {
                    range -= 100;
                }
                if (range < 5) {
                    range = 5;
                }
                this.moveToPawn(this.getAttackTarget(), range);
                return;
            }
            this.melee(npc.getPrimarySkillId());
        }
        catch (NullPointerException e) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            this._log.warning(this.getClass().getSimpleName() + ": " + this + " - failed executing movementDisable(): " + e.getMessage());
            return;
        }
    }

    private boolean checkSkillCastConditions(Skill skill) {
        if ((double)skill.getMpConsume() >= this.getActiveChar().getCurrentMp()) {
            return false;
        }
        if (this.getActiveChar().isSkillDisabled(skill)) {
            return false;
        }
        return skill.isStatic() || (!skill.isMagic() || !this.getActiveChar().isMuted()) && !this.getActiveChar().isPhysicalMuted();
    }

    private L2Character effectTargetReconsider(Skill sk, boolean positive) {
        block19: {
            L2Attackable actor;
            block17: {
                block18: {
                    if (sk == null) {
                        return null;
                    }
                    actor = this.getActiveChar();
                    if (sk.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) break block17;
                    if (positive) break block18;
                    double dist = 0.0;
                    double dist2 = 0.0;
                    int range = 0;
                    for (L2Character obj : actor.getAttackByList()) {
                        block13: {
                            if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj == this.getAttackTarget()) continue;
                            try {
                                actor.setTarget(this.getAttackTarget());
                                dist = actor.calculateDistance(obj, false, false);
                                dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                                range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                                if (!obj.isMoving()) break block13;
                                dist2 -= 70.0;
                            }
                            catch (NullPointerException e) {
                                continue;
                            }
                        }
                        if (!(dist2 <= (double)range) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                        return obj;
                    }
                    for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                        block14: {
                            if (obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                            try {
                                actor.setTarget(this.getAttackTarget());
                                dist2 = dist = actor.calculateDistance(obj, false, false);
                                range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                                if (!obj.isMoving()) break block14;
                                dist2 -= 70.0;
                            }
                            catch (NullPointerException e) {
                                continue;
                            }
                        }
                        if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().isAffectedBySkill(sk.getId())) continue;
                        return obj;
                    }
                    break block19;
                }
                if (!positive) break block19;
                double dist = 0.0;
                double dist2 = 0.0;
                int range = 0;
                for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                    block15: {
                        L2Attackable targets;
                        if (!(obj instanceof L2Attackable) || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || (targets = (L2Attackable)obj).isInMyClan(actor)) continue;
                        try {
                            actor.setTarget(this.getAttackTarget());
                            dist = actor.calculateDistance(obj, false, false);
                            dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                            range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                            if (!obj.isMoving()) break block15;
                            dist2 -= 70.0;
                        }
                        catch (NullPointerException e) {
                            continue;
                        }
                    }
                    if (!(dist2 <= (double)range) || obj.isAffectedBySkill(sk.getId())) continue;
                    return obj;
                }
                break block19;
            }
            double dist = 0.0;
            double dist2 = 0.0;
            int range = 0;
            range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
            for (L2Character obj : actor.getKnownList().getKnownCharactersInRadius(range)) {
                block16: {
                    if (obj == null || obj.isDead() || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj)) continue;
                    try {
                        actor.setTarget(this.getAttackTarget());
                        dist = actor.calculateDistance(obj, false, false);
                        dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                        range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                        if (!obj.isMoving()) break block16;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(obj instanceof L2PcInstance) && !(obj instanceof L2Summon) || !(dist2 <= (double)range) || this.getAttackTarget().getEffectList().getFirstEffect(L2EffectType.BUFF) == null) continue;
                return obj;
            }
        }
        return null;
    }

    private L2Character skillTargetReconsider(Skill sk) {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = this.getActiveChar();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead()) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist = actor.calculateDistance(obj, false, false);
                    dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                    range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (!(dist2 <= (double)range)) continue;
                return obj;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                try {
                    actor.setTarget(this.getAttackTarget());
                    dist2 = dist = actor.calculateDistance(target, false, false);
                    range = sk.getCastRange() + actor.getTemplate().getCollisionRadius() + this.getAttackTarget().getTemplate().getCollisionRadius();
                }
                catch (NullPointerException e) {
                    continue;
                }
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || dist2 > (double)range) continue;
                if (obj instanceof L2PcInstance) {
                    return obj;
                }
                if (obj instanceof L2Attackable && actor.isChaos()) {
                    if (((L2Attackable)obj).isInMyClan(actor)) continue;
                    return obj;
                }
                if (!(obj instanceof L2Summon)) continue;
                return obj;
            }
        }
        return null;
    }

    private void targetReconsider() {
        double dist = 0.0;
        double dist2 = 0.0;
        int range = 0;
        L2Attackable actor = this.getActiveChar();
        L2Character MostHate = actor.getMostHated();
        if (actor.getHateList() != null) {
            for (L2Character obj : actor.getHateList()) {
                block17: {
                    if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor) continue;
                    try {
                        dist = actor.calculateDistance(obj, false, false);
                        dist2 = dist - (double)actor.getTemplate().getCollisionRadius();
                        range = actor.getPhysicalAttackRange() + actor.getTemplate().getCollisionRadius() + obj.getTemplate().getCollisionRadius();
                        if (!obj.isMoving()) break block17;
                        dist2 -= 70.0;
                    }
                    catch (NullPointerException e) {
                        continue;
                    }
                }
                if (!(dist2 <= (double)range)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj = null;
                if (target instanceof L2Character) {
                    obj = (L2Character)target;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor || obj == this.getAttackTarget()) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (!actor.isChaos() || ((L2Attackable)obj).isInMyClan(actor)) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private void aggroReconsider() {
        L2Attackable actor = this.getActiveChar();
        L2Character MostHate = actor.getMostHated();
        if (actor.getHateList() != null) {
            int rand = Rnd.get(actor.getHateList().size());
            int count = 0;
            for (L2Character obj : actor.getHateList()) {
                if (count < rand) {
                    ++count;
                    continue;
                }
                if (obj == null || !GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj == this.getAttackTarget() || obj == actor) continue;
                try {
                    actor.setTarget(this.getAttackTarget());
                }
                catch (NullPointerException e) {
                    continue;
                }
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
                return;
            }
        }
        if (!(actor instanceof L2GuardInstance)) {
            Collection objs = actor.getKnownList().getKnownObjects().values();
            for (L2Object target : objs) {
                L2Character obj;
                obj = null;
                if (!(target instanceof L2Character)) continue;
                obj = (L2Character)target;
                if (!GeoData.getInstance().canSeeTarget((L2Object)actor, obj) || obj.isDead() || obj != MostHate || obj == actor) continue;
                if (obj instanceof L2PcInstance) {
                    if (MostHate != null && !MostHate.isDead()) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (obj instanceof L2Attackable) {
                    if (!actor.isChaos() || ((L2Attackable)obj).isInMyClan(actor)) continue;
                    if (MostHate != null) {
                        actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                    } else {
                        actor.addDamageHate(obj, 0, 2000);
                    }
                    actor.setTarget(obj);
                    this.setAttackTarget(obj);
                    continue;
                }
                if (!(obj instanceof L2Summon)) continue;
                if (MostHate != null) {
                    actor.addDamageHate(obj, 0, actor.getHating(MostHate));
                } else {
                    actor.addDamageHate(obj, 0, 2000);
                }
                actor.setTarget(obj);
                this.setAttackTarget(obj);
            }
        }
    }

    private List<Skill> longRangeSkillRender() {
        List<Skill> longRangeSkills = this._skillrender.getAISkills(AISkillScope.LONG_RANGE);
        if (longRangeSkills.isEmpty()) {
            longRangeSkills = this.getActiveChar().getLongRangeSkill();
        }
        return longRangeSkills;
    }

    private List<Skill> shortRangeSkillRender() {
        List<Skill> shortRangeSkills = this._skillrender.getAISkills(AISkillScope.SHORT_RANGE);
        if (shortRangeSkills.isEmpty()) {
            shortRangeSkills = this.getActiveChar().getShortRangeSkill();
        }
        return shortRangeSkills;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void onEvtThink() {
        if (this._thinking) return;
        if (this.getActiveChar().isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            switch (this.getIntention()) {
                case AI_INTENTION_ACTIVE: {
                    this.thinkActive();
                    return;
                }
                case AI_INTENTION_ATTACK: {
                    this.thinkAttack();
                    return;
                }
                case AI_INTENTION_CAST: {
                    this.thinkCast();
                    return;
                }
            }
            return;
        }
        catch (Exception e) {
            this._log.warning(this.getClass().getSimpleName() + ": " + this + " -  onEvtThink() failed: " + e.getMessage());
            return;
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        L2Attackable me = this.getActiveChar();
        this._attackTimeout = 1200 + GameTimeController.getInstance().getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        me.addDamageHate(attacker, 0, 1);
        if (!me.isRunning()) {
            me.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        } else if (me.getMostHated() != this.getAttackTarget()) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker);
        }
        if (me instanceof L2MonsterInstance) {
            L2MonsterInstance master = (L2MonsterInstance)me;
            if (master.hasMinions()) {
                master.getMinionList().onAssist(me, attacker);
            }
            if ((master = master.getLeader()) != null && master.hasMinions()) {
                master.getMinionList().onAssist(me, attacker);
            }
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
        L2Attackable me = this.getActiveChar();
        if (me.isDead()) {
            return;
        }
        if (target != null) {
            me.addDamageHate(target, 0, aggro);
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                if (!me.isRunning()) {
                    me.setRunning();
                }
                this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target);
            }
            if (me instanceof L2MonsterInstance) {
                L2MonsterInstance master = (L2MonsterInstance)me;
                if (master.hasMinions()) {
                    master.getMinionList().onAssist(me, target);
                }
                if ((master = master.getLeader()) != null && master.hasMinions()) {
                    master.getMinionList().onAssist(me, target);
                }
            }
        }
    }

    @Override
    protected void onIntentionActive() {
        this._attackTimeout = Integer.MAX_VALUE;
        super.onIntentionActive();
    }

    public void setGlobalAggro(int value) {
        this._globalAggro = value;
    }

    public void setTimepass(int TP) {
        this.timepass = TP;
    }

    public int getTimepass() {
        return this.timepass;
    }

    public L2Attackable getActiveChar() {
        return (L2Attackable)this._actor;
    }
}

