/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.AbstractAI;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2PlayerAI;
import com.l2jserver.gameserver.ai.L2SummonAI;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.instancemanager.WalkingManager;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.Location;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.actor.templates.L2NpcTemplate;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.events.EventType;
import com.l2jserver.gameserver.model.events.listeners.AbstractEventListener;
import com.l2jserver.gameserver.model.interfaces.ILocational;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.items.type.WeaponType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.model.skills.targets.L2TargetType;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ActionFailed;
import com.l2jserver.gameserver.network.serverpackets.AutoAttackStop;
import com.l2jserver.gameserver.taskmanager.AttackStanceTaskManager;
import com.l2jserver.util.Rnd;
import java.util.List;
import java.util.Queue;
import javolution.util.FastList;

public class L2CharacterAI
extends AbstractAI {
    public L2CharacterAI(L2Character.AIAccessor accessor) {
        super(accessor);
    }

    public IntentionCommand getNextIntention() {
        return null;
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        if (attacker instanceof L2Attackable && !((L2Attackable)attacker).isCoreAIDisabled()) {
            this.clientStartAutoAttack();
        }
    }

    @Override
    protected void onIntentionIdle() {
        this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
        this.clientStopMoving(null);
        this.clientStopAutoAttack();
    }

    @Override
    protected void onIntentionActive() {
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ACTIVE) {
            this.changeIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this.setCastTarget(null);
            this.setAttackTarget(null);
            this.clientStopMoving(null);
            this.clientStopAutoAttack();
            if (this._actor instanceof L2Attackable) {
                ((L2Npc)this._actor).startRandomAnimationTimer();
            }
            this.onEvtThink();
        }
    }

    @Override
    protected void onIntentionRest() {
        this.setIntention(CtrlIntention.AI_INTENTION_IDLE);
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        if (target == null) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow() || this._actor.isAfraid()) {
            this.clientActionFailed();
            return;
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
            if (this.getAttackTarget() != target) {
                this.setAttackTarget(target);
                this.stopFollow();
                this.notifyEvent(CtrlEvent.EVT_THINK, null);
            } else {
                this.clientActionFailed();
            }
        } else {
            this.changeIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
            this.setAttackTarget(target);
            this.stopFollow();
            this.notifyEvent(CtrlEvent.EVT_THINK, null);
        }
    }

    @Override
    protected void onIntentionCast(Skill skill, L2Object target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST && skill.isMagic()) {
            this.clientActionFailed();
            this._actor.setIsCastingNow(false);
            return;
        }
        if (this._actor.getBowAttackEndTime() > GameTimeController.getInstance().getGameTicks()) {
            ThreadPoolManager.getInstance().scheduleGeneral(new CastTask(this._actor, skill, target), (this._actor.getBowAttackEndTime() - GameTimeController.getInstance().getGameTicks()) * 100);
        } else {
            this.changeIntentionToCast(skill, target);
        }
    }

    protected void changeIntentionToCast(Skill skill, L2Object target) {
        this.setCastTarget((L2Character)target);
        this._skill = skill;
        this.changeIntention(CtrlIntention.AI_INTENTION_CAST, skill, target);
        this.notifyEvent(CtrlEvent.EVT_THINK, null);
    }

    @Override
    protected void onIntentionMoveTo(Location loc) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_MOVE_TO, loc, null);
        this.clientStopAutoAttack();
        this._actor.abortAttack();
        this.moveTo(loc.getX(), loc.getY(), loc.getZ());
    }

    @Override
    protected void onIntentionFollow(L2Character target) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isMovementDisabled()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isDead()) {
            this.clientActionFailed();
            return;
        }
        if (this._actor == target) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        this.changeIntention(CtrlIntention.AI_INTENTION_FOLLOW, target, null);
        this.startFollow(target);
    }

    @Override
    protected void onIntentionPickUp(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        if (object instanceof L2ItemInstance && ((L2ItemInstance)object).getItemLocation() != ItemLocation.VOID) {
            return;
        }
        this.changeIntention(CtrlIntention.AI_INTENTION_PICK_UP, object, null);
        this.setTarget(object);
        if (object.getX() == 0 && object.getY() == 0) {
            this._log.warning("Object in coords 0,0 - using a temporary fix");
            object.setXYZ(this.getActor().getX(), this.getActor().getY(), this.getActor().getZ() + 5);
        }
        this.moveToPawn(object, 20);
    }

    @Override
    protected void onIntentionInteract(L2Object object) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_REST) {
            this.clientActionFailed();
            return;
        }
        if (this._actor.isAllSkillsDisabled() || this._actor.isCastingNow()) {
            this.clientActionFailed();
            return;
        }
        this.clientStopAutoAttack();
        if (this.getIntention() != CtrlIntention.AI_INTENTION_INTERACT) {
            this.changeIntention(CtrlIntention.AI_INTENTION_INTERACT, object, null);
            this.setTarget(object);
            this.moveToPawn(object, 60);
        }
    }

    @Override
    protected void onEvtThink() {
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
    }

    @Override
    protected void onEvtStunned(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtParalyzed(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtSleeping(L2Character attacker) {
        this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        if (AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            AttackStanceTaskManager.getInstance().removeAttackStanceTask(this._actor);
        }
        this.setAutoAttacking(false);
        this.clientStopMoving(null);
    }

    @Override
    protected void onEvtRooted(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtConfused(L2Character attacker) {
        this.clientStopMoving(null);
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtMuted(L2Character attacker) {
        this.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtEvaded(L2Character attacker) {
    }

    @Override
    protected void onEvtReadyToAct() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtUserCmd(Object arg0, Object arg1) {
    }

    @Override
    protected void onEvtArrived() {
        this._accessor.getActor().revalidateZone(true);
        if (this._accessor.getActor().moveToNextRoutePoint()) {
            return;
        }
        if (this._accessor.getActor() instanceof L2Attackable) {
            ((L2Attackable)this._accessor.getActor()).setisReturningToSpawnPoint(false);
        }
        this.clientStoppedMoving();
        if (this._actor instanceof L2Npc) {
            boolean override = false;
            L2Npc npc = (L2Npc)this._actor;
            override |= WalkingManager.getInstance().onArrived(npc);
            Queue<AbstractEventListener> eventQuests = npc.getTemplate().getListeners(EventType.ON_NPC_MOVE_FINISHED);
            if (eventQuests != null) {
                for (AbstractEventListener quest : eventQuests) {
                    override |= quest.getQuest().notifyMoveFinished(npc);
                }
            }
            if (override) {
                return;
            }
        }
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.onEvtThink();
    }

    @Override
    protected void onEvtArrivedRevalidate() {
        this.onEvtThink();
    }

    @Override
    protected void onEvtArrivedBlocked(Location blocked_at_loc) {
        if (this.getIntention() == CtrlIntention.AI_INTENTION_MOVE_TO || this.getIntention() == CtrlIntention.AI_INTENTION_CAST) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        this.clientStopMoving(blocked_at_loc);
        this.onEvtThink();
    }

    @Override
    protected void onEvtForgetObject(L2Object object) {
        if (this.getTarget() == object) {
            this.setTarget(null);
            if (this.getIntention() == CtrlIntention.AI_INTENTION_INTERACT || this.getIntention() == CtrlIntention.AI_INTENTION_PICK_UP) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            }
        }
        if (this.getAttackTarget() == object) {
            this.setAttackTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getCastTarget() == object) {
            this.setCastTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this.getFollowTarget() == object) {
            this.clientStopMoving(null);
            this.stopFollow();
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
        }
        if (this._actor == object) {
            this.setTarget(null);
            this.setAttackTarget(null);
            this.setCastTarget(null);
            this.stopFollow();
            this.clientStopMoving(null);
            this.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
        }
    }

    @Override
    protected void onEvtCancel() {
        this._actor.abortCast();
        this.stopFollow();
        if (!AttackStanceTaskManager.getInstance().hasAttackStanceTask(this._actor)) {
            this._actor.broadcastPacket(new AutoAttackStop(this._actor.getObjectId()));
        }
        this.onEvtThink();
    }

    @Override
    protected void onEvtDead() {
        this.stopAITask();
        this.clientNotifyDead();
        if (!(this._actor instanceof L2Playable)) {
            this._actor.setWalking();
        }
    }

    @Override
    protected void onEvtFakeDeath() {
        this.stopFollow();
        this.clientStopMoving(null);
        this._intention = CtrlIntention.AI_INTENTION_IDLE;
        this.setTarget(null);
        this.setCastTarget(null);
        this.setAttackTarget(null);
    }

    @Override
    protected void onEvtFinishCasting() {
    }

    protected boolean maybeMoveToPosition(ILocational worldPosition, int offset) {
        if (worldPosition == null) {
            this._log.warning("maybeMoveToPosition: worldPosition == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        if (!this._actor.isInsideRadius(worldPosition, offset + this._actor.getTemplate().getCollisionRadius(), false, false)) {
            if (this._actor.isMovementDisabled()) {
                return true;
            }
            if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
                this._actor.setRunning();
            }
            this.stopFollow();
            int x = this._actor.getX();
            int y = this._actor.getY();
            double dx = worldPosition.getX() - x;
            double dy = worldPosition.getY() - y;
            double dist = Math.sqrt(dx * dx + dy * dy);
            double sin = dy / dist;
            double cos = dx / dist;
            this.moveTo(x += (int)((dist -= (double)(offset - 5)) * cos), y += (int)(dist * sin), worldPosition.getZ());
            return true;
        }
        if (this.getFollowTarget() != null) {
            this.stopFollow();
        }
        return false;
    }

    protected boolean maybeMoveToPawn(L2Object target, int offset) {
        if (target == null) {
            this._log.warning("maybeMoveToPawn: target == NULL!");
            return false;
        }
        if (offset < 0) {
            return false;
        }
        offset += this._actor.getTemplate().getCollisionRadius();
        if (target instanceof L2Character) {
            offset += ((L2Character)target).getTemplate().getCollisionRadius();
        }
        if (!this._actor.isInsideRadius(target, offset, false, false)) {
            if (this.getFollowTarget() != null) {
                if (!this._actor.isInsideRadius(target, offset + 100, false, false)) {
                    return true;
                }
                this.stopFollow();
                return false;
            }
            if (this._actor.isMovementDisabled()) {
                if (this._actor.getAI().getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                    this._actor.getAI().setIntention(CtrlIntention.AI_INTENTION_IDLE);
                }
                return true;
            }
            if (this._actor.getAI().getIntention() == CtrlIntention.AI_INTENTION_CAST && this._actor instanceof L2PcInstance && ((L2PcInstance)this._actor).isTransformed() && !((L2PcInstance)this._actor).getTransformation().isCombat()) {
                this._actor.sendPacket(SystemMessageId.DIST_TOO_FAR_CASTING_STOPPED);
                this._actor.sendPacket(ActionFailed.STATIC_PACKET);
                return true;
            }
            if (!(this._actor.isRunning() || this instanceof L2PlayerAI || this instanceof L2SummonAI)) {
                this._actor.setRunning();
            }
            this.stopFollow();
            if (target instanceof L2Character && !(target instanceof L2DoorInstance)) {
                if (((L2Character)target).isMoving()) {
                    offset -= 100;
                }
                if (offset < 5) {
                    offset = 5;
                }
                this.startFollow((L2Character)target, offset);
            } else {
                this.moveToPawn(target, offset);
            }
            return true;
        }
        if (this.getFollowTarget() != null) {
            this.stopFollow();
        }
        return false;
    }

    protected boolean checkTargetLostOrDead(L2Character target) {
        if (target == null || target.isAlikeDead()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isFakeDeath()) {
                target.stopFakeDeath(true);
                return false;
            }
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    protected boolean checkTargetLost(L2Object target) {
        L2PcInstance target2;
        if (target instanceof L2PcInstance && (target2 = (L2PcInstance)target).isFakeDeath()) {
            target2.stopFakeDeath(true);
            return false;
        }
        if (target == null) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        if (this._actor != null && this._skill != null && this._skill.isBad() && this._skill.getAffectRange() > 0 && Config.GEODATA > 0 && !GeoData.getInstance().canSeeTarget((L2Object)this._actor, target)) {
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE);
            return true;
        }
        return false;
    }

    public boolean canAura(Skill sk) {
        if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA || sk.getTargetType() == L2TargetType.AURA_CORPSE_MOB) {
            for (L2Object l2Object : this._actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                if (l2Object != this.getAttackTarget()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canAOE(Skill sk) {
        if (sk.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) {
            if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA || sk.getTargetType() == L2TargetType.AURA_CORPSE_MOB) {
                boolean cancast = true;
                for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                    L2Npc actors;
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || target instanceof L2Attackable && !(actors = (L2Npc)this._actor).isChaos() || !target.isAffectedBySkill(sk.getId())) continue;
                    cancast = false;
                }
                if (cancast) {
                    return true;
                }
            } else if (sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) {
                boolean cancast = true;
                for (L2Character target : this.getAttackTarget().getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                    L2Npc actors;
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || target == null || target instanceof L2Attackable && !(actors = (L2Npc)this._actor).isChaos() || target.getEffectList().isEmpty()) continue;
                    cancast = true;
                }
                if (cancast) {
                    return true;
                }
            }
        } else if (sk.getTargetType() == L2TargetType.AURA || sk.getTargetType() == L2TargetType.BEHIND_AURA || sk.getTargetType() == L2TargetType.FRONT_AURA || sk.getTargetType() == L2TargetType.AURA_CORPSE_MOB) {
            boolean cancast = false;
            for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                L2Npc actors;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || target instanceof L2Attackable && !(actors = (L2Npc)this._actor).isChaos() || target.getEffectList().isEmpty()) continue;
                cancast = true;
            }
            if (cancast) {
                return true;
            }
        } else if (sk.getTargetType() == L2TargetType.AREA || sk.getTargetType() == L2TargetType.BEHIND_AREA || sk.getTargetType() == L2TargetType.FRONT_AREA) {
            boolean cancast = true;
            for (L2Character target : this.getAttackTarget().getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                L2Npc actors;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || target instanceof L2Attackable && !(actors = (L2Npc)this._actor).isChaos() || !target.isAffectedBySkill(sk.getId())) continue;
                cancast = false;
            }
            if (cancast) {
                return true;
            }
        }
        return false;
    }

    public boolean canParty(Skill sk) {
        if (sk.getTargetType() == L2TargetType.PARTY) {
            int count = 0;
            int ccount = 0;
            for (L2Character target : this._actor.getKnownList().getKnownCharactersInRadius(sk.getAffectRange())) {
                L2Npc actors;
                L2Npc targets;
                if (!(target instanceof L2Attackable) || !GeoData.getInstance().canSeeTarget((L2Object)this._actor, target) || !(targets = (L2Npc)target).isInMyClan(actors = (L2Npc)this._actor)) continue;
                ++count;
                if (!target.isAffectedBySkill(sk.getId())) continue;
                ++ccount;
            }
            if (ccount < count) {
                return true;
            }
        }
        return false;
    }

    public boolean isParty(Skill sk) {
        return sk.getTargetType() == L2TargetType.PARTY;
    }

    protected class TargetAnalysis {
        public L2Character character;
        public boolean isMage;
        public boolean isBalanced;
        public boolean isArcher;
        public boolean isFighter;
        public boolean isCanceled;
        public boolean isSlower;
        public boolean isMagicResistant;

        public void update(L2Character target) {
            if (target == this.character && Rnd.nextInt(100) > 25) {
                return;
            }
            this.character = target;
            if (target == null) {
                return;
            }
            this.isMage = false;
            this.isBalanced = false;
            this.isArcher = false;
            this.isFighter = false;
            this.isCanceled = false;
            if ((double)target.getMAtk(null, null) > 1.5 * (double)target.getPAtk(null)) {
                this.isMage = true;
            } else if ((double)target.getPAtk(null) * 0.8 < (double)target.getMAtk(null, null) || (double)target.getMAtk(null, null) * 0.8 > (double)target.getPAtk(null)) {
                this.isBalanced = true;
            } else {
                L2Weapon weapon = target.getActiveWeaponItem();
                if (weapon != null && (weapon.getItemType() == WeaponType.BOW || weapon.getItemType() == WeaponType.CROSSBOW)) {
                    this.isArcher = true;
                } else {
                    this.isFighter = true;
                }
            }
            this.isSlower = target.getRunSpeed() < L2CharacterAI.this._actor.getRunSpeed() - 3.0;
            this.isMagicResistant = (double)target.getMDef(null, null) * 1.2 > (double)L2CharacterAI.this._actor.getMAtk(null, null);
            if (target.getBuffCount() < 4) {
                this.isCanceled = true;
            }
        }
    }

    protected class SelfAnalysis {
        public boolean isMage = false;
        public boolean isBalanced;
        public boolean isArcher = false;
        public boolean isHealer = false;
        public boolean isFighter = false;
        public boolean cannotMoveOnLand = false;
        public List<Skill> generalSkills = new FastList();
        public List<Skill> buffSkills = new FastList();
        public int lastBuffTick = 0;
        public List<Skill> debuffSkills = new FastList();
        public int lastDebuffTick = 0;
        public List<Skill> cancelSkills = new FastList();
        public List<Skill> healSkills = new FastList();
        public List<Skill> generalDisablers = new FastList();
        public List<Skill> sleepSkills = new FastList();
        public List<Skill> rootSkills = new FastList();
        public List<Skill> muteSkills = new FastList();
        public List<Skill> resurrectSkills = new FastList();
        public boolean hasHealOrResurrect = false;
        public boolean hasLongRangeSkills = false;
        public boolean hasLongRangeDamageSkills = false;
        public int maxCastRange = 0;

        public void init() {
            switch (((L2NpcTemplate)L2CharacterAI.this._actor.getTemplate()).getAIType()) {
                case FIGHTER: {
                    this.isFighter = true;
                    break;
                }
                case MAGE: {
                    this.isMage = true;
                    break;
                }
                case CORPSE: 
                case BALANCED: {
                    this.isBalanced = true;
                    break;
                }
                case ARCHER: {
                    this.isArcher = true;
                    break;
                }
                case HEALER: {
                    this.isHealer = true;
                    break;
                }
                default: {
                    this.isFighter = true;
                }
            }
            if (L2CharacterAI.this._actor.isNpc()) {
                switch (L2CharacterAI.this._actor.getId()) {
                    case 20314: 
                    case 20849: {
                        this.cannotMoveOnLand = true;
                        break;
                    }
                    default: {
                        this.cannotMoveOnLand = false;
                    }
                }
            }
            for (Skill sk : L2CharacterAI.this._actor.getAllSkills()) {
                if (sk.isPassive()) continue;
                int castRange = sk.getCastRange();
                boolean hasLongRangeDamageSkill = false;
                if (sk.isContinuous()) {
                    if (!sk.isDebuff()) {
                        this.buffSkills.add(sk);
                        continue;
                    }
                    this.debuffSkills.add(sk);
                    continue;
                }
                if (sk.hasEffectType(L2EffectType.DISPEL, L2EffectType.DISPEL_BY_SLOT)) {
                    this.cancelSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.HEAL)) {
                    this.healSkills.add(sk);
                    this.hasHealOrResurrect = true;
                } else if (sk.hasEffectType(L2EffectType.SLEEP)) {
                    this.sleepSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.STUN, L2EffectType.PARALYZE)) {
                    switch (sk.getId()) {
                        case 367: 
                        case 4111: 
                        case 4383: 
                        case 4578: 
                        case 4616: {
                            this.sleepSkills.add(sk);
                            break;
                        }
                        default: {
                            this.generalDisablers.add(sk);
                            break;
                        }
                    }
                } else if (sk.hasEffectType(L2EffectType.ROOT)) {
                    this.rootSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.FEAR)) {
                    this.debuffSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.MUTE)) {
                    this.muteSkills.add(sk);
                } else if (sk.hasEffectType(L2EffectType.RESURRECTION)) {
                    this.resurrectSkills.add(sk);
                    this.hasHealOrResurrect = true;
                } else {
                    this.generalSkills.add(sk);
                    hasLongRangeDamageSkill = true;
                }
                if (castRange > 70) {
                    this.hasLongRangeSkills = true;
                    if (hasLongRangeDamageSkill) {
                        this.hasLongRangeDamageSkills = true;
                    }
                }
                if (castRange <= this.maxCastRange) continue;
                this.maxCastRange = castRange;
            }
            if (!this.hasLongRangeDamageSkills && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
                this.isFighter = false;
            }
            if (!this.hasLongRangeSkills && (this.isMage || this.isBalanced)) {
                this.isBalanced = false;
                this.isMage = false;
                this.isFighter = true;
            }
            if (this.generalSkills.isEmpty() && this.isMage) {
                this.isBalanced = true;
                this.isMage = false;
            }
        }
    }

    public static class CastTask
    implements Runnable {
        private final L2Character _activeChar;
        private final L2Object _target;
        private final Skill _skill;

        public CastTask(L2Character actor, Skill skill, L2Object target) {
            this._activeChar = actor;
            this._target = target;
            this._skill = skill;
        }

        @Override
        public void run() {
            if (this._activeChar.isAttackingNow()) {
                this._activeChar.abortAttack();
            }
            this._activeChar.getAI().changeIntentionToCast(this._skill, this._target);
        }
    }

    public static class IntentionCommand {
        protected final CtrlIntention _crtlIntention;
        protected final Object _arg0;
        protected final Object _arg1;

        protected IntentionCommand(CtrlIntention pIntention, Object pArg0, Object pArg1) {
            this._crtlIntention = pIntention;
            this._arg0 = pArg0;
            this._arg1 = pArg1;
        }

        public CtrlIntention getCtrlIntention() {
            return this._crtlIntention;
        }
    }
}

