/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.ai;

import com.l2jserver.Config;
import com.l2jserver.gameserver.GameTimeController;
import com.l2jserver.gameserver.GeoData;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.ai.CtrlEvent;
import com.l2jserver.gameserver.ai.CtrlIntention;
import com.l2jserver.gameserver.ai.L2CharacterAI;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.L2Character;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.L2Playable;
import com.l2jserver.gameserver.model.actor.L2Summon;
import com.l2jserver.gameserver.model.actor.instance.L2DefenderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2DoorInstance;
import com.l2jserver.gameserver.model.actor.instance.L2FortCommanderInstance;
import com.l2jserver.gameserver.model.actor.instance.L2NpcInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.effects.L2EffectType;
import com.l2jserver.gameserver.model.skills.Skill;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.Rnd;
import java.util.Collection;
import java.util.concurrent.Future;

public class L2FortSiegeGuardAI
extends L2CharacterAI
implements Runnable {
    private static final int MAX_ATTACK_TIMEOUT = 300;
    private Future<?> _aiTask;
    private final L2CharacterAI.SelfAnalysis _selfAnalysis = new L2CharacterAI.SelfAnalysis();
    private int _attackTimeout;
    private int _globalAggro;
    private boolean _thinking;
    private final int _attackRange;

    public L2FortSiegeGuardAI(L2Character.AIAccessor accessor) {
        super(accessor);
        this._selfAnalysis.init();
        this._attackTimeout = Integer.MAX_VALUE;
        this._globalAggro = -10;
        this._attackRange = ((L2Attackable)this._actor).getPhysicalAttackRange();
    }

    @Override
    public void run() {
        this.onEvtThink();
    }

    private boolean autoAttackCondition(L2Character target) {
        L2PcInstance owner;
        if (target == null || target instanceof L2DefenderInstance || target instanceof L2NpcInstance || target instanceof L2DoorInstance || target.isAlikeDead() || target instanceof L2FortCommanderInstance || target instanceof L2Playable) {
            L2PcInstance player = null;
            if (target instanceof L2PcInstance) {
                player = (L2PcInstance)target;
            } else if (target instanceof L2Summon) {
                player = ((L2Summon)target).getOwner();
            }
            if (player == null || player.getClan() != null && player.getClan().getFortId() == ((L2Npc)this._actor).getFort().getResidenceId()) {
                return false;
            }
        }
        if (target != null && target.isInvul()) {
            if (target instanceof L2PcInstance && ((L2PcInstance)target).isGM()) {
                return false;
            }
            if (target instanceof L2Summon && ((L2Summon)target).getOwner().isGM()) {
                return false;
            }
        }
        if (target instanceof L2Summon && this._actor.isInsideRadius(owner = ((L2Summon)target).getOwner(), 1000, true, false)) {
            target = owner;
        }
        if (target instanceof L2Playable && ((L2Playable)target).isSilentMovingAffected() && !this._actor.isInsideRadius(target, 250, false, false)) {
            return false;
        }
        return this._actor.isAutoAttackable(target) && GeoData.getInstance().canSeeTarget((L2Object)this._actor, target);
    }

    @Override
    synchronized void changeIntention(CtrlIntention intention, Object arg0, Object arg1) {
        if (Config.DEBUG) {
            this._log.warning(this.getClass().getSimpleName() + ": changeIntention(" + (Object)((Object)intention) + ", " + arg0 + ", " + arg1 + ")");
        }
        if (intention == CtrlIntention.AI_INTENTION_IDLE) {
            if (!this._actor.isAlikeDead()) {
                L2Attackable npc = (L2Attackable)this._actor;
                intention = !npc.getKnownList().getKnownPlayers().isEmpty() ? CtrlIntention.AI_INTENTION_ACTIVE : CtrlIntention.AI_INTENTION_IDLE;
            }
            if (intention == CtrlIntention.AI_INTENTION_IDLE) {
                super.changeIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                if (this._aiTask != null) {
                    this._aiTask.cancel(true);
                    this._aiTask = null;
                }
                this._accessor.detachAI();
                return;
            }
        }
        super.changeIntention(intention, arg0, arg1);
        if (this._aiTask == null) {
            this._aiTask = ThreadPoolManager.getInstance().scheduleAiAtFixedRate(this, 1000L, 1000L);
        }
    }

    @Override
    protected void onIntentionAttack(L2Character target) {
        this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        super.onIntentionAttack(target);
    }

    private void thinkActive() {
        L2Attackable npc = (L2Attackable)this._actor;
        if (this._globalAggro != 0) {
            this._globalAggro = this._globalAggro < 0 ? ++this._globalAggro : --this._globalAggro;
        }
        if (this._globalAggro >= 0) {
            for (L2Character target : npc.getKnownList().getKnownCharactersInRadius(this._attackRange)) {
                int hating;
                if (target == null || !this.autoAttackCondition(target) || (hating = npc.getHating(target)) != 0) continue;
                npc.addDamageHate(target, 0, 1);
            }
            L2Character hated = this._actor.isConfused() ? this.getAttackTarget() : npc.getMostHated();
            if (hated != null) {
                int aggro = npc.getHating(hated);
                if (aggro + this._globalAggro > 0) {
                    if (!this._actor.isRunning()) {
                        this._actor.setRunning();
                    }
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, hated, null);
                }
                return;
            }
        }
        if (this._actor.getWalkSpeed() >= 0.0) {
            if (this._actor instanceof L2DefenderInstance) {
                ((L2DefenderInstance)this._actor).returnHome();
            } else {
                ((L2FortCommanderInstance)this._actor).returnHome();
            }
        }
    }

    private void thinkAttack() {
        L2Character attackTarget;
        if (Config.DEBUG) {
            this._log.warning(this.getClass().getSimpleName() + ": thinkAttack(); timeout=" + (this._attackTimeout - GameTimeController.getInstance().getGameTicks()));
        }
        if (this._attackTimeout < GameTimeController.getInstance().getGameTicks() && this._actor.isRunning()) {
            this._actor.setWalking();
            this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        }
        if ((attackTarget = this.getAttackTarget()) == null || attackTarget.isAlikeDead() || this._attackTimeout < GameTimeController.getInstance().getGameTicks()) {
            if (attackTarget != null) {
                L2Attackable npc = (L2Attackable)this._actor;
                npc.stopHating(attackTarget);
            }
            this._attackTimeout = Integer.MAX_VALUE;
            this.setAttackTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
            this._actor.setWalking();
            return;
        }
        this.factionNotifyAndSupport();
        this.attackPrepare();
    }

    private final void factionNotifyAndSupport() {
        L2Character target = this.getAttackTarget();
        if (((L2Npc)this._actor).getTemplate().getClans() == null || target == null) {
            return;
        }
        if (target.isInvul()) {
            return;
        }
        block0: for (L2Character cha : this._actor.getKnownList().getKnownCharactersInRadius(1000L)) {
            if (cha == null) continue;
            if (!(cha instanceof L2Npc)) {
                if (!this._selfAnalysis.hasHealOrResurrect || !(cha instanceof L2PcInstance) || !((L2Npc)this._actor).getFort().getSiege().checkIsDefender(((L2PcInstance)cha).getClan()) || this._actor.isAttackingDisabled() || !(cha.getCurrentHp() < (double)cha.getMaxHp() * 0.6) || !(this._actor.getCurrentHp() > (double)(this._actor.getMaxHp() / 2)) || !(this._actor.getCurrentMp() > (double)(this._actor.getMaxMp() / 2)) || !cha.isInCombat()) continue;
                for (Skill sk : this._selfAnalysis.healSkills) {
                    int chance;
                    if (this._actor.getCurrentMp() < (double)sk.getMpConsume() || this._actor.isSkillDisabled(sk) || !Util.checkIfInRange(sk.getCastRange(), this._actor, cha, true) || (chance = 5) >= Rnd.get(100)) continue;
                    if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, cha)) continue block0;
                    L2Object OldTarget = this._actor.getTarget();
                    this._actor.setTarget(cha);
                    this.clientStopMoving(null);
                    this._accessor.doCast(sk);
                    this._actor.setTarget(OldTarget);
                    return;
                }
                continue;
            }
            L2Npc npc = (L2Npc)cha;
            if (!npc.isInMyClan((L2Npc)this._actor) || npc.getAI() == null) continue;
            if (!npc.isDead() && Math.abs(target.getZ() - npc.getZ()) < 600 && (npc.getAI()._intention == CtrlIntention.AI_INTENTION_IDLE || npc.getAI()._intention == CtrlIntention.AI_INTENTION_ACTIVE) && target.isInsideRadius(npc, 1500, true, false) && GeoData.getInstance().canSeeTarget((L2Object)npc, target)) {
                npc.getAI().notifyEvent(CtrlEvent.EVT_AGGRESSION, this.getAttackTarget(), 1);
                return;
            }
            if (!this._selfAnalysis.hasHealOrResurrect || this._actor.isAttackingDisabled() || !(npc.getCurrentHp() < (double)npc.getMaxHp() * 0.6) || !(this._actor.getCurrentHp() > (double)(this._actor.getMaxHp() / 2)) || !(this._actor.getCurrentMp() > (double)(this._actor.getMaxMp() / 2)) || !npc.isInCombat()) continue;
            for (Skill sk : this._selfAnalysis.healSkills) {
                int chance;
                if (this._actor.getCurrentMp() < (double)sk.getMpConsume() || this._actor.isSkillDisabled(sk) || !Util.checkIfInRange(sk.getCastRange(), this._actor, npc, true) || (chance = 4) >= Rnd.get(100)) continue;
                if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, npc)) continue block0;
                L2Object OldTarget = this._actor.getTarget();
                this._actor.setTarget(npc);
                this.clientStopMoving(null);
                this._accessor.doCast(sk);
                this._actor.setTarget(OldTarget);
                return;
            }
        }
    }

    private void attackPrepare() {
        Collection<Skill> skills = null;
        double dist_2 = 0.0;
        int range = 0;
        L2DefenderInstance sGuard = this._actor instanceof L2FortCommanderInstance ? (L2FortCommanderInstance)this._actor : (L2DefenderInstance)this._actor;
        L2Character attackTarget = this.getAttackTarget();
        try {
            this._actor.setTarget(attackTarget);
            skills = this._actor.getAllSkills();
            dist_2 = this._actor.calculateDistance(attackTarget, false, true);
            range = this._actor.getPhysicalAttackRange() + this._actor.getTemplate().getCollisionRadius() + attackTarget.getTemplate().getCollisionRadius();
            if (attackTarget.isMoving()) {
                range += 50;
            }
        }
        catch (NullPointerException e) {
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (attackTarget instanceof L2PcInstance && sGuard.getFort().getSiege().checkIsDefender(((L2PcInstance)attackTarget).getClan())) {
            sGuard.stopHating(attackTarget);
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (!GeoData.getInstance().canSeeTarget((L2Object)this._actor, attackTarget)) {
            sGuard.stopHating(attackTarget);
            this._actor.setTarget(null);
            this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            return;
        }
        if (!this._actor.isMuted() && dist_2 > (double)(range * range)) {
            for (Skill sk : skills) {
                int castRange = sk.getCastRange();
                if (!(dist_2 <= (double)(castRange * castRange)) || castRange <= 70 || this._actor.isSkillDisabled(sk) || !(this._actor.getCurrentMp() >= (double)this._actor.getStat().getMpConsume(sk)) || sk.isPassive()) continue;
                L2Object OldTarget = this._actor.getTarget();
                if (sk.isContinuous() && !sk.isDebuff() || sk.hasEffectType(L2EffectType.HEAL)) {
                    boolean useSkillSelf = true;
                    if (sk.hasEffectType(L2EffectType.HEAL) && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                        useSkillSelf = false;
                        break;
                    }
                    if (sk.isContinuous() && !sk.isDebuff() && this._actor.isAffectedBySkill(sk.getId())) {
                        useSkillSelf = false;
                    }
                    if (useSkillSelf) {
                        this._actor.setTarget(this._actor);
                    }
                }
                this.clientStopMoving(null);
                this._accessor.doCast(sk);
                this._actor.setTarget(OldTarget);
                return;
            }
            if (!this._actor.isAttackingNow() && this._actor.getRunSpeed() == 0.0 && this._actor.getKnownList().knowsObject(attackTarget)) {
                this._actor.getKnownList().removeKnownObject(attackTarget);
                this._actor.setTarget(null);
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            } else {
                double dx = this._actor.getX() - attackTarget.getX();
                double dy = this._actor.getY() - attackTarget.getY();
                double dz = this._actor.getZ() - attackTarget.getZ();
                double homeX = attackTarget.getX() - sGuard.getSpawn().getX();
                double homeY = attackTarget.getY() - sGuard.getSpawn().getY();
                if (dx * dx + dy * dy > 10000.0 && homeX * homeX + homeY * homeY > 3240000.0 && this._actor.getKnownList().knowsObject(attackTarget)) {
                    this._actor.getKnownList().removeKnownObject(attackTarget);
                    this._actor.setTarget(null);
                    this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                } else if (dz * dz < 28900.0) {
                    if (this._selfAnalysis.isMage) {
                        range = this._selfAnalysis.maxCastRange - 50;
                    }
                    if (this._actor.getWalkSpeed() <= 0.0) {
                        return;
                    }
                    if (attackTarget.isMoving()) {
                        this.moveToPawn(attackTarget, range - 70);
                    } else {
                        this.moveToPawn(attackTarget, range);
                    }
                }
            }
            return;
        }
        if (this._actor.isMuted() && dist_2 > (double)(range * range)) {
            double dz = this._actor.getZ() - attackTarget.getZ();
            if (dz * dz < 28900.0) {
                if (this._selfAnalysis.isMage) {
                    range = this._selfAnalysis.maxCastRange - 50;
                }
                if (this._actor.getWalkSpeed() <= 0.0) {
                    return;
                }
                if (attackTarget.isMoving()) {
                    this.moveToPawn(attackTarget, range - 70);
                } else {
                    this.moveToPawn(attackTarget, range);
                }
            }
            return;
        }
        if (dist_2 <= (double)(range * range)) {
            L2Character hated = null;
            hated = this._actor.isConfused() ? attackTarget : ((L2Attackable)this._actor).getMostHated();
            if (hated == null) {
                this.setIntention(CtrlIntention.AI_INTENTION_ACTIVE, null, null);
                return;
            }
            if (hated != attackTarget) {
                attackTarget = hated;
            }
            this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
            if (!this._actor.isMuted() && Rnd.nextInt(100) <= 5) {
                for (Skill sk : skills) {
                    int castRange = sk.getCastRange();
                    if (!((double)(castRange * castRange) >= dist_2) || sk.isPassive() || !(this._actor.getCurrentMp() >= (double)this._actor.getStat().getMpConsume(sk)) || this._actor.isSkillDisabled(sk)) continue;
                    L2Object OldTarget = this._actor.getTarget();
                    if (sk.isContinuous() && !sk.isDebuff() || sk.hasEffectType(L2EffectType.HEAL)) {
                        boolean useSkillSelf = true;
                        if (sk.hasEffectType(L2EffectType.HEAL) && this._actor.getCurrentHp() > (double)((int)((double)this._actor.getMaxHp() / 1.5))) {
                            useSkillSelf = false;
                            break;
                        }
                        if (sk.isContinuous() && !sk.isDebuff() && this._actor.isAffectedBySkill(sk.getId())) {
                            useSkillSelf = false;
                        }
                        if (useSkillSelf) {
                            this._actor.setTarget(this._actor);
                        }
                    }
                    this.clientStopMoving(null);
                    this._accessor.doCast(sk);
                    this._actor.setTarget(OldTarget);
                    return;
                }
            }
            this._accessor.doAttack(attackTarget);
        }
    }

    @Override
    protected void onEvtThink() {
        if (this._thinking || this._actor.isCastingNow() || this._actor.isAllSkillsDisabled()) {
            return;
        }
        this._thinking = true;
        try {
            if (this.getIntention() == CtrlIntention.AI_INTENTION_ACTIVE) {
                this.thinkActive();
            } else if (this.getIntention() == CtrlIntention.AI_INTENTION_ATTACK) {
                this.thinkAttack();
            }
        }
        finally {
            this._thinking = false;
        }
    }

    @Override
    protected void onEvtAttacked(L2Character attacker) {
        this._attackTimeout = 300 + GameTimeController.getInstance().getGameTicks();
        if (this._globalAggro < 0) {
            this._globalAggro = 0;
        }
        ((L2Attackable)this._actor).addDamageHate(attacker, 0, 1);
        if (!this._actor.isRunning()) {
            this._actor.setRunning();
        }
        if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
            this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, attacker, null);
        }
        super.onEvtAttacked(attacker);
    }

    @Override
    protected void onEvtAggression(L2Character target, int aggro) {
        if (this._actor == null) {
            return;
        }
        L2Attackable me = (L2Attackable)this._actor;
        if (target != null) {
            me.addDamageHate(target, 0, aggro);
            aggro = me.getHating(target);
            if (aggro <= 0) {
                if (me.getMostHated() == null) {
                    this._globalAggro = -25;
                    me.clearAggroList();
                    this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
                }
                return;
            }
            if (this.getIntention() != CtrlIntention.AI_INTENTION_ATTACK) {
                double homeY;
                if (!this._actor.isRunning()) {
                    this._actor.setRunning();
                }
                L2DefenderInstance sGuard = this._actor instanceof L2FortCommanderInstance ? (L2FortCommanderInstance)this._actor : (L2DefenderInstance)this._actor;
                double homeX = target.getX() - sGuard.getSpawn().getX();
                if (homeX * homeX + (homeY = (double)(target.getY() - sGuard.getSpawn().getY())) * homeY < 3240000.0) {
                    this.setIntention(CtrlIntention.AI_INTENTION_ATTACK, target, null);
                }
            }
        } else {
            if (aggro >= 0) {
                return;
            }
            L2Character mostHated = me.getMostHated();
            if (mostHated == null) {
                this._globalAggro = -25;
                return;
            }
            for (L2Character aggroed : me.getAggroList().keySet()) {
                me.addDamageHate(aggroed, 0, aggro);
            }
            aggro = me.getHating(mostHated);
            if (aggro <= 0) {
                this._globalAggro = -25;
                me.clearAggroList();
                this.setIntention(CtrlIntention.AI_INTENTION_IDLE, null, null);
            }
        }
    }

    @Override
    public void stopAITask() {
        if (this._aiTask != null) {
            this._aiTask.cancel(false);
            this._aiTask = null;
        }
        this._accessor.detachAI();
        super.stopAITask();
    }
}

