/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.cache;

import com.l2jserver.Config;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.util.ConcurrentFastMap;
import java.util.Map;

public class WarehouseCacheManager {
    protected final Map<L2PcInstance, Long> _cachedWh = new ConcurrentFastMap();
    protected final long _cacheTime = (long)Config.WAREHOUSE_CACHE_TIME * 60000L;

    protected WarehouseCacheManager() {
        ThreadPoolManager.getInstance().scheduleAiAtFixedRate(new CacheScheduler(), 120000L, 60000L);
    }

    public void addCacheTask(L2PcInstance pc) {
        this._cachedWh.put(pc, System.currentTimeMillis());
    }

    public void remCacheTask(L2PcInstance pc) {
        this._cachedWh.remove(pc);
    }

    public static WarehouseCacheManager getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final WarehouseCacheManager _instance = new WarehouseCacheManager();

        private SingletonHolder() {
        }
    }

    public class CacheScheduler
    implements Runnable {
        @Override
        public void run() {
            long cTime = System.currentTimeMillis();
            for (L2PcInstance pc : WarehouseCacheManager.this._cachedWh.keySet()) {
                if (cTime - WarehouseCacheManager.this._cachedWh.get(pc) <= WarehouseCacheManager.this._cacheTime) continue;
                pc.clearWarehouse();
                WarehouseCacheManager.this._cachedWh.remove(pc);
            }
        }
    }
}

