/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.communitybbs.BB.CustomMsg;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomComment {
    private static Logger _log = Logger.getLogger(CustomComment.class.getName());
    private int _msgId;
    private int _comId;
    private long _msgDate;
    private String _fromName;
    private String _fromId;
    private String _message;
    private String _title;

    public static int list(List<CustomComment> comTable, int msgId, int offset, int limit) {
        int comTotal = -1;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            ResultSet result;
            try (Statement statement = con.prepareStatement("SELECT SQL_CALC_FOUND_ROWS com_id,msg_date,from_name,from_id,message FROM commentz WHERE msg_id=? AND delflg=0 ORDER BY com_id DESC LIMIT ?,?");){
                statement.setInt(1, msgId);
                statement.setInt(2, offset);
                statement.setInt(3, limit);
                result = statement.executeQuery();
                while (result.next()) {
                    CustomComment t = new CustomComment();
                    t._msgId = msgId;
                    t._comId = result.getInt("com_id");
                    t._msgDate = result.getLong("msg_date");
                    t._fromName = result.getString("from_name");
                    t._fromId = result.getString("from_id");
                    t._message = result.getString("message");
                    comTable.add(t);
                }
            }
            statement = con.createStatement();
            var8_11 = null;
            try {
                result = statement.executeQuery("SELECT FOUND_ROWS()");
                if (result.next()) {
                    comTotal = result.getInt(1);
                }
            }
            catch (Throwable throwable) {
                var8_11 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var8_11 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var8_11.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on commentz: ", e);
        }
        return comTotal;
    }

    public CustomComment load(int msgId, int comId) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("SELECT C.msg_date,C.from_name,C.from_id,C.message,M.title FROM commentz AS C LEFT JOIN messagez AS M ON C.msg_id=M.msg_id WHERE C.msg_id=? AND com_id=? AND C.delflg=0");){
            statement.setInt(1, msgId);
            statement.setInt(2, comId);
            ResultSet result = statement.executeQuery();
            if (result.next()) {
                this._msgId = msgId;
                this._comId = comId;
                this._msgDate = result.getLong("msg_date");
                this._fromName = result.getString("from_name");
                this._fromId = result.getString("from_id");
                this._message = result.getString("message");
                this._title = result.getString("title");
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "data error on commentz: ", e);
        }
        return this;
    }

    public static boolean insert(int msgId, String comment, L2PcInstance activeChar) {
        boolean isSuccess = false;
        long now = System.currentTimeMillis();
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();){
            try (PreparedStatement statement = con.prepareStatement("INSERT INTO commentz SET msg_date=?, from_name=?, from_id=?, message=?, msg_id=?");){
                statement.setLong(1, now);
                statement.setString(2, activeChar.getName());
                statement.setString(3, activeChar.getAccountName2());
                statement.setString(4, comment);
                statement.setInt(5, msgId);
                statement.executeUpdate();
            }
            statement = con.prepareStatement("UPDATE messagez SET last_date=?, com_max=(SELECT MAX(com_id) FROM commentz WHERE commentz.msg_id=messagez.msg_id GROUP BY msg_id) WHERE msg_id=?");
            var9_11 = null;
            try {
                statement.setLong(1, now);
                statement.setInt(2, msgId);
                statement.executeUpdate();
            }
            catch (Throwable throwable) {
                var9_11 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var9_11 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var9_11.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
            isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while insert commentz to db ", e);
        }
        return isSuccess;
    }

    public static boolean delete(int msgId, int comId, int delflg) {
        boolean isSuccess = false;
        if (msgId == 0) {
            return isSuccess;
        }
        if (comId == 0) {
            return isSuccess;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement statement = con.prepareStatement("UPDATE commentz SET delflg=? WHERE msg_id=? AND com_id=?");){
            statement.setInt(1, delflg);
            statement.setInt(2, msgId);
            statement.setInt(3, comId);
            statement.executeUpdate();
            isSuccess = true;
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, "error while delete commentz from db ", e);
        }
        return isSuccess;
    }

    public boolean isOwn(L2PcInstance activeChar) {
        return this._fromId.equals(activeChar.getAccountName2());
    }

    public int getMsgId() {
        return this._msgId;
    }

    public int getComId() {
        return this._comId;
    }

    public String getDate() {
        return CustomMsg.dateFormat(this._msgDate);
    }

    public String getFromName() {
        return this._fromName;
    }

    public String getFromId() {
        return this._fromId;
    }

    public String getMessage() {
        return this._message;
    }

    public String getTitle() {
        return this._title;
    }
}

