/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.communitybbs.BB;

import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.communitybbs.BB.Topic;
import com.l2jserver.gameserver.communitybbs.Manager.ForumsBBSManager;
import com.l2jserver.gameserver.communitybbs.Manager.TopicBBSManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javolution.util.FastList;
import javolution.util.FastMap;

public class Forum {
    private static final Logger _log = Logger.getLogger(Forum.class.getName());
    public static final int ROOT = 0;
    public static final int NORMAL = 1;
    public static final int CLAN = 2;
    public static final int MEMO = 3;
    public static final int MAIL = 4;
    public static final int INVISIBLE = 0;
    public static final int ALL = 1;
    public static final int CLANMEMBERONLY = 2;
    public static final int OWNERONLY = 3;
    private final List<Forum> _children;
    private final Map<Integer, Topic> _topic;
    private final int _forumId;
    private String _forumName;
    private int _forumType;
    private int _forumPost;
    private int _forumPerm;
    private final Forum _fParent;
    private int _ownerID;
    private boolean _loaded = false;

    public Forum(int Forumid, Forum FParent) {
        this._forumId = Forumid;
        this._fParent = FParent;
        this._children = new FastList();
        this._topic = new FastMap();
    }

    public Forum(String name, Forum parent, int type, int perm, int OwnerID) {
        this._forumName = name;
        this._forumId = ForumsBBSManager.getInstance().getANewID();
        this._forumType = type;
        this._forumPost = 0;
        this._forumPerm = perm;
        this._fParent = parent;
        this._ownerID = OwnerID;
        this._children = new FastList();
        this._topic = new FastMap();
        parent._children.add(this);
        ForumsBBSManager.getInstance().addForum(this);
        this._loaded = true;
    }

    private void load() {
        Throwable throwable;
        ResultSet rs2;
        Throwable throwable2;
        PreparedStatement ps2;
        Throwable throwable3;
        Connection con;
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                ps2 = con.prepareStatement("SELECT * FROM forums WHERE forum_id=?");
                throwable2 = null;
                try {
                    ps2.setInt(1, this._forumId);
                    rs2 = ps2.executeQuery();
                    throwable = null;
                    try {
                        if (rs2.next()) {
                            this._forumName = rs2.getString("forum_name");
                            this._forumPost = rs2.getInt("forum_post");
                            this._forumType = rs2.getInt("forum_type");
                            this._forumPerm = rs2.getInt("forum_perm");
                            this._ownerID = rs2.getInt("forum_owner_id");
                        }
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable.addSuppressed(throwable5);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable rs2) {
                    throwable2 = rs2;
                    throw rs2;
                }
                finally {
                    if (ps2 != null) {
                        if (throwable2 != null) {
                            try {
                                ps2.close();
                            }
                            catch (Throwable rs2) {
                                throwable2.addSuppressed(rs2);
                            }
                        } else {
                            ps2.close();
                        }
                    }
                }
            }
            catch (Throwable ps2) {
                throwable3 = ps2;
                throw ps2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable ps2) {
                            throwable3.addSuppressed(ps2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Data error on Forum " + this._forumId + " : " + e.getMessage(), e);
        }
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                ps2 = con.prepareStatement("SELECT * FROM topic WHERE topic_forum_id=? ORDER BY topic_id DESC");
                throwable2 = null;
                try {
                    ps2.setInt(1, this._forumId);
                    rs2 = ps2.executeQuery();
                    throwable = null;
                    try {
                        while (rs2.next()) {
                            Topic t = new Topic(Topic.ConstructorType.RESTORE, rs2.getInt("topic_id"), rs2.getInt("topic_forum_id"), rs2.getString("topic_name"), rs2.getLong("topic_date"), rs2.getString("topic_ownername"), rs2.getInt("topic_ownerid"), rs2.getInt("topic_type"), rs2.getInt("topic_reply"));
                            this._topic.put(t.getID(), t);
                            if (t.getID() <= TopicBBSManager.getInstance().getMaxID(this)) continue;
                            TopicBBSManager.getInstance().setMaxID(t.getID(), this);
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (rs2 != null) {
                            if (throwable != null) {
                                try {
                                    rs2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable.addSuppressed(throwable7);
                                }
                            } else {
                                rs2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable2 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (ps2 != null) {
                        if (throwable2 != null) {
                            try {
                                ps2.close();
                            }
                            catch (Throwable throwable9) {
                                throwable2.addSuppressed(throwable9);
                            }
                        } else {
                            ps2.close();
                        }
                    }
                }
            }
            catch (Throwable throwable10) {
                throwable3 = throwable10;
                throw throwable10;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable throwable11) {
                            throwable3.addSuppressed(throwable11);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Data error on Forum " + this._forumId + " : " + e.getMessage(), e);
        }
    }

    private void getChildren() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT forum_id FROM forums WHERE forum_parent=?");){
            ps.setInt(1, this._forumId);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    Forum f = new Forum(rs.getInt("forum_id"), this);
                    this._children.add(f);
                    ForumsBBSManager.getInstance().addForum(f);
                }
            }
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Data error on Forum (children): " + e.getMessage(), e);
        }
    }

    public int getTopicSize() {
        this.vload();
        return this._topic.size();
    }

    public Topic getTopic(int j) {
        this.vload();
        return this._topic.get(j);
    }

    public void addTopic(Topic t) {
        this.vload();
        this._topic.put(t.getID(), t);
    }

    public int getID() {
        return this._forumId;
    }

    public String getName() {
        this.vload();
        return this._forumName;
    }

    public int getType() {
        this.vload();
        return this._forumType;
    }

    public Forum getChildByName(String name) {
        this.vload();
        for (Forum f : this._children) {
            if (!f.getName().equals(name)) continue;
            return f;
        }
        return null;
    }

    public void rmTopicByID(int id) {
        this._topic.remove(id);
    }

    public void insertIntoDb() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("INSERT INTO forums (forum_id,forum_name,forum_parent,forum_post,forum_type,forum_perm,forum_owner_id) VALUES (?,?,?,?,?,?,?)");){
            ps.setInt(1, this._forumId);
            ps.setString(2, this._forumName);
            ps.setInt(3, this._fParent.getID());
            ps.setInt(4, this._forumPost);
            ps.setInt(5, this._forumType);
            ps.setInt(6, this._forumPerm);
            ps.setInt(7, this._ownerID);
            ps.execute();
        }
        catch (Exception e) {
            _log.log(Level.WARNING, "Error while saving new Forum to db " + e.getMessage(), e);
        }
    }

    public void vload() {
        if (!this._loaded) {
            this.load();
            this.getChildren();
            this._loaded = true;
        }
    }
}

