/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.datatables.OptionsData;
import com.l2jserver.gameserver.model.L2Augmentation;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.model.options.Options;
import com.l2jserver.util.Rnd;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilderFactory;

public class AugmentationData {
    private static final Logger _log = Logger.getLogger(AugmentationData.class.getName());
    private static final int STAT_BLOCKSIZE = 3640;
    private static final int STAT_SUBBLOCKSIZE = 91;
    public static final int MIN_SKILL_ID = 14560;
    private static final int BLUE_START = 14561;
    private static final int SKILLS_BLOCKSIZE = 178;
    private static final int BASESTAT_STR = 16341;
    private static final int BASESTAT_MEN = 16344;
    private static final int ACC_START = 16669;
    private static final int ACC_BLOCKS_NUM = 10;
    private static final int ACC_STAT_SUBBLOCKSIZE = 21;
    private static final int ACC_RING_START = 16669;
    private static final int ACC_RING_SKILLS = 18;
    private static final int ACC_RING_BLOCKSIZE = 102;
    private static final int ACC_RING_END = 17688;
    private static final int ACC_EAR_START = 17689;
    private static final int ACC_EAR_SKILLS = 18;
    private static final int ACC_EAR_BLOCKSIZE = 102;
    private static final int ACC_EAR_END = 18708;
    private static final int ACC_NECK_START = 18709;
    private static final int ACC_NECK_SKILLS = 24;
    private static final int ACC_NECK_BLOCKSIZE = 108;
    private final ArrayList<ArrayList<Integer>> _blueSkills = new ArrayList(10);
    private final ArrayList<ArrayList<Integer>> _purpleSkills = new ArrayList(10);
    private final ArrayList<ArrayList<Integer>> _redSkills = new ArrayList(10);
    private final ArrayList<ArrayList<Integer>> _yellowSkills = new ArrayList(10);
    private final List<AugmentationChance> _augmentationChances = new ArrayList<AugmentationChance>();
    private final List<augmentationChanceAcc> _augmentationChancesAcc = new ArrayList<augmentationChanceAcc>();

    protected AugmentationData() {
        int i;
        for (i = 0; i < 10; ++i) {
            this._blueSkills.add(new ArrayList());
            this._purpleSkills.add(new ArrayList());
            this._redSkills.add(new ArrayList());
            this._yellowSkills.add(new ArrayList());
        }
        this.load();
        if (!Config.RETAIL_LIKE_AUGMENTATION) {
            for (i = 0; i < 10; ++i) {
                _log.info(this.getClass().getSimpleName() + ": Loaded: " + this._blueSkills.get(i).size() + " blue, " + this._purpleSkills.get(i).size() + " purple and " + this._redSkills.get(i).size() + " red skills for lifeStoneLevel " + i);
            }
        } else {
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._augmentationChances.size() + " augmentations.");
            _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._augmentationChancesAcc.size() + " accessory augmentations.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void load() {
        factory2 = DocumentBuilderFactory.newInstance();
        factory2.setValidating(false);
        factory2.setIgnoringComments(true);
        if (!Config.RETAIL_LIKE_AUGMENTATION) {
            try {
                badAugmantData = 0;
                factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setIgnoringComments(true);
                file = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/augmentation_skillmap.xml");
                if (!file.exists()) {
                    AugmentationData._log.log(Level.WARNING, this.getClass().getSimpleName() + ": ERROR The augmentation skillmap file is missing.");
                    return;
                }
                doc = factory.newDocumentBuilder().parse(file);
                for (n = doc.getFirstChild(); n != null; n = n.getNextSibling()) {
                    if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                    for (d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                        if (!"augmentation".equalsIgnoreCase(d.getNodeName())) continue;
                        attrs = d.getAttributes();
                        skillId = 0;
                        augmentationId = Integer.parseInt(attrs.getNamedItem("id").getNodeValue());
                        skillLvL = 0;
                        type = "blue";
                        for (cd = d.getFirstChild(); cd != null; cd = cd.getNextSibling()) {
                            if ("skillId".equalsIgnoreCase(cd.getNodeName())) {
                                attrs = cd.getAttributes();
                                skillId = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if ("skillLevel".equalsIgnoreCase(cd.getNodeName())) {
                                attrs = cd.getAttributes();
                                skillLvL = Integer.parseInt(attrs.getNamedItem("val").getNodeValue());
                                continue;
                            }
                            if (!"type".equalsIgnoreCase(cd.getNodeName())) continue;
                            attrs = cd.getAttributes();
                            type = attrs.getNamedItem("val").getNodeValue();
                        }
                        if (skillId == 0) {
                            ++badAugmantData;
                            continue;
                        }
                        if (skillLvL == 0) {
                            ++badAugmantData;
                            continue;
                        }
                        k = (augmentationId - 14561) / 178;
                        if (type.equalsIgnoreCase("blue")) {
                            this._blueSkills.get(k).add(augmentationId);
                            continue;
                        }
                        if (type.equalsIgnoreCase("purple")) {
                            this._purpleSkills.get(k).add(augmentationId);
                            continue;
                        }
                        this._redSkills.get(k).add(augmentationId);
                    }
                }
                if (badAugmantData == 0) ** GOTO lbl115
                AugmentationData._log.info(this.getClass().getSimpleName() + ": " + badAugmantData + " bad skill(s) were skipped.");
            }
            catch (Exception e) {
                AugmentationData._log.log(Level.WARNING, this.getClass().getSimpleName() + ": ERROR parsing augmentation_skillmap.xml.", e);
                return;
            }
        } else {
            factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setIgnoringComments(true);
            aFile = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/retailchances.xml");
            if (aFile.exists()) {
                aDoc = null;
                try {
                    aDoc = factory.newDocumentBuilder().parse(aFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                aWeaponType = null;
                aStoneId = 0;
                aVariationId = 0;
                aCategoryChance = 0;
                aAugmentId = 0;
                aAugmentChance = 0.0f;
                for (l = aDoc.getFirstChild(); l != null; l = l.getNextSibling()) {
                    if (!l.getNodeName().equals("list")) continue;
                    aNodeAttributes = null;
                    for (n = l.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (!n.getNodeName().equals("weapon")) continue;
                        aNodeAttributes = n.getAttributes();
                        aWeaponType = aNodeAttributes.getNamedItem("type").getNodeValue();
                        for (c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
                            if (!c.getNodeName().equals("stone")) continue;
                            aNodeAttributes = c.getAttributes();
                            aStoneId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                            for (v = c.getFirstChild(); v != null; v = v.getNextSibling()) {
                                if (!v.getNodeName().equals("variation")) continue;
                                aNodeAttributes = v.getAttributes();
                                aVariationId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                                for (j = v.getFirstChild(); j != null; j = j.getNextSibling()) {
                                    if (!j.getNodeName().equals("category")) continue;
                                    aNodeAttributes = j.getAttributes();
                                    aCategoryChance = Integer.parseInt(aNodeAttributes.getNamedItem("probability").getNodeValue());
                                    for (e = j.getFirstChild(); e != null; e = e.getNextSibling()) {
                                        if (!e.getNodeName().equals("augment")) continue;
                                        aNodeAttributes = e.getAttributes();
                                        aAugmentId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                                        aAugmentChance = Float.parseFloat(aNodeAttributes.getNamedItem("chance").getNodeValue());
                                        this._augmentationChances.add(new AugmentationChance(aWeaponType, aStoneId, aVariationId, aCategoryChance, aAugmentId, aAugmentChance));
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                AugmentationData._log.log(Level.WARNING, this.getClass().getSimpleName() + ": ERROR The retailchances.xml data file is missing.");
                return;
            }
        }
lbl115:
        // 3 sources

        if (Config.RETAIL_LIKE_AUGMENTATION_ACCESSORY) {
            factory3 = DocumentBuilderFactory.newInstance();
            factory3.setValidating(false);
            factory3.setIgnoringComments(true);
            aFile3 = new File(Config.DATAPACK_ROOT + "/data/stats/augmentation/retailchances_accessory.xml");
            if (aFile3.exists()) {
                aDoc = null;
                try {
                    aDoc = factory3.newDocumentBuilder().parse(aFile3);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                aWeaponType = null;
                aStoneId = 0;
                aVariationId = 0;
                aCategoryChance = 0;
                aAugmentId = 0;
                aAugmentChance = 0.0f;
                for (l = aDoc.getFirstChild(); l != null; l = l.getNextSibling()) {
                    if (!l.getNodeName().equals("list")) continue;
                    aNodeAttributes = null;
                    for (n = l.getFirstChild(); n != null; n = n.getNextSibling()) {
                        if (!n.getNodeName().equals("weapon")) continue;
                        aNodeAttributes = n.getAttributes();
                        aWeaponType = aNodeAttributes.getNamedItem("type").getNodeValue();
                        for (c = n.getFirstChild(); c != null; c = c.getNextSibling()) {
                            if (!c.getNodeName().equals("stone")) continue;
                            aNodeAttributes = c.getAttributes();
                            aStoneId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                            for (v = c.getFirstChild(); v != null; v = v.getNextSibling()) {
                                if (!v.getNodeName().equals("variation")) continue;
                                aNodeAttributes = v.getAttributes();
                                aVariationId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                                for (j = v.getFirstChild(); j != null; j = j.getNextSibling()) {
                                    if (!j.getNodeName().equals("category")) continue;
                                    aNodeAttributes = j.getAttributes();
                                    aCategoryChance = Integer.parseInt(aNodeAttributes.getNamedItem("probability").getNodeValue());
                                    for (e = j.getFirstChild(); e != null; e = e.getNextSibling()) {
                                        if (!e.getNodeName().equals("augment")) continue;
                                        aNodeAttributes = e.getAttributes();
                                        aAugmentId = Integer.parseInt(aNodeAttributes.getNamedItem("id").getNodeValue());
                                        aAugmentChance = Float.parseFloat(aNodeAttributes.getNamedItem("chance").getNodeValue());
                                        this._augmentationChancesAcc.add(new augmentationChanceAcc(aWeaponType, aStoneId, aVariationId, aCategoryChance, aAugmentId, aAugmentChance));
                                    }
                                }
                            }
                        }
                    }
                }
            } else {
                AugmentationData._log.log(Level.WARNING, this.getClass().getSimpleName() + ": ERROR The retailchances_accessory.xml data file is missing.");
                return;
            }
        }
    }

    public L2Augmentation generateRandomAugmentation(int lifeStoneLevel, int lifeStoneGrade, int bodyPart, int lifeStoneId, L2ItemInstance targetItem) {
        switch (bodyPart) {
            case 6: 
            case 8: 
            case 48: {
                return this.generateRandomAccessoryAugmentation(lifeStoneLevel, bodyPart, lifeStoneId);
            }
        }
        return this.generateRandomWeaponAugmentation(lifeStoneLevel, lifeStoneGrade, lifeStoneId, targetItem);
    }

    private L2Augmentation generateRandomWeaponAugmentation(int lifeStoneLevel, int lifeStoneGrade, int lifeStoneId, L2ItemInstance item) {
        int offset;
        int stat12 = 0;
        int stat34 = 0;
        if (Config.RETAIL_LIKE_AUGMENTATION) {
            if (((L2Weapon)item.getItem()).isMagicWeapon()) {
                ArrayList<AugmentationChance> _selectedChances12 = new ArrayList<AugmentationChance>();
                ArrayList<AugmentationChance> _selectedChances34 = new ArrayList<AugmentationChance>();
                for (AugmentationChance ac : this._augmentationChances) {
                    if (!ac.getWeaponType().equals("mage") || ac.getStoneId() != lifeStoneId) continue;
                    if (ac.getVariationId() == 1) {
                        _selectedChances12.add(ac);
                        continue;
                    }
                    _selectedChances34.add(ac);
                }
                int r = Rnd.get(10000);
                float s = 10000.0f;
                for (AugmentationChance ac : _selectedChances12) {
                    if (!(s > (float)r)) continue;
                    s -= ac.getAugmentChance() * 100.0f;
                    stat12 = ac.getAugmentId();
                }
                int[] gradeChance = null;
                switch (lifeStoneGrade) {
                    case 0: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_NG_CHANCE;
                        break;
                    }
                    case 1: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_MID_CHANCE;
                        break;
                    }
                    case 2: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_HIGH_CHANCE;
                        break;
                    }
                    case 3: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_TOP_CHANCE;
                        break;
                    }
                    default: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_NG_CHANCE;
                    }
                }
                int c = Rnd.get(100);
                c = c < gradeChance[0] ? 55 : (c < gradeChance[0] + gradeChance[1] ? 35 : (c < gradeChance[0] + gradeChance[1] + gradeChance[2] ? 7 : 3));
                ArrayList<AugmentationChance> _selectedChances34final = new ArrayList<AugmentationChance>();
                for (AugmentationChance ac : _selectedChances34) {
                    if (ac.getCategoryChance() != c) continue;
                    _selectedChances34final.add(ac);
                }
                r = Rnd.get(10000);
                s = 10000.0f;
                for (AugmentationChance ac : _selectedChances34final) {
                    if (!(s > (float)r)) continue;
                    s -= ac.getAugmentChance() * 100.0f;
                    stat34 = ac.getAugmentId();
                }
            } else {
                ArrayList<AugmentationChance> _selectedChances12 = new ArrayList<AugmentationChance>();
                ArrayList<AugmentationChance> _selectedChances34 = new ArrayList<AugmentationChance>();
                for (AugmentationChance ac : this._augmentationChances) {
                    if (!ac.getWeaponType().equals("warrior") || ac.getStoneId() != lifeStoneId) continue;
                    if (ac.getVariationId() == 1) {
                        _selectedChances12.add(ac);
                        continue;
                    }
                    _selectedChances34.add(ac);
                }
                int r = Rnd.get(10000);
                float s = 10000.0f;
                for (AugmentationChance ac : _selectedChances12) {
                    if (!(s > (float)r)) continue;
                    s -= ac.getAugmentChance() * 100.0f;
                    stat12 = ac.getAugmentId();
                }
                Object gradeChance = null;
                switch (lifeStoneGrade) {
                    case 0: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_NG_CHANCE;
                        break;
                    }
                    case 1: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_MID_CHANCE;
                        break;
                    }
                    case 2: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_HIGH_CHANCE;
                        break;
                    }
                    case 3: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_TOP_CHANCE;
                        break;
                    }
                    default: {
                        gradeChance = Config.RETAIL_LIKE_AUGMENTATION_NG_CHANCE;
                    }
                }
                int c = Rnd.get(100);
                c = c < gradeChance[0] ? 55 : (c < gradeChance[0] + gradeChance[1] ? 35 : (c < gradeChance[0] + gradeChance[1] + gradeChance[2] ? 7 : 3));
                ArrayList<AugmentationChance> _selectedChances34final = new ArrayList<AugmentationChance>();
                for (AugmentationChance ac : _selectedChances34) {
                    if (ac.getCategoryChance() != c) continue;
                    _selectedChances34final.add(ac);
                }
                r = Rnd.get(10000);
                s = 10000.0f;
                for (AugmentationChance ac : _selectedChances34final) {
                    if (!(s > (float)r)) continue;
                    s -= ac.getAugmentChance() * 100.0f;
                    stat34 = ac.getAugmentId();
                }
            }
            return new L2Augmentation((stat34 << 16) + stat12);
        }
        boolean generateSkill = false;
        boolean generateGlow = false;
        lifeStoneLevel = Math.min(lifeStoneLevel, 9);
        switch (lifeStoneGrade) {
            case 0: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_NG_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_NG_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 1: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_MID_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_MID_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 2: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_HIGH_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_HIGH_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 3: {
                if (Rnd.get(1, 100) <= Config.AUGMENTATION_TOP_SKILL_CHANCE) {
                    generateSkill = true;
                }
                if (Rnd.get(1, 100) > Config.AUGMENTATION_TOP_GLOW_CHANCE) break;
                generateGlow = true;
                break;
            }
            case 4: {
                if (Rnd.get(1, 100) > Config.AUGMENTATION_ACC_SKILL_CHANCE) break;
                generateSkill = true;
            }
        }
        if (!generateSkill && Rnd.get(1, 100) <= Config.AUGMENTATION_BASESTAT_CHANCE) {
            stat34 = Rnd.get(16341, 16344);
        }
        int resultColor = Rnd.get(0, 100);
        resultColor = stat34 == 0 && !generateSkill ? (resultColor <= 15 * lifeStoneGrade + 40 ? 1 : 0) : (resultColor <= 10 * lifeStoneGrade + 5 || stat34 != 0 ? 3 : (resultColor <= 10 * lifeStoneGrade + 10 ? 1 : 2));
        if (generateSkill) {
            switch (resultColor) {
                case 1: {
                    stat34 = this._blueSkills.get(lifeStoneLevel).get(Rnd.get(this._blueSkills.get(lifeStoneLevel).size()));
                    break;
                }
                case 2: {
                    stat34 = this._purpleSkills.get(lifeStoneLevel).get(Rnd.get(this._purpleSkills.get(lifeStoneLevel).size()));
                    break;
                }
                case 3: {
                    stat34 = this._redSkills.get(lifeStoneLevel).get(Rnd.get(this._redSkills.get(lifeStoneLevel).size()));
                }
            }
        }
        if (stat34 == 0) {
            int temp = Rnd.get(2, 3);
            int colorOffset = resultColor * 910 + temp * 3640 + 1;
            offset = lifeStoneLevel * 91 + colorOffset;
            stat34 = Rnd.get(offset, offset + 91 - 1);
            offset = generateGlow && lifeStoneGrade >= 2 ? lifeStoneLevel * 91 + (temp - 2) * 3640 + lifeStoneGrade * 910 + 1 : lifeStoneLevel * 91 + (temp - 2) * 3640 + Rnd.get(0, 1) * 910 + 1;
        } else {
            offset = !generateGlow ? lifeStoneLevel * 91 + Rnd.get(0, 1) * 3640 + 1 : lifeStoneLevel * 91 + Rnd.get(0, 1) * 3640 + (lifeStoneGrade + resultColor) / 2 * 910 + 1;
        }
        stat12 = Rnd.get(offset, offset + 91 - 1);
        if (Config.DEBUG) {
            _log.info(this.getClass().getSimpleName() + ": Augmentation success: stat12=" + stat12 + "; stat34=" + stat34 + "; resultColor=" + resultColor + "; level=" + lifeStoneLevel + "; grade=" + lifeStoneGrade);
        }
        return new L2Augmentation((stat34 << 16) + stat12);
    }

    private L2Augmentation generateRandomAccessoryAugmentation(int lifeStoneLevel, int bodyPart, int lifeStoneId) {
        int stat12 = 0;
        int stat34 = 0;
        if (Config.RETAIL_LIKE_AUGMENTATION_ACCESSORY) {
            ArrayList<augmentationChanceAcc> _selectedChances12 = new ArrayList<augmentationChanceAcc>();
            ArrayList<augmentationChanceAcc> _selectedChances34 = new ArrayList<augmentationChanceAcc>();
            for (augmentationChanceAcc ac : this._augmentationChancesAcc) {
                if (!ac.getWeaponType().equals("warrior") || ac.getStoneId() != lifeStoneId) continue;
                if (ac.getVariationId() == 1) {
                    _selectedChances12.add(ac);
                    continue;
                }
                _selectedChances34.add(ac);
            }
            int r = Rnd.get(10000);
            float s = 10000.0f;
            for (augmentationChanceAcc ac : _selectedChances12) {
                if (!(s > (float)r)) continue;
                s -= ac.getAugmentChance() * 100.0f;
                stat12 = ac.getAugmentId();
            }
            int c = Rnd.get(100);
            c = c < 55 ? 55 : (c < 90 ? 35 : (c < 99 ? 9 : 1));
            ArrayList<augmentationChanceAcc> _selectedChances34final = new ArrayList<augmentationChanceAcc>();
            for (augmentationChanceAcc ac : _selectedChances34) {
                if (ac.getCategoryChance() != c) continue;
                _selectedChances34final.add(ac);
            }
            r = Rnd.get(10000);
            s = 10000.0f;
            for (augmentationChanceAcc ac : _selectedChances34final) {
                if (!(s > (float)r)) continue;
                s -= ac.getAugmentChance() * 100.0f;
                stat34 = ac.getAugmentId();
            }
            return new L2Augmentation((stat34 << 16) + stat12);
        }
        lifeStoneLevel = Math.min(lifeStoneLevel, 9);
        int base = 0;
        int skillsLength = 0;
        switch (bodyPart) {
            case 48: {
                base = 16669 + 102 * lifeStoneLevel;
                skillsLength = 18;
                break;
            }
            case 6: {
                base = 17689 + 102 * lifeStoneLevel;
                skillsLength = 18;
                break;
            }
            case 8: {
                base = 18709 + 108 * lifeStoneLevel;
                skillsLength = 24;
                break;
            }
            default: {
                return null;
            }
        }
        int resultColor = Rnd.get(0, 3);
        stat12 = Rnd.get(21);
        Options op = null;
        if (Rnd.get(1, 100) <= Config.AUGMENTATION_ACC_SKILL_CHANCE) {
            stat34 = base + Rnd.get(skillsLength);
            op = OptionsData.getInstance().getOptions(stat34);
        }
        if (op == null || !op.hasActiveSkill() && !op.hasPassiveSkill() && !op.hasActivationSkills()) {
            stat34 = (stat12 + 1 + Rnd.get(20)) % 21;
            stat34 = base + skillsLength + 21 * resultColor + stat34;
        }
        stat12 = base + skillsLength + 21 * resultColor + stat12;
        if (Config.DEBUG) {
            _log.info(this.getClass().getSimpleName() + ": Accessory augmentation success: stat12=" + stat12 + "; stat34=" + stat34 + "; level=" + lifeStoneLevel);
        }
        return new L2Augmentation((stat34 << 16) + stat12);
    }

    public static final AugmentationData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final AugmentationData _instance = new AugmentationData();

        private SingletonHolder() {
        }
    }

    public class augmentationChanceAcc {
        private final String _WeaponType;
        private final int _StoneId;
        private final int _VariationId;
        private final int _CategoryChance;
        private final int _AugmentId;
        private final float _AugmentChance;

        public augmentationChanceAcc(String WeaponType2, int StoneId, int VariationId, int CategoryChance, int AugmentId, float AugmentChance) {
            this._WeaponType = WeaponType2;
            this._StoneId = StoneId;
            this._VariationId = VariationId;
            this._CategoryChance = CategoryChance;
            this._AugmentId = AugmentId;
            this._AugmentChance = AugmentChance;
        }

        public String getWeaponType() {
            return this._WeaponType;
        }

        public int getStoneId() {
            return this._StoneId;
        }

        public int getVariationId() {
            return this._VariationId;
        }

        public int getCategoryChance() {
            return this._CategoryChance;
        }

        public int getAugmentId() {
            return this._AugmentId;
        }

        public float getAugmentChance() {
            return this._AugmentChance;
        }
    }

    public class AugmentationChance {
        private final String _WeaponType;
        private final int _StoneId;
        private final int _VariationId;
        private final int _CategoryChance;
        private final int _AugmentId;
        private final float _AugmentChance;

        public AugmentationChance(String WeaponType2, int StoneId, int VariationId, int CategoryChance, int AugmentId, float AugmentChance) {
            this._WeaponType = WeaponType2;
            this._StoneId = StoneId;
            this._VariationId = VariationId;
            this._CategoryChance = CategoryChance;
            this._AugmentId = AugmentId;
            this._AugmentChance = AugmentChance;
        }

        public String getWeaponType() {
            return this._WeaponType;
        }

        public int getStoneId() {
            return this._StoneId;
        }

        public int getVariationId() {
            return this._VariationId;
        }

        public int getCategoryChance() {
            return this._CategoryChance;
        }

        public int getAugmentId() {
            return this._AugmentId;
        }

        public float getAugmentChance() {
            return this._AugmentChance;
        }
    }
}

