/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;
import jp.sf.l2j.troja.IntObjectMap;

public class CharNameTable {
    private static Logger _log = Logger.getLogger(CharNameTable.class.getName());
    private final FastIntObjectMap<String> _chars = new FastIntObjectMap().shared();
    private final FastIntObjectMap<Integer> _accessLevels = new FastIntObjectMap().shared();

    protected CharNameTable() {
        if (Config.CACHE_CHAR_NAMES) {
            this.loadAll();
        }
    }

    public final void addName(L2PcInstance player) {
        if (player != null) {
            this.addName(player.getObjectId(), player.getName());
            this._accessLevels.put(player.getObjectId(), (Object)player.getAccessLevel().getLevel());
        }
    }

    private final void addName(int objectId, String name) {
        if (name != null && !name.equals(this._chars.get(objectId))) {
            this._chars.put(objectId, (Object)name);
        }
    }

    public final void removeName(int objId) {
        this._chars.remove(objId);
        this._accessLevels.remove(objId);
    }

    public final int getIdByName(String name) {
        if (name == null || name.isEmpty()) {
            return -1;
        }
        for (IntObjectMap.Entry entry : this._chars.entrySet()) {
            if (!((String)entry.getValue()).equalsIgnoreCase(name)) continue;
            return entry.getKey();
        }
        if (Config.CACHE_CHAR_NAMES) {
            return -1;
        }
        int id = -1;
        int accessLevel = 0;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT charId,accesslevel FROM characters WHERE char_name=?");){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    id = rs.getInt(1);
                    accessLevel = rs.getInt(2);
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not check existing char name: " + e.getMessage(), e);
        }
        if (id > 0) {
            this._chars.put(id, (Object)name);
            this._accessLevels.put(id, (Object)accessLevel);
            return id;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String getNameById(int id) {
        if (id <= 0) {
            return null;
        }
        String name = (String)this._chars.get(id);
        if (name != null) {
            return name;
        }
        if (Config.CACHE_CHAR_NAMES) {
            return null;
        }
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT char_name,accesslevel FROM characters WHERE charId=?");){
            ps.setInt(1, id);
            try (ResultSet rset = ps.executeQuery();){
                if (!rset.next()) return null;
                name = rset.getString(1);
                this._chars.put(id, (Object)name);
                this._accessLevels.put(id, (Object)rset.getInt(2));
                String string = name;
                return string;
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not check existing char id: " + e.getMessage(), e);
        }
        return null;
    }

    public final int getAccessLevelById(int objectId) {
        if (this.getNameById(objectId) != null) {
            return (Integer)this._accessLevels.get(objectId);
        }
        return 0;
    }

    public synchronized boolean doesCharNameExist(String name) {
        boolean result = true;
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT account_name FROM characters WHERE char_name=?");){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                result = rs.next();
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not check existing charname: " + e.getMessage(), e);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getAccountCharacterCount(String account) {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             PreparedStatement ps = con.prepareStatement("SELECT COUNT(char_name) FROM characters WHERE account_name=?");){
            ps.setString(1, account);
            try (ResultSet rset = ps.executeQuery();){
                if (!rset.next()) return 0;
                int n = rset.getInt(1);
                return n;
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not check existing char count: " + e.getMessage(), e);
        }
        return 0;
    }

    private void loadAll() {
        try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
             Statement s = con.createStatement();
             ResultSet rs = s.executeQuery("SELECT charId, char_name, accesslevel FROM characters");){
            while (rs.next()) {
                int id = rs.getInt(1);
                this._chars.put(id, (Object)rs.getString(2));
                this._accessLevels.put(id, (Object)rs.getInt(3));
            }
        }
        catch (SQLException e) {
            _log.log(Level.WARNING, this.getClass().getSimpleName() + ": Could not load char name: " + e.getMessage(), e);
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._chars.size() + " char names.");
    }

    public static CharNameTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final CharNameTable _instance = new CharNameTable();

        private SingletonHolder() {
        }
    }
}

