/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.L2EnchantSkillGroup;
import com.l2jserver.gameserver.model.L2EnchantSkillLearn;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.skills.Skill;
import java.util.logging.Level;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import jp.sf.l2j.troja.FastIntObjectMap;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class EnchantSkillGroupsData
extends DocumentParser {
    public static final int NORMAL_ENCHANT_COST_MULTIPLIER = Config.NORMAL_ENCHANT_COST_MULTIPLIER;
    public static final int SAFE_ENCHANT_COST_MULTIPLIER = Config.SAFE_ENCHANT_COST_MULTIPLIER;
    public static final int NORMAL_ENCHANT_BOOK = 6622;
    public static final int SAFE_ENCHANT_BOOK = 9627;
    public static final int CHANGE_ENCHANT_BOOK = 9626;
    public static final int UNTRAIN_ENCHANT_BOOK = 9625;
    private final SortedIntObjectArrayMap<L2EnchantSkillGroup> _enchantSkillGroups = new SortedIntObjectArrayMap((Object[])new L2EnchantSkillGroup[0]);
    private final FastIntObjectMap<L2EnchantSkillLearn> _enchantSkillTrees = new FastIntObjectMap();

    protected EnchantSkillGroupsData() {
        this.load();
    }

    @Override
    public void load() {
        this._enchantSkillGroups.clear();
        this._enchantSkillTrees.clear();
        this.parseDatapackFile("data/enchantSkillGroups.xml");
        int routes = 0;
        for (L2EnchantSkillGroup group : (L2EnchantSkillGroup[])this._enchantSkillGroups.values()) {
            routes += group.getEnchantGroupDetails().size();
        }
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._enchantSkillGroups.size() + " groups and " + routes + " routes.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
            for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                if (!"group".equalsIgnoreCase(d.getNodeName())) continue;
                NamedNodeMap attrs = d.getAttributes();
                int id = this.parseInteger(attrs, "id");
                L2EnchantSkillGroup group = (L2EnchantSkillGroup)this._enchantSkillGroups.get(id);
                if (group == null) {
                    group = new L2EnchantSkillGroup(id);
                    this._enchantSkillGroups.put(id, (Object)group);
                }
                for (Node b = d.getFirstChild(); b != null; b = b.getNextSibling()) {
                    if (!"enchant".equalsIgnoreCase(b.getNodeName())) continue;
                    attrs = b.getAttributes();
                    StatsSet set = new StatsSet();
                    for (int i = 0; i < attrs.getLength(); ++i) {
                        Node att = attrs.item(i);
                        set.set(att.getNodeName(), att.getNodeValue());
                    }
                    group.addEnchantDetail(new L2EnchantSkillGroup.EnchantSkillHolder(set));
                }
            }
        }
    }

    public int addNewRouteForSkill(int skillId, int maxLvL, int route, int group) {
        L2EnchantSkillGroup enchantSkillGroup;
        L2EnchantSkillLearn enchantableSkill = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skillId);
        if (enchantableSkill == null) {
            enchantableSkill = new L2EnchantSkillLearn(skillId, maxLvL);
            this._enchantSkillTrees.put(skillId, (Object)enchantableSkill);
        }
        if ((enchantSkillGroup = (L2EnchantSkillGroup)this._enchantSkillGroups.get(group)) != null) {
            enchantableSkill.addNewEnchantRoute(route, group);
            return enchantSkillGroup.getEnchantGroupDetails().size();
        }
        this._log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error while loading generating enchant skill id: " + skillId + "; route: " + route + "; missing group: " + group);
        return 0;
    }

    public L2EnchantSkillLearn getSkillEnchantmentForSkill(Skill skill) {
        L2EnchantSkillLearn esl = this.getSkillEnchantmentBySkillId(skill.getId());
        if (esl != null && skill.getLevel() >= esl.getBaseLevel()) {
            return esl;
        }
        return null;
    }

    public L2EnchantSkillLearn getSkillEnchantmentBySkillId(int skillId) {
        return (L2EnchantSkillLearn)this._enchantSkillTrees.get(skillId);
    }

    public L2EnchantSkillGroup getEnchantSkillGroupById(int id) {
        return (L2EnchantSkillGroup)this._enchantSkillGroups.get(id);
    }

    public int getEnchantSkillSpCost(Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getSpCost();
        }
        return Integer.MAX_VALUE;
    }

    public int getEnchantSkillAdenaCost(Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getAdenaCost();
        }
        return Integer.MAX_VALUE;
    }

    public byte getEnchantSkillRate(L2PcInstance player, Skill skill) {
        L2EnchantSkillGroup.EnchantSkillHolder esh;
        L2EnchantSkillLearn enchantSkillLearn = (L2EnchantSkillLearn)this._enchantSkillTrees.get(skill.getId());
        if (enchantSkillLearn != null && (esh = enchantSkillLearn.getEnchantSkillHolder(skill.getLevel())) != null) {
            return esh.getRate(player);
        }
        return 0;
    }

    public static EnchantSkillGroupsData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final EnchantSkillGroupsData _instance = new EnchantSkillGroupsData();

        private SingletonHolder() {
        }
    }
}

