/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.enums.MacroType;
import com.l2jserver.gameserver.enums.ShortcutType;
import com.l2jserver.gameserver.model.Macro;
import com.l2jserver.gameserver.model.MacroCmd;
import com.l2jserver.gameserver.model.Shortcut;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.base.ClassId;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.network.serverpackets.ShortCutRegister;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public final class InitialShortcutData
extends DocumentParser {
    private final Map<ClassId, List<Shortcut>> _initialShortcutData = new HashMap<ClassId, List<Shortcut>>();
    private final List<Shortcut> _initialGlobalShortcutList = new ArrayList<Shortcut>();
    private final Map<Integer, Macro> _macroPresets = new HashMap<Integer, Macro>();

    protected InitialShortcutData() {
        this.load();
    }

    @Override
    public void load() {
        this._initialShortcutData.clear();
        this._initialGlobalShortcutList.clear();
        this.parseDatapackFile("data/stats/initialShortcuts.xml");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._initialGlobalShortcutList.size() + " Initial Global Shortcuts data.");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._initialShortcutData.size() + " Initial Shortcuts data.");
        this._log.info(this.getClass().getSimpleName() + ": Loaded " + this._macroPresets.size() + " Macros presets.");
    }

    @Override
    protected void parseDocument() {
        for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
            if (!"list".equals(n.getNodeName())) continue;
            block9: for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                switch (d.getNodeName()) {
                    case "shortcuts": {
                        this.parseShortcuts(d);
                        continue block9;
                    }
                    case "macros": {
                        this.parseMacros(d);
                    }
                }
            }
        }
    }

    private void parseShortcuts(Node d) {
        NamedNodeMap attrs = d.getAttributes();
        Node classIdNode = attrs.getNamedItem("classId");
        ArrayList<Shortcut> list = new ArrayList<Shortcut>();
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            if (!"page".equals(c.getNodeName())) continue;
            attrs = c.getAttributes();
            int pageId = this.parseInteger(attrs, "pageId");
            for (Node b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                if (!"slot".equals(b.getNodeName())) continue;
                list.add(this.createShortcut(pageId, b));
            }
        }
        if (classIdNode != null) {
            this._initialShortcutData.put(ClassId.getClassId(Integer.parseInt(classIdNode.getNodeValue())), list);
        } else {
            this._initialGlobalShortcutList.addAll(list);
        }
    }

    private void parseMacros(Node d) {
        for (Node c = d.getFirstChild(); c != null; c = c.getNextSibling()) {
            NamedNodeMap attrs;
            if (!"macro".equals(c.getNodeName()) || !this.parseBoolean(attrs = c.getAttributes(), "enabled", true).booleanValue()) continue;
            int macroId = this.parseInteger(attrs, "macroId");
            int icon = this.parseInteger(attrs, "icon");
            String name = this.parseString(attrs, "name");
            String description = this.parseString(attrs, "description");
            String acronym = this.parseString(attrs, "acronym");
            ArrayList<MacroCmd> commands = new ArrayList<MacroCmd>(1);
            int entry = 0;
            for (Node b = c.getFirstChild(); b != null; b = b.getNextSibling()) {
                if (!"command".equals(b.getNodeName())) continue;
                attrs = b.getAttributes();
                MacroType type = this.parseEnum(attrs, MacroType.class, "type");
                int d1 = 0;
                int d2 = 0;
                String cmd = b.getTextContent();
                switch (type) {
                    case SKILL: {
                        d1 = this.parseInteger(attrs, "skillId");
                        d2 = this.parseInteger(attrs, "skillLvl", 0);
                        break;
                    }
                    case ACTION: {
                        d1 = this.parseInteger(attrs, "actionId");
                        break;
                    }
                    case TEXT: {
                        break;
                    }
                    case SHORTCUT: {
                        d1 = this.parseInteger(attrs, "page");
                        d2 = this.parseInteger(attrs, "slot", 0);
                        break;
                    }
                    case ITEM: {
                        d1 = this.parseInteger(attrs, "itemId");
                        break;
                    }
                    case DELAY: {
                        d1 = this.parseInteger(attrs, "delay");
                    }
                }
                commands.add(new MacroCmd(entry++, type, d1, d2, cmd));
            }
            this._macroPresets.put(macroId, new Macro(macroId, icon, name, description, acronym, commands));
        }
    }

    private Shortcut createShortcut(int pageId, Node b) {
        NamedNodeMap attrs = b.getAttributes();
        int slotId = this.parseInteger(attrs, "slotId");
        ShortcutType shortcutType = this.parseEnum(attrs, ShortcutType.class, "shortcutType");
        int shortcutId = this.parseInteger(attrs, "shortcutId");
        int shortcutLevel = this.parseInteger(attrs, "shortcutLevel", 0);
        int characterType = this.parseInteger(attrs, "characterType", 0);
        return new Shortcut(slotId, pageId, shortcutType, shortcutId, shortcutLevel, characterType);
    }

    public List<Shortcut> getShortcutList(ClassId cId) {
        return this._initialShortcutData.get(cId);
    }

    public List<Shortcut> getShortcutList(int cId) {
        return this._initialShortcutData.get(ClassId.getClassId(cId));
    }

    public List<Shortcut> getGlobalMacroList() {
        return this._initialGlobalShortcutList;
    }

    public void registerAllShortcuts(L2PcInstance player) {
        if (player == null) {
            return;
        }
        block10: for (Shortcut shortcut : this._initialGlobalShortcutList) {
            int shortcutId = shortcut.getId();
            switch (shortcut.getType()) {
                case ITEM: {
                    L2ItemInstance item = player.getInventory().getItemByItemId(shortcutId);
                    if (item == null) continue block10;
                    shortcutId = item.getObjectId();
                    break;
                }
                case SKILL: {
                    if (player.getSkills().containsKey(shortcutId)) break;
                    continue block10;
                }
                case MACRO: {
                    Macro macro = this._macroPresets.get(shortcutId);
                    if (macro == null) continue block10;
                    player.registerMacro(macro);
                    break;
                }
            }
            Shortcut newShortcut = new Shortcut(shortcut.getSlot(), shortcut.getPage(), shortcut.getType(), shortcutId, shortcut.getLevel(), shortcut.getCharacterType());
            player.sendPacket(new ShortCutRegister(newShortcut));
            player.registerShortCut(newShortcut);
        }
        List<Shortcut> v = this._initialShortcutData.get(player.getClassId());
        if (v != null) {
            block11: for (Shortcut shortcut : v) {
                int shortcutId = shortcut.getId();
                switch (shortcut.getType()) {
                    case ITEM: {
                        L2ItemInstance item = player.getInventory().getItemByItemId(shortcutId);
                        if (item == null) continue block11;
                        shortcutId = item.getObjectId();
                        break;
                    }
                    case SKILL: {
                        if (player.getSkills().containsKey(shortcut.getId())) break;
                        continue block11;
                    }
                    case MACRO: {
                        Macro macro = this._macroPresets.get(shortcutId);
                        if (macro == null) continue block11;
                        player.registerMacro(macro);
                        break;
                    }
                }
                Shortcut newShortcut = new Shortcut(shortcut.getSlot(), shortcut.getPage(), shortcut.getType(), shortcutId, shortcut.getLevel(), shortcut.getCharacterType());
                player.sendPacket(new ShortCutRegister(newShortcut));
                player.registerShortCut(newShortcut);
            }
        }
    }

    public static InitialShortcutData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final InitialShortcutData _instance = new InitialShortcutData();

        private SingletonHolder() {
        }
    }
}

