/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.ThreadPoolManager;
import com.l2jserver.gameserver.datatables.EnchantItemHPBonusData;
import com.l2jserver.gameserver.engines.DocumentEngine;
import com.l2jserver.gameserver.enums.ItemLocation;
import com.l2jserver.gameserver.idfactory.IdFactory;
import com.l2jserver.gameserver.model.L2Object;
import com.l2jserver.gameserver.model.L2World;
import com.l2jserver.gameserver.model.actor.L2Attackable;
import com.l2jserver.gameserver.model.actor.instance.L2EventMonsterInstance;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.events.EventDispatcher;
import com.l2jserver.gameserver.model.events.impl.item.OnItemCreate;
import com.l2jserver.gameserver.model.items.L2Armor;
import com.l2jserver.gameserver.model.items.L2EtcItem;
import com.l2jserver.gameserver.model.items.L2Item;
import com.l2jserver.gameserver.model.items.L2Weapon;
import com.l2jserver.gameserver.model.items.instance.L2ItemInstance;
import com.l2jserver.gameserver.util.GMAudit;
import com.l2jserver.util.Util;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ScheduledFuture;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javolution.util.FastMap;
import jp.sf.l2j.troja.FastIntObjectMap;

public class ItemTable {
    private static Logger _log = Logger.getLogger(ItemTable.class.getName());
    private static Logger _logItems = Logger.getLogger("item");
    public static final Map<String, Integer> _slots = new FastMap();
    private L2Item[] _allTemplates;
    private final FastIntObjectMap<L2EtcItem> _etcItems = new FastIntObjectMap();
    private final FastIntObjectMap<L2Armor> _armors = new FastIntObjectMap();
    private final FastIntObjectMap<L2Weapon> _weapons = new FastIntObjectMap();

    public static ItemTable getInstance() {
        return SingletonHolder._instance;
    }

    protected ItemTable() {
        this.load();
    }

    private void load() {
        long started = System.currentTimeMillis();
        int highest = 0;
        this._armors.clear();
        this._etcItems.clear();
        this._weapons.clear();
        for (L2Item item : DocumentEngine.getInstance().loadItems()) {
            if (highest < item.getId()) {
                highest = item.getId();
            }
            if (item instanceof L2EtcItem) {
                this._etcItems.put(item.getId(), (Object)((L2EtcItem)item));
                continue;
            }
            if (item instanceof L2Armor) {
                this._armors.put(item.getId(), (Object)((L2Armor)item));
                continue;
            }
            this._weapons.put(item.getId(), (Object)((L2Weapon)item));
        }
        this.buildFastLookupTable(highest);
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._etcItems.size() + " Etc Items");
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._armors.size() + " Armor Items");
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + this._weapons.size() + " Weapon Items");
        _log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded: " + (this._etcItems.size() + this._armors.size() + this._weapons.size()) + " Items in total. (" + Util.strMillTime(System.currentTimeMillis() - started) + ")");
    }

    private void buildFastLookupTable(int size) {
        L2Item item;
        _log.info(this.getClass().getSimpleName() + ": Highest item id used:" + size);
        this._allTemplates = new L2Item[size + 1];
        Iterator iterator = this._armors.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = (L2Armor)iterator.next();
        }
        iterator = this._weapons.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = (L2Weapon)iterator.next();
        }
        iterator = this._etcItems.values().iterator();
        while (iterator.hasNext()) {
            this._allTemplates[item.getId()] = item = (L2EtcItem)iterator.next();
        }
    }

    public L2Item getTemplate(int id) {
        if (id >= this._allTemplates.length || id < 0) {
            return null;
        }
        return this._allTemplates[id];
    }

    public L2ItemInstance createItem(String process, int itemId, long count, L2PcInstance actor, Object reference) {
        L2ItemInstance item = new L2ItemInstance(IdFactory.getInstance().getNextId(), itemId);
        if (process.equalsIgnoreCase("loot")) {
            ScheduledFuture<?> itemLootShedule;
            if (reference instanceof L2Attackable && ((L2Attackable)reference).isRaid()) {
                L2Attackable raid = (L2Attackable)reference;
                if (raid.getFirstCommandChannelAttacked() != null && !Config.AUTO_LOOT_RAIDS) {
                    item.setOwnerId(raid.getFirstCommandChannelAttacked().getLeaderObjectId());
                    itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), Config.LOOT_RAIDS_PRIVILEGE_INTERVAL);
                    item.setItemLootShedule(itemLootShedule);
                }
            } else if (!Config.AUTO_LOOT || reference instanceof L2EventMonsterInstance && ((L2EventMonsterInstance)reference).eventDropOnGround()) {
                item.setOwnerId(actor.getObjectId());
                itemLootShedule = ThreadPoolManager.getInstance().scheduleGeneral(new ResetOwner(item), 15000L);
                item.setItemLootShedule(itemLootShedule);
            }
        }
        if (Config.DEBUG) {
            _log.fine(this.getClass().getSimpleName() + ": Item created  oid:" + item.getObjectId() + " itemid:" + itemId);
        }
        L2World.getInstance().storeObject(item);
        if (item.isStackable() && count > 1L) {
            item.setCount(count);
        }
        if (Config.LOG_ITEMS && !process.equals("Reset") && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (item.isEquipable() || item.getId() == 57))) {
            LogRecord record = new LogRecord(Level.INFO, "CREATE:" + process);
            record.setLoggerName("item");
            record.setParameters(new Object[]{item, actor, reference});
            _logItems.log(record);
        }
        if (actor != null && actor.isGM()) {
            String targetName;
            String referenceName = "no-reference";
            if (reference instanceof L2Object) {
                referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
            } else if (reference instanceof String) {
                referenceName = (String)reference;
            }
            String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
            if (Config.GMAUDIT) {
                GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + itemId + " count: " + count + " name: " + item.getItemName() + " objId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
            }
        }
        EventDispatcher.getInstance().notifyEventAsync(new OnItemCreate(process, item, actor, reference), item.getItem());
        return item;
    }

    public L2ItemInstance createItem(String process, int itemId, int count, L2PcInstance actor) {
        return this.createItem(process, itemId, count, actor, null);
    }

    public L2ItemInstance createDummyItem(int itemId) {
        L2Item item = this.getTemplate(itemId);
        if (item == null) {
            return null;
        }
        L2ItemInstance temp = new L2ItemInstance(0, item);
        return temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyItem(String process, L2ItemInstance item, L2PcInstance actor, Object reference) {
        L2ItemInstance l2ItemInstance = item;
        synchronized (l2ItemInstance) {
            long old = item.getCount();
            item.setCount(0L);
            item.setOwnerId(0);
            item.setItemLocation(ItemLocation.VOID);
            item.setLastChange(3);
            L2World.getInstance().removeObject(item);
            IdFactory.getInstance().releaseId(item.getObjectId());
            if (Config.LOG_ITEMS && (!Config.LOG_ITEMS_SMALL_LOG || Config.LOG_ITEMS_SMALL_LOG && (item.isEquipable() || item.getId() == 57))) {
                LogRecord record = new LogRecord(Level.INFO, "DELETE:" + process);
                record.setLoggerName("item");
                record.setParameters(new Object[]{item, "PrevCount(" + old + ")", actor, reference});
                _logItems.log(record);
            }
            if (actor != null && actor.isGM()) {
                String targetName;
                String referenceName = "no-reference";
                if (reference instanceof L2Object) {
                    referenceName = ((L2Object)reference).getName() != null ? ((L2Object)reference).getName() : "no-name";
                } else if (reference instanceof String) {
                    referenceName = (String)reference;
                }
                String string = targetName = actor.getTarget() != null ? actor.getTarget().getName() : "no-target";
                if (Config.GMAUDIT) {
                    GMAudit.auditGMAction(actor.getName() + " [" + actor.getObjectId() + "]", process + "(id: " + item.getId() + " count: " + item.getCount() + " itemObjId: " + item.getObjectId() + ")", targetName, "L2Object referencing this action is: " + referenceName);
                }
            }
            if (item.getItem().isPetItem()) {
                try (Connection con = L2DatabaseFactory.getInstance().getConnectionFast();
                     PreparedStatement statement = con.prepareStatement("DELETE FROM pets WHERE item_obj_id=?");){
                    statement.setInt(1, item.getObjectId());
                    statement.execute();
                }
                catch (Exception e) {
                    _log.log(Level.WARNING, "could not delete pet objectid:", e);
                }
            }
        }
    }

    public void reload() {
        this.load();
        EnchantItemHPBonusData.getInstance().load();
    }

    public Collection<L2EtcItem> getAllEtcItems() {
        return this._etcItems.values();
    }

    public Collection<L2Armor> getAllArmors() {
        return this._armors.values();
    }

    public Collection<L2Weapon> getAllWeapons() {
        return this._weapons.values();
    }

    public int getArraySize() {
        return this._allTemplates.length;
    }

    static {
        _slots.put("shirt", 1);
        _slots.put("lbracelet", 0x200000);
        _slots.put("rbracelet", 0x100000);
        _slots.put("talisman", 0x400000);
        _slots.put("chest", 1024);
        _slots.put("fullarmor", 32768);
        _slots.put("head", 64);
        _slots.put("hair", 65536);
        _slots.put("hairall", 524288);
        _slots.put("underwear", 1);
        _slots.put("back", 8192);
        _slots.put("neck", 8);
        _slots.put("legs", 2048);
        _slots.put("feet", 4096);
        _slots.put("gloves", 512);
        _slots.put("chest,legs", 3072);
        _slots.put("belt", 0x10000000);
        _slots.put("rhand", 128);
        _slots.put("lhand", 256);
        _slots.put("lrhand", 16384);
        _slots.put("rear;lear", 6);
        _slots.put("rfinger;lfinger", 48);
        _slots.put("wolf", -100);
        _slots.put("greatwolf", -104);
        _slots.put("hatchling", -101);
        _slots.put("strider", -102);
        _slots.put("babypet", -103);
        _slots.put("none", 0);
        _slots.put("onepiece", 32768);
        _slots.put("hair2", 262144);
        _slots.put("dhair", 524288);
        _slots.put("alldress", 131072);
        _slots.put("deco1", 0x400000);
        _slots.put("waist", 0x10000000);
    }

    private static class SingletonHolder {
        protected static final ItemTable _instance = new ItemTable();

        private SingletonHolder() {
        }
    }

    protected static class ResetOwner
    implements Runnable {
        L2ItemInstance _item;

        public ResetOwner(L2ItemInstance item) {
            this._item = item;
        }

        @Override
        public void run() {
            this._item.setOwnerId(0);
            this._item.setItemLootShedule(null);
        }
    }
}

