/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.gameserver.engines.DocumentParser;
import com.l2jserver.gameserver.model.StatsSet;
import com.l2jserver.gameserver.model.actor.L2Npc;
import com.l2jserver.gameserver.model.actor.instance.L2PcInstance;
import com.l2jserver.gameserver.model.multisell.Entry;
import com.l2jserver.gameserver.model.multisell.Ingredient;
import com.l2jserver.gameserver.model.multisell.ListContainer;
import com.l2jserver.gameserver.model.multisell.PreparedListContainer;
import com.l2jserver.gameserver.network.SystemMessageId;
import com.l2jserver.gameserver.network.serverpackets.ExBrExtraUserInfo;
import com.l2jserver.gameserver.network.serverpackets.MultiSellList;
import com.l2jserver.gameserver.network.serverpackets.SystemMessage;
import com.l2jserver.gameserver.network.serverpackets.UserInfo;
import com.l2jserver.gameserver.util.Util;
import com.l2jserver.util.file.filter.NumericNameFilter;
import java.util.logging.Level;
import jp.sf.l2j.arrayMaps.SortedIntObjectArrayMap;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class MultisellData
extends DocumentParser {
    public static final int PAGE_SIZE = 40;
    public static final int PC_BANG_POINTS = -100;
    public static final int CLAN_REPUTATION = -200;
    public static final int FAME = -300;
    private final SortedIntObjectArrayMap<ListContainer> _entries = new SortedIntObjectArrayMap((Object[])new ListContainer[0]);

    protected MultisellData() {
        this.load();
    }

    @Override
    public final void load() {
        this.setCurrentFileFilter(new NumericNameFilter());
        this._entries.clear();
        this.parseDatapackDirectory("data/multisell", false);
        if (Config.CUSTOM_MULTISELL_LOAD) {
            this.parseDatapackDirectory("data/multisell/custom", false);
        }
        this.verify();
        this._log.log(Level.INFO, this.getClass().getSimpleName() + ": Loaded " + this._entries.size() + " multisell lists.");
        this.setCurrentFileFilter(null);
    }

    @Override
    protected final void parseDocument() {
        try {
            int id = Integer.parseInt(this.getCurrentFile().getName().replace(".xml", ""));
            int entryId = 1;
            ListContainer list = new ListContainer(id);
            for (Node n = this.getCurrentDocument().getFirstChild(); n != null; n = n.getNextSibling()) {
                if (!"list".equalsIgnoreCase(n.getNodeName())) continue;
                Node att = n.getAttributes().getNamedItem("applyTaxes");
                list.setApplyTaxes(att != null && Boolean.parseBoolean(att.getNodeValue()));
                att = n.getAttributes().getNamedItem("useRate");
                if (att != null) {
                    try {
                        list.setUseRate(Double.parseDouble(att.getNodeValue()));
                        if (list.getUseRate() <= 1.0E-6) {
                            throw new NumberFormatException("The value cannot be 0");
                        }
                    }
                    catch (NumberFormatException e) {
                        try {
                            list.setUseRate(Config.class.getField(att.getNodeValue()).getDouble(Config.class));
                        }
                        catch (Exception e1) {
                            this._log.warning(e1.getMessage() + this.getCurrentDocument().getLocalName());
                            list.setUseRate(1.0);
                        }
                    }
                    catch (DOMException e) {
                        this._log.warning(e.getMessage() + this.getCurrentDocument().getLocalName());
                    }
                }
                list.setMaintainEnchantment((att = n.getAttributes().getNamedItem("maintainEnchantment")) != null && Boolean.parseBoolean(att.getNodeValue()));
                for (Node d = n.getFirstChild(); d != null; d = d.getNextSibling()) {
                    if ("item".equalsIgnoreCase(d.getNodeName())) {
                        Entry e = this.parseEntry(d, entryId++, list);
                        list.getEntries().add(e);
                        continue;
                    }
                    if (!"npcs".equalsIgnoreCase(d.getNodeName())) continue;
                    for (Node b = d.getFirstChild(); b != null; b = b.getNextSibling()) {
                        if (!"npc".equalsIgnoreCase(b.getNodeName()) || !Util.isDigit(b.getTextContent())) continue;
                        list.allowNpc(Integer.parseInt(b.getTextContent()));
                    }
                }
                list.getEntries().trimToSize();
            }
            this._entries.put(id, (Object)list);
        }
        catch (Exception e) {
            this._log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error in file " + this.getCurrentFile(), e);
        }
    }

    private final Entry parseEntry(Node n, int entryId, ListContainer list) {
        Node first = n.getFirstChild();
        Entry entry = new Entry(entryId);
        for (n = first; n != null; n = n.getNextSibling()) {
            Node att;
            int i;
            StatsSet set;
            NamedNodeMap attrs;
            if ("ingredient".equalsIgnoreCase(n.getNodeName())) {
                attrs = n.getAttributes();
                set = new StatsSet();
                for (i = 0; i < attrs.getLength(); ++i) {
                    att = attrs.item(i);
                    set.set(att.getNodeName(), att.getNodeValue());
                }
                entry.addIngredient(new Ingredient(set));
                continue;
            }
            if (!"production".equalsIgnoreCase(n.getNodeName())) continue;
            attrs = n.getAttributes();
            set = new StatsSet();
            for (i = 0; i < attrs.getLength(); ++i) {
                att = attrs.item(i);
                set.set(att.getNodeName(), att.getNodeValue());
            }
            entry.addProduct(new Ingredient(set));
        }
        return entry;
    }

    public final void separateAndSend(int listId, L2PcInstance player, L2Npc npc, boolean inventoryOnly, double productMultiplier, double ingredientMultiplier) {
        ListContainer template = (ListContainer)this._entries.get(listId);
        if (template == null) {
            this._log.warning(this.getClass().getSimpleName() + ": can't find list id: " + listId + " requested by player: " + player.getName() + ", npcId:" + (npc != null ? npc.getId() : 0));
            return;
        }
        if (npc != null && !template.isNpcAllowed(npc.getId()) || npc == null && template.isNpcOnly()) {
            this._log.warning(this.getClass().getSimpleName() + ": player " + player + " attempted to open multisell " + listId + " from npc " + npc + " which is not allowed!");
            return;
        }
        PreparedListContainer list = new PreparedListContainer(template, inventoryOnly, player, npc);
        if (productMultiplier != 1.0 || ingredientMultiplier != 1.0) {
            list.getEntries().forEach(entry -> {
                entry.getProducts().forEach(product -> product.setItemCount((long)Math.max((double)product.getItemCount() * productMultiplier, 1.0)));
                entry.getIngredients().forEach(ingredient -> ingredient.setItemCount((long)Math.max((double)ingredient.getItemCount() * ingredientMultiplier, 1.0)));
            });
        }
        int index = 0;
        do {
            player.sendPacket(new MultiSellList(list, index));
        } while ((index += 40) < list.getEntries().size());
        player.setMultiSell(list);
    }

    public final void separateAndSend(int listId, L2PcInstance player, L2Npc npc, boolean inventoryOnly) {
        this.separateAndSend(listId, player, npc, inventoryOnly, 1.0, 1.0);
    }

    public static final boolean hasSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                if (player.getClan() == null) {
                    player.sendPacket(SystemMessageId.YOU_ARE_NOT_A_CLAN_MEMBER);
                    break;
                }
                if (!player.isClanLeader()) {
                    player.sendPacket(SystemMessageId.ONLY_THE_CLAN_LEADER_IS_ENABLED);
                    break;
                }
                if ((long)player.getClan().getReputationScore() < amount) {
                    player.sendPacket(SystemMessageId.THE_CLAN_REPUTATION_SCORE_IS_TOO_LOW);
                    break;
                }
                return true;
            }
            case -300: {
                if ((long)player.getFame() < amount) {
                    player.sendPacket(SystemMessageId.NOT_ENOUGH_FAME_POINTS);
                    break;
                }
                return true;
            }
        }
        return false;
    }

    public static final boolean takeSpecialIngredient(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().takeReputationScore((int)amount, true);
                SystemMessage smsg = SystemMessage.getSystemMessage(SystemMessageId.S1_DEDUCTED_FROM_CLAN_REP);
                smsg.addLong(amount);
                player.sendPacket(smsg);
                return true;
            }
            case -300: {
                player.setFame(player.getFame() - (int)amount);
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
                return true;
            }
        }
        return false;
    }

    public static final void giveSpecialProduct(int id, long amount, L2PcInstance player) {
        switch (id) {
            case -200: {
                player.getClan().addReputationScore((int)amount, true);
                break;
            }
            case -300: {
                player.setFame((int)((long)player.getFame() + amount));
                player.sendPacket(new UserInfo(player));
                player.sendPacket(new ExBrExtraUserInfo(player));
            }
        }
    }

    private final void verify() {
        for (ListContainer list : (ListContainer[])this._entries.values()) {
            for (Entry ent : list.getEntries()) {
                for (Ingredient ing : ent.getIngredients()) {
                    if (this.verifyIngredient(ing)) continue;
                    this._log.warning(this.getClass().getSimpleName() + ": can't find ingredient with itemId: " + ing.getItemId() + " in list: " + list.getListId());
                }
                for (Ingredient ing : ent.getProducts()) {
                    if (this.verifyIngredient(ing)) continue;
                    this._log.warning(this.getClass().getSimpleName() + ": can't find product with itemId: " + ing.getItemId() + " in list: " + list.getListId());
                }
            }
        }
    }

    private final boolean verifyIngredient(Ingredient ing) {
        switch (ing.getItemId()) {
            case -300: 
            case -200: {
                return true;
            }
        }
        return ing.getTemplate() != null;
    }

    public static MultisellData getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final MultisellData _instance = new MultisellData();

        private SingletonHolder() {
        }
    }
}

