/*
 * Decompiled with CFR 0.152.
 */
package com.l2jserver.gameserver.datatables;

import com.l2jserver.Config;
import com.l2jserver.L2DatabaseFactory;
import com.l2jserver.gameserver.model.holders.ItemHolder;
import com.l2jserver.gameserver.model.holders.SkillHolder;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.Level;
import java.util.logging.Logger;
import jp.sf.l2j.troja.FastIntObjectMap;

public class NpcBufferTable {
    private static final Logger _log = Logger.getLogger(NpcBufferTable.class.getName());
    private final FastIntObjectMap<NpcBufferSkills> _buffers = new FastIntObjectMap();

    protected NpcBufferTable() {
        int buffGroup;
        int skillFeeAmount;
        int skillFeeId;
        int skillLevel;
        int skillId;
        int npcId;
        NpcBufferSkills skills;
        int lastNpcId2;
        Throwable throwable;
        ResultSet rset2;
        Throwable throwable2;
        Statement s2;
        Throwable throwable3;
        Connection con;
        int skillCount = 0;
        try {
            con = L2DatabaseFactory.getInstance().getConnectionFast();
            throwable3 = null;
            try {
                s2 = con.createStatement();
                throwable2 = null;
                try {
                    rset2 = s2.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `npc_buffer` ORDER BY `npc_id` ASC");
                    throwable = null;
                    try {
                        lastNpcId2 = 0;
                        skills = null;
                        while (rset2.next()) {
                            npcId = rset2.getInt("npc_id");
                            skillId = rset2.getInt("skill_id");
                            skillLevel = rset2.getInt("skill_level");
                            skillFeeId = rset2.getInt("skill_fee_id");
                            skillFeeAmount = rset2.getInt("skill_fee_amount");
                            buffGroup = rset2.getInt("buff_group");
                            if (npcId != lastNpcId2) {
                                if (lastNpcId2 != 0) {
                                    this._buffers.put(lastNpcId2, skills);
                                }
                                skills = new NpcBufferSkills(npcId);
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            } else if (skills != null) {
                                skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                            }
                            lastNpcId2 = npcId;
                            ++skillCount;
                        }
                        if (lastNpcId2 != 0) {
                            this._buffers.put(lastNpcId2, skills);
                        }
                    }
                    catch (Throwable lastNpcId2) {
                        throwable = lastNpcId2;
                        throw lastNpcId2;
                    }
                    finally {
                        if (rset2 != null) {
                            if (throwable != null) {
                                try {
                                    rset2.close();
                                }
                                catch (Throwable lastNpcId2) {
                                    throwable.addSuppressed(lastNpcId2);
                                }
                            } else {
                                rset2.close();
                            }
                        }
                    }
                }
                catch (Throwable rset2) {
                    throwable2 = rset2;
                    throw rset2;
                }
                finally {
                    if (s2 != null) {
                        if (throwable2 != null) {
                            try {
                                s2.close();
                            }
                            catch (Throwable rset2) {
                                throwable2.addSuppressed(rset2);
                            }
                        } else {
                            s2.close();
                        }
                    }
                }
            }
            catch (Throwable s2) {
                throwable3 = s2;
                throw s2;
            }
            finally {
                if (con != null) {
                    if (throwable3 != null) {
                        try {
                            con.close();
                        }
                        catch (Throwable s2) {
                            throwable3.addSuppressed(s2);
                        }
                    } else {
                        con.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading npc_buffer table: " + e.getMessage(), e);
        }
        if (Config.CUSTOM_NPCBUFFER_TABLES) {
            try {
                con = L2DatabaseFactory.getInstance().getConnectionFast();
                throwable3 = null;
                try {
                    s2 = con.createStatement();
                    throwable2 = null;
                    try {
                        rset2 = s2.executeQuery("SELECT `npc_id`,`skill_id`,`skill_level`,`skill_fee_id`,`skill_fee_amount`,`buff_group` FROM `custom_npc_buffer` ORDER BY `npc_id` ASC");
                        throwable = null;
                        try {
                            lastNpcId2 = 0;
                            skills = null;
                            while (rset2.next()) {
                                npcId = rset2.getInt("npc_id");
                                skillId = rset2.getInt("skill_id");
                                skillLevel = rset2.getInt("skill_level");
                                skillFeeId = rset2.getInt("skill_fee_id");
                                skillFeeAmount = rset2.getInt("skill_fee_amount");
                                buffGroup = rset2.getInt("buff_group");
                                if (npcId != lastNpcId2) {
                                    if (lastNpcId2 != 0) {
                                        this._buffers.put(lastNpcId2, (Object)skills);
                                    }
                                    skills = new NpcBufferSkills(npcId);
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                } else if (skills != null) {
                                    skills.addSkill(skillId, skillLevel, skillFeeId, skillFeeAmount, buffGroup);
                                }
                                lastNpcId2 = npcId;
                                ++skillCount;
                            }
                            if (lastNpcId2 != 0) {
                                this._buffers.put(lastNpcId2, skills);
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (rset2 != null) {
                                if (throwable != null) {
                                    try {
                                        rset2.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    rset2.close();
                                }
                            }
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (s2 != null) {
                            if (throwable2 != null) {
                                try {
                                    s2.close();
                                }
                                catch (Throwable throwable7) {
                                    throwable2.addSuppressed(throwable7);
                                }
                            } else {
                                s2.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable8) {
                    throwable3 = throwable8;
                    throw throwable8;
                }
                finally {
                    if (con != null) {
                        if (throwable3 != null) {
                            try {
                                con.close();
                            }
                            catch (Throwable throwable9) {
                                throwable3.addSuppressed(throwable9);
                            }
                        } else {
                            con.close();
                        }
                    }
                }
            }
            catch (SQLException e) {
                _log.log(Level.SEVERE, this.getClass().getSimpleName() + ": Error reading custom_npc_buffer table: " + e.getMessage(), e);
            }
        }
        _log.info(this.getClass().getSimpleName() + ": Loaded " + this._buffers.size() + " buffers and " + skillCount + " skills.");
    }

    public NpcBufferData getSkillInfo(int npcId, int buffGroup) {
        NpcBufferSkills skills = (NpcBufferSkills)this._buffers.get(npcId);
        if (skills != null) {
            return skills.getSkillGroupInfo(buffGroup);
        }
        return null;
    }

    public static NpcBufferTable getInstance() {
        return SingletonHolder._instance;
    }

    private static class SingletonHolder {
        protected static final NpcBufferTable _instance = new NpcBufferTable();

        private SingletonHolder() {
        }
    }

    private static class NpcBufferSkills {
        private final int _npcId;
        private final FastIntObjectMap<NpcBufferData> _skills = new FastIntObjectMap();

        protected NpcBufferSkills(int npcId) {
            this._npcId = npcId;
        }

        public void addSkill(int skillId, int skillLevel, int skillFeeId, int skillFeeAmount, int buffGroup) {
            this._skills.put(buffGroup, (Object)new NpcBufferData(skillId, skillLevel, skillFeeId, skillFeeAmount));
        }

        public NpcBufferData getSkillGroupInfo(int buffGroup) {
            return (NpcBufferData)this._skills.get(buffGroup);
        }

        public int getNpcId() {
            return this._npcId;
        }
    }

    public static class NpcBufferData {
        private final SkillHolder _skill;
        private final ItemHolder _fee;

        protected NpcBufferData(int skillId, int skillLevel, int feeId, int feeAmount) {
            this._skill = new SkillHolder(skillId, skillLevel);
            this._fee = new ItemHolder(feeId, feeAmount);
        }

        public SkillHolder getSkill() {
            return this._skill;
        }

        public ItemHolder getFee() {
            return this._fee;
        }
    }
}

